/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.impl.javase.ClassPathLoader;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CN1Bootstrap {
    private static ClassPathLoader rootClassLoader;
    private static String OS;
    private static boolean isWindows;
    private static boolean isMac;
    private static final String ARCH;
    private static boolean isUnix;
    private static final boolean is64Bit;

    public static boolean isJavaFXLoaded() {
        try {
            Class.forName("javafx.embed.swing.JFXPanel");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isCEFLoaded() {
        try {
            Class.forName("org.cef.CefApp");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isBootstrapped() {
        return System.getProperty("CN1Bootstrap", null) != null;
    }

    public static boolean run(Class mainClass, String[] argv) throws Exception {
        return CN1Bootstrap.run(mainClass.getName(), argv);
    }

    public static boolean run(String mainClass, String[] argv) throws Exception {
        ClassPathLoader ldr;
        String implementation;
        File jmf;
        File cef;
        if (CN1Bootstrap.isBootstrapped()) {
            return false;
        }
        System.setProperty("CN1Bootstrap", "true");
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        System.setProperty("NSHighResolutionCapable", "true");
        StringTokenizer t = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        ArrayList<File> files = new ArrayList<File>();
        int len = t.countTokens();
        for (int iter = 0; iter < len; ++iter) {
            files.add(new File(t.nextToken()));
        }
        File javase = new File("native" + File.separator + "javase");
        File libJavase = new File("lib" + File.separator + "impl" + File.separator + "native" + File.separator + "javase");
        for (File dir : new File[]{javase, libJavase}) {
            if (!dir.exists()) continue;
            for (File file : dir.listFiles()) {
                if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip") || files.contains(file)) continue;
                files.add(file);
                System.setProperty("java.class.path", System.getProperty("java.class.path") + File.pathSeparator + file.getAbsolutePath());
            }
        }
        boolean cefSupported = false;
        boolean fxSupported = false;
        try {
            Class.forName("javafx.embed.swing.JFXPanel");
            fxSupported = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean fxOnSystemPath = fxSupported;
        File file = cef = System.getProperty("cef.dir") != null ? new File(System.getProperty("cef.dir")) : new File(System.getProperty("user.home") + File.separator + ".codenameone" + File.separator + "cef");
        if (cef.exists()) {
            if (isUnix && !is64Bit) {
                System.out.println("Found CEF, but not using because CEF is only supported on 64 bit platforms.  Try running inside a 64 bit JVM");
            } else {
                String bitSuffix;
                cefSupported = true;
                System.out.println("Adding CEF to classpath " + cef);
                String cn1LibPath = System.getProperty("cn1.library.path", ".");
                String string = bitSuffix = is64Bit ? "64" : "32";
                String nativeDir = isMac ? "macos64" : (isWindows ? "lib" + File.separator + "win" + bitSuffix : "lib" + File.separator + "linux" + bitSuffix);
                System.setProperty("cn1.library.path", cn1LibPath + File.pathSeparator + cef.getAbsolutePath() + File.separator + nativeDir);
                System.setProperty("java.library.path", cef.getAbsolutePath() + File.separator + nativeDir + File.pathSeparator + System.getProperty("java.library.path", "."));
                for (File jar : cef.listFiles()) {
                    if (!jar.getName().endsWith(".jar")) continue;
                    files.add(jar);
                }
            }
        }
        if ((jmf = new File(System.getProperty("user.home") + File.separator + ".codenameone" + File.separator + "jmf-2.1.1e.jar")).exists()) {
            System.setProperty("java.class.path", System.getProperty("java.class.path") + File.pathSeparator + jmf.getAbsolutePath());
            files.add(jmf);
        }
        if ((implementation = System.getProperty("cn1.javase.implementation", "")).equalsIgnoreCase("cef") && !cefSupported) {
            System.err.println("cn1.javase.implementation=cef but CEF was not found.  Please update your Codename One libraries and try again.\nAlternatively, you can try using a different implementation.");
            System.exit(1);
        }
        if (implementation.equalsIgnoreCase("fx") && !fxSupported) {
            System.err.println("cn1.javase.implementation=fx but JavaFX was not found.  Please use a JDK that has JavaFX such as ZuluFX.  https://www.azul.com/downloads/zulu-community/");
            System.exit(1);
        }
        if ("".equals(implementation)) {
            if (cefSupported) {
                System.setProperty("cn1.javase.implementation", "cef");
            } else if (fxSupported) {
                System.setProperty("cn1.javase.implementation", "fx");
            } else {
                System.setProperty("cn1.javase.implementation", "jmf");
            }
        }
        ClassPathLoader classPathLoader = ldr = rootClassLoader == null ? new ClassPathLoader(files.toArray(new File[files.size()])) : new ClassPathLoader(rootClassLoader, files.toArray(new File[files.size()]));
        if (rootClassLoader == null) {
            rootClassLoader = ldr;
            ldr = new ClassPathLoader(rootClassLoader, files.toArray(new File[files.size()]));
        }
        ldr.addExclude("org.cef.");
        ClassPathLoader classPathLoader2 = ldr;
        Class<?> c = Class.forName(mainClass, true, ldr);
        Method m = c.getDeclaredMethod("main", String[].class);
        m.invoke(null, new Object[]{argv});
        return true;
    }

    private static final boolean is64Bit() {
        String model = System.getProperty("sun.arch.data.model", System.getProperty("com.ibm.vm.bitmode"));
        if (model != null) {
            return "64".equals(model);
        }
        return "x86-64".equals(ARCH) || "ia64".equals(ARCH) || "ppc64".equals(ARCH) || "ppc64le".equals(ARCH) || "sparcv9".equals(ARCH) || "mips64".equals(ARCH) || "mips64el".equals(ARCH) || "amd64".equals(ARCH) || "aarch64".equals(ARCH);
    }

    static {
        OS = System.getProperty("os.name").toLowerCase();
        isWindows = OS.indexOf("win") >= 0;
        isMac = OS.indexOf("mac") >= 0;
        ARCH = System.getProperty("os.arch");
        isUnix = OS.indexOf("nux") >= 0;
        is64Bit = CN1Bootstrap.is64Bit();
    }
}

