/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class ClassPathLoader
extends ClassLoader {
    private File[] classpath;
    private Map classes = new HashMap();
    private Map<String, URL> resources = new HashMap<String, URL>();
    private List<String> excludes = new ArrayList<String>();
    private List<String> includes;
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static boolean isWindows = OS.indexOf("win") >= 0;
    private static boolean isMac = OS.indexOf("mac") >= 0;
    private static boolean isUnix = OS.indexOf("nux") >= 0;

    public ClassPathLoader(File[] classpath) {
        this(ClassPathLoader.class.getClassLoader(), classpath);
    }

    public ClassPathLoader(ClassLoader parent, File[] classpath) {
        super(parent);
        this.excludes.add("com.apple.laf");
        this.excludes.add("com.github.sarxos.webcam");
        this.excludes.add("org.bridj");
        this.excludes.add("java");
        this.excludes.add("com.sun");
        this.excludes.add("org.jdesktop");
        this.excludes.add("netscape.javascript");
        this.excludes.add("javafx");
        this.excludes.add("org.w3c");
        this.includes = new ArrayList<String>();
        this.classpath = classpath;
    }

    public void addExclude(String exclude) {
        this.excludes.add(exclude);
    }

    public void addInclude(String include) {
        this.includes.add(include);
    }

    public void removeInclude(String include) {
        this.includes.remove(include);
    }

    private boolean isExcluded(String className) {
        for (String prefix : this.excludes) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean isIncluded(String className) {
        for (String prefix : this.includes) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        if (this.isExcluded(className)) {
            return super.loadClass(className);
        }
        return this.findClass(className);
    }

    @Override
    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        if (this.isExcluded(className)) {
            return super.loadClass(className, resolve);
        }
        return this.findClass(className);
    }

    @Override
    protected String findLibrary(String libname) {
        String out = super.findLibrary(libname);
        if (out == null) {
            for (String libDir : System.getProperty("cn1.library.path", "").split(File.pathSeparator)) {
                File f;
                if (isMac) {
                    f = new File(libDir, "lib" + libname + ".dylib");
                    if (f.exists()) {
                        return f.getAbsolutePath();
                    }
                    f = new File(libDir, "lib" + libname + ".jnilib");
                    if (!f.exists()) continue;
                    return f.getAbsolutePath();
                }
                if (isWindows) {
                    f = new File(libDir, libname + ".dll");
                    if (f.exists()) {
                        return f.getAbsolutePath();
                    }
                    f = new File(libDir, libname + ".jnilib");
                    if (!f.exists()) continue;
                    return f.getAbsolutePath();
                }
                f = new File(libDir, libname + ".so");
                if (f.exists()) {
                    return f.getAbsolutePath();
                }
                f = new File(libDir, "lib" + libname + ".so");
                if (f.exists()) {
                    return f.getAbsolutePath();
                }
                f = new File(libDir, libname + ".jnilib");
                if (!f.exists()) continue;
                return f.getAbsolutePath();
            }
        }
        return out;
    }

    public Class findClass(String className) throws ClassNotFoundException {
        Class<?> result = null;
        result = (Class<?>)this.classes.get(className);
        if (result != null) {
            return result;
        }
        try {
            for (File f : this.classpath) {
                InputStream is;
                if (f.isDirectory()) {
                    File current = new File(f, className.replace('.', File.separatorChar) + ".class");
                    if (!current.exists()) continue;
                    is = new FileInputStream(current);
                } else {
                    try {
                        JarFile jar = new JarFile(f);
                        JarEntry entry = jar.getJarEntry(className.replace('.', '/') + ".class");
                        if (entry == null) continue;
                        is = jar.getInputStream(entry);
                        if (is == null) {
                        }
                    }
                    catch (Throwable t) {}
                    continue;
                }
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                int nextValue = is.read();
                while (-1 != nextValue) {
                    byteStream.write(nextValue);
                    nextValue = is.read();
                }
                is.close();
                byte[] classByte = byteStream.toByteArray();
                result = this.defineClass(className, classByte, 0, classByte.length, null);
                this.classes.put(className, result);
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.findSystemClass(className);
    }
}

