/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.impl.javase.ComponentTreeModel;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Painter;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.Resources;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class ComponentTreeInspector
extends JFrame {
    private List<String> themePaths = new ArrayList<String>();
    private List<String> themeNames = new ArrayList<String>();
    private Component currentComponent;
    private JTextField componentClass;
    private JTextField componentName;
    private JCheckBox componentSelected;
    private JTree componentTree;
    private JTextField componentUIID;
    private JTextField constraint;
    private JTextField coordinates;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;
    private JTextField layout;
    private JTextField margin;
    private JTextField padding;
    private JTextField preferredSize;
    private JButton refreshTree;
    private JComboBox themes;
    private JButton unselected;
    private JButton validate;

    public ComponentTreeInspector() {
        this.initComponents();
        File[] resFiles = new File("src").listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".res");
            }
        });
        this.themes.removeAllItems();
        if (resFiles != null) {
            for (File r : resFiles) {
                try {
                    Resources rr = Resources.open((String)("/" + r.getName()));
                    for (String themeName : rr.getThemeResourceNames()) {
                        this.themes.addItem(r.getName() + " - " + themeName);
                        this.themePaths.add(r.getAbsolutePath());
                        this.themeNames.add(themeName);
                    }
                }
                catch (IOException err) {
                    err.printStackTrace();
                }
            }
        }
        this.refreshComponentTree();
        this.componentUIID.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateUiid();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateUiid();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateUiid();
            }

            private void updateUiid() {
                final String uiidText = ComponentTreeInspector.this.componentUIID.getText();
                if (ComponentTreeInspector.this.currentComponent != null && uiidText.length() > 0) {
                    Display.getInstance().callSerially(new Runnable(){

                        @Override
                        public void run() {
                            if (ComponentTreeInspector.this.currentComponent != null && !Objects.equals(ComponentTreeInspector.this.currentComponent.getUIID(), uiidText)) {
                                ComponentTreeInspector.this.currentComponent.setUIID(uiidText);
                                Display.getInstance().getCurrent().revalidate();
                            }
                        }
                    });
                }
            }
        });
        this.componentTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public java.awt.Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component t = (Component)value;
                String newVal = t.getClass().getSimpleName();
                newVal = t.getName() != null ? newVal + "[" + t.getName() + "]" : newVal + "[Unnamed]";
                newVal = newVal + ", " + t.getUIID();
                return super.getTreeCellRendererComponent(tree, newVal, sel, expanded, leaf, row, hasFocus);
            }
        });
        this.componentTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getPath() != null) {
                    Form parentForm = Display.getInstance().getCurrent();
                    Component c = (Component)e.getPath().getLastPathComponent();
                    if (c != null) {
                        Object o;
                        if (parentForm.getGlassPane() == null) {
                            parentForm.setGlassPane((Painter)new SelectedComponentGlassPane(c));
                        } else if (parentForm.getGlassPane() instanceof SelectedComponentGlassPane) {
                            SelectedComponentGlassPane s = (SelectedComponentGlassPane)parentForm.getGlassPane();
                            if (s.cmp != c) {
                                s.cmp = c;
                                parentForm.repaint();
                            }
                        }
                        ComponentTreeInspector.this.currentComponent = c;
                        ComponentTreeInspector.this.componentClass.setText(c.getClass().getName());
                        ComponentTreeInspector.this.componentName.setText("" + c.getName());
                        ComponentTreeInspector.this.componentUIID.setText("" + c.getUIID());
                        ComponentTreeInspector.this.componentSelected.setSelected(c.hasFocus());
                        ComponentTreeInspector.this.coordinates.setText("x: " + c.getX() + " y: " + c.getY() + " absX: " + c.getAbsoluteX() + " absY: " + c.getAbsoluteY() + " Width: " + c.getWidth() + " Height: " + c.getHeight());
                        ComponentTreeInspector.this.preferredSize.setText(c.getPreferredW() + ", " + c.getPreferredH());
                        ComponentTreeInspector.this.padding.setText("Top: " + c.getStyle().getPadding(0) + " Bottom: " + c.getStyle().getPadding(2) + " Left: " + c.getStyle().getPadding(1) + " Right: " + c.getStyle().getPadding(3));
                        ComponentTreeInspector.this.margin.setText("Top: " + c.getStyle().getMargin(0) + " Bottom: " + c.getStyle().getMargin(2) + " Left: " + c.getStyle().getMargin(1) + " Right: " + c.getStyle().getMargin(3));
                        if (c instanceof Container) {
                            ComponentTreeInspector.this.layout.setText(((Container)c).getLayout().getClass().getSimpleName());
                        } else {
                            ComponentTreeInspector.this.layout.setText("");
                        }
                        Container parent = c.getParent();
                        ComponentTreeInspector.this.constraint.setText("");
                        if (parent != null && (o = parent.getLayout().getComponentConstraint(c)) != null) {
                            ComponentTreeInspector.this.constraint.setText(o.toString());
                        }
                    } else if (parentForm.getGlassPane() != null && parentForm.getGlassPane() instanceof SelectedComponentGlassPane) {
                        parentForm.setGlassPane(null);
                        parentForm.repaint();
                    }
                }
            }
        });
        this.pack();
        this.setLocationByPlatform(true);
        this.setVisible(true);
    }

    private void refreshComponentTree() {
        TreePath tp = this.componentTree.getSelectionPath();
        ComponentTreeModel cm = new ComponentTreeModel(Display.getInstance().getCurrent());
        this.componentTree.setModel(cm);
        this.componentTree.setSelectionPath(tp);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.componentTree = new JTree();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.componentClass = new JTextField();
        this.componentName = new JTextField();
        this.componentUIID = new JTextField();
        this.componentSelected = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.layout = new JTextField();
        this.jLabel6 = new JLabel();
        this.constraint = new JTextField();
        this.jLabel7 = new JLabel();
        this.coordinates = new JTextField();
        this.jLabel8 = new JLabel();
        this.preferredSize = new JTextField();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.padding = new JTextField();
        this.margin = new JTextField();
        this.unselected = new JButton();
        this.themes = new JComboBox();
        this.jToolBar1 = new JToolBar();
        this.refreshTree = new JButton();
        this.validate = new JButton();
        FormListener formListener = new FormListener();
        this.setDefaultCloseOperation(2);
        this.setTitle("Component Tree Inspector");
        this.jScrollPane1.setViewportView(this.componentTree);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jLabel1.setText("Class");
        this.jLabel2.setText("Name");
        this.jLabel3.setText("UIID");
        this.jLabel4.setText("Selected");
        this.componentClass.setEditable(false);
        this.componentName.setEditable(false);
        this.componentSelected.setEnabled(false);
        this.jLabel5.setText("Layout");
        this.layout.setEditable(false);
        this.jLabel6.setText("Constraint");
        this.jLabel6.setToolTipText("Layout Constraint (for border layout)");
        this.constraint.setEditable(false);
        this.constraint.setToolTipText("Layout Constraint (for border layout)");
        this.jLabel7.setText("Coordinates");
        this.coordinates.setEditable(false);
        this.jLabel8.setText("Preferred Size");
        this.preferredSize.setEditable(false);
        this.jLabel9.setText("Padding");
        this.jLabel10.setText("Margin");
        this.padding.setEditable(false);
        this.margin.setEditable(false);
        this.unselected.setText("Edit");
        this.unselected.addActionListener(formListener);
        this.themes.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent(this.jLabel8).addComponent(this.jLabel9).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.componentClass).addComponent(this.componentName).addComponent(this.layout).addComponent(this.constraint).addComponent(this.coordinates).addComponent(this.preferredSize).addComponent(this.padding).addComponent(this.margin).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.componentSelected).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.componentUIID, -2, 192, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.themes, 0, 162, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unselected, -2, 94, -2))))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.componentClass, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.componentName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.componentUIID, -2, -1, -2).addComponent(this.unselected).addComponent(this.themes, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.componentSelected)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.layout, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.constraint, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.coordinates, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.preferredSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.padding, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.margin, -2, -1, -2)).addContainerGap(33, Short.MAX_VALUE)));
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.getContentPane().add((java.awt.Component)this.jSplitPane1, "Center");
        this.jToolBar1.setRollover(true);
        this.refreshTree.setText("Refresh");
        this.refreshTree.setFocusable(false);
        this.refreshTree.setHorizontalTextPosition(0);
        this.refreshTree.setVerticalTextPosition(3);
        this.refreshTree.addActionListener(formListener);
        this.jToolBar1.add(this.refreshTree);
        this.validate.setText("Validate");
        this.validate.setFocusable(false);
        this.validate.setHorizontalTextPosition(0);
        this.validate.setName("");
        this.validate.setVerticalTextPosition(3);
        this.validate.addActionListener(formListener);
        this.jToolBar1.add(this.validate);
        this.getContentPane().add((java.awt.Component)this.jToolBar1, "First");
        this.pack();
    }

    private void refreshTreeActionPerformed(ActionEvent evt) {
        this.refreshComponentTree();
    }

    private void unselectedActionPerformed(ActionEvent evt) {
        this.editStyle();
    }

    private void showErrorMessage(final String message, final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(ComponentTreeInspector.this, message, title, 0);
            }
        });
    }

    private void showInfoMessage(final String message, final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(ComponentTreeInspector.this, message, title, -1);
            }
        });
    }

    private void validateActionPerformed(ActionEvent evt) {
        Display.getInstance().callSerially(new Runnable(){

            @Override
            public void run() {
                Form f = Display.getInstance().getCurrent();
                ArrayList scrollables = new ArrayList();
                ComponentTreeInspector.this.findScrollableContainers(f.getContentPane(), scrollables);
                if (scrollables.size() > 1) {
                    for (Container cnt : scrollables) {
                        for (Container child : scrollables) {
                            if (cnt == child || !ComponentTreeInspector.this.isChildOf(cnt, (Component)child)) continue;
                            String message = "Nested scrollable containers detected: ";
                            message = cnt == f.getContentPane() ? message + "\nContent pane is scrollable" : message + "\nScrollable container named: " + cnt.getName();
                            message = child == f.getContentPane() ? message + "\nContent pane is scrollable" : message + "\nScrollable container named: " + child.getName();
                            ComponentTreeInspector.this.showErrorMessage(message, "Nested Scrollables");
                            return;
                        }
                    }
                }
                ComponentTreeInspector.this.showInfoMessage("Validation finished without an error", "Validation");
            }
        });
    }

    public boolean isChildOf(Container cnt, Component cmp) {
        while (cmp.getParent() != null) {
            if ((cmp = cmp.getParent()) != cnt) continue;
            return true;
        }
        return false;
    }

    private void findScrollableContainers(Container cnt, List<Container> response) {
        try {
            Method m = Container.class.getDeclaredMethod("scrollableYFlag", new Class[0]);
            m.setAccessible(true);
            Boolean res = (Boolean)m.invoke((Object)cnt, new Object[0]);
            if (res.booleanValue()) {
                response.add(cnt);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (Component c : cnt) {
            if (!(c instanceof Container)) continue;
            this.findScrollableContainers((Container)c, response);
        }
    }

    private void editStyle() {
        File cn1dir = new File(System.getProperty("user.home"), ".codenameone");
        if (!cn1dir.exists()) {
            JOptionPane.showMessageDialog(this, "Please open the designer once by opening the theme.res file", "Error Opening Designer", 0);
            return;
        }
        File resourceEditor = new File(cn1dir, "designer_1.jar");
        if (!resourceEditor.exists()) {
            resourceEditor = new File(cn1dir, "designer.jar");
        }
        if (!resourceEditor.exists()) {
            JOptionPane.showMessageDialog(this, "Please open the designer once by opening the theme.res file", "Error Opening Designer", 0);
            return;
        }
        File javaBin = new File(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java.exe");
        if (!javaBin.exists()) {
            javaBin = new File(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        }
        final File javaExe = javaBin;
        final File resourceEditorFinal = resourceEditor;
        final String themeFile = this.themePaths.get(this.themes.getSelectedIndex());
        if (themeFile.endsWith(".css.res")) {
            File srcDir = new File(themeFile).getParentFile();
            File projectDir = srcDir.getParentFile();
            File cssDir = new File(projectDir, "css");
            String cssThemeFileName = new File(themeFile).getName();
            int lastDot = cssThemeFileName.lastIndexOf(".");
            if (lastDot >= 0) {
                cssThemeFileName = cssThemeFileName.substring(0, lastDot);
            }
            File cssThemeFile = new File(cssDir, cssThemeFileName);
            System.out.println("Trying to open " + cssThemeFile);
            if (cssThemeFile.exists()) {
                try {
                    Desktop.getDesktop().edit(cssThemeFile);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return;
            }
        }
        final String themeName = this.themeNames.get(this.themes.getSelectedIndex());
        final String uiid = this.componentUIID.getText();
        new Thread(){

            @Override
            public void run() {
                try {
                    ProcessBuilder pb = new ProcessBuilder(javaExe.getAbsolutePath(), "-jar", resourceEditorFinal.getAbsolutePath(), "-style", themeFile, uiid, themeName).inheritIO();
                    Process proc = pb.start();
                    proc.waitFor();
                    Display.getInstance().callSerially(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Resources res = Resources.open((InputStream)new FileInputStream(themeFile));
                                UIManager.getInstance().addThemeProps(res.getTheme(themeName));
                                Display.getInstance().getCurrent().refreshTheme();
                                Display.getInstance().getCurrent().revalidate();
                            }
                            catch (Exception err) {
                                err.printStackTrace();
                            }
                        }
                    });
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        }.start();
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == ComponentTreeInspector.this.unselected) {
                ComponentTreeInspector.this.unselectedActionPerformed(evt);
            } else if (evt.getSource() == ComponentTreeInspector.this.refreshTree) {
                ComponentTreeInspector.this.refreshTreeActionPerformed(evt);
            } else if (evt.getSource() == ComponentTreeInspector.this.validate) {
                ComponentTreeInspector.this.validateActionPerformed(evt);
            }
        }
    }

    class SelectedComponentGlassPane
    implements Painter {
        Component cmp;

        public SelectedComponentGlassPane(Component cmp) {
            this.cmp = cmp;
        }

        public void paint(Graphics g, Rectangle rect) {
            g.setAlpha(30);
            g.setColor(0xFF0000);
            g.fillRect(this.cmp.getAbsoluteX(), this.cmp.getAbsoluteY(), this.cmp.getWidth(), this.cmp.getHeight());
            g.setAlpha(255);
        }
    }
}

