/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class FileEncoder {
    private static List<FileEncoder> registeredEncoders = new ArrayList<FileEncoder>();

    public static synchronized void register(FileEncoder encoder) {
        registeredEncoders.add(encoder);
    }

    public static synchronized FileEncoder getEncoder(String sourceMimetype, String destMimetype) {
        for (FileEncoder enc : registeredEncoders) {
            if (!sourceMimetype.equals(enc.getSourceMimetype()) || !destMimetype.equals(enc.getTargetMimetype())) continue;
            return enc;
        }
        return null;
    }

    public abstract String getSourceMimetype();

    public abstract String getTargetMimetype();

    public abstract void encode(File var1, File var2, Object var3) throws IOException;
}

