/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.impl.javase.JavaSEPort;
import com.codename1.impl.javase.NetworkRequestObject;
import com.codename1.io.ConnectionRequest;
import com.codename1.io.IOAccessor;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URLConnection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NetworkMonitor
extends JFrame {
    private Map<URLConnection, NetworkRequestObject> requests = new HashMap<URLConnection, NetworkRequestObject>();
    private Map<ConnectionRequest, NetworkRequestObject> queuedRequests = new HashMap<ConnectionRequest, NetworkRequestObject>();
    private JLabel downloadTime;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel13;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JTextArea postBody;
    private JList request;
    private JTextArea requestHeaders;
    private JLabel requestTime;
    private JLabel requestType;
    private JTextArea responseBody;
    private JLabel responseCode;
    private JTextArea responseHeaders;
    private JLabel responseLength;
    private JLabel responseTime;
    private JLabel timeQueued;
    private JLabel totalTime;
    private JTextField url;

    public NetworkMonitor() {
        this.initComponents();
        this.requestHeaders.setLineWrap(true);
        this.postBody.setLineWrap(true);
        this.responseBody.setLineWrap(true);
        this.responseHeaders.setLineWrap(true);
        this.request.setModel(new DefaultListModel());
        this.request.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jlist, Object o, int i, boolean bln, boolean bln1) {
                NetworkRequestObject nr = (NetworkRequestObject)o;
                o = nr.getMethod() != null ? nr.getMethod() + " - " + nr.getUrl() : nr.getUrl();
                return super.getListCellRendererComponent((JList<?>)jlist, o, i, bln, bln1);
            }
        });
        this.request.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                NetworkRequestObject nr = (NetworkRequestObject)NetworkMonitor.this.request.getSelectedValue();
            }
        });
    }

    public synchronized void addRequest(URLConnection con, NetworkRequestObject r) {
        this.requests.put(con, r);
        ((DefaultListModel)this.request.getModel()).addElement(r);
    }

    public synchronized void addQueuedRequest(ConnectionRequest req, NetworkRequestObject r) {
        this.queuedRequests.put(req, r);
    }

    public synchronized void removeQueuedRequest(NetworkRequestObject r) {
        ConnectionRequest key = null;
        for (ConnectionRequest req : this.queuedRequests.keySet()) {
            if (this.queuedRequests.get(req) != r) continue;
            key = req;
            break;
        }
        if (key != null) {
            this.queuedRequests.remove(key);
        }
    }

    public synchronized NetworkRequestObject findQueuedRequest(int id) {
        for (ConnectionRequest req : this.queuedRequests.keySet()) {
            if (id != IOAccessor.getId(req)) continue;
            return this.queuedRequests.get(req);
        }
        return null;
    }

    public synchronized NetworkRequestObject getByConnectionRequest(ConnectionRequest req) {
        return this.queuedRequests.get(req);
    }

    public synchronized NetworkRequestObject getByConnection(URLConnection con) {
        return this.requests.get(con);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.request = new JList();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.requestType = new JLabel();
        this.jLabel5 = new JLabel();
        this.responseCode = new JLabel();
        this.jLabel8 = new JLabel();
        this.responseLength = new JLabel();
        this.url = new JTextField();
        this.jLabel9 = new JLabel();
        this.requestTime = new JLabel();
        this.jLabel11 = new JLabel();
        this.responseTime = new JLabel();
        this.jLabel13 = new JLabel();
        this.downloadTime = new JLabel();
        this.jLabel15 = new JLabel();
        this.totalTime = new JLabel();
        this.jLabel16 = new JLabel();
        this.timeQueued = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.postBody = new JTextArea();
        this.jLabel3 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.requestHeaders = new JTextArea();
        this.jPanel3 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.responseBody = new JTextArea();
        this.jLabel4 = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.responseHeaders = new JTextArea();
        this.jPanel4 = new JPanel();
        this.jButton1 = new JButton();
        FormListener formListener = new FormListener();
        this.setDefaultCloseOperation(2);
        this.setTitle("Network Monitor");
        this.addWindowListener(formListener);
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.request.addListSelectionListener(formListener);
        this.jScrollPane1.setViewportView(this.request);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jLabel1.setText("URL");
        this.jLabel2.setText("Type");
        this.requestType.setText("POST");
        this.jLabel5.setText("Response Code");
        this.responseCode.setText("200");
        this.jLabel8.setText("Response Length");
        this.responseLength.setText("-1");
        this.url.setEditable(false);
        this.jLabel9.setText("Request Time");
        this.requestTime.setText("-1");
        this.jLabel11.setText("Response Time");
        this.responseTime.setText("-1");
        this.jLabel13.setText("Download Time");
        this.downloadTime.setText("-1");
        this.jLabel15.setText("Total Time");
        this.totalTime.setText("-1");
        this.jLabel16.setText("Time Queued");
        this.timeQueued.setText("-1");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel8).addComponent(this.jLabel9).addComponent(this.jLabel11).addComponent(this.jLabel13).addComponent(this.jLabel15).addComponent(this.jLabel16)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.timeQueued, -1, -1, Short.MAX_VALUE).addComponent(this.totalTime, -1, -1, Short.MAX_VALUE).addComponent(this.downloadTime, -1, -1, Short.MAX_VALUE).addComponent(this.responseTime, -1, -1, Short.MAX_VALUE).addComponent(this.url).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.responseLength).addComponent(this.responseCode).addComponent(this.requestType)).addGap(0, 312, Short.MAX_VALUE)).addComponent(this.requestTime, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.url, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.requestType)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.responseCode)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.responseLength)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.requestTime)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.responseTime)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.downloadTime)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.totalTime)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.timeQueued)).addContainerGap(126, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Basics", this.jPanel1);
        this.jLabel6.setText("Post Body");
        this.postBody.setColumns(20);
        this.postBody.setEditable(false);
        this.postBody.setRows(5);
        this.jScrollPane3.setViewportView(this.postBody);
        this.jLabel3.setText("Request Headers (Partial List!)");
        this.requestHeaders.setColumns(20);
        this.requestHeaders.setEditable(false);
        this.requestHeaders.setRows(5);
        this.jScrollPane4.setViewportView(this.requestHeaders);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, GroupLayout.Alignment.TRAILING, -1, 435, Short.MAX_VALUE).addComponent(this.jScrollPane4, -1, 435, Short.MAX_VALUE).addComponent(this.jLabel6).addComponent(this.jLabel3)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane3, -1, 133, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -1, 149, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Request", this.jPanel2);
        this.jLabel7.setText("Response Body");
        this.responseBody.setColumns(20);
        this.responseBody.setEditable(false);
        this.responseBody.setRows(5);
        this.jScrollPane2.setViewportView(this.responseBody);
        this.jLabel4.setText("Response Headers (Partial List)");
        this.responseHeaders.setColumns(20);
        this.responseHeaders.setRows(5);
        this.jScrollPane5.setViewportView(this.responseHeaders);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane5, GroupLayout.Alignment.LEADING, -1, 435, Short.MAX_VALUE).addComponent(this.jLabel7, GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 435, Short.MAX_VALUE).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(41, 41, 41).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2).addGap(18, 18, 18).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane5, -2, 141, -2).addContainerGap()));
        this.jTabbedPane1.addTab("Response", this.jPanel3);
        this.jSplitPane1.setRightComponent(this.jTabbedPane1);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.jPanel4.setLayout(new FlowLayout(0));
        this.jButton1.setText("Remove All");
        this.jButton1.addActionListener(formListener);
        this.jPanel4.add(this.jButton1);
        this.getContentPane().add((Component)this.jPanel4, "South");
        this.pack();
    }

    private void windowClosing(WindowEvent evt) {
        JavaSEPort.disableNetworkMonitor();
    }

    private void requestValueChanged(ListSelectionEvent evt) {
        NetworkRequestObject nr = (NetworkRequestObject)this.request.getSelectedValue();
        if (nr != null) {
            this.responseLength.setText(nr.getContentLength());
            this.requestHeaders.setText(nr.getHeaders());
            this.requestType.setText(nr.getMethod());
            this.postBody.setText(nr.getRequestBody());
            this.responseBody.setText(nr.getResponseBody());
            this.responseCode.setText(nr.getResponseCode());
            this.responseHeaders.setText(nr.getResponseHeaders());
            this.url.setText(nr.getUrl());
            this.requestTime.setText("" + new Date(nr.getTimeSent()) + " (" + nr.getTimeSent() + ")");
            this.responseTime.setText("" + nr.getWaitTime() + "ms (" + nr.getTimeServerResponse() + ")");
            this.downloadTime.setText("" + nr.getDownloadTime() + "ms (" + nr.getTimeComplete() + ")");
            this.totalTime.setText("" + nr.getTotalTime() + "ms");
            this.timeQueued.setText("" + nr.getQueuedTime() + "ms (" + nr.getTimeQueued() + ")");
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        DefaultListModel model = (DefaultListModel)this.request.getModel();
        model.removeAllElements();
    }

    private class FormListener
    implements ActionListener,
    WindowListener,
    ListSelectionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == NetworkMonitor.this.jButton1) {
                NetworkMonitor.this.jButton1ActionPerformed(evt);
            }
        }

        @Override
        public void windowActivated(WindowEvent evt) {
        }

        @Override
        public void windowClosed(WindowEvent evt) {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            if (evt.getSource() == NetworkMonitor.this) {
                NetworkMonitor.this.windowClosing(evt);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent evt) {
        }

        @Override
        public void windowDeiconified(WindowEvent evt) {
        }

        @Override
        public void windowIconified(WindowEvent evt) {
        }

        @Override
        public void windowOpened(WindowEvent evt) {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (evt.getSource() == NetworkMonitor.this.request) {
                NetworkMonitor.this.requestValueChanged(evt);
            }
        }
    }
}

