/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.impl.javase.ComponentTreeModel;
import com.codename1.impl.javase.JavaSEPort;
import com.codename1.ui.Component;
import com.codename1.ui.Display;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultTreeCellRenderer;

public class PerformanceMonitor
extends JFrame {
    private int componentId = 0;
    private static String idString = "$prefid";
    private Map<Integer, Stats> componentStats = new HashMap<Integer, Stats>();
    private DefaultTableModel trackedDrawing;
    private boolean trackDrawing;
    private boolean paused;
    private static final String[] COLUMNS = new String[]{"Name", "Type", "UIID", "Parent Name", "Icon", "Invocations", "Fastest", "Slowest", "Average"};
    private static final Class[] COLUMN_CLASSES = new Class[]{String.class, String.class, String.class, String.class, String.class, Integer.class, Long.class, Long.class, Long.class};
    private int imageRam;
    private JButton clearData;
    private JTree componentHierarchy;
    private JLabel imageMemory;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JToolBar jToolBar1;
    private JButton pauseContinue;
    private JTextArea performanceLog;
    private JButton refreshFrame;
    private JTable renderedItems;
    private JTable resultData;
    private JButton runGC;

    public PerformanceMonitor() {
        this.initComponents();
        if (Display.getInstance().getCurrent() != null) {
            this.refreshFrameActionPerformed(null);
        }
        this.resultData.setModel(new Model());
        this.performanceLog.setLineWrap(true);
        this.resultData.setRowSorter(new TableRowSorter<Model>((Model)this.resultData.getModel()));
    }

    public void addImageRAM(int ram) {
        this.imageRam += ram;
        this.imageMemory.setText("Image Memory Overhead: " + this.imageRam);
    }

    public void removeImageRAM(int ram) {
        this.imageRam -= ram;
        this.imageMemory.setText("Image Memory Overhead: " + this.imageRam);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.resultData = new JTable();
        this.clearData = new JButton();
        this.pauseContinue = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.performanceLog = new JTextArea();
        this.imageMemory = new JLabel();
        this.runGC = new JButton();
        this.jPanel2 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane4 = new JScrollPane();
        this.componentHierarchy = new JTree();
        this.jScrollPane5 = new JScrollPane();
        this.renderedItems = PerformanceMonitor.createJTable();
        this.jToolBar1 = new JToolBar();
        this.refreshFrame = new JButton();
        FormListener formListener = new FormListener();
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.jTable1);
        this.setDefaultCloseOperation(2);
        this.setTitle("Performance Monitor");
        this.addWindowListener(formListener);
        this.jScrollPane1.setViewportView(this.resultData);
        this.clearData.setText("Clear Data");
        this.clearData.addActionListener(formListener);
        this.pauseContinue.setText("Pause/Continue");
        this.pauseContinue.addActionListener(formListener);
        this.jLabel1.setText("Component Details (times are in nano-seconds: one billionth of a second)");
        this.jLabel2.setText("Log");
        this.performanceLog.setColumns(20);
        this.performanceLog.setRows(5);
        this.jScrollPane3.setViewportView(this.performanceLog);
        this.imageMemory.setText("Image Memory Overhead: (Calculating...)");
        this.runGC.setText("GC");
        this.runGC.addActionListener(formListener);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane3, GroupLayout.Alignment.LEADING, -1, 793, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 793, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.clearData).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pauseContinue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 89, Short.MAX_VALUE).addComponent(this.runGC).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.imageMemory)).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.clearData, this.pauseContinue, this.runGC);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearData).addComponent(this.pauseContinue).addComponent(this.imageMemory).addComponent(this.runGC)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 170, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 137, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Generic Statistics", this.jPanel1);
        this.componentHierarchy.addTreeSelectionListener(formListener);
        this.jScrollPane4.setViewportView(this.componentHierarchy);
        this.jSplitPane1.setLeftComponent(this.jScrollPane4);
        this.renderedItems.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane5.setViewportView(this.renderedItems);
        this.jSplitPane1.setRightComponent(this.jScrollPane5);
        this.jToolBar1.setRollover(true);
        this.refreshFrame.setText("Refresh");
        this.refreshFrame.setFocusable(false);
        this.refreshFrame.setHorizontalTextPosition(0);
        this.refreshFrame.setVerticalTextPosition(3);
        this.refreshFrame.addActionListener(formListener);
        this.jToolBar1.add(this.refreshFrame);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 805, Short.MAX_VALUE).addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 385, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Rendering Details", this.jPanel2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1).addContainerGap()));
        this.pack();
    }

    public void printToLog(String t) {
        this.performanceLog.append(t + "\n");
        this.performanceLog.setCaretPosition(t.length());
    }

    private void pauseContinueActionPerformed(ActionEvent evt) {
        this.paused = !this.paused;
    }

    private void clearDataActionPerformed(ActionEvent evt) {
        ((Model)this.resultData.getModel()).clear();
        this.performanceLog.setText("");
    }

    private void formWindowClosing(WindowEvent evt) {
        JavaSEPort.disablePerformanceMonitor();
    }

    private void runGCActionPerformed(ActionEvent evt) {
        System.gc();
        System.gc();
    }

    private void refreshFrameActionPerformed(ActionEvent evt) {
        this.componentHierarchy.setModel(new ComponentTreeModel(Display.getInstance().getCurrent()));
        this.componentHierarchy.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public java.awt.Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                String s = value.toString();
                if (value instanceof Component) {
                    s = ((Component)value).getUIID() + ": " + s;
                }
                return super.getTreeCellRendererComponent(tree, s, sel, expanded, leaf, row, hasFocus);
            }
        });
        Display.getInstance().callSerially(new Runnable(){

            @Override
            public void run() {
                PerformanceMonitor.this.trackDrawing = true;
                Display.getInstance().getCurrent().repaint();
                Display.getInstance().callSerially(new Runnable(){

                    @Override
                    public void run() {
                        PerformanceMonitor.this.trackDrawing = false;
                        PerformanceMonitor.this.renderedItems.setModel(PerformanceMonitor.createTableModel());
                    }
                });
            }
        });
    }

    private void refreshComponentStatsTable(Component c) {
        TableModel tm = (TableModel)c.getClientProperty("track");
        if (tm != null) {
            this.renderedItems.setModel(tm);
        } else {
            this.renderedItems.setModel(PerformanceMonitor.createTableModel());
        }
    }

    private void componentHierarchyValueChanged(TreeSelectionEvent evt) {
        Object o;
        if (evt.getPath() != null && (o = evt.getPath().getLastPathComponent()) instanceof Component) {
            Component c = (Component)o;
            this.refreshComponentStatsTable(c);
        }
    }

    public void nothingWithinComponentPaint(Component c) {
        if (this.trackDrawing) {
            if (c.isCellRenderer()) {
                return;
            }
            if (c.getParent() != null) {
                this.trackedDrawing = (DefaultTableModel)c.getParent().getClientProperty("track");
            }
        }
    }

    private static DefaultTableModel createTableModel() {
        return new DefaultTableModel(new String[]{"Call", "Details", "Comments", "Stack", "Image"}, 0){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 3) {
                    return Action.class;
                }
                if (columnIndex == 4) {
                    return Icon.class;
                }
                return String.class;
            }
        };
    }

    public void beforeComponentPaint(Component c) {
        if (this.trackDrawing) {
            if (c.isCellRenderer()) {
                return;
            }
            this.trackedDrawing = PerformanceMonitor.createTableModel();
            c.putClientProperty("track", (Object)this.trackedDrawing);
            return;
        }
        if (!this.paused) {
            c.putClientProperty("$t", (Object)new Long(System.nanoTime()));
        }
    }

    public void afterComponentPaint(Component c) {
        if (this.trackDrawing) {
            if (c.isCellRenderer()) {
                return;
            }
            if (c.getParent() != null) {
                this.trackedDrawing = (DefaultTableModel)c.getParent().getClientProperty("track");
            }
            return;
        }
        if (this.paused) {
            return;
        }
        long t = System.nanoTime();
        Long l = (Long)c.getClientProperty("$t");
        if (l != null) {
            Stats st;
            t -= l.longValue();
            Integer id = (Integer)c.getClientProperty(idString);
            if (id == null) {
                id = new Integer(this.componentId);
                c.putClientProperty(idString, (Object)id);
                ++this.componentId;
                st = new Stats(c);
                this.componentStats.put(id, st);
            } else {
                st = this.componentStats.get(id);
                if (st == null) {
                    st = new Stats(c);
                    this.componentStats.put(id, st);
                }
            }
            st.updateInvocation(t);
        }
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        String s = sw.toString();
        int pos = s.indexOf("at");
        pos = s.indexOf("at", pos + 2);
        return s.substring(pos + 2);
    }

    public void setClip(int x, int y, int width, int height) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"setClip(" + x + ", " + y + ", " + width + ", " + height + ")", "", "", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    public void clipRect(int x, int y, int width, int height) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"clipRect(" + x + ", " + y + ", " + width + ", " + height + ")", "", "", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"drawLine(" + x1 + ", " + y1 + ", " + x2 + ", " + y2 + ")", "", "", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    public void fillRect(int x, int y, int w, int h) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"fillRect(" + x + ", " + y + ", " + w + ", " + h + ")", "", "", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    void clearRect(int x, int y, int width, int height) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"clearRect(" + x + ", " + y + ", " + width + ", " + height + ")", "", "", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    public void drawRect(int x, int y, int width, int height) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"drawRect(" + x + ", " + y + ", " + width + ", " + height + ")", "", "", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"drawRoundRect(" + x + ", " + y + ", " + width + ", " + height + ", " + arcWidth + ", " + arcHeight + ")", "", "", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"fillRoundRect(" + x + ", " + y + ", " + width + ", " + height + ", " + arcWidth + ", " + arcHeight + ")", "", "", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"fillArc(" + x + ", " + y + ", " + width + ", " + height + ", " + startAngle + ", " + arcAngle + ")", "", "", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"drawArc(" + x + ", " + y + ", " + width + ", " + height + ", " + startAngle + ", " + arcAngle + ")", "", "", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    public void setColor(int RGB) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"setColor(0x" + Integer.toHexString(RGB) + ")", "", "", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    public void setAlpha(int alpha) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"setAlpha(0x" + Integer.toHexString(alpha) + ")", "", "", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    public void drawString(String str, int x, int y) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"drawString(" + str + ", " + x + ", " + y + ")", "", "", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    public void drawImage(Object img, int x, int y) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"drawImage(" + x + ", " + y + ")", "Image size: " + ((BufferedImage)img).getWidth() + "x" + ((BufferedImage)img).getHeight(), "", PerformanceMonitor.getStackTrace(new Throwable()), new ImageIcon((BufferedImage)img)});
        }
    }

    public void drawImage(Object img, int x, int y, int w, int h) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"drawImage(" + x + ", " + y + ", " + w + ", " + h + ")", "Image size: " + ((BufferedImage)img).getWidth() + "x" + ((BufferedImage)img).getHeight(), "This version of the method is slow on feature phones", PerformanceMonitor.getStackTrace(new Throwable()), new ImageIcon((BufferedImage)img)});
        }
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"fillTriangle(" + x1 + ", " + y1 + ", " + x2 + ", " + y2 + ", " + x3 + ", " + y3 + ")", "", "", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    public void drawRGB(int[] rgbData, int offset, int x, int y, int w, int h, boolean processAlpha) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"drawRGB(" + x + ", " + y + ", " + w + ", " + h + ")", "Rgb data length " + rgbData.length, "This method is problematic on some devices!", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    public void stringWidth(Object nativeFont, String str) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"stringWidth(" + str + ")", "", "Slow method, don't overuse", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    public void charWidth(Object nativeFont, char ch) {
        if (this.trackDrawing && this.trackedDrawing != null) {
            this.trackedDrawing.addRow(new Object[]{"charWidth(" + ch + ")", "", "Slow method, don't overuse", PerformanceMonitor.getStackTrace(new Throwable()), null});
        }
    }

    private static JTable createJTable() {
        final JTable t = new JTable(PerformanceMonitor.createTableModel()){
            MultilineTableCell wordWrapRenderer = new MultilineTableCell();

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                if (column < 3) {
                    return this.wordWrapRenderer;
                }
                return super.getCellRenderer(row, column);
            }
        };
        AbstractAction view = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable table = (JTable)e.getSource();
                int modelRow = Integer.valueOf(e.getActionCommand());
                String s = (String)((DefaultTableModel)table.getModel()).getValueAt(modelRow, 3);
                JOptionPane.showMessageDialog(t, s, "Stack", 1);
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn(t, view, 3);
        buttonColumn.setMnemonic(68);
        return t;
    }

    static class MultilineTableCell
    implements TableCellRenderer {
        MultilineTableCell() {
        }

        @Override
        public java.awt.Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = "";
            }
            CellArea area = new CellArea(value.toString(), table, row, column, isSelected);
            return area;
        }

        class CellArea
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;
            private String text;
            protected int rowIndex;
            protected int columnIndex;
            protected JTable table;
            protected Font font;
            private int paragraphStart;
            private int paragraphEnd;
            private LineBreakMeasurer lineMeasurer;

            public CellArea(String s, JTable tab, int row, int column, boolean isSelected) {
                this.text = s;
                this.rowIndex = row;
                this.columnIndex = column;
                this.table = tab;
                this.font = this.table.getFont();
                if (isSelected) {
                    this.setForeground(this.table.getSelectionForeground());
                    this.setBackground(this.table.getSelectionBackground());
                }
            }

            @Override
            public void paintComponent(Graphics gr) {
                super.paintComponent(gr);
                if (this.text != null && !this.text.isEmpty()) {
                    Graphics2D g = (Graphics2D)gr;
                    if (this.lineMeasurer == null) {
                        AttributedCharacterIterator paragraph = new AttributedString(this.text).getIterator();
                        this.paragraphStart = paragraph.getBeginIndex();
                        this.paragraphEnd = paragraph.getEndIndex();
                        FontRenderContext frc = g.getFontRenderContext();
                        this.lineMeasurer = new LineBreakMeasurer(paragraph, BreakIterator.getWordInstance(), frc);
                    }
                    float breakWidth = this.table.getColumnModel().getColumn(this.columnIndex).getWidth();
                    float drawPosY = 0.0f;
                    this.lineMeasurer.setPosition(this.paragraphStart);
                    while (this.lineMeasurer.getPosition() < this.paragraphEnd) {
                        TextLayout layout = this.lineMeasurer.nextLayout(breakWidth);
                        float drawPosX = layout.isLeftToRight() ? 0.0f : breakWidth - layout.getAdvance();
                        layout.draw(g, drawPosX, drawPosY += layout.getAscent());
                        drawPosY += layout.getDescent() + layout.getLeading();
                    }
                    this.table.setRowHeight(this.rowIndex, (int)drawPosY);
                }
            }
        }
    }

    public static class ButtonColumn
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    ActionListener,
    MouseListener {
        private JTable table;
        private Action action;
        private int mnemonic;
        private Border originalBorder;
        private Border focusBorder;
        private JButton renderButton;
        private JButton editButton;
        private Object editorValue;
        private boolean isButtonColumnEditor;

        public ButtonColumn(JTable table, Action action, int column) {
            this.table = table;
            this.action = action;
            this.renderButton = new JButton();
            this.editButton = new JButton();
            this.editButton.setFocusPainted(false);
            this.editButton.addActionListener(this);
            this.originalBorder = this.editButton.getBorder();
            this.setFocusBorder(new LineBorder(Color.BLUE));
            TableColumnModel columnModel = table.getColumnModel();
            columnModel.getColumn(column).setCellRenderer(this);
            columnModel.getColumn(column).setCellEditor(this);
            table.addMouseListener(this);
            table.setDefaultEditor(Action.class, this);
            table.setDefaultRenderer(Action.class, this);
        }

        public Border getFocusBorder() {
            return this.focusBorder;
        }

        public void setFocusBorder(Border focusBorder) {
            this.focusBorder = focusBorder;
            this.editButton.setBorder(focusBorder);
        }

        public int getMnemonic() {
            return this.mnemonic;
        }

        public void setMnemonic(int mnemonic) {
            this.mnemonic = mnemonic;
            this.renderButton.setMnemonic(mnemonic);
            this.editButton.setMnemonic(mnemonic);
        }

        @Override
        public java.awt.Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.editButton.setText("");
                this.editButton.setIcon(null);
            } else if (value instanceof Icon) {
                this.editButton.setText("");
                this.editButton.setIcon((Icon)value);
            } else {
                this.editButton.setText(value.toString());
                this.editButton.setIcon(null);
            }
            this.editorValue = value;
            return this.editButton;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorValue;
        }

        @Override
        public java.awt.Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.renderButton.setForeground(table.getSelectionForeground());
                this.renderButton.setBackground(table.getSelectionBackground());
            } else {
                this.renderButton.setForeground(table.getForeground());
                this.renderButton.setBackground(UIManager.getColor("Button.background"));
            }
            if (hasFocus) {
                this.renderButton.setBorder(this.focusBorder);
            } else {
                this.renderButton.setBorder(this.originalBorder);
            }
            if (value == null) {
                this.renderButton.setText("");
                this.renderButton.setIcon(null);
            } else if (value instanceof Icon) {
                this.renderButton.setText("");
                this.renderButton.setIcon((Icon)value);
            } else {
                this.renderButton.setText(value.toString());
                this.renderButton.setIcon(null);
            }
            return this.renderButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = this.table.convertRowIndexToModel(this.table.getEditingRow());
            this.fireEditingStopped();
            ActionEvent event = new ActionEvent(this.table, 1001, "" + row);
            this.action.actionPerformed(event);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.table.isEditing() && this.table.getCellEditor() == this) {
                this.isButtonColumnEditor = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isButtonColumnEditor && this.table.isEditing()) {
                this.table.getCellEditor().stopCellEditing();
            }
            this.isButtonColumnEditor = false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class Model
    implements TableModel {
        private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
        private boolean first;

        Model() {
        }

        @Override
        public int getRowCount() {
            return PerformanceMonitor.this.componentStats.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.length;
        }

        @Override
        public String getColumnName(int i) {
            return COLUMNS[i];
        }

        @Override
        public Class<?> getColumnClass(int i) {
            return COLUMN_CLASSES[i];
        }

        @Override
        public boolean isCellEditable(int i, int i1) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Stats s = (Stats)PerformanceMonitor.this.componentStats.get(row);
            switch (column) {
                case 0: {
                    return s.getName();
                }
                case 1: {
                    return s.getType();
                }
                case 2: {
                    return s.getUiid();
                }
                case 3: {
                    return s.getParentName();
                }
                case 4: {
                    return s.getImageName();
                }
                case 5: {
                    return s.getInvocationCount();
                }
                case 6: {
                    return s.getFastest();
                }
                case 7: {
                    return s.getSlowest();
                }
            }
            return s.getAverage();
        }

        public void clear() {
            PerformanceMonitor.this.componentStats.clear();
            PerformanceMonitor.this.componentId = 0;
            idString = idString + "x";
            this.fireUpdate();
        }

        @Override
        public void setValueAt(Object o, int i, int i1) {
        }

        void fireUpdate() {
            for (TableModelListener t : this.listeners) {
                t.tableChanged(new TableModelEvent(this));
            }
        }

        @Override
        public void addTableModelListener(TableModelListener tl) {
            this.listeners.add(tl);
            if (!this.first) {
                this.first = true;
                Timer t = new Timer(2000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if (!PerformanceMonitor.this.paused) {
                            Model.this.fireUpdate();
                        }
                    }
                });
                t.setRepeats(true);
                t.start();
            }
        }

        @Override
        public void removeTableModelListener(TableModelListener tl) {
            this.listeners.remove(tl);
        }
    }

    static class Stats {
        private String name;
        private String type;
        private String uiid;
        private String parentName;
        private String imageName;
        private int invocationCount;
        private long fastest = Long.MAX_VALUE;
        private long slowest;
        private long[] allInvocations = new long[20];

        public Stats(Component c) {
            Image l;
            this.name = c.getName();
            this.type = c.getClass().getName();
            this.uiid = c.getUIID();
            if (c instanceof Label && (l = ((Label)c).getIcon()) != null) {
                this.imageName = l.getImageName();
            }
            if (c.getParent() != null) {
                this.parentName = c.getParent().getName();
            }
        }

        public void updateInvocation(long t) {
            this.fastest = Math.min(t, this.fastest);
            this.slowest = Math.max(t, this.slowest);
            if (this.allInvocations.length <= this.invocationCount) {
                long[] arr = new long[this.allInvocations.length * 3];
                System.arraycopy(this.allInvocations, 0, arr, 0, this.allInvocations.length);
                this.allInvocations = arr;
            }
            this.allInvocations[this.invocationCount] = t;
            ++this.invocationCount;
        }

        public long getAverage() {
            long total = 0L;
            for (int iter = 0; iter < this.invocationCount; ++iter) {
                total += this.allInvocations[iter];
            }
            return total / (long)this.invocationCount;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getParentName() {
            return this.parentName;
        }

        public int getInvocationCount() {
            return this.invocationCount;
        }

        public long getFastest() {
            return this.fastest;
        }

        public long getSlowest() {
            return this.slowest;
        }

        public long[] getAllInvocations() {
            return this.allInvocations;
        }

        public String getUiid() {
            return this.uiid;
        }

        public String getImageName() {
            return this.imageName;
        }
    }

    private class FormListener
    implements ActionListener,
    WindowListener,
    TreeSelectionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == PerformanceMonitor.this.clearData) {
                PerformanceMonitor.this.clearDataActionPerformed(evt);
            } else if (evt.getSource() == PerformanceMonitor.this.pauseContinue) {
                PerformanceMonitor.this.pauseContinueActionPerformed(evt);
            } else if (evt.getSource() == PerformanceMonitor.this.runGC) {
                PerformanceMonitor.this.runGCActionPerformed(evt);
            } else if (evt.getSource() == PerformanceMonitor.this.refreshFrame) {
                PerformanceMonitor.this.refreshFrameActionPerformed(evt);
            }
        }

        @Override
        public void windowActivated(WindowEvent evt) {
        }

        @Override
        public void windowClosed(WindowEvent evt) {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            if (evt.getSource() == PerformanceMonitor.this) {
                PerformanceMonitor.this.formWindowClosing(evt);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent evt) {
        }

        @Override
        public void windowDeiconified(WindowEvent evt) {
        }

        @Override
        public void windowIconified(WindowEvent evt) {
        }

        @Override
        public void windowOpened(WindowEvent evt) {
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            if (evt.getSource() == PerformanceMonitor.this.componentHierarchy) {
                PerformanceMonitor.this.componentHierarchyValueChanged(evt);
            }
        }
    }
}

