/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.impl.javase.Executor;
import com.codename1.impl.javase.JavaSEPort;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.UUID;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class PushSimulator
extends JFrame {
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JTextArea pushBody;
    private JButton pushError;
    private JComboBox pushType;
    private JButton registerForPush;
    private JButton sendPush;

    public PushSimulator() {
        this.initComponents();
        this.setLocationByPlatform(true);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                PushSimulator.this.dispose();
                Preferences pref = Preferences.userNodeForPackage(JavaSEPort.class);
                pref.putBoolean("PushSimulator", false);
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.pack();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.registerForPush = new JButton();
        this.pushError = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.pushBody = new JTextArea();
        this.sendPush = new JButton();
        this.pushType = new JComboBox();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("Push Simulation");
        this.jLabel1.setText("Push Events");
        this.registerForPush.setText("Registered Successfully");
        this.registerForPush.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PushSimulator.this.registerForPushActionPerformed(evt);
            }
        });
        this.pushError.setText("Registration Error");
        this.pushError.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PushSimulator.this.pushErrorActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Send Message");
        this.pushBody.setColumns(20);
        this.pushBody.setRows(5);
        this.jScrollPane1.setViewportView(this.pushBody);
        this.sendPush.setText("Send");
        this.sendPush.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PushSimulator.this.sendPushActionPerformed(evt);
            }
        });
        this.pushType.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "99", "100", "101", "102"}));
        this.jLabel3.setText("Push Type");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pushError, -1, -1, Short.MAX_VALUE).addComponent(this.registerForPush, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 394, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.sendPush))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pushType, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.registerForPush).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pushError).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pushType, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 81, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sendPush)));
        this.pack();
    }

    private void registerForPushActionPerformed(ActionEvent evt) {
        String k = com.codename1.io.Preferences.get((String)"push_key", null);
        if (k == null || !k.startsWith("cn1")) {
            k = "cn1-simulator-" + UUID.randomUUID().toString();
            com.codename1.io.Preferences.set((String)"push_key", (String)k);
        }
        Executor.registerForPush(k);
    }

    private void pushErrorActionPerformed(ActionEvent evt) {
        Executor.pushRegistrationError("Error During Push", -1);
    }

    private void sendPushActionPerformed(ActionEvent evt) {
        Executor.push(this.pushBody.getText(), Integer.parseInt((String)this.pushType.getSelectedItem()));
    }
}

