/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.db.Cursor;
import com.codename1.db.Database;
import com.codename1.impl.javase.SECursor;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SEDatabase
extends Database {
    private Connection conn;

    public SEDatabase(Connection conn) {
        this.conn = conn;
        try {
            conn.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void beginTransaction() throws IOException {
        System.out.println("**** Database.beginTransaction() is not supported in the Javascript port.  If you plan to deploy to Javascript, you should avoid this method. *****");
        try {
            this.conn.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    public void commitTransaction() throws IOException {
        System.out.println("**** Database.commitTransaction() is not supported in the Javascript port.  If you plan to deploy to Javascript, you should avoid this method. *****");
        try {
            this.conn.commit();
            this.conn.setAutoCommit(true);
        }
        catch (SQLException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    protected void finalize() throws Throwable {
        if (this.conn != null) {
            System.out.println("**** WARNING! Database object was released by the GC without being closed first! This might cause crashes on iOS *****");
        }
    }

    public void close() throws IOException {
        try {
            this.conn.close();
            this.conn = null;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    private void cleanup(PreparedStatement ps) {
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void execute(String sql) throws IOException {
        PreparedStatement s = null;
        try {
            s = this.conn.prepareStatement(sql);
            s.execute();
        }
        catch (SQLException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            this.cleanup(s);
        }
    }

    public void execute(String sql, String[] params) throws IOException {
        PreparedStatement s = null;
        try {
            s = this.conn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    String param = params[i];
                    s.setString(i + 1, param);
                }
            }
            s.execute();
        }
        catch (SQLException ex) {
            this.cleanup(s);
            throw new IOException(ex.getMessage(), ex);
        }
    }

    public void execute(String sql, Object ... params) throws IOException {
        PreparedStatement s = null;
        try {
            s = this.conn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    Object p = params[i];
                    if (p == null) {
                        s.setNull(i + 1, 0);
                        continue;
                    }
                    if (p instanceof String) {
                        s.setString(i + 1, (String)p);
                        continue;
                    }
                    if (p instanceof byte[]) {
                        s.setBytes(i + 1, (byte[])p);
                        continue;
                    }
                    if (p instanceof Double) {
                        s.setDouble(i + 1, (Double)p);
                        continue;
                    }
                    if (p instanceof Long) {
                        s.setLong(i + 1, (Long)p);
                        continue;
                    }
                    if (p instanceof Integer) {
                        s.setInt(i + 1, (Integer)p);
                        continue;
                    }
                    s.setString(i + 1, p.toString());
                }
            }
            s.execute();
        }
        catch (SQLException ex) {
            this.cleanup(s);
            throw new IOException(ex.getMessage(), ex);
        }
    }

    public Cursor executeQuery(String sql, String[] params) throws IOException {
        PreparedStatement s = null;
        try {
            s = this.conn.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    String param = params[i];
                    s.setString(i + 1, param);
                }
            }
            ResultSet resultSet = s.executeQuery();
            return new SECursor(resultSet);
        }
        catch (SQLException ex) {
            this.cleanup(s);
            throw new IOException(ex.getMessage(), ex);
        }
    }

    public Cursor executeQuery(String sql) throws IOException {
        PreparedStatement s = null;
        try {
            s = this.conn.prepareStatement(sql);
            ResultSet resultSet = s.executeQuery();
            return new SECursor(resultSet);
        }
        catch (SQLException ex) {
            this.cleanup(s);
            throw new IOException(ex.getMessage(), ex);
        }
    }

    public void rollbackTransaction() throws IOException {
        System.out.println("**** Database.rollbackTransaction() is not supported in the Javascript port.  If you plan to deploy to Javascript, you should avoid this method. *****");
        try {
            this.conn.rollback();
        }
        catch (SQLException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }
}

