/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.io.Log;
import com.codename1.ui.CN;
import com.codename1.ui.Display;
import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;

public class SourceChangeWatcher
implements Runnable {
    private WatchService watchService;
    private List<File> watchDirectories = new ArrayList<File>();
    private List<Watch> watches = new ArrayList<Watch>();
    private boolean stopped;
    private Object app;
    private boolean requiresRecompile;

    public void setApp(Object obj) {
        this.app = obj;
    }

    private Path getPathForKey(WatchKey key) {
        for (Watch w : this.watches) {
            if (!key.equals(w.key)) continue;
            return w.path;
        }
        return null;
    }

    private boolean recompile(Path path) throws IOException, InterruptedException {
        File f = path.toFile();
        File pom = this.findPom(f.getParentFile());
        if (pom == null) {
            System.out.println("Skipping recompile of " + path + " because no pom.xml was found");
            return false;
        }
        String mavenHome = System.getProperty("maven.home");
        if (mavenHome == null) {
            Log.p((String)("Not recompiling path " + path + " because maven.home system property was not found."));
            return false;
        }
        String mavenPath = mavenHome + File.separator + "bin" + File.separator + "mvn";
        if (!new File(mavenPath).exists()) {
            if (new File(mavenPath + ".exe").exists()) {
                mavenPath = mavenPath + ".exe";
            } else if (new File(mavenPath + ".bat").exists()) {
                mavenPath = mavenPath + ".bat";
            } else if (new File(mavenPath + ".cmd").exists()) {
                mavenPath = mavenPath + ".cmd";
            } else {
                Log.p((String)("Not recompiling path " + path + " because " + mavenPath + " could not be found."));
                return false;
            }
        }
        ProcessBuilder pb = new ProcessBuilder(mavenPath, "compile", "-DskipComplianceCheck");
        pb.environment().put("JAVA_HOME", System.getProperty("java.home"));
        pb.directory(pom.getParentFile());
        pb.inheritIO();
        Process p = pb.start();
        int result = p.waitFor();
        if (result != 0) {
            return false;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        CN.callSeriallyAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (SourceChangeWatcher.this.app != null) {
                        Method stop = SourceChangeWatcher.this.app.getClass().getMethod("stop", new Class[0]);
                        stop.invoke(SourceChangeWatcher.this.app, (Object[])new Class[0]);
                        Method start = SourceChangeWatcher.this.app.getClass().getMethod("start", new Class[0]);
                        start.invoke(SourceChangeWatcher.this.app, (Object[])new Class[0]);
                    }
                    CN.restoreToBookmark();
                }
                catch (Exception ex) {
                    Log.e((Throwable)ex);
                }
            }
        });
        return true;
    }

    private File findPom(File startingPoint) {
        File pom = new File(startingPoint, "pom.xml");
        if (pom.exists()) {
            return pom;
        }
        File parent = startingPoint.getParentFile();
        if (parent != null) {
            return this.findPom(parent);
        }
        return null;
    }

    private void registerWatchRecursive(File directory) throws IOException {
        if (directory.isDirectory()) {
            WatchKey key = directory.toPath().register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE}, SensitivityWatchEventModifier.HIGH);
            this.watches.add(new Watch(directory.toPath(), key));
            for (File child : directory.listFiles()) {
                this.registerWatchRecursive(child);
            }
        }
    }

    @Override
    public void run() {
        try {
            System.out.println("SourceChangeWatcher running.  Watching directories " + this.watchDirectories);
            this.watchService = FileSystems.getDefault().newWatchService();
            for (File directory : this.watchDirectories) {
                this.registerWatchRecursive(directory);
            }
            while (!this.stopped && Display.isInitialized()) {
                try {
                    WatchKey key = this.watchService.take();
                    if (this.stopped) {
                        return;
                    }
                    Path path = this.getPathForKey(key);
                    this.requiresRecompile = false;
                    key.pollEvents().forEach(evt -> {
                        System.out.println("[Watcher " + this + "] File changedL: " + evt.context() + " key=" + key);
                        if (evt.context().toString().endsWith(".java") || evt.context().toString().endsWith(".kt")) {
                            this.requiresRecompile = true;
                        }
                    });
                    if (this.requiresRecompile) {
                        System.out.println("Changes detected in directory " + path);
                        this.recompile(path);
                    }
                    key.reset();
                }
                catch (InterruptedException ex) {
                    if (this.stopped) {
                        return;
                    }
                    Log.e((Throwable)ex);
                }
            }
        }
        catch (IOException ex) {
            Log.e((Throwable)ex);
        }
    }

    public void stop() {
        this.stopped = true;
        try {
            if (this.watchService != null) {
                this.watchService.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addWatchFolder(File path) {
        System.out.println("Adding watch folder " + path);
        this.watchDirectories.add(path);
    }

    public boolean hasWatchFolder(File path) {
        return this.watchDirectories.contains(path);
    }

    private class Watch {
        private Path path;
        private WatchKey key;

        Watch(Path path, WatchKey key) {
            this.path = path;
            this.key = key;
        }
    }
}

