/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.impl.javase.JavaSEPort;
import com.codename1.impl.javase.LocationSimulation;
import com.codename1.io.Log;
import com.codename1.location.Geofence;
import com.codename1.location.GeofenceListener;
import com.codename1.location.Location;
import com.codename1.location.LocationListener;
import com.codename1.location.LocationManager;
import com.codename1.ui.Component;
import com.codename1.ui.Display;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

class StubLocationManager
extends LocationManager {
    private Timer geofenceTimer;
    private TimerTask geofenceTask;
    private Timer timer;
    private TimerTask task;
    private Location loc = new Location();
    private boolean checked;
    private static StubLocationManager instance = new StubLocationManager();
    List<Geofence> geoFences = new ArrayList<Geofence>();
    List<String> insideFences = new ArrayList<String>();

    private StubLocationManager() {
        Preferences p = Preferences.userNodeForPackage(Component.class);
        double lat = p.getDouble("lastGoodLat", 40.714353);
        double lon = p.getDouble("lastGoodLon", -74.005973);
        this.loc.setLongitude(lon);
        this.loc.setLatitude(lat);
        this.loc.setAccuracy(p.getFloat("accuracy", 55.0f));
        this.loc.setAltitude(p.getDouble("Altitude", 1000.0));
        this.loc.setDirection(p.getFloat("direction", 0.0f));
        this.loc.setVelocity(p.getFloat("velocity", 50.0f));
        this.loc.setStatus(p.getInt("state", 0));
        if (JavaSEPort.locSimulation == null) {
            JavaSEPort.locSimulation = new LocationSimulation();
        }
        JavaSEPort.locSimulation.setMeasUnit(p.getInt("unit", 0));
        JavaSEPort.locSimulation.setLocation(this.loc);
    }

    private void checkLocationRegistration() {
        if (!this.checked) {
            Map m = Display.getInstance().getProjectBuildHints();
            if (m != null && !m.containsKey("ios.locationUsageDescription")) {
                Display.getInstance().setProjectBuildHint("ios.locationUsageDescription", "Some functionality of the application depends on your location");
            }
            this.checked = true;
        }
    }

    public boolean isGPSDetectionSupported() {
        return true;
    }

    public boolean isGPSEnabled() {
        return true;
    }

    public static LocationManager getLocationManager() {
        return instance;
    }

    private boolean isInRegion(Location l, Geofence f) {
        return l.getDistanceTo(f.getLoc()) < (double)f.getRadius();
    }

    public void addGeoFencing(final Class GeofenceListenerClass, Geofence gf) {
        if (gf.getId() != null) {
            String id = gf.getId();
            int index = -1;
            for (Geofence f : this.geoFences) {
                if (!id.equals(f.getId())) continue;
                index = this.geoFences.indexOf(f);
                break;
            }
            if (index >= 0) {
                this.geoFences.remove(index);
            }
            if (gf.getRadius() < 0) {
                throw new IllegalArgumentException("Attempt to add geofence with negative radius");
            }
            if (gf.getRadius() < 100) {
                Log.p((String)("Adding Geofence with a radius of " + gf.getRadius() + " metres.  On an actual device, the effective radius will vary.  Typical Android and iOS devices have a minimum geofence radius of approximately 100m"));
            }
            long expires = gf.getExpiration();
            this.geoFences.add(gf);
            if (this.geofenceTimer == null) {
                this.geofenceTimer = new Timer();
                this.geofenceTask = new TimerTask(){

                    @Override
                    public void run() {
                        Display.getInstance().callSerially(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    GeofenceListener l;
                                    Location loc = StubLocationManager.this.getCurrentLocation();
                                    if (JavaSEPort.locSimulation == null) {
                                        loc.setLongitude(loc.getLongitude() + 0.001);
                                        loc.setLatitude(loc.getLatitude() + 0.001);
                                    } else {
                                        loc.setLongitude(JavaSEPort.locSimulation.getLongitude());
                                        loc.setLatitude(JavaSEPort.locSimulation.getLatitude());
                                    }
                                    for (final Geofence f : StubLocationManager.this.geoFences) {
                                        if (StubLocationManager.this.isInRegion(loc, f) || !StubLocationManager.this.insideFences.contains(f.getId())) continue;
                                        StubLocationManager.this.insideFences.remove(f.getId());
                                        try {
                                            l = (GeofenceListener)GeofenceListenerClass.newInstance();
                                            new Thread(){

                                                @Override
                                                public void run() {
                                                    l.onExit(f.getId());
                                                }
                                            }.start();
                                        }
                                        catch (Throwable t) {
                                            Log.e((Throwable)t);
                                        }
                                    }
                                    for (final Geofence f : StubLocationManager.this.geoFences) {
                                        if (!StubLocationManager.this.isInRegion(loc, f) || StubLocationManager.this.insideFences.contains(f.getId())) continue;
                                        StubLocationManager.this.insideFences.add(f.getId());
                                        try {
                                            l = (GeofenceListener)GeofenceListenerClass.newInstance();
                                            new Thread(){

                                                @Override
                                                public void run() {
                                                    l.onEntered(f.getId());
                                                }
                                            }.start();
                                        }
                                        catch (Throwable t) {
                                            Log.e((Throwable)t);
                                        }
                                    }
                                }
                                catch (IOException ex) {
                                    Logger.getLogger(StubLocationManager.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            }
                        });
                    }
                };
                this.geofenceTimer.schedule(this.geofenceTask, new Date(System.currentTimeMillis() + 10000L), 10000L);
            }
        } else {
            Log.p((String)"Attempt to add Geofence with null ID", (int)3);
        }
    }

    public void removeGeoFencing(String id) {
        int index = -1;
        for (Geofence gf : this.geoFences) {
            if (gf.getId() == null || !gf.getId().equals(id)) continue;
            index = this.geoFences.indexOf(gf);
            break;
        }
        if (index >= 0) {
            this.geoFences.remove(index);
        }
        if (this.geoFences.isEmpty() && this.geofenceTimer != null) {
            this.geofenceTimer.cancel();
            this.geofenceTimer = null;
            this.geofenceTask = null;
        }
    }

    public boolean isGeofenceSupported() {
        return true;
    }

    public Location getCurrentLocation() throws IOException {
        this.checkLocationRegistration();
        if (JavaSEPort.locSimulation != null) {
            this.loc.setLatitude(JavaSEPort.locSimulation.getLatitude());
            this.loc.setLongitude(JavaSEPort.locSimulation.getLongitude());
            this.loc.setAccuracy(JavaSEPort.locSimulation.getAccuracy());
            this.loc.setAltitude(JavaSEPort.locSimulation.getAltitude());
            this.loc.setDirection(JavaSEPort.locSimulation.getDirection());
            this.loc.setVelocity(JavaSEPort.locSimulation.getVelocity());
            this.loc.setStatus(JavaSEPort.locSimulation.getState());
        }
        this.loc.setTimeStamp(System.currentTimeMillis());
        return this.loc;
    }

    public Location getLastKnownLocation() {
        this.checkLocationRegistration();
        if (JavaSEPort.locSimulation != null) {
            this.loc.setLatitude(JavaSEPort.locSimulation.getLatitude());
            this.loc.setLongitude(JavaSEPort.locSimulation.getLongitude());
            this.loc.setAccuracy(JavaSEPort.locSimulation.getAccuracy());
            this.loc.setAltitude(JavaSEPort.locSimulation.getAltitude());
            this.loc.setDirection(JavaSEPort.locSimulation.getDirection());
            this.loc.setVelocity(JavaSEPort.locSimulation.getVelocity());
            this.loc.setStatus(JavaSEPort.locSimulation.getState());
        }
        this.loc.setTimeStamp(System.currentTimeMillis());
        return this.loc;
    }

    protected void bindListener() {
        this.checkLocationRegistration();
        this.setStatus(0);
        final LocationListener l = this.getLocationListener();
        this.task = new TimerTask(){

            @Override
            public void run() {
                Display.getInstance().callSerially(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Location loc = StubLocationManager.this.getCurrentLocation();
                            if (JavaSEPort.locSimulation == null) {
                                loc.setLongitude(loc.getLongitude() + 0.001);
                                loc.setLatitude(loc.getLatitude() + 0.001);
                            } else {
                                int s = JavaSEPort.locSimulation.getState();
                                if (s != StubLocationManager.super.getStatus()) {
                                    l.providerStateChanged(s);
                                    StubLocationManager.this.setStatus(s);
                                }
                            }
                            l.locationUpdated(loc);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(StubLocationManager.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
            }
        };
        this.timer = new Timer();
        this.timer.schedule(this.task, 3000L, 3000L);
    }

    protected void clearListener() {
        this.task.cancel();
        this.timer.cancel();
        this.timer = null;
        this.task = null;
    }

    public int getStatus() {
        Preferences p = Preferences.userNodeForPackage(Component.class);
        if (JavaSEPort.locSimulation != null) {
            int s = JavaSEPort.locSimulation.getState();
            this.setStatus(s);
            p.putInt("lastGoodLocationStat", s);
            return s;
        }
        return p.getInt("lastGoodLocationStat", super.getStatus());
    }
}

