/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.impl.javase.CN1Bootstrap;
import com.codename1.impl.javase.ClassPathLoader;
import com.codename1.impl.javase.JavaSEPort;
import com.codename1.testing.JUnitXMLReporting;
import com.codename1.testing.TestReporting;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;

public class TestRunner {
    private static final int VERSION = 1;
    private String mainClass;
    private String[] testCases;
    private String[] skins;
    private boolean forceLandscape;
    private boolean forcePortrait;
    private boolean quietMode;
    private boolean cleanMode = true;
    private boolean stopOnFail;

    private TestRunner() {
    }

    private void printUsage() {
        System.out.println("Usage: TestRunner mainClass [-testCases testCase1,testCase2...] [-skins skin1,skin2...] [-quiet] [-cleanMode] [-junitXML][-stopOnFail]\n\nmainClass - the main application class which is being tested, this is the full name for the lifecycle class.\ntestCases - optional set of test cases to run using the full package/class name syntax and comma delimited. If ommitted all test cases will be executed.\nskins - the skins on which the test cases should be executed. If ommitted the default simulator skin is used.\nquietMode - when set the skin running the tests will not appear and the tests will be executed in the background\ncleanMode - clean mode executes every test in complete isolation from the previous test restarting the Classloadercompletely. Clean mode can't be used on the device so its only useful for debugging\nstopOnFail - indicates that execution should stop the moment a failure occured\njunitXML - output is written in junit XML format");
    }

    private void init(String[] argv) {
        try {
            Preferences pref;
            int iter;
            String[] tests;
            if (argv[0].startsWith("-") || argv[0].startsWith("/")) {
                this.printUsage();
                return;
            }
            try {
                this.mainClass = argv[0];
                int pos = 1;
                while (pos < argv.length) {
                    String s = argv[pos];
                    if (s.equalsIgnoreCase("-stopOnFail")) {
                        ++pos;
                        this.stopOnFail = true;
                        continue;
                    }
                    if (s.equalsIgnoreCase("-testCases")) {
                        this.testCases = argv[++pos].split(",");
                        ++pos;
                        continue;
                    }
                    if (s.equalsIgnoreCase("-skins")) {
                        this.skins = argv[++pos].split(",");
                        ++pos;
                        continue;
                    }
                    if (s.equalsIgnoreCase("-landscape")) {
                        this.forceLandscape = true;
                        ++pos;
                        continue;
                    }
                    if (s.equalsIgnoreCase("-portrait")) {
                        this.forcePortrait = true;
                        ++pos;
                        continue;
                    }
                    if (s.equalsIgnoreCase("-quietMode")) {
                        this.quietMode = true;
                        ++pos;
                        continue;
                    }
                    if (s.equalsIgnoreCase("-junitXML")) {
                        TestReporting.setInstance((TestReporting)new JUnitXMLReporting());
                    }
                    if (s.equalsIgnoreCase("-cleanMode")) {
                        this.cleanMode = true;
                        ++pos;
                        continue;
                    }
                    System.out.println("Unrecognized argument: " + s);
                    this.printUsage();
                    System.exit(1);
                    return;
                }
            }
            catch (Exception err) {
                err.printStackTrace();
                this.printUsage();
                return;
            }
            if (this.testCases == null || this.testCases.length == 0) {
                InputStream is = this.getClass().getResourceAsStream("/tests.dat");
                if (is == null) {
                    System.err.println("Test data not found in the file, make sure the ant task was executed in full");
                    System.exit(2);
                    return;
                }
                DataInputStream di = new DataInputStream(is);
                int version = di.readInt();
                if (version > 1) {
                    System.err.println("Tests were built with a new version of Codename One and can't be executed with this runner");
                    System.exit(4);
                    return;
                }
                tests = new String[di.readInt()];
                for (iter = 0; iter < tests.length; ++iter) {
                    tests[iter] = di.readUTF();
                }
                di.close();
            } else {
                tests = this.testCases;
            }
            if (this.forceLandscape) {
                System.out.println("Forcing landscape");
                pref = Preferences.userNodeForPackage(JavaSEPort.class);
                pref.putBoolean("Portrait", false);
                pref.sync();
            } else if (this.forcePortrait) {
                System.out.println("Forcing portrait");
                pref = Preferences.userNodeForPackage(JavaSEPort.class);
                pref.putBoolean("Portrait", true);
                pref.sync();
            }
            System.out.println("Preparing to execute " + tests.length + " tests");
            String classPathStr = System.getProperty("java.class.path");
            if (System.getProperty("cn1.class.path") != null) {
                classPathStr = classPathStr + File.pathSeparator + System.getProperty("cn1.class.path");
            }
            StringTokenizer t = new StringTokenizer(classPathStr, File.pathSeparator);
            File[] files = new File[t.countTokens()];
            for (iter = 0; iter < files.length; ++iter) {
                files[iter] = new File(t.nextToken());
            }
            int passedTests = 0;
            int failedTests = 0;
            if (this.cleanMode) {
                for (String currentTestClass : tests) {
                    ClassPathLoader ldr = new ClassPathLoader(files);
                    Class<?> c = Class.forName("com.codename1.impl.javase.TestExecuter", true, ldr);
                    Method m = c.getDeclaredMethod("runTest", String.class, String.class, Boolean.TYPE);
                    Boolean passed = (Boolean)m.invoke(null, this.mainClass, currentTestClass, this.quietMode);
                    if (passed.booleanValue()) {
                        ++passedTests;
                        continue;
                    }
                    ++failedTests;
                    if (!this.stopOnFail) continue;
                    System.exit(100);
                    return;
                }
            } else {
                ClassPathLoader ldr = new ClassPathLoader(files);
                Class<?> c = Class.forName("com.codename1.impl.javase.TestExecuter", true, ldr);
                for (String currentTestClass : tests) {
                    Method m = c.getDeclaredMethod("runTest", String.class, String.class, Boolean.TYPE);
                    Boolean passed = (Boolean)m.invoke(null, this.mainClass, currentTestClass, this.quietMode);
                    if (passed.booleanValue()) {
                        System.out.println(currentTestClass + " passed!");
                        ++passedTests;
                        continue;
                    }
                    System.out.println(currentTestClass + " failed!");
                    ++failedTests;
                    if (!this.stopOnFail) continue;
                    System.exit(100);
                    return;
                }
            }
            TestReporting.getInstance().testExecutionFinished();
            int exitCode = 0;
            if (failedTests > 0) {
                System.out.println("Test execution finished, some failed tests occured. Passed: " + passedTests + " tests. Failed: " + failedTests + " tests.");
                exitCode = 100;
            } else {
                System.out.println("All tests passed. Total " + passedTests + " tests passed");
            }
            System.exit(exitCode);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(3);
        }
    }

    public static void main(String[] argv) throws Exception {
        if (CN1Bootstrap.run(TestRunner.class, argv)) {
            return;
        }
        new TestRunner().init(argv);
    }
}

