/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.ui.Component;
import com.codename1.ui.Display;
import com.codename1.ui.Form;

public class TextEditUtil {
    public static Component curEditedComponent;

    public static void setCurrentEditComponent(Component current) {
        curEditedComponent = current;
    }

    public static boolean isLastEditComponent() {
        return TextEditUtil.getNextEditComponent() == null;
    }

    public static void editNextTextArea() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                Component next = TextEditUtil.getNextEditComponent();
                if (next != null && next.isFocusable()) {
                    next.requestFocus();
                    next.startEditingAsync();
                }
            }
        };
        Display.getInstance().callSerially(task);
    }

    public static void editPrevTextArea() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                Component next = TextEditUtil.getPrevEditComponent();
                if (next != null && next.isFocusable()) {
                    next.requestFocus();
                    next.startEditingAsync();
                }
            }
        };
        Display.getInstance().callSerially(task);
    }

    private static Component getNextEditComponent() {
        Form parent;
        if (curEditedComponent != null && (parent = curEditedComponent.getComponentForm()) != null) {
            return parent.getNextComponent(curEditedComponent);
        }
        return null;
    }

    private static Component getPrevEditComponent() {
        Form parent;
        if (curEditedComponent != null && (parent = curEditedComponent.getComponentForm()) != null) {
            return parent.getPreviousComponent(curEditedComponent);
        }
        return null;
    }
}

