/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase.cef;

import com.codename1.impl.javase.cef.ClientSchemeHandler;
import com.codename1.impl.javase.cef.InputStreamSchemeHandler;
import com.codename1.impl.javase.cef.SearchSchemeHandler;
import org.cef.CefApp;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.callback.CefSchemeRegistrar;
import org.cef.handler.CefAppHandlerAdapter;
import org.cef.handler.CefResourceHandler;
import org.cef.network.CefRequest;

public class AppHandler
extends CefAppHandlerAdapter {
    public AppHandler(String[] args) {
        super(args);
    }

    public void onRegisterCustomSchemes(CefSchemeRegistrar registrar) {
        if (registrar.addCustomScheme("search", true, false, false, false, true, false, false)) {
            System.out.println("Added scheme search://");
        }
        if (registrar.addCustomScheme("client", true, false, false, false, true, false, false)) {
            System.out.println("Added scheme client://");
        }
        if (registrar.addCustomScheme("cn1stream", false, false, false, true, true, true, false)) {
            System.out.println("Added scheme cn1stream://");
        }
    }

    public void onContextInitialized() {
        CefApp cefApp = CefApp.getInstance();
        cefApp.registerSchemeHandlerFactory("search", "", (CefSchemeHandlerFactory)new SchemeHandlerFactory());
        cefApp.registerSchemeHandlerFactory("client", "tests", (CefSchemeHandlerFactory)new SchemeHandlerFactory());
        cefApp.registerSchemeHandlerFactory("cn1stream", "cn1app", (CefSchemeHandlerFactory)new SchemeHandlerFactory());
    }

    public void stateHasChanged(CefApp.CefAppState state) {
        System.out.println("AppHandler.stateHasChanged: " + state);
        if (state == CefApp.CefAppState.TERMINATED || state == CefApp.CefAppState.SHUTTING_DOWN) {
            System.exit(0);
        }
    }

    private class SchemeHandlerFactory
    implements CefSchemeHandlerFactory {
        private SchemeHandlerFactory() {
        }

        public CefResourceHandler create(CefBrowser browser, CefFrame frame, String schemeName, CefRequest request) {
            if (schemeName.equals("search")) {
                return new SearchSchemeHandler(browser);
            }
            if (schemeName.equals("client")) {
                return new ClientSchemeHandler();
            }
            if (schemeName.equals("cn1stream")) {
                return new InputStreamSchemeHandler();
            }
            return null;
        }
    }
}

