/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase.cef;

import com.codename1.impl.javase.JavaSEPort;
import com.codename1.impl.javase.cef.AppHandler;
import com.codename1.impl.javase.cef.CEFComponentFactory;
import com.codename1.impl.javase.cef.CEFPeerComponentBuffer;
import com.codename1.impl.javase.cef.CEFUIPlatform;
import com.codename1.impl.javase.cef.ContextMenuHandler;
import com.codename1.impl.javase.cef.DragHandler;
import com.codename1.impl.javase.cef.JSDialogHandler;
import com.codename1.impl.javase.cef.KeyboardHandler;
import com.codename1.impl.javase.cef.MessageRouterHandler;
import com.codename1.impl.javase.cef.RequestHandler;
import com.codename1.impl.javase.cef.StreamRegistry;
import com.codename1.ui.CN;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.BrowserNavigationCallback;
import java.awt.CardLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.ref.WeakReference;
import java.net.ServerSocket;
import javax.swing.SwingUtilities;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CN1CefBrowser;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefRequestHandler;

public abstract class BrowserPanel
extends JavaSEPort.CN1JPanel {
    private static StreamRegistry streamRegistry_ = new StreamRegistry();
    private boolean isClosed_ = false;
    private CefBrowser browser_ = null;
    private static int browserCount_ = 0;
    private Runnable afterParentChangedAction_ = null;
    private String title_ = null;
    private String url_ = null;
    private final CefClient client_;
    private String errorMsg_ = "";
    private boolean browserFocus_ = true;
    private Runnable readyCallback;
    private boolean ready_;

    public BrowserPanel(CEFPeerComponentBuffer buffer, BrowserNavigationCallback navigationCallback, boolean osrEnabled, boolean transparentPaintingEnabled, boolean createImmediately, String[] args) {
        this("about:blank", buffer, navigationCallback, osrEnabled, transparentPaintingEnabled, createImmediately, args);
    }

    public BrowserPanel(String startingURL, CEFPeerComponentBuffer buffer, BrowserNavigationCallback navigationCallback, boolean osrEnabled, boolean transparentPaintingEnabled, boolean createImmediately, String[] args) {
        CefApp myApp;
        this.setZoom(1.0);
        this.setLayout(new CardLayout());
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                if (BrowserPanel.this.browser_ != null) {
                    BrowserPanel.this.browser_.getUIComponent().requestFocus();
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
        if (CefApp.getState() != CefApp.CefAppState.INITIALIZED) {
            CefSettings settings = new CefSettings();
            settings.windowless_rendering_enabled = osrEnabled;
            CefSettings cefSettings = settings;
            cefSettings.getClass();
            settings.background_color = new CefSettings.ColorType(cefSettings, 255, 255, 0, 0);
            settings.user_agent = CN.getProperty((String)"user-agent", (String)"Mozilla/5.0 (iPhone; CPU iPhone OS 13_5 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/83.0.4103.88 Mobile/15E148 Safari/604.1");
            int port = 8088;
            try {
                ServerSocket sock = new ServerSocket(0);
                port = sock.getLocalPort();
                sock.close();
            }
            catch (Exception sock) {
                // empty catch block
            }
            settings.remote_debugging_port = port;
            JavaSEPort.instance.setChromeDebugPort(port);
            myApp = CefApp.getInstance((String[])args, (CefSettings)settings);
            CefApp.CefVersion version = myApp.getVersion();
            System.out.println("Using:\n" + version);
            CefApp.addAppHandler((CefAppHandler)new AppHandler(args));
        } else {
            myApp = CefApp.getInstance((String[])args);
        }
        this.client_ = myApp.createClient();
        this.client_.addContextMenuHandler((CefContextMenuHandler)new ContextMenuHandler(this));
        this.client_.addDragHandler((CefDragHandler)new DragHandler());
        this.client_.addJSDialogHandler((CefJSDialogHandler)new JSDialogHandler());
        this.client_.addKeyboardHandler((CefKeyboardHandler)new KeyboardHandler());
        this.client_.addRequestHandler((CefRequestHandler)new RequestHandler(this, navigationCallback));
        CefMessageRouter msgRouter = CefMessageRouter.create();
        msgRouter.addHandler((CefMessageRouterHandler)new MessageRouterHandler(navigationCallback), true);
        this.client_.addMessageRouter(msgRouter);
        this.client_.addDisplayHandler((CefDisplayHandler)BrowserPanel.createDisplayHandlerAdapter(this));
        this.client_.addLoadHandler((CefLoadHandler)BrowserPanel.createLoadHandler(this));
        CN1CefBrowser.setComponentFactory(new CEFComponentFactory());
        CN1CefBrowser.setUIPlatform(new CEFUIPlatform());
        CefBrowser browser = this.client_.createBrowser(startingURL, osrEnabled, transparentPaintingEnabled, null);
        ((CN1CefBrowser)browser).setPeerComponentBuffer(buffer);
        this.setBrowser(browser);
        this.client_.addFocusHandler((CefFocusHandler)BrowserPanel.createFocusHandler(this));
        if (createImmediately) {
            browser.createImmediately();
        }
        this.add(this.getBrowser().getUIComponent());
    }

    private static CefFocusHandlerAdapter createFocusHandler(BrowserPanel p) {
        final WeakReference<BrowserPanel> selfRef = new WeakReference<BrowserPanel>(p);
        return new CefFocusHandlerAdapter(){

            public void onGotFocus(CefBrowser browser) {
                BrowserPanel self = (BrowserPanel)selfRef.get();
                if (self == null) {
                    return;
                }
                if (self.browserFocus_) {
                    return;
                }
                self.browserFocus_ = true;
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                browser.setFocus(true);
            }

            public void onTakeFocus(CefBrowser browser, boolean next) {
                BrowserPanel self = (BrowserPanel)selfRef.get();
                if (self == null) {
                    return;
                }
                self.browserFocus_ = false;
            }
        };
    }

    private static CefDisplayHandlerAdapter createDisplayHandlerAdapter(BrowserPanel p) {
        final WeakReference<BrowserPanel> selfRef = new WeakReference<BrowserPanel>(p);
        return new CefDisplayHandlerAdapter(){

            public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
                BrowserPanel self = (BrowserPanel)selfRef.get();
                if (self != null) {
                    self.url_ = url;
                }
            }

            public void onTitleChange(CefBrowser browser, String title) {
                BrowserPanel self = (BrowserPanel)selfRef.get();
                if (self != null) {
                    self.setTitle(title);
                }
            }

            public void onStatusMessage(CefBrowser browser, String value) {
            }
        };
    }

    private static CefLoadHandlerAdapter createLoadHandler(BrowserPanel p) {
        final WeakReference<BrowserPanel> selfRef = new WeakReference<BrowserPanel>(p);
        return new CefLoadHandlerAdapter(){

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                BrowserPanel self = (BrowserPanel)selfRef.get();
                if (self != null) {
                    if (isLoading) {
                        self.onStart(new ActionEvent((Object)self.url_));
                    } else {
                        self.onLoad(new ActionEvent((Object)self.url_));
                    }
                }
            }

            public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                BrowserPanel self = (BrowserPanel)selfRef.get();
                if (self != null) {
                    self.onError(new ActionEvent((Object)errorText, errorCode.getCode()));
                    if (errorCode != CefLoadHandler.ErrorCode.ERR_NONE && errorCode != CefLoadHandler.ErrorCode.ERR_ABORTED) {
                        self.errorMsg_ = "<html><head>";
                        BrowserPanel browserPanel = self;
                        browserPanel.errorMsg_ = browserPanel.errorMsg_ + "<title>Error while loading</title>";
                        browserPanel = self;
                        browserPanel.errorMsg_ = browserPanel.errorMsg_ + "</head><body>";
                        browserPanel = self;
                        browserPanel.errorMsg_ = browserPanel.errorMsg_ + "<h1>" + errorCode + "</h1>";
                        browserPanel = self;
                        browserPanel.errorMsg_ = browserPanel.errorMsg_ + "<h3>Failed to load " + failedUrl + "</h3>";
                        browserPanel = self;
                        browserPanel.errorMsg_ = browserPanel.errorMsg_ + "<p>" + (errorText == null ? "" : errorText) + "</p>";
                        browserPanel = self;
                        browserPanel.errorMsg_ = browserPanel.errorMsg_ + "</body></html>";
                        browser.stopLoad();
                    }
                }
            }
        };
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    private static CefLifeSpanHandlerAdapter createLifespanHandler(BrowserPanel p) {
        final WeakReference<BrowserPanel> selfRef = new WeakReference<BrowserPanel>(p);
        return new CefLifeSpanHandlerAdapter(){

            public void onAfterCreated(CefBrowser browser) {
                BrowserPanel self = (BrowserPanel)selfRef.get();
                if (self == null) {
                    return;
                }
                browserCount_++;
                self.ready_ = true;
                if (self.readyCallback != null) {
                    self.readyCallback.run();
                }
            }

            public void onAfterParentChanged(CefBrowser browser) {
                BrowserPanel self = (BrowserPanel)selfRef.get();
                if (self == null) {
                    return;
                }
                if (self.afterParentChangedAction_ != null) {
                    SwingUtilities.invokeLater(self.afterParentChangedAction_);
                    self.afterParentChangedAction_ = null;
                }
            }

            public boolean doClose(CefBrowser browser) {
                boolean result = browser.doClose();
                return result;
            }

            public void onBeforeClose(CefBrowser browser) {
                if (--browserCount_ == 0) {
                    // empty if block
                }
            }
        };
    }

    public void setBrowser(CefBrowser browser) {
        if (this.browser_ == null) {
            this.browser_ = browser;
        }
        this.browser_.getClient().removeLifeSpanHandler();
        this.browser_.getClient().addLifeSpanHandler((CefLifeSpanHandler)BrowserPanel.createLifespanHandler(this));
    }

    public void removeBrowser(Runnable r) {
        this.afterParentChangedAction_ = r;
        this.remove(this.browser_.getUIComponent());
        this.browser_.getUIComponent().removeNotify();
        this.browser_ = null;
    }

    public CefBrowser getBrowser() {
        return this.browser_;
    }

    public void setTitle(String title) {
        this.title_ = title;
    }

    public String getTitle() {
        return this.title_;
    }

    public String getURL() {
        return this.url_;
    }

    protected abstract void onLoad(ActionEvent var1);

    protected abstract void onStart(ActionEvent var1);

    protected abstract void onError(ActionEvent var1);

    public void setReadyCallback(Runnable r) {
        this.readyCallback = r;
        if (this.readyCallback != null && this.ready_) {
            this.readyCallback.run();
        }
    }

    public void cleanup() {
        if (this.isClosed_) {
            return;
        }
        this.isClosed_ = true;
        if (this.browser_ != null) {
            this.browser_.setCloseAllowed();
        }
        if (this.client_ != null) {
            this.client_.dispose();
        }
    }

    public static StreamRegistry getStreamRegistry() {
        return streamRegistry_;
    }
}

