/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase.cef;

import com.codename1.impl.javase.IBrowserComponent;
import com.codename1.impl.javase.JavaSEPort;
import com.codename1.impl.javase.cef.BrowserPanel;
import com.codename1.impl.javase.cef.CEFBrowserComponentAdapter;
import com.codename1.impl.javase.cef.CEFBrowserComponentListener;
import com.codename1.impl.javase.cef.CEFPeerComponentBuffer;
import com.codename1.impl.javase.cef.StreamWrapper;
import com.codename1.io.Util;
import com.codename1.ui.BrowserComponent;
import com.codename1.ui.CN;
import com.codename1.ui.Component;
import com.codename1.ui.Display;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.BrowserNavigationCallback;
import com.codename1.ui.events.FocusListener;
import java.awt.Container;
import java.awt.EventQueue;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import org.cef.CefApp;
import org.cef.CefSettings;
import org.cef.browser.CN1CefBrowserFactory;
import org.cef.browser.CefBrowserFactory;

public class CEFBrowserComponent
extends JavaSEPort.Peer
implements IBrowserComponent {
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static final boolean isWindows = CEFBrowserComponent.isWindows();
    private static final boolean isMac = CEFBrowserComponent.isMac();
    private static final boolean isUnix = CEFBrowserComponent.isUnix();
    private static final boolean is64Bit = CEFBrowserComponent.is64Bit();
    private static final String ARCH = System.getProperty("os.arch");
    private BrowserPanel panel;
    private boolean ready;
    private List<Runnable> readyCallbacks = new LinkedList<Runnable>();
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(Component cmp) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CEFBrowserComponent.this.panel.requestFocus();
                }
            });
        }

        public void focusLost(Component cmp) {
        }
    };
    private String url_;
    private String title_;
    private final Object readyLock = new Object();

    private static final boolean is64Bit() {
        String model = System.getProperty("sun.arch.data.model", System.getProperty("com.ibm.vm.bitmode"));
        if (model != null) {
            return "64".equals(model);
        }
        return "x86-64".equals(ARCH) || "ia64".equals(ARCH) || "ppc64".equals(ARCH) || "ppc64le".equals(ARCH) || "sparcv9".equals(ARCH) || "mips64".equals(ARCH) || "mips64el".equals(ARCH) || "amd64".equals(ARCH) || "aarch64".equals(ARCH);
    }

    private static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    private static boolean isMac() {
        return OS.indexOf("mac") >= 0;
    }

    private static boolean isUnix() {
        return OS.indexOf("nux") >= 0;
    }

    public CEFBrowserComponent(JFrame frame, BrowserPanel browserPanel) {
        super(frame, browserPanel);
        this.panel = browserPanel;
        this.setFocusable(true);
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    @Override
    protected void initComponent() {
        super.initComponent();
        this.addFocusListener(this.focusListener);
    }

    @Override
    protected void deinitialize() {
        this.removeFocusListener(this.focusListener);
        super.deinitialize();
    }

    private static String getLibPath() {
        String out = System.getProperty("cef.libPath", null);
        if (out != null) {
            return out;
        }
        if (isMac) {
            String cefRoot = System.getProperty("cef.dir", System.getProperty("user.home") + File.separator + ".codenameone" + File.separator + "cef") + File.separator;
            return cefRoot + "macos64";
        }
        if (isWindows) {
            String bitSuffix = is64Bit ? "64" : "32";
            String cefRoot = System.getProperty("cef.dir", System.getProperty("user.home") + File.separator + ".codenameone" + File.separator + "cef") + File.separator + "lib" + File.separator;
            return cefRoot + "win" + bitSuffix;
        }
        if (isUnix && is64Bit) {
            String bitSuffix = is64Bit ? "64" : "32";
            String cefRoot = System.getProperty("cef.dir", System.getProperty("user.home") + File.separator + ".codenameone" + File.separator + "cef") + File.separator + "lib" + File.separator;
            return cefRoot + "linux" + bitSuffix;
        }
        throw new UnsupportedOperationException("CEF Not implemented on this platform yet");
    }

    private static String[] createArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (isMac) {
            if (!"true".equals(System.getProperty("cn1.cef.bundled"))) {
                args.add(String.format("--framework-dir-path=%s/Chromium Embedded Framework.framework", CEFBrowserComponent.getLibPath()));
                args.add(String.format("--main-bundle-path=%s/jcef Helper.app", CEFBrowserComponent.getLibPath()));
                args.add(String.format("--browser-subprocess-path=%s/jcef Helper.app/Contents/MacOS/jcef Helper", CEFBrowserComponent.getLibPath()));
            }
            args.add("--disable-gpu");
        } else if (isWindows) {
            args.add("--disable-gpu");
            args.add("--disable-software-rasterizer");
            args.add("--disable-gpu-compositing");
        } else if (isUnix) {
            args.add("--disable-gpu");
            args.add("--disable-software-rasterizer");
            args.add("--disable-gpu-compositing");
        } else {
            throw new UnsupportedOperationException("CEF Not implemented on this platform yet");
        }
        args.add("--touch-events=enabled");
        args.add("--enable-media-stream");
        args.add("--autoplay-policy=no-user-gesture-required");
        args.add("--enable-usermedia-screen-capturing");
        return args.toArray(new String[args.size()]);
    }

    public static CEFBrowserComponent create(BrowserComponent bc) {
        return CEFBrowserComponent.create(new CEFBrowserComponentAdapter(bc));
    }

    public static CEFBrowserComponent create(CEFBrowserComponentListener parent) {
        return CEFBrowserComponent.create(null, parent);
    }

    public static CEFBrowserComponent create(String startingURL, CEFBrowserComponentListener parent) {
        CefSettings settings = new CefSettings();
        String[] args = CEFBrowserComponent.createArgs();
        if (!"true".equals(System.getProperty("cef.started", "false"))) {
            if (!CefApp.startup((String[])args)) {
                System.err.println("CEFStartup initialization failed");
                throw new RuntimeException("CEF Startup initialization failed!");
            }
            System.setProperty("cef.started", "true");
        }
        boolean osrEnabledArg = true;
        boolean transparentPaintingEnabledArg = true;
        boolean createImmediately = true;
        for (String arg : args) {
            if ((arg = arg.toLowerCase()).equals("--off-screen-rendering-enabled")) {
                osrEnabledArg = true;
                continue;
            }
            if (arg.equals("--transparent-painting-enabled")) {
                transparentPaintingEnabledArg = true;
                continue;
            }
            if (!arg.equals("--create-immediately")) continue;
            createImmediately = true;
        }
        CEFPeerComponentBuffer buffer = new CEFPeerComponentBuffer();
        final WeakReference<CEFBrowserComponentListener> parentRef = new WeakReference<CEFBrowserComponentListener>(parent);
        BrowserNavigationCallback navigationCallback = new BrowserNavigationCallback(){
            private CEFBrowserComponentListener l;
            {
                this.l = (CEFBrowserComponentListener)parentRef.get();
            }

            public boolean shouldNavigate(String url) {
                if (this.l != null) {
                    return this.l.shouldNavigate(url);
                }
                return false;
            }
        };
        BrowserPanel panel = new BrowserPanel(startingURL, buffer, navigationCallback, osrEnabledArg, transparentPaintingEnabledArg, createImmediately, args){
            private CEFBrowserComponentListener p;
            {
                super(startingURL, buffer, navigationCallback, osrEnabled, transparentPaintingEnabled, createImmediately, args);
                this.p = (CEFBrowserComponentListener)parentRef.get();
            }

            @Override
            protected void onError(ActionEvent l) {
                if (this.p != null) {
                    this.p.onError(l);
                }
            }

            @Override
            protected void onStart(ActionEvent l) {
                if (this.p != null) {
                    this.p.onStart(l);
                }
            }

            @Override
            protected void onLoad(ActionEvent l) {
                if (this.p != null) {
                    this.p.onLoad(l);
                }
            }
        };
        Container cnt = JavaSEPort.instance.getCanvas().getParent();
        while (!(cnt instanceof JFrame)) {
            if ((cnt = cnt.getParent()) != null) continue;
            System.err.println("CEFBrowserComponent requires a JFrame as an ancestor.  None found.  Returning null");
            return null;
        }
        CEFBrowserComponent out = new CEFBrowserComponent((JFrame)cnt, panel);
        out.setPeerComponentBuffer(buffer);
        final WeakReference<CEFBrowserComponent> weakRef = new WeakReference<CEFBrowserComponent>(out);
        panel.setReadyCallback(new Runnable(){

            @Override
            public void run() {
                CEFBrowserComponent callback = (CEFBrowserComponent)weakRef.get();
                if (callback != null) {
                    callback.fireReady();
                }
            }
        });
        return out;
    }

    @Override
    public void back() {
        if (!this.ready) {
            this.readyCallbacks.add(new Runnable(){

                @Override
                public void run() {
                    CEFBrowserComponent.this.back();
                }
            });
            return;
        }
        this.panel.getBrowser().goBack();
    }

    @Override
    public void forward() {
        if (!this.ready) {
            this.readyCallbacks.add(new Runnable(){

                @Override
                public void run() {
                    CEFBrowserComponent.this.forward();
                }
            });
            return;
        }
        this.panel.getBrowser().goForward();
    }

    @Override
    public void setPage(String html, String baseUrl) {
        if (Display.getInstance().getProperty("cef.setPage.useDataURI", "false").equals("true")) {
            this.setURL("data:text/html," + Util.encodeUrl((String)html));
            return;
        }
        try {
            byte[] bytes = html.getBytes("UTF-8");
            StreamWrapper stream = new StreamWrapper(new ByteArrayInputStream(bytes), "text/html", bytes.length);
            String id = BrowserPanel.getStreamRegistry().registerStream(stream);
            String url = "https://cn1app/streams/" + id;
            this.setURL(url);
        }
        catch (Exception ex) {
            this.setURL("data:text/html," + Util.encodeUrl((String)html));
        }
    }

    @Override
    public String getTitle() {
        if (!this.ready) {
            return this.title_;
        }
        return this.panel.getTitle();
    }

    @Override
    public String getURL() {
        if (!this.ready) {
            return this.url_;
        }
        return this.panel.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setURL(final String url) {
        Object object = this.readyLock;
        synchronized (object) {
            if (!this.ready) {
                this.url_ = url;
                this.readyCallbacks.add(new Runnable(){

                    @Override
                    public void run() {
                        CEFBrowserComponent.this.setURL(url);
                    }
                });
                return;
            }
        }
        this.url_ = url;
        this.panel.getBrowser().loadURL(url);
    }

    @Override
    public void stop() {
        if (!this.ready) {
            this.readyCallbacks.add(new Runnable(){

                @Override
                public void run() {
                    CEFBrowserComponent.this.stop();
                }
            });
            return;
        }
        this.panel.getBrowser().stopLoad();
    }

    @Override
    public void reload() {
        if (!this.ready) {
            this.readyCallbacks.add(new Runnable(){

                @Override
                public void run() {
                    CEFBrowserComponent.this.reload();
                }
            });
            return;
        }
        this.panel.getBrowser().reload();
    }

    @Override
    public boolean hasBack() {
        if (!this.ready) {
            return false;
        }
        return this.panel.getBrowser().canGoBack();
    }

    @Override
    public boolean hasForward() {
        if (!this.ready) {
            return false;
        }
        return this.panel.getBrowser().canGoForward();
    }

    @Override
    public void execute(final String js) {
        if (!this.ready) {
            this.readyCallbacks.add(new Runnable(){

                @Override
                public void run() {
                    CEFBrowserComponent.this.execute(js);
                }
            });
            return;
        }
        this.panel.getBrowser().executeJavaScript(js, js, 0);
    }

    @Override
    public String executeAndReturnString(String js) {
        throw new UnsupportedOperationException("Not supported .");
    }

    @Override
    public void setProperty(String key, Object value) {
        if (key.equalsIgnoreCase("User-Agent")) {
            // empty if block
        }
    }

    @Override
    public void runLater(Runnable r) {
        EventQueue.invokeLater(r);
    }

    @Override
    public void clearHistory() {
    }

    @Override
    public void exposeInJavaScript(Object o, String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireReady() {
        if (!CN.isEdt()) {
            CN.callSerially((Runnable)new Runnable(){

                @Override
                public void run() {
                    CEFBrowserComponent.this.fireReady();
                }
            });
            return;
        }
        ArrayList<Runnable> toRun = null;
        Object object = this.readyLock;
        synchronized (object) {
            if (!this.ready) {
                this.ready = true;
                if (!this.readyCallbacks.isEmpty()) {
                    toRun = new ArrayList<Runnable>(this.readyCallbacks);
                    this.readyCallbacks.clear();
                }
            }
        }
        if (toRun != null && !toRun.isEmpty()) {
            while (!toRun.isEmpty()) {
                ((Runnable)toRun.remove(0)).run();
            }
        }
    }

    @Override
    public boolean supportsExecuteAndReturnString() {
        return false;
    }

    public void cleanup() {
        if (this.panel != null) {
            final BrowserPanel fPanel = this.panel;
            this.panel = null;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (fPanel != null) {
                        fPanel.cleanup();
                    }
                }
            });
        }
    }

    static {
        CefBrowserFactory.setInstance((CefBrowserFactory)new CN1CefBrowserFactory());
    }
}

