/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase.cef;

import com.codename1.impl.javase.cef.BrowserPanel;
import com.codename1.impl.javase.cef.StreamWrapper;
import com.codename1.io.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandlerAdapter;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;

public class InputStreamSchemeHandler
extends CefResourceHandlerAdapter {
    public static final String scheme = "cn1stream";
    public static final String domain = "cn1app";
    private StreamWrapper stream;
    private byte[] data_;
    private String mime_type_;
    private int offset_ = 0;
    private boolean closed;
    private static final int LIMIT = 131072;
    private int written;
    boolean rangeRequest;
    long rangeStart;

    public static String getURL(String streamId) {
        return "cn1stream://cn1app/streams/" + streamId;
    }

    public synchronized boolean processRequest(CefRequest request, CefCallback callback) {
        HashMap headerMap = new HashMap();
        request.getHeaderMap(headerMap);
        String range = (String)headerMap.get("Range");
        System.out.println("In processRequest " + request.getURL() + " " + headerMap + " handler=" + (Object)((Object)this));
        String url = request.getURL();
        String streamId = null;
        if (url.indexOf("/") != -1) {
            streamId = url.substring(url.lastIndexOf("/") + 1);
        }
        if (streamId != null) {
            this.stream = BrowserPanel.getStreamRegistry().getStream(streamId);
            if (range != null && range.indexOf("=") != -1) {
                long start;
                this.rangeRequest = true;
                range = range.substring(range.indexOf("=") + 1);
                String startStr = range.substring(0, range.indexOf("-"));
                this.rangeStart = start = Long.parseLong(startStr);
                if (this.stream.getOffset() < start) {
                    InputStream inputStream = this.stream.getStream();
                    int seekTo = (int)(start - this.stream.getOffset());
                    try {
                        for (int i = 0; i < seekTo; ++i) {
                            inputStream.read();
                        }
                        this.stream.setOffset(start);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        System.out.println("Stream found " + this.stream + " offset " + this.stream.getOffset());
        callback.Continue();
        return this.stream != null;
    }

    public void getResponseHeaders(CefResponse response, IntRef response_length, StringRef redirectUrl) {
        System.out.println("In getResponseHeaders");
        if (this.stream != null) {
            System.out.println("InputStreamSchemeHandler:: " + this.stream.getMimeType() + " len=" + this.stream.getLength());
            String mime = this.stream.getMimeType();
            if (mime == null) {
                mime = "application/octet-stream";
            }
            response.setMimeType(mime);
            response.setHeaderByName("Accept-Ranges", "bytes", true);
            if (this.rangeRequest) {
                response.setHeaderByName("Content-Range", this.rangeStart + "-" + this.stream.getLength() + "/" + this.stream.getLength(), true);
                response.setHeaderByName("Content-Length", "" + (this.stream.getLength() - this.rangeStart), true);
                response.setStatus(206);
                response_length.set((int)(this.stream.getLength() - this.rangeStart));
            } else {
                response_length.set((int)(this.stream.getLength() - this.rangeStart));
                response.setStatus(200);
            }
            System.out.println("Set response length to " + response_length.get());
        } else {
            String msg = "Not found";
            this.data_ = msg.getBytes();
            this.mime_type_ = "text/plain";
            response.setMimeType(this.mime_type_);
            response.setStatus(404);
            response_length.set(this.data_.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean readResponse(byte[] data_out, int bytes_to_read, IntRef bytes_read, CefCallback callback) {
        int has_data;
        block13: {
            int read;
            block14: {
                block12: {
                    int transfer_size;
                    block11: {
                        System.out.println("readResponse:" + data_out.length + ", " + bytes_to_read);
                        has_data = 1;
                        if (!this.closed) break block11;
                        System.out.println("Stream was closed");
                        bytes_read.set(0);
                        boolean bl = false;
                        System.out.println("Exiting readResponse");
                        return bl;
                    }
                    if (this.stream != null) break block12;
                    has_data = 0;
                    if (this.offset_ < this.data_.length) {
                        transfer_size = Math.min(bytes_to_read, this.data_.length - this.offset_);
                        System.arraycopy(this.data_, this.offset_, data_out, 0, transfer_size);
                        this.offset_ += transfer_size;
                        bytes_read.set(transfer_size);
                        has_data = 1;
                    } else {
                        this.offset_ = 0;
                        bytes_read.set(0);
                    }
                    System.out.println("Stream was null");
                    transfer_size = has_data;
                    System.out.println("Exiting readResponse");
                    return transfer_size != 0;
                }
                if (this.stream.getStream().available() <= 0) break block13;
                System.out.println("Abbout to attempt reading " + bytes_to_read);
                read = this.stream.getStream().read(data_out, 0, bytes_to_read > 0 ? Math.min(bytes_to_read, data_out.length) : data_out.length);
                System.out.println("Read " + read + " from stream");
                if (read != -1) break block14;
                System.out.println("Reached the end of the stream");
                has_data = 0;
                bytes_read.set(0);
                this.stream.getStream().close();
                this.closed = true;
                BrowserPanel.getStreamRegistry().removeStream(this.stream);
                this.stream = null;
                boolean bl = false;
                System.out.println("Exiting readResponse");
                return bl;
            }
            this.written += read;
            long oldOffset = this.stream.getOffset();
            this.stream.setOffset(oldOffset += (long)read);
            bytes_read.set(read);
            boolean bl = true;
            System.out.println("Exiting readResponse");
            return bl;
        }
        try {
            try {
                System.out.println("No bytes available");
                bytes_read.set(0);
            }
            catch (IOException ex) {
                Log.e((Throwable)ex);
            }
            System.out.println("Returning " + (has_data != 0));
            int n = has_data;
            return n != 0;
        }
        finally {
            System.out.println("Exiting readResponse");
        }
    }
}

