/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase.cef;

import com.codename1.impl.javase.cef.BrowserPanel;
import com.codename1.impl.javase.cef.StreamWrapper;
import com.codename1.io.Log;
import java.io.IOException;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandlerAdapter;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;

public class ResourceHandler
extends CefResourceHandlerAdapter {
    private StreamWrapper stream;
    private boolean closed;
    private int written;

    public boolean processRequest(CefRequest request, CefCallback callback) {
        String url = request.getURL();
        String streamId = null;
        if (url.indexOf("/") != -1) {
            streamId = url.substring(url.lastIndexOf("/") + 1);
        }
        if (streamId != null) {
            this.stream = BrowserPanel.getStreamRegistry().getStream(streamId);
        }
        callback.Continue();
        return true;
    }

    public void getResponseHeaders(CefResponse response, IntRef response_length, StringRef redirectUrl) {
        response_length.set((int)this.stream.getLength());
        response.setMimeType(this.stream.getMimeType());
        response.setStatus(200);
    }

    public boolean readResponse(byte[] data_out, int bytes_to_read, IntRef bytes_read, CefCallback callback) {
        boolean has_data = true;
        if (this.closed || this.stream == null) {
            System.out.println("Stream was closed");
            bytes_read.set(0);
            return false;
        }
        try {
            if (this.stream.getStream().available() > 0) {
                int read = this.stream.getStream().read(data_out, 0, bytes_to_read > 0 ? Math.min(bytes_to_read, data_out.length) : data_out.length);
                if (read == -1) {
                    has_data = false;
                    bytes_read.set(0);
                    this.stream.getStream().close();
                    this.closed = true;
                    BrowserPanel.getStreamRegistry().removeStream(this.stream);
                    this.stream = null;
                    return false;
                }
                this.written += read;
                long oldOffset = this.stream.getOffset();
                this.stream.setOffset(oldOffset += (long)read);
                bytes_read.set(read);
                if ((long)this.written == this.stream.getLength()) {
                    this.stream.getStream().close();
                    this.closed = true;
                    BrowserPanel.getStreamRegistry().removeStream(this.stream);
                    this.stream = null;
                }
                return true;
            }
            bytes_read.set(0);
        }
        catch (IOException ex) {
            Log.e((Throwable)ex);
        }
        return has_data;
    }

    public void cancel() {
        try {
            this.stream.getStream().close();
            this.closed = true;
            BrowserPanel.getStreamRegistry().removeStream(this.stream);
            this.stream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

