/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase.fx;

import com.codename1.impl.javase.AbstractBrowserWindowSE;
import com.codename1.io.Log;
import com.codename1.ui.BrowserWindow;
import com.codename1.ui.events.ActionEvent;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class FXBrowserWindowSE
extends AbstractBrowserWindowSE {
    private Stage stage;
    private WebView webview;
    private Worker.State state;

    public FXBrowserWindowSE(String startURL) {
        try {
            this.initUI(startURL);
        }
        catch (IllegalStateException ex) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        new JFXPanel();
                    }
                });
            }
            catch (InterruptedException iex) {
                Log.e((Throwable)iex);
                throw ex;
            }
            catch (InvocationTargetException ite) {
                Log.e((Throwable)ite);
                throw ex;
            }
            this.initUI(startURL);
        }
    }

    private void initUI(final String startURL) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FXBrowserWindowSE.this.initUI(startURL);
                }
            });
            return;
        }
        this.webview = new WebView();
        this.webview.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> ov, Worker.State t, Worker.State t1) {
                FXBrowserWindowSE.this.state = t1;
                if (t1 == Worker.State.SUCCEEDED) {
                    FXBrowserWindowSE.this.fireLoadEvent(new ActionEvent(FXBrowserWindowSE.this.webview.getEngine().locationProperty().get()));
                }
            }
        });
        StackPane stackPane = new StackPane();
        stackPane.getChildren().add((Object)this.webview);
        Scene scene = new Scene((Parent)stackPane);
        this.stage = new Stage();
        this.stage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent t) {
                FXBrowserWindowSE.this.fireCloseEvent(new ActionEvent(null));
            }
        });
        this.stage.setScene(scene);
        this.webview.getEngine().load(startURL);
    }

    @Override
    public void show() {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FXBrowserWindowSE.this.show();
                }
            });
            return;
        }
        this.stage.show();
    }

    @Override
    public void setSize(final int width, final int height) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FXBrowserWindowSE.this.setSize(width, height);
                }
            });
            return;
        }
        this.stage.setWidth((double)width);
        this.stage.setHeight((double)height);
    }

    @Override
    public void setTitle(final String title) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FXBrowserWindowSE.this.setTitle(title);
                }
            });
            return;
        }
        this.stage.setTitle(title);
    }

    @Override
    public void hide() {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FXBrowserWindowSE.this.hide();
                }
            });
            return;
        }
        this.stage.hide();
    }

    @Override
    public void cleanup() {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FXBrowserWindowSE.this.cleanup();
                }
            });
            return;
        }
        this.stage.close();
    }

    @Override
    public void eval(BrowserWindow.EvalRequest req) {
        req.error((Throwable)new RuntimeException("Not implemented"));
    }
}

