/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase.fx;

import com.codename1.impl.javase.UnzipUtility;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class JavaFXLoader {
    private static String OS = System.getProperty("os.name").toLowerCase();
    private File javafxDir = new File(System.getProperty("javafx.install.dir", new File(System.getProperty("user.home"), ".codenameone" + File.separator + "javafx" + JavaFXLoader.getJavaFXVersionStr()).getAbsolutePath()));
    private String winUrl = System.getProperty("javafx.win.url", "https://github.com/codenameone/cn1-binaries/raw/master/javafx" + JavaFXLoader.getJavaFXVersionStr() + "-win.zip");
    private String macUrl = System.getProperty("javafx.mac.url", "https://github.com/codenameone/cn1-binaries/raw/master/javafx" + JavaFXLoader.getJavaFXVersionStr() + "-mac.zip");
    private String linuxUrl = System.getProperty("javafx.linux.url", "https://github.com/codenameone/cn1-binaries/raw/master/javafx" + JavaFXLoader.getJavaFXVersionStr() + "-linux.zip");
    private static int cachedJavaVersion = -1;

    private static boolean delTree(File f) throws IOException {
        if (f.isDirectory()) {
            for (File child : f.listFiles()) {
                if (JavaFXLoader.delTree(child)) continue;
                return false;
            }
        }
        return !f.exists() || f.delete();
    }

    private static void downloadToFile(String url, File f) throws IOException {
        URL u = new URL(url);
        URLConnection conn = u.openConnection();
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)conn;
            http.setInstanceFollowRedirects(true);
            http.setDefaultUseCaches(false);
        }
        try (InputStream input = conn.getInputStream();
             FileOutputStream output = new FileOutputStream(f);){
            int len;
            byte[] buf = new byte[131072];
            while ((len = input.read(buf)) >= 0) {
                output.write(buf, 0, len);
            }
        }
    }

    private static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    private static boolean isMac() {
        return OS.indexOf("mac") >= 0;
    }

    private static boolean isUnix() {
        return OS.indexOf("nux") >= 0;
    }

    private String getJavaFXURL() {
        if (JavaFXLoader.isWindows()) {
            return this.winUrl;
        }
        if (JavaFXLoader.isMac()) {
            return this.macUrl;
        }
        if (JavaFXLoader.isUnix()) {
            return this.linuxUrl;
        }
        return null;
    }

    private static File findDir(File root, String dirName) {
        if (root.getName().equals(dirName)) {
            return root;
        }
        if (root.isDirectory()) {
            for (File child : root.listFiles()) {
                File found = JavaFXLoader.findDir(child, dirName);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadJavaFX() throws IOException {
        try {
            String url = this.getJavaFXURL();
            if (url == null) {
                throw new RuntimeException("No JavaFX URL found for this platform");
            }
            if (this.javafxDir.exists()) {
                JavaFXLoader.delTree(this.javafxDir);
            }
            this.javafxDir.getParentFile().mkdirs();
            File javafxZip = new File(this.javafxDir.getParentFile(), "javafx.zip");
            JavaFXLoader.downloadToFile(url, javafxZip);
            System.out.println("Downladed " + javafxZip + " " + javafxZip.length() + " bytes");
            File tmpDir = new File(javafxZip.getParentFile(), "javafx.tmp." + System.currentTimeMillis());
            try {
                new UnzipUtility().unzip(javafxZip.getAbsolutePath(), tmpDir.getAbsolutePath());
                this.javafxDir.mkdir();
                File libDirTmp = JavaFXLoader.findDir(tmpDir, "lib");
                File legalDirTmp = JavaFXLoader.findDir(tmpDir, "legal");
                File binDirTmp = JavaFXLoader.findDir(tmpDir, "bin");
                if (libDirTmp == null || !libDirTmp.exists()) {
                    throw new IOException("No lib dir found within JavaFX zip");
                }
                libDirTmp.renameTo(new File(this.javafxDir, "lib"));
                if (legalDirTmp != null && legalDirTmp.exists()) {
                    legalDirTmp.renameTo(new File(this.javafxDir, "legal"));
                }
                if (binDirTmp != null && binDirTmp.exists()) {
                    binDirTmp.renameTo(new File(this.javafxDir, "bin"));
                }
            }
            finally {
                JavaFXLoader.delTree(tmpDir);
                javafxZip.delete();
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(JavaFXLoader.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    public URL[] getJavaFXJars() throws IOException {
        if (!this.javafxDir.exists()) {
            this.downloadJavaFX();
        }
        if (!this.javafxDir.exists()) {
            throw new RuntimeException("Failed to download JavaFX");
        }
        File javafxLibDir = new File(this.javafxDir, "lib");
        if (!javafxLibDir.exists()) {
            throw new RuntimeException("JavaFX is missing.  This application requires a JDK with JavaFX.");
        }
        File jarsDir = javafxLibDir;
        if ("8".equals(JavaFXLoader.getJavaFXVersionStr())) {
            jarsDir = new File(javafxLibDir, "ext");
        }
        ArrayList<URL> javafxUrls = new ArrayList<URL>();
        for (File f : jarsDir.listFiles()) {
            if (!f.getName().endsWith(".jar")) continue;
            try {
                URL u = f.toURI().toURL();
                javafxUrls.add(u);
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        if (javafxUrls.isEmpty()) {
            throw new RuntimeException("JavaFX is missing.  This application requires a JDK with JavaFX.");
        }
        try {
            javafxUrls.add(javafxLibDir.toURI().toURL());
        }
        catch (MalformedURLException mex) {
            throw new RuntimeException(mex);
        }
        return javafxUrls.toArray(new URL[javafxUrls.size()]);
    }

    public File[] getJavaFXJarFiles() throws IOException, URISyntaxException {
        URL[] urls = this.getJavaFXJars();
        File[] files = new File[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            files[i] = new File(urls[i].toURI());
        }
        return files;
    }

    public String getJavaFXClassPath() throws IOException, URISyntaxException {
        StringBuilder sb = new StringBuilder();
        for (File f : this.getJavaFXJarFiles()) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(f.getAbsolutePath());
        }
        return sb.toString();
    }

    public static boolean isJavaFXLoaded() {
        boolean isJavaFX8 = "8".equals(JavaFXLoader.getJavaFXVersionStr());
        if (!isJavaFX8 && JavaFXLoader.containsJavaFX8(System.getProperty("java.class.path"))) {
            return false;
        }
        try {
            ClassLoader.getSystemClassLoader().loadClass("javafx.scene.web.WebEngine");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        catch (UnsupportedClassVersionError er) {
            return false;
        }
    }

    private File findEclipseLaunchFile() {
        for (File child : new File(".").listFiles()) {
            if (!child.getName().startsWith("Simulator_") || !child.getName().endsWith(".launch")) continue;
            return child;
        }
        return null;
    }

    private void updateEclipseLaunchClasspath() {
        block36: {
            File launchFile = this.findEclipseLaunchFile();
            if (launchFile == null || !launchFile.exists()) {
                return;
            }
            String contents = null;
            try {
                int closingPos;
                String endTag;
                int pos;
                try (FileInputStream fos = new FileInputStream(launchFile);){
                    byte[] buf = new byte[(int)launchFile.length()];
                    fos.read(buf);
                    contents = new String(buf, "UTF-8");
                }
                boolean isJavaFX8 = "8".equals(JavaFXLoader.getJavaFXVersionStr());
                String javafxListEntry = "<listEntry value=\"&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot;?&gt;&#10;&lt;runtimeClasspathEntry id=&quot;org.eclipse.jdt.launching.classpathentry.variableClasspathEntry&quot;&gt;&#10;    &lt;memento path=&quot;5&quot; variableString=&quot;${system_property:user.home}/.codenameone/javafx/lib/*&quot;/&gt;&#10;&lt;/runtimeClasspathEntry&gt;&#10;\"/>";
                String javafx8ListEntry = "<listEntry value=\"&lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot;?&gt;&#10;&lt;runtimeClasspathEntry id=&quot;org.eclipse.jdt.launching.classpathentry.variableClasspathEntry&quot;&gt;&#10;    &lt;memento path=&quot;5&quot; variableString=&quot;${system_property:user.home}/.codenameone/javafx8/lib/ext/*&quot;/&gt;&#10;&lt;/runtimeClasspathEntry&gt;&#10;\"/>";
                boolean changed = false;
                if (isJavaFX8 && JavaFXLoader.containsJavaFX(contents)) {
                    System.out.println("Detected Incompatible version of JavaFX. Removing incompatible libs from the classpath");
                    contents = contents.replaceAll("<listEntry .*\\.codenameone/javafx/lib.*/>", "");
                    changed = true;
                } else if (!isJavaFX8 && JavaFXLoader.containsJavaFX8(contents)) {
                    System.out.println("Detected Incompatible version of JavaFX.  Removing incompatible libs from the classpath");
                    contents = contents.replaceAll("<listEntry .*\\.codenameone/javafx8/lib.*/>", "");
                    changed = true;
                }
                if (!isJavaFX8 && !JavaFXLoader.containsJavaFX(contents)) {
                    System.out.println("Adding OpenJFX11 to the classpath");
                    pos = contents.indexOf("<listAttribute key=\"org.eclipse.jdt.launching.CLASSPATH\">");
                    if (pos < 0) {
                        return;
                    }
                    endTag = "</listAttribute>";
                    closingPos = contents.indexOf(endTag, pos);
                    contents = contents.substring(0, closingPos) + "    " + javafxListEntry + "\n    " + endTag + contents.substring(closingPos + endTag.length());
                    changed = true;
                } else if (isJavaFX8 && !JavaFXLoader.containsJavaFX8(contents)) {
                    System.out.println("Adding OpenJFX8 to the classpath");
                    pos = contents.indexOf("<listAttribute key=\"org.eclipse.jdt.launching.CLASSPATH\">");
                    if (pos < 0) {
                        return;
                    }
                    endTag = "</listAttribute>";
                    closingPos = contents.indexOf(endTag, pos);
                    contents = contents.substring(0, closingPos) + "    " + javafx8ListEntry + "\n    " + endTag + contents.substring(closingPos + endTag.length());
                    changed = true;
                }
                if (!changed) break block36;
                System.out.println("Adding JavaFX to your Eclipse launch classpath at " + launchFile);
                System.out.println("JavaFX should be correctly loaded the next time you run this project.");
                try (FileOutputStream fos = new FileOutputStream(launchFile);){
                    fos.write(contents.getBytes("UTF-8"));
                }
            }
            catch (IOException ex) {
                System.err.println("Failed to update " + launchFile + " with JavaFX path");
                ex.printStackTrace(System.err);
            }
        }
    }

    private void updateNbProjectProperties() {
        block38: {
            File nbProjectProperties = new File("nbproject" + File.separator + "project.properties");
            if (nbProjectProperties.exists()) {
                String contents = null;
                try {
                    try (FileInputStream fos = new FileInputStream(nbProjectProperties);){
                        byte[] buf = new byte[(int)nbProjectProperties.length()];
                        fos.read(buf);
                        contents = new String(buf, "UTF-8");
                    }
                    boolean isJavaFX8 = "8".equals(JavaFXLoader.getJavaFXVersionStr());
                    String jfxPath = isJavaFX8 ? "${user.home}/.codenameone/javafx8/lib/ext/*" : "${user.home}/.codenameone/javafx/lib/*";
                    boolean changed = false;
                    if (contents != null) {
                        if (contents.contains("cn1.javafx.path=")) {
                            int pos = contents.indexOf("cn1.javafx.path=");
                            String newContents = contents;
                            if (pos > -1) {
                                int eqPos = contents.indexOf("=", pos);
                                int newlinePos = contents.indexOf("\n", pos);
                                if (newlinePos < 0) {
                                    newlinePos = contents.length();
                                }
                                newContents = contents.substring(0, pos) + contents.substring(newlinePos);
                            }
                            if (!newContents.equals(contents)) {
                                contents = newContents;
                                changed = true;
                            }
                        } else {
                            String sep = System.getProperty("line.separator");
                            if (!contents.endsWith(sep)) {
                                contents = contents + sep;
                            }
                            contents = contents + "cn1.javafx.path=" + jfxPath;
                            changed = true;
                        }
                        if (!contents.contains("${cn1.javafx.path}")) {
                            int pos;
                            int runClassPathPos = contents.indexOf("run.classpath=");
                            if (runClassPathPos > 0 && (pos = contents.indexOf("${build.classes.dir}", runClassPathPos)) > 0) {
                                String before = contents.substring(0, pos);
                                String after = contents.substring(pos + "${build.classes.dir}".length());
                                contents = before + "${build.classes.dir}:${cn1.javafx.path}" + after;
                                contents = contents.replace("${cn1.javafx.path}:${cn1.javafx.path}", "${cn1.javafx.path}");
                                changed = true;
                            }
                            if ((runClassPathPos = contents.indexOf("run.test.classpath=")) > 0 && (pos = contents.indexOf("${build.classes.dir}", runClassPathPos)) > 0) {
                                String before = contents.substring(0, pos);
                                String after = contents.substring(pos + "${build.classes.dir}".length());
                                contents = before + "${build.classes.dir}:${cn1.javafx.path}" + after;
                                contents = contents.replace("${cn1.javafx.path}:${cn1.javafx.path}", "${cn1.javafx.path}");
                                changed = true;
                            }
                        }
                    }
                    if (!changed) break block38;
                    System.out.println("Adding JavaFX to your project properties file at " + nbProjectProperties);
                    System.out.println("JavaFX should be correctly loaded the next time you run this project.");
                    try (FileOutputStream fos = new FileOutputStream(nbProjectProperties);){
                        fos.write(contents.getBytes("UTF-8"));
                    }
                }
                catch (IOException ex) {
                    System.err.println("Failed to update " + nbProjectProperties + " with JavaFX path");
                    ex.printStackTrace(System.err);
                }
            }
        }
    }

    private static int getJavaVersion() {
        if (cachedJavaVersion < 0) {
            String version = System.getProperty("java.version");
            if (version.startsWith("1.")) {
                version = version.substring(2);
            }
            int dotPos = version.indexOf(46);
            int dashPos = version.indexOf(45);
            if (dotPos < 0 && dashPos < 0) {
                cachedJavaVersion = Integer.parseInt(version);
                return cachedJavaVersion;
            }
            cachedJavaVersion = Integer.parseInt(version.substring(0, dotPos > -1 ? dotPos : (dashPos > -1 ? dashPos : 1)));
            return cachedJavaVersion;
        }
        return cachedJavaVersion;
    }

    private static String getJavaFXVersionStr() {
        return JavaFXLoader.getJavaVersion() == 8 ? "8" : "";
    }

    private static boolean containsJavaFX8(String classpath) {
        return classpath.contains(".codenameone/javafx8/lib/ext") || classpath.contains(".codenameone\\javafx8\\lib\\ext");
    }

    private static boolean containsJavaFX(String classpath) {
        return classpath.contains(".codenameone/javafx/lib") || classpath.contains(".codenameone\\javafx\\lib");
    }

    private static String p(String path) {
        if ("\\".equals(File.separator)) {
            return path.replace("/", "\\");
        }
        return path.replace("\\", "/");
    }

    public boolean runWithJavaFX(Class launchClass, Class mainClass, String[] args) throws JavaFXNotLoadedException, InvocationTargetException {
        if (System.getProperty("skip.fx.test", "false").equalsIgnoreCase("true")) {
            System.out.println("Skipping JavaFX auto-install");
            return false;
        }
        if (!JavaFXLoader.isJavaFXLoaded()) {
            System.out.println("JavaFX Not loaded.  Classpath=" + System.getProperty("java.class.path") + " . Adding to classpath");
            try {
                this.getJavaFXJarFiles();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
            Properties props = new Properties();
            boolean isJavaFX8 = "8".equals(JavaFXLoader.getJavaFXVersionStr());
            try {
                String cp = System.getProperty("java.class.path");
                ArrayList<String> cpParts = new ArrayList<String>(Arrays.asList(cp.split(Pattern.quote(File.pathSeparator))));
                if (isJavaFX8 && JavaFXLoader.containsJavaFX(cp)) {
                    ListIterator lit = cpParts.listIterator();
                    while (lit.hasNext()) {
                        String nex = (String)lit.next();
                        if (!JavaFXLoader.containsJavaFX(nex)) continue;
                        lit.remove();
                    }
                    cp = String.join((CharSequence)File.pathSeparator, cpParts.toArray(new String[cpParts.size()]));
                    cp = cp + File.pathSeparator + System.getProperty("user.home") + JavaFXLoader.p("/.codenameone/javafx8/lib/ext/*");
                } else if (!isJavaFX8 && JavaFXLoader.containsJavaFX8(cp)) {
                    ListIterator lit = cpParts.listIterator();
                    while (lit.hasNext()) {
                        String nex = (String)lit.next();
                        if (!JavaFXLoader.containsJavaFX8(nex)) continue;
                        lit.remove();
                    }
                    cp = String.join((CharSequence)File.pathSeparator, cpParts.toArray(new String[cpParts.size()]));
                    cp = cp + File.pathSeparator + System.getProperty("user.home") + JavaFXLoader.p("/.codenameone/javafx/lib/*");
                } else if (isJavaFX8 && !JavaFXLoader.containsJavaFX8(cp)) {
                    cp = cp + File.pathSeparator + System.getProperty("user.home") + JavaFXLoader.p("/.codenameone/javafx8/lib/ext/*");
                } else if (!isJavaFX8 && !JavaFXLoader.containsJavaFX(cp)) {
                    cp = cp + File.pathSeparator + System.getProperty("user.home") + JavaFXLoader.p("/.codenameone/javafx/lib/*");
                } else {
                    String javafxPath = isJavaFX8 ? System.getProperty("user.home") + JavaFXLoader.p("/.codenameone/javafx8") : System.getProperty("user.home") + JavaFXLoader.p("/.codenameone/javafx");
                    System.err.println("Project could not be run because JavaFX is missing.  It already has JavaFX in the class path so something else must be wrong.  Ensure that the " + javafxPath + " directory exists and contains the proper files.  You may want to try just deleting the entire directory and try running this project again, as it should autonmatically re-download it.");
                    System.exit(1);
                }
                props.setProperty("java.class.path", cp);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to load JavaFX", ex);
            }
            this.updateNbProjectProperties();
            this.updateEclipseLaunchClasspath();
            System.out.println("Restarting JVM with JavaFX in the classpath.");
            System.out.println("NOTE: If you are trying to debug the project, you'll need to cancel this run and try running debug on the project again.  JavaFX should now be in your classpath.");
            JavaFXLoader.restartJVM(launchClass, props, args);
            return true;
        }
        System.out.println("JavaFX is loaded");
        return false;
    }

    public static boolean main(Class launchClass, Class mainClass, String[] argv) throws JavaFXNotLoadedException, InvocationTargetException {
        return new JavaFXLoader().runWithJavaFX(launchClass, mainClass, argv);
    }

    public static boolean restartJVM(Class launchClass, Properties props, String[] args) {
        String osName = System.getProperty("os.name");
        String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        String env = System.getenv("JAVA_STARTED_ON_FIRST_THREAD_" + pid);
        String separator = System.getProperty("file.separator");
        String classpath = props.getProperty("java.class.path", System.getProperty("java.class.path"));
        String mainClass = System.getenv("JAVA_MAIN_CLASS_" + pid);
        if (mainClass == null) {
            mainClass = launchClass.getName();
        }
        String jvmPath = System.getProperty("java.home") + separator + "bin" + separator + "java";
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        ArrayList<String> jvmArgs = new ArrayList<String>();
        jvmArgs.add(jvmPath);
        jvmArgs.addAll(inputArguments);
        jvmArgs.add("-cp");
        jvmArgs.add(classpath);
        jvmArgs.add(mainClass);
        for (String arg : args) {
            jvmArgs.add(arg);
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(jvmArgs);
            processBuilder.inheritIO();
            Process process = processBuilder.start();
            process.waitFor();
            int exitCode = process.exitValue();
            System.exit(exitCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void main(String[] args) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        PrintStream stdOut = System.out;
        PrintStream stdErr = System.err;
        System.setOut(out);
        System.setErr(out);
        JavaFXLoader jfxLoader = new JavaFXLoader();
        if (!JavaFXLoader.isJavaFXLoaded()) {
            try {
                jfxLoader.getJavaFXClassPath();
                boolean isJavaFX8 = "8".equals(JavaFXLoader.getJavaFXVersionStr());
                String path = isJavaFX8 ? System.getProperty("user.home") + File.separator + ".codenameone" + File.separator + "javafx8" + File.separator + "lib" + File.separator + "ext" + File.separator + "*" : System.getProperty("user.home") + File.separator + ".codenameone" + File.separator + "javafx" + File.separator + "lib" + File.separator + "*";
                stdOut.print(path);
            }
            catch (Exception ex) {
                stdErr.print("Failed to load JavaFX jars");
                ex.printStackTrace(stdErr);
                System.exit(1);
            }
        }
        System.exit(0);
    }

    public static class JavaFXNotLoadedException
    extends Exception {
        public JavaFXNotLoadedException(Throwable cause) {
            super(cause);
        }
    }
}

