/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase.fx;

import com.codename1.impl.javase.AbstractBrowserWindowSE;
import com.codename1.impl.javase.BrowserWindowFactory;
import com.codename1.impl.javase.IBrowserComponent;
import com.codename1.impl.javase.JavaSEPort;
import com.codename1.impl.javase.fx.FXBrowserWindowSE;
import com.codename1.impl.javase.fx.SEBrowserComponent;
import com.codename1.io.Log;
import com.codename1.io.Util;
import com.codename1.media.AbstractMedia;
import com.codename1.media.AsyncMedia;
import com.codename1.ui.Accessor;
import com.codename1.ui.BrowserComponent;
import com.codename1.ui.Component;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.PeerComponent;
import com.codename1.ui.Toolbar;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.Layout;
import com.codename1.util.AsyncResource;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.media.Media;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.web.WebView;
import javafx.util.Duration;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JavaFXSEPort
extends JavaSEPort {
    @Override
    public void init(Object m) {
        super.init(m);
        try {
            Class.forName("javafx.embed.swing.JFXPanel");
            Platform.setImplicitExit((boolean)false);
            fxExists = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean isPlayable(String filename) {
        block2: {
            try {
                Media media = new Media(filename);
            }
            catch (MediaException e) {
                if (e.getType() != MediaException.Type.MEDIA_UNSUPPORTED) break block2;
                return false;
            }
        }
        return true;
    }

    @Override
    public AsyncResource<com.codename1.media.Media> createMediaAsync(String uriAddress, final boolean isVideo, final Runnable onCompletion) {
        final AsyncResource out = new AsyncResource();
        if (!JavaFXSEPort.checkForPermission("android.permission.READ_PHONE_STATE", "This is required to play media")) {
            out.error((Throwable)new IOException("android.permission.READ_PHONE_STATE is required to play media"));
            return out;
        }
        if (!JavaFXSEPort.checkForPermission("android.permission.WRITE_EXTERNAL_STORAGE", "This is required to play media")) {
            out.error((Throwable)new IOException("android.permission.WRITE_EXTERNAL_STORAGE is required to play media"));
            return out;
        }
        if (uriAddress.startsWith("file:")) {
            uriAddress = this.unfile(uriAddress);
        }
        final String uri = uriAddress;
        if (!fxExists) {
            String msg = "This fetaure is supported from Java version 1.7.0_06, update your Java to enable this feature. This might fail on OpenJDK as well in which case you will need to install the Oracle JDK. ";
            System.out.println(msg);
            out.error((Throwable)new IOException(msg));
            return out;
        }
        Container cnt = this.canvas.getParent();
        while (!(cnt instanceof JFrame)) {
            if ((cnt = cnt.getParent()) != null) continue;
            out.error((Throwable)new RuntimeException("Could not find canvas.  Cannot create media"));
            return out;
        }
        final Container c = cnt;
        Exception[] err = new Exception[1];
        final CN1JFXPanel m = new CN1JFXPanel();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (uri.indexOf(58) < 0 && uri.lastIndexOf(47) == 0) {
                        String mimeType = "video/mp4";
                        new CodenameOneMediaPlayer(JavaFXSEPort.this.getResourceAsStream(this.getClass(), uri), mimeType, (JFrame)c, m, onCompletion, (AsyncResource<com.codename1.media.Media>)out);
                        return;
                    }
                    new CodenameOneMediaPlayer(uri, isVideo, (JFrame)c, m, onCompletion, (AsyncResource<com.codename1.media.Media>)out);
                }
                catch (Exception ex) {
                    out.error((Throwable)ex);
                }
            }
        });
        return out;
    }

    @Override
    public AsyncResource<com.codename1.media.Media> createMediaAsync(final InputStream stream, final String mimeType, final Runnable onCompletion) {
        final AsyncResource out = new AsyncResource();
        if (!JavaFXSEPort.checkForPermission("android.permission.READ_PHONE_STATE", "This is required to play media")) {
            out.error((Throwable)new IOException("android.permission.READ_PHONE_STATE is required to play media"));
            return out;
        }
        if (!JavaFXSEPort.checkForPermission("android.permission.WRITE_EXTERNAL_STORAGE", "This is required to play media")) {
            out.error((Throwable)new IOException("android.permission.WRITE_EXTERNAL_STORAGE is required to play media"));
            return out;
        }
        if (!fxExists) {
            String msg = "This fetaure is supported from Java version 1.7.0_06, update your Java to enable this feature. This might fail on OpenJDK as well in which case you will need to install the Oracle JDK. ";
            out.error((Throwable)new IOException(msg));
            return out;
        }
        Container cnt = this.canvas.getParent();
        while (!(cnt instanceof JFrame)) {
            if ((cnt = cnt.getParent()) != null) continue;
            return null;
        }
        final Container c = cnt;
        final CN1JFXPanel m = new CN1JFXPanel();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    new CodenameOneMediaPlayer(stream, mimeType, (JFrame)c, m, onCompletion, (AsyncResource<com.codename1.media.Media>)out);
                }
                catch (Exception ex) {
                    out.error((Throwable)ex);
                }
            }
        });
        return out;
    }

    public void addCompletionHandler(com.codename1.media.Media media, Runnable onCompletion) {
        super.addCompletionHandler(media, onCompletion);
        if (media instanceof CodenameOneMediaPlayer) {
            ((CodenameOneMediaPlayer)media).addCompletionHandler(onCompletion);
        }
    }

    public void removeCompletionHandler(com.codename1.media.Media media, Runnable onCompletion) {
        super.removeCompletionHandler(media, onCompletion);
        if (media instanceof CodenameOneMediaPlayer) {
            ((CodenameOneMediaPlayer)media).removeCompletionHandler(onCompletion);
        }
    }

    public AsyncResource<Image> captureBrowserScreenshot(PeerComponent browserPeer) {
        if (!(browserPeer instanceof SEBrowserComponent)) {
            return null;
        }
        SEBrowserComponent sebc = (SEBrowserComponent)browserPeer;
        return sebc.captureScreenshot();
    }

    public PeerComponent createFXBrowserComponent(final Object parent) {
        Container cnt = this.canvas.getParent();
        while (!(cnt instanceof JFrame)) {
            if ((cnt = cnt.getParent()) != null) continue;
            return null;
        }
        Container c = cnt;
        final Exception[] err = new Exception[1];
        final CN1JFXPanel webContainer = new CN1JFXPanel();
        final SEBrowserComponent[] bc = new SEBrowserComponent[1];
        final SEBrowserComponent bcc = new SEBrowserComponent();
        Platform.setImplicitExit((boolean)false);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                StackPane root = new StackPane();
                WebView webView = new WebView();
                root.getChildren().add((Object)webView);
                webContainer.setScene(new Scene((Parent)root));
                JPanel parentPanel = (JPanel)JavaFXSEPort.this.canvas.getParent();
                bcc.SEBrowserComponent_init(JavaFXSEPort.this, parentPanel, webContainer, webView, (BrowserComponent)parent, JavaFXSEPort.this.hSelector, JavaFXSEPort.this.vSelector);
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        bc[0] = bcc;
                        SEBrowserComponent[] sEBrowserComponentArray = bc;
                        synchronized (bc) {
                            bc.notify();
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                });
            }
        });
        if (bc[0] == null && err[0] == null) {
            Display.getInstance().invokeAndBlock(new Runnable(){

                @Override
                public void run() {
                    while (bc[0] == null && err[0] == null) {
                        Util.wait((Object)bc, (int)20);
                    }
                }
            });
        }
        return bc[0];
    }

    private void browserExposeInJavaScriptImpl(PeerComponent browserPeer, Object o, String name) {
        ((IBrowserComponent)browserPeer).exposeInJavaScript(o, name);
    }

    @Override
    public void browserExposeInJavaScript(final PeerComponent browserPeer, final Object o, final String name) {
        if (!(browserPeer instanceof SEBrowserComponent)) {
            return;
        }
        if (Platform.isFxApplicationThread()) {
            this.browserExposeInJavaScriptImpl(browserPeer, o, name);
            return;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JavaFXSEPort.this.browserExposeInJavaScriptImpl(browserPeer, o, name);
            }
        });
    }

    public PeerComponent createBrowserComponent(Object parent) {
        boolean useWKWebView = "true".equals(Display.getInstance().getProperty("BrowserComponent.useWKWebView", "false"));
        if (useWKWebView && !this.useWKWebViewChecked) {
            this.useWKWebViewChecked = true;
            Map m = Display.getInstance().getProjectBuildHints();
            if (m != null && !m.containsKey("ios.useWKWebView")) {
                Display.getInstance().setProjectBuildHint("ios.useWKWebView", "true");
            }
        }
        return this.createFXBrowserComponent(parent);
    }

    @Override
    public boolean isNativeBrowserComponentSupported() {
        return fxExists && !blockNativeBrowser;
    }

    @Override
    protected BrowserWindowFactory createBrowserWindowFactory() {
        return new BrowserWindowFactory(){

            @Override
            public AbstractBrowserWindowSE createBrowserWindow(String startURL) {
                return new FXBrowserWindowSE(startURL);
            }
        };
    }

    class CN1JFXPanel
    extends JFXPanel {
        private boolean peerGrabbedDrag = false;

        public void revalidate() {
        }

        protected void processMouseEvent(MouseEvent e) {
            if (!this.sendToCn1(e)) {
                super.processMouseEvent(e);
            }
        }

        protected void processMouseMotionEvent(MouseEvent e) {
            if (!this.sendToCn1(e)) {
                super.processMouseMotionEvent(e);
            }
        }

        protected void processMouseWheelEvent(MouseWheelEvent e) {
            if (!this.sendToCn1(e)) {
                super.processMouseWheelEvent(e);
            }
        }

        private boolean sendToCn1(MouseEvent e) {
            Form f;
            int cn1X = this.getCN1X(e);
            int cn1Y = this.getCN1Y(e);
            if (this.peerGrabbedDrag) {
                // empty if block
            }
            if (Display.isInitialized() && (f = Display.getInstance().getCurrent()) != null) {
                Component cmp = f.getComponentAt(cn1X, cn1Y);
                e = SwingUtilities.convertMouseEvent((java.awt.Component)((Object)this), e, JavaFXSEPort.this.canvas);
                switch (e.getID()) {
                    case 500: {
                        JavaFXSEPort.this.canvas.mouseClicked(e);
                        break;
                    }
                    case 506: {
                        JavaFXSEPort.this.canvas.mouseDragged(e);
                        break;
                    }
                    case 503: {
                        JavaFXSEPort.this.canvas.mouseMoved(e);
                        break;
                    }
                    case 501: {
                        if (!(cmp instanceof PeerComponent)) {
                            JavaFXSEPort.this.cn1GrabbedDrag = true;
                        }
                        JavaFXSEPort.this.canvas.mousePressed(e);
                        break;
                    }
                    case 502: {
                        JavaFXSEPort.this.cn1GrabbedDrag = false;
                        JavaFXSEPort.this.canvas.mouseReleased(e);
                        break;
                    }
                    case 507: {
                        JavaFXSEPort.this.canvas.mouseWheelMoved((MouseWheelEvent)e);
                    }
                }
                if (JavaFXSEPort.this.cn1GrabbedDrag) {
                    return true;
                }
                return !(cmp instanceof PeerComponent);
            }
            if (e.getID() == 502) {
                JavaFXSEPort.this.cn1GrabbedDrag = false;
                this.peerGrabbedDrag = false;
            } else if (e.getID() == 501) {
                this.peerGrabbedDrag = true;
            }
            return false;
        }

        private int getCN1X(MouseEvent e) {
            int x;
            if (JavaFXSEPort.this.canvas == null) {
                int out = e.getXOnScreen();
                if (out == 0) {
                    out = e.getX();
                    Object source = e.getSource();
                    if (source instanceof java.awt.Component) {
                        Point pt = ((java.awt.Component)source).getLocationOnScreen();
                        out += pt.x;
                    }
                }
                return out;
            }
            Rectangle screenCoords = JavaFXSEPort.this.getScreenCoordinates();
            if (screenCoords == null) {
                screenCoords = new Rectangle(0, 0, 0, 0);
            }
            if ((x = e.getXOnScreen()) == 0) {
                x = e.getX();
                Object source = e.getSource();
                if (source instanceof java.awt.Component) {
                    Point pt = ((java.awt.Component)source).getLocationOnScreen();
                    x += pt.x;
                }
            }
            return (int)(((double)(x - JavaFXSEPort.this.canvas.getLocationOnScreen().x) - (double)((float)(JavaFXSEPort.this.canvas.x + screenCoords.x) * JavaFXSEPort.this.zoomLevel) / JavaSEPort.retinaScale) / (double)JavaFXSEPort.this.zoomLevel * JavaSEPort.retinaScale);
        }

        private int getCN1Y(MouseEvent e) {
            int y;
            if (JavaFXSEPort.this.canvas == null) {
                int out = e.getYOnScreen();
                if (out == 0) {
                    out = e.getY();
                    Object source = e.getSource();
                    if (source instanceof java.awt.Component) {
                        Point pt = ((java.awt.Component)source).getLocationOnScreen();
                        out += pt.y;
                    }
                }
                return out;
            }
            Rectangle screenCoords = JavaFXSEPort.this.getScreenCoordinates();
            if (screenCoords == null) {
                screenCoords = new Rectangle(0, 0, 0, 0);
            }
            if ((y = e.getYOnScreen()) == 0) {
                y = e.getY();
                Object source = e.getSource();
                if (source instanceof java.awt.Component) {
                    Point pt = ((java.awt.Component)source).getLocationOnScreen();
                    y += pt.y;
                }
            }
            return (int)(((double)(y - JavaFXSEPort.this.canvas.getLocationOnScreen().y) - (double)((float)(JavaFXSEPort.this.canvas.y + screenCoords.y) * JavaFXSEPort.this.zoomLevel) / JavaSEPort.retinaScale) / (double)JavaFXSEPort.this.zoomLevel * JavaSEPort.retinaScale);
        }

        public CN1JFXPanel() {
            CN1JFXPanel panel = this;
        }
    }

    class VideoComponent
    extends PeerComponent {
        private JFXPanel vid;
        private JFrame frm;
        private JPanel cnt;
        private MediaView v;
        private boolean init;
        private Rectangle bounds;
        BufferedImage buf;

        private BufferedImage getBuffer() {
            if (this.buf == null || this.buf.getWidth() != this.cnt.getWidth() || this.buf.getHeight() != this.cnt.getHeight()) {
                this.buf = new BufferedImage(this.cnt.getWidth(), this.cnt.getHeight(), 2);
            }
            return this.buf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintOnBuffer() {
            if (EventQueue.isDispatchThread()) {
                VideoComponent videoComponent = this;
                synchronized (videoComponent) {
                    this.paintOnBufferImpl();
                }
            }
            if (!Display.getInstance().isEdt()) {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            VideoComponent.this.paintOnBuffer();
                        }
                    });
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        private void paintOnBufferImpl() {
            BufferedImage buf = this.getBuffer();
            Graphics2D g2d = buf.createGraphics();
            AffineTransform t = g2d.getTransform();
            double tx = t.getTranslateX();
            double ty = t.getTranslateY();
            this.vid.paint((Graphics)g2d);
            g2d.dispose();
            this.putClientProperty("__buffer", buf);
        }

        public VideoComponent(JFrame frm, final JFXPanel vid, MediaPlayer player) {
            super(null);
            this.cnt = new JPanel();
            this.init = false;
            this.bounds = new Rectangle();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VideoComponent.this.cnt = new JPanel(){

                        @Override
                        public void paint(Graphics g) {
                            VideoComponent.this.paintOnBuffer();
                            Display.getInstance().callSerially(new Runnable(){

                                @Override
                                public void run() {
                                    VideoComponent.this.repaint();
                                }
                            });
                        }

                        @Override
                        protected void paintChildren(Graphics g) {
                        }

                        @Override
                        protected void paintBorder(Graphics g) {
                        }
                    };
                    VideoComponent.this.cnt.setOpaque(false);
                    vid.setOpaque(false);
                    VideoComponent.this.cnt.setLayout(new java.awt.BorderLayout());
                    VideoComponent.this.cnt.add("Center", (java.awt.Component)vid);
                    VideoComponent.this.cnt.setVisible(false);
                }
            });
            Group root = new Group();
            this.v = new MediaView(player);
            final Runnable oldOnReady = player.getOnPlaying();
            player.setOnPlaying(new Runnable(){

                @Override
                public void run() {
                    if (oldOnReady != null) {
                        oldOnReady.run();
                    }
                    Display.getInstance().callSerially(new Runnable(){

                        @Override
                        public void run() {
                            if (VideoComponent.this.getParent() != null) {
                                VideoComponent.this.getParent().revalidate();
                            }
                        }
                    });
                }
            });
            root.getChildren().add((Object)this.v);
            vid.setScene(new Scene((Parent)root));
            this.vid = vid;
            this.frm = frm;
        }

        protected void initComponent() {
            this.bounds.setBounds(0, 0, 0, 0);
            super.initComponent();
        }

        protected void deinitialize() {
            super.deinitialize();
            if (JavaFXSEPort.this.testRecorder != null) {
                JavaFXSEPort.this.testRecorder.dispose();
                JavaFXSEPort.this.testRecorder = null;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VideoComponent.this.vid.setScene(null);
                    VideoComponent.this.vid.removeAll();
                    VideoComponent.this.cnt.remove((java.awt.Component)VideoComponent.this.vid);
                    VideoComponent.this.frm.remove(VideoComponent.this.cnt);
                    VideoComponent.this.frm.repaint();
                }
            });
        }

        protected void setLightweightMode(final boolean l) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!l) {
                        if (!VideoComponent.this.init) {
                            VideoComponent.this.init = true;
                            VideoComponent.this.cnt.setVisible(true);
                            VideoComponent.this.frm.add((java.awt.Component)VideoComponent.this.cnt, 0);
                            VideoComponent.this.frm.repaint();
                        } else {
                            VideoComponent.this.cnt.setVisible(false);
                        }
                    } else if (VideoComponent.this.init) {
                        VideoComponent.this.cnt.setVisible(false);
                    }
                }
            });
        }

        protected Dimension calcPreferredSize() {
            Dimension out = new Dimension(this.vid.getPreferredSize().width, this.vid.getPreferredSize().height);
            return out;
        }

        public void paint(com.codename1.ui.Graphics g) {
            if (this.init) {
                this.onPositionSizeChange();
                JavaFXSEPort.this.drawNativePeer(Accessor.getNativeGraphics(g), this, this.cnt);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VideoComponent.this.paintOnBuffer();
                    }
                });
            } else if (this.getComponentForm() != null && this.getComponentForm() == JavaFXSEPort.this.getCurrentForm()) {
                this.setLightweightMode(false);
            }
        }

        protected void onPositionSizeChange() {
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            final int w = this.getWidth();
            final int h = this.getHeight();
            int screenX = 0;
            int screenY = 0;
            if (JavaFXSEPort.this.getScreenCoordinates() != null) {
                screenX = JavaFXSEPort.this.getScreenCoordinates().x;
                screenY = JavaFXSEPort.this.getScreenCoordinates().y;
            }
            this.bounds.setBounds(x + screenX + JavaFXSEPort.this.canvas.x, y + screenY + JavaFXSEPort.this.canvas.y, w, h);
            if (!this.bounds.equals(this.cnt.getBounds())) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        VideoComponent.this.v.setFitWidth((double)w);
                        VideoComponent.this.v.setFitHeight((double)h);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                VideoComponent.this.cnt.setBounds(VideoComponent.this.bounds);
                                VideoComponent.this.cnt.doLayout();
                                VideoComponent.this.paintOnBuffer();
                            }
                        });
                    }
                });
            }
        }
    }

    class CodenameOneMediaPlayer
    extends AbstractMedia {
        private Timer endMediaPoller;
        private Runnable onCompletion;
        private List<Runnable> completionHandlers;
        private MediaPlayer player;
        private boolean realized = false;
        private boolean isVideo;
        private JFXPanel videoPanel;
        private JFrame frm;
        private boolean playing = false;
        private boolean nativePlayerMode;
        private AsyncResource<com.codename1.media.Media> _callback;
        private Runnable onPaused = new Runnable(){

            @Override
            public void run() {
                if (CodenameOneMediaPlayer.this.endMediaPoller != null) {
                    CodenameOneMediaPlayer.this.endMediaPoller.cancel();
                    CodenameOneMediaPlayer.this.endMediaPoller = null;
                }
                CodenameOneMediaPlayer.this.stopEndMediaPoller();
                CodenameOneMediaPlayer.this.playing = false;
                CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Paused);
            }
        };
        private Runnable onPlaying = new Runnable(){

            @Override
            public void run() {
                CodenameOneMediaPlayer.this.playing = true;
                CodenameOneMediaPlayer.this.startEndMediaPoller();
                CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Playing);
            }
        };
        private Runnable onError = new Runnable(){

            @Override
            public void run() {
                if (CodenameOneMediaPlayer.this._callback != null && !CodenameOneMediaPlayer.this._callback.isDone()) {
                    CodenameOneMediaPlayer.this._callback.error((Throwable)CodenameOneMediaPlayer.this.player.errorProperty().get());
                    return;
                }
                Log.e((Throwable)((Throwable)CodenameOneMediaPlayer.this.player.errorProperty().get()));
                CodenameOneMediaPlayer.this.fireMediaError(CodenameOneMediaPlayer.this.createMediaException((MediaException)CodenameOneMediaPlayer.this.player.errorProperty().get()));
                if (!CodenameOneMediaPlayer.this.playing) {
                    CodenameOneMediaPlayer.this.stopEndMediaPoller();
                    CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Playing);
                    CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Paused);
                }
            }
        };

        public CodenameOneMediaPlayer(String uri, boolean isVideo, JFrame f, JFXPanel fx, Runnable onCompletion, final AsyncResource<com.codename1.media.Media> callback) throws IOException {
            this._callback = callback;
            if (onCompletion != null) {
                this.addCompletionHandler(onCompletion);
            }
            this.onCompletion = new Runnable(){

                @Override
                public void run() {
                    if (callback != null && !callback.isDone()) {
                        callback.complete((Object)CodenameOneMediaPlayer.this);
                    }
                    CodenameOneMediaPlayer.this.stopEndMediaPoller();
                    CodenameOneMediaPlayer.this.playing = false;
                    CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Paused);
                    CodenameOneMediaPlayer.this.fireCompletionHandlers();
                }
            };
            this.isVideo = isVideo;
            this.frm = f;
            try {
                File fff;
                if (uri.startsWith("file:")) {
                    uri = JavaFXSEPort.this.unfile(uri);
                }
                if ((fff = new File(uri)).exists()) {
                    uri = fff.toURI().toURL().toExternalForm();
                }
                if (isVideo && !JavaFXSEPort.isPlayable(uri)) {
                    File temp = File.createTempFile("mtmp", ".mp4");
                    temp.deleteOnExit();
                    FileOutputStream out = new FileOutputStream(temp);
                    byte[] buf = new byte[1024];
                    int len = 0;
                    InputStream stream = new URL(uri).openStream();
                    while ((len = stream.read(buf, 0, buf.length)) > -1) {
                        out.write(buf, 0, len);
                    }
                    stream.close();
                    uri = temp.toURI().toURL().toExternalForm();
                }
                this.player = new MediaPlayer(new Media(uri));
                this.player.setOnReady(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null && !callback.isDone()) {
                            callback.complete((Object)CodenameOneMediaPlayer.this);
                        }
                    }
                });
                this.installFxCallbacks();
                if (isVideo) {
                    this.videoPanel = fx;
                }
            }
            catch (Exception ex) {
                if (callback != null && !callback.isDone()) {
                    callback.error((Throwable)ex);
                }
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }

        private AsyncMedia.MediaException createMediaException(MediaException ex) {
            AsyncMedia.MediaErrorType type;
            switch (ex.getType()) {
                case MEDIA_CORRUPTED: {
                    type = AsyncMedia.MediaErrorType.Decode;
                    break;
                }
                case MEDIA_INACCESSIBLE: 
                case MEDIA_UNAVAILABLE: {
                    type = AsyncMedia.MediaErrorType.Network;
                    break;
                }
                case MEDIA_UNSUPPORTED: {
                    type = AsyncMedia.MediaErrorType.SrcNotSupported;
                    break;
                }
                case MEDIA_UNSPECIFIED: {
                    type = AsyncMedia.MediaErrorType.Unknown;
                    break;
                }
                case OPERATION_UNSUPPORTED: {
                    type = AsyncMedia.MediaErrorType.SrcNotSupported;
                    break;
                }
                case PLAYBACK_ERROR: {
                    type = AsyncMedia.MediaErrorType.Decode;
                    break;
                }
                case PLAYBACK_HALTED: {
                    type = AsyncMedia.MediaErrorType.Aborted;
                    break;
                }
                default: {
                    type = AsyncMedia.MediaErrorType.Unknown;
                }
            }
            return new AsyncMedia.MediaException(type, (Throwable)ex);
        }

        private void startEndMediaPoller() {
            this.stopEndMediaPoller();
            this.endMediaPoller = new Timer();
            this.endMediaPoller.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (!CodenameOneMediaPlayer.this.playing && CodenameOneMediaPlayer.this.player.getStatus() == MediaPlayer.Status.PLAYING) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (!CodenameOneMediaPlayer.this.playing && CodenameOneMediaPlayer.this.player.getStatus() == MediaPlayer.Status.PLAYING) {
                                    CodenameOneMediaPlayer.this.playing = true;
                                    CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Playing);
                                }
                            }
                        });
                    } else if (CodenameOneMediaPlayer.this.playing && CodenameOneMediaPlayer.this.player.getStatus() != MediaPlayer.Status.PLAYING) {
                        CodenameOneMediaPlayer.this.stopEndMediaPoller();
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (CodenameOneMediaPlayer.this.playing && CodenameOneMediaPlayer.this.player.getStatus() != MediaPlayer.Status.PLAYING) {
                                    CodenameOneMediaPlayer.this.playing = false;
                                    CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Paused);
                                }
                            }
                        });
                    }
                    double diff = CodenameOneMediaPlayer.this.player.getTotalDuration().toMillis() - CodenameOneMediaPlayer.this.player.getCurrentTime().toMillis();
                    if (CodenameOneMediaPlayer.this.playing && diff < 0.01) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Runnable completionCallback;
                                double diff = CodenameOneMediaPlayer.this.player.getTotalDuration().toMillis() - CodenameOneMediaPlayer.this.player.getCurrentTime().toMillis();
                                if (CodenameOneMediaPlayer.this.playing && diff < 0.01 && (completionCallback = CodenameOneMediaPlayer.this.onCompletion) != null) {
                                    completionCallback.run();
                                }
                            }
                        });
                    }
                }
            }, 100L, 100L);
        }

        private void stopEndMediaPoller() {
            if (this.endMediaPoller != null) {
                this.endMediaPoller.cancel();
                this.endMediaPoller = null;
            }
        }

        public CodenameOneMediaPlayer(InputStream stream, String mimeType, JFrame f, JFXPanel fx, Runnable onCompletion, final AsyncResource<com.codename1.media.Media> callback) throws IOException {
            String suffix = JavaFXSEPort.this.guessSuffixForMimetype(mimeType);
            File temp = File.createTempFile("mtmp", suffix);
            temp.deleteOnExit();
            FileOutputStream out = new FileOutputStream(temp);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = stream.read(buf, 0, buf.length)) > -1) {
                out.write(buf, 0, len);
            }
            stream.close();
            if (onCompletion != null) {
                this.addCompletionHandler(onCompletion);
            }
            this.onCompletion = new Runnable(){

                @Override
                public void run() {
                    if (callback != null && !callback.isDone()) {
                        callback.complete((Object)CodenameOneMediaPlayer.this);
                    }
                    CodenameOneMediaPlayer.this.stopEndMediaPoller();
                    CodenameOneMediaPlayer.this.playing = false;
                    CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Paused);
                    CodenameOneMediaPlayer.this.fireCompletionHandlers();
                }
            };
            this.isVideo = mimeType.contains("video");
            this.frm = f;
            try {
                this.player = new MediaPlayer(new Media(temp.toURI().toString()));
                this.player.setOnReady(new Runnable(){

                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.complete((Object)CodenameOneMediaPlayer.this);
                        }
                    }
                });
                this.installFxCallbacks();
                if (this.isVideo) {
                    this.videoPanel = fx;
                }
            }
            catch (Exception ex) {
                if (callback != null) {
                    callback.error((Throwable)ex);
                }
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }

        private void fireCompletionHandlers() {
            if (this.completionHandlers != null && !this.completionHandlers.isEmpty()) {
                Display.getInstance().callSerially(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (CodenameOneMediaPlayer.this.completionHandlers != null && !CodenameOneMediaPlayer.this.completionHandlers.isEmpty()) {
                            ArrayList toRun;
                            CodenameOneMediaPlayer codenameOneMediaPlayer = CodenameOneMediaPlayer.this;
                            synchronized (codenameOneMediaPlayer) {
                                toRun = new ArrayList(CodenameOneMediaPlayer.this.completionHandlers);
                            }
                            for (Runnable r : toRun) {
                                r.run();
                            }
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCompletionHandler(Runnable onCompletion) {
            CodenameOneMediaPlayer codenameOneMediaPlayer = this;
            synchronized (codenameOneMediaPlayer) {
                if (this.completionHandlers == null) {
                    this.completionHandlers = new ArrayList<Runnable>();
                }
                this.completionHandlers.add(onCompletion);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeCompletionHandler(Runnable onCompletion) {
            if (this.completionHandlers != null) {
                CodenameOneMediaPlayer codenameOneMediaPlayer = this;
                synchronized (codenameOneMediaPlayer) {
                    this.completionHandlers.remove(onCompletion);
                }
            }
        }

        public void cleanup() {
            this.pause();
        }

        public void prepare() {
        }

        protected void playImpl() {
            if (this.isVideo && this.nativePlayerMode) {
                final Form currForm = Display.getInstance().getCurrent();
                Form playerForm = new Form("Video Player", (Layout)new BorderLayout()){

                    protected void onShow() {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CodenameOneMediaPlayer.this.playInternal();
                            }
                        });
                    }
                };
                Toolbar tb = new Toolbar();
                playerForm.setToolbar(tb);
                tb.setBackCommand("Back", (ActionListener)new ActionListener<ActionEvent>(){

                    public void actionPerformed(ActionEvent e) {
                        CodenameOneMediaPlayer.this.pauseInternal();
                        currForm.showBack();
                    }
                });
                Component videoComponent = this.getVideoComponent();
                if (videoComponent.getComponentForm() != null) {
                    videoComponent.remove();
                }
                playerForm.addComponent((Object)"Center", videoComponent);
                playerForm.show();
                return;
            }
            this.playInternal();
        }

        private void playInternal() {
            this.installFxCallbacks();
            this.player.play();
            this.startEndMediaPoller();
        }

        private void pauseInternal() {
            this.player.pause();
        }

        private void installFxCallbacks() {
            this.player.setOnPlaying(this.onPlaying);
            this.player.setOnPaused(this.onPaused);
            this.player.setOnError(this.onError);
            this.player.setOnEndOfMedia(this.onCompletion);
        }

        protected void pauseImpl() {
            if (this.player.getStatus() == MediaPlayer.Status.PLAYING) {
                this.pauseInternal();
            }
        }

        public int getTime() {
            return (int)this.player.getCurrentTime().toMillis();
        }

        public void setTime(int time) {
            this.player.seek(new Duration((double)time));
        }

        public int getDuration() {
            int d = (int)this.player.getStopTime().toMillis();
            if (d == 0) {
                return -1;
            }
            return d;
        }

        public void setVolume(int vol) {
            this.player.setVolume((double)vol / 100.0);
        }

        public int getVolume() {
            return (int)this.player.getVolume() * 100;
        }

        public Component getVideoComponent() {
            if (!this.isVideo) {
                return new Label();
            }
            if (this.videoPanel != null) {
                final Component[] retVal = new Component[1];
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        retVal[0] = new VideoComponent(CodenameOneMediaPlayer.this.frm, CodenameOneMediaPlayer.this.videoPanel, CodenameOneMediaPlayer.this.player);
                    }
                });
                Display.getInstance().invokeAndBlock(new Runnable(){

                    @Override
                    public void run() {
                        while (retVal[0] == null) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(JavaSEPort.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                });
                return retVal[0];
            }
            System.out.println("Video Playing is not supported on this platform");
            Label l = new Label("Video");
            l.getStyle().setAlignment(4);
            return l;
        }

        public boolean isVideo() {
            return this.isVideo;
        }

        public boolean isFullScreen() {
            return false;
        }

        public void setFullScreen(boolean fullScreen) {
        }

        public boolean isPlaying() {
            return this.playing;
        }

        public void setNativePlayerMode(boolean nativePlayer) {
            this.nativePlayerMode = nativePlayer;
        }

        public boolean isNativePlayerMode() {
            return this.nativePlayerMode;
        }

        public void setVariable(String key, Object value) {
        }

        public Object getVariable(String key) {
            return null;
        }
    }
}

