/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase.fx;

import com.codename1.impl.javase.IBrowserComponent;
import com.codename1.impl.javase.JavaSEPort;
import com.codename1.io.Log;
import com.codename1.ui.Accessor;
import com.codename1.ui.BrowserComponent;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.PeerComponent;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.geom.Dimension;
import com.codename1.util.AsyncResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.scene.SnapshotParameters;
import javafx.scene.SnapshotResult;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import netscape.javascript.JSObject;

public class SEBrowserComponent
extends PeerComponent
implements IBrowserComponent {
    private static boolean firstTime = true;
    private WebView web;
    private JFXPanel panel;
    private JFrame frm;
    private JavaSEPort instance;
    private String currentURL;
    private boolean init = false;
    private JPanel cnt;
    private boolean lightweightMode;
    private boolean lightweightModeSet;
    private JScrollBar hSelector;
    private JScrollBar vSelector;
    private AdjustmentListener adjustmentListener;
    private BrowserComponent browserComp;
    private boolean transparent;
    private static final Object DEINIT_LOCK = new Object();
    private static final Object INIT_LOCK = new Object();
    private final Object imageLock = new Object();
    private BufferedImage peerImage;
    int lastX;
    int lastY;
    int lastW;
    int lastH;
    double lastZoom;

    private void makePageBackgroundTransparent() {
        try {
            Class<?> WebPage = Class.forName("com.sun.webkit.WebPage", true, SEBrowserComponent.class.getClassLoader());
            Class<?> Accessor2 = Class.forName("com.sun.javafx.webkit.Accessor", true, SEBrowserComponent.class.getClassLoader());
            Method getPageFor = Accessor2.getMethod("getPageFor", WebEngine.class);
            Object webPage = getPageFor.invoke(null, this.web.getEngine());
            Method setBackgroundColor = WebPage.getMethod("setBackgroundColor", Integer.TYPE);
            setBackgroundColor.invoke(webPage, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AsyncResource<com.codename1.ui.Image> captureScreenshot() {
        final AsyncResource out = new AsyncResource();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SEBrowserComponent.this.panel.repaint();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SnapshotParameters params = new SnapshotParameters();
                        params.setFill((Paint)Color.TRANSPARENT);
                        SEBrowserComponent.this.web.snapshot((Callback)new Callback<SnapshotResult, Void>(){

                            public Void call(SnapshotResult p) {
                                WritableImage wi = p.getImage();
                                BufferedImage img = SwingFXUtils.fromFXImage((javafx.scene.image.Image)wi, null);
                                out.complete((Object)com.codename1.ui.Image.createImage((Object)img));
                                return null;
                            }
                        }, params, null);
                    }
                });
            }
        });
        return out;
    }

    private void setZoom(double zoom) {
        try {
            Method setZoom = WebView.class.getMethod("setZoom", Double.TYPE);
            setZoom.invoke((Object)this, zoom);
            System.out.println("Set zoom to " + zoom);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void init(SEBrowserComponent self, BrowserComponent p) {
        final WeakReference<SEBrowserComponent> weakSelf = new WeakReference<SEBrowserComponent>(self);
        final WeakReference<BrowserComponent> weakP = new WeakReference<BrowserComponent>(p);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SEBrowserComponent self = (SEBrowserComponent)weakSelf.get();
                if (self == null) {
                    return;
                }
                self.cnt = new InternalJPanel(self.instance, self);
                self.cnt.setOpaque(false);
                self.cnt.setLayout(new BorderLayout());
                self.cnt.add("Center", (Component)self.panel);
            }
        });
        self.web.getEngine().getLoadWorker().messageProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String t, String t1) {
                SEBrowserComponent self = (SEBrowserComponent)weakSelf.get();
                BrowserComponent p = (BrowserComponent)weakP.get();
                if (self == null || p == null) {
                    return;
                }
                if (t1.startsWith("Loading http:") || t1.startsWith("Loading file:") || t1.startsWith("Loading https:")) {
                    String url = t1.substring("Loading ".length());
                    if (!url.equals(self.currentURL)) {
                        p.fireWebEvent("onStart", new ActionEvent((Object)url));
                    }
                    self.currentURL = url;
                } else if ("Loading complete".equals(t1)) {
                    // empty if block
                }
            }
        });
        self.web.getEngine().setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

            public void handle(WebEvent<String> t) {
                BrowserComponent p = (BrowserComponent)weakP.get();
                if (p == null) {
                    return;
                }
                String msg = (String)t.getData();
                if (msg.startsWith("!cn1_message:")) {
                    System.out.println("Receiving message " + msg);
                    p.fireWebEvent("onMessage", new ActionEvent((Object)msg.substring("!cn1_message:".length())));
                }
            }
        });
        self.web.getEngine().getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

            public void changed(ObservableValue<? extends Throwable> ov, Throwable t, Throwable t1) {
                System.out.println("Received exception: " + t1.getMessage());
                if (ov.getValue() != null) {
                    ((Throwable)ov.getValue()).printStackTrace();
                }
                if (t != ov.getValue() && t != null) {
                    t.printStackTrace();
                }
                if (t1 != ov.getValue() && t1 != t && t1 != null) {
                    t.printStackTrace();
                }
            }
        });
        self.web.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                SEBrowserComponent self = (SEBrowserComponent)weakSelf.get();
                BrowserComponent p = (BrowserComponent)weakP.get();
                try {
                    JSObject w = (JSObject)self.web.getEngine().executeScript("window");
                    if (w == null) {
                        System.err.println("Could not get window");
                    } else {
                        Bridge b = new Bridge(p);
                        self.putClientProperty("SEBrowserComponent.Bridge.jconsole", b);
                        w.setMember("jconsole", b);
                    }
                }
                catch (Throwable t) {
                    Log.e((Throwable)t);
                }
                if (self == null || p == null) {
                    return;
                }
                String url = self.web.getEngine().getLocation();
                if (newState == Worker.State.SCHEDULED) {
                    p.fireWebEvent("onStart", new ActionEvent((Object)url));
                } else if (newState == Worker.State.RUNNING) {
                    p.fireWebEvent("onLoadResource", new ActionEvent((Object)url));
                } else if (newState == Worker.State.SUCCEEDED) {
                    if (!p.isNativeScrollingEnabled()) {
                        self.web.getEngine().executeScript("document.body.style.overflow='hidden'");
                    }
                    if (Boolean.TRUE.equals(p.getClientProperty("BrowserComponent.firebug"))) {
                        self.web.getEngine().executeScript("if (!document.getElementById('FirebugLite')){E = document['createElement' + 'NS'] && document.documentElement.namespaceURI;E = E ? document['createElement' + 'NS'](E, 'script') : document['createElement']('script');E['setAttribute']('id', 'FirebugLite');E['setAttribute']('src', 'https://getfirebug.com/' + 'firebug-lite.js' + '#startOpened');E['setAttribute']('FirebugLite', '4');(document['getElementsByTagName']('head')[0] || document['getElementsByTagName']('body')[0]).appendChild(E);E = new Image;E['setAttribute']('src', 'https://getfirebug.com/' + '#startOpened');}");
                    }
                    JSObject window = (JSObject)self.web.getEngine().executeScript("window");
                    Bridge b = new Bridge(p);
                    self.putClientProperty("SEBrowserComponent.Bridge.cn1application", b);
                    window.setMember("cn1application", b);
                    self.web.getEngine().executeScript("while (window._cn1ready && window._cn1ready.length > 0) {var f = window._cn1ready.shift(); f();}");
                    self.web.getEngine().executeScript("window.addEventListener('unload', function(e){console.log('unloading...');return 'foobar';});");
                    p.fireWebEvent("onLoad", new ActionEvent((Object)url));
                }
                self.currentURL = url;
                self.repaint();
            }
        });
        self.web.getEngine().getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

            public void changed(ObservableValue<? extends Throwable> ov, Throwable t, Throwable t1) {
                BrowserComponent p = (BrowserComponent)weakP.get();
                if (p == null) {
                    return;
                }
                t1.printStackTrace();
                if (t1 == null) {
                    if (t == null) {
                        p.fireWebEvent("onError", new ActionEvent((Object)"Unknown error", -1));
                    } else {
                        p.fireWebEvent("onError", new ActionEvent((Object)t.getMessage(), -1));
                    }
                } else {
                    p.fireWebEvent("onError", new ActionEvent((Object)t1.getMessage(), -1));
                }
            }
        });
        self.web.getEngine().locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> prop, String before, String after) {
                SEBrowserComponent self = (SEBrowserComponent)weakSelf.get();
                BrowserComponent p = (BrowserComponent)weakP.get();
                if (self == null || p == null) {
                    return;
                }
                if (!p.fireBrowserNavigationCallbacks(self.web.getEngine().getLocation())) {
                    self.web.getEngine().getLoadWorker().cancel();
                }
            }
        });
        self.adjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                Display.getInstance().callSerially(new Runnable(){

                    @Override
                    public void run() {
                        SEBrowserComponent self = (SEBrowserComponent)weakSelf.get();
                        if (self == null) {
                            return;
                        }
                        self.onPositionSizeChange();
                    }
                });
            }
        };
    }

    public SEBrowserComponent() {
        super(null);
    }

    public void SEBrowserComponent_init(JavaSEPort instance, JPanel f, JFXPanel fx, WebView web, BrowserComponent p, JScrollBar hSelector, JScrollBar vSelector) {
        this.web = web;
        this.instance = instance;
        this.frm = (JFrame)f.getTopLevelAncestor();
        this.transparent = p.getStyle().getBgTransparency() == 0;
        this.panel = fx;
        WebEngine we = web.getEngine();
        try {
            File home = new File(System.getProperty("user.home") + File.separator + JavaSEPort.getAppHomeDir());
            File userdata = new File(home, ".fxuserdata");
            if (!userdata.exists()) {
                userdata.mkdirs();
            }
            Method mtd = we.getClass().getMethod("setUserDataDirectory", File.class);
            mtd.invoke((Object)we, userdata);
        }
        catch (Throwable t) {
            System.out.println("It looks like you are running on a version of Java older than Java 8. We recommend upgrading");
            t.printStackTrace();
        }
        SEBrowserComponent.init(this, p);
        this.hSelector = hSelector;
        this.vSelector = vSelector;
    }

    @Override
    public String executeAndReturnString(final String js) {
        if (SEBrowserComponent.isFXThread()) {
            try {
                return "" + this.web.getEngine().executeScript(js);
            }
            catch (Throwable jse) {
                System.out.println("Error trying to execute js " + js);
                throw new RuntimeException(jse);
            }
        }
        final String[] result = new String[1];
        final boolean[] complete = new boolean[]{false};
        final Throwable[] error = new Throwable[1];
        Platform.runLater((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    result[0] = "" + SEBrowserComponent.this.web.getEngine().executeScript(js);
                }
                catch (Throwable jse) {
                    System.out.println("Error trying to execute js " + js);
                    error[0] = jse;
                }
                boolean[] blArray = complete;
                synchronized (complete) {
                    complete[0] = true;
                    complete.notify();
                    // ** MonitorExit[var1_2] (shouldn't be in output)
                    return;
                }
            }
        });
        while (!complete[0]) {
            Display.getInstance().invokeAndBlock(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (complete[0]) return;
                    boolean[] blArray = complete;
                    synchronized (complete) {
                        try {
                            complete.wait(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        return;
                    }
                }
            });
        }
        if (error[0] != null) {
            throw new RuntimeException(error[0]);
        }
        return result[0];
    }

    private void executeImpl(String js) {
        try {
            this.web.getEngine().executeScript(js);
        }
        catch (Throwable t) {
            Log.p((String)("Javascript exception occurred while running expression: " + js));
            throw t;
        }
    }

    private static boolean isFXThread() {
        return Platform.isFxApplicationThread();
    }

    @Override
    public void execute(final String js) {
        if (SEBrowserComponent.isFXThread()) {
            this.executeImpl(js);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    SEBrowserComponent.this.executeImpl(js);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deinitialize() {
        final boolean[] complete = new boolean[1];
        Object object = this.imageLock;
        synchronized (object) {
            this.peerImage = new BufferedImage(this.cnt.getWidth(), this.cnt.getHeight(), 2);
            final Graphics2D imageG = this.peerImage.createGraphics();
            try {
                this.instance.drawingNativePeer = true;
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SEBrowserComponent.this.cnt.paint(imageG);
                    }
                });
            }
            catch (Exception exception) {
            }
            finally {
                this.instance.drawingNativePeer = false;
                imageG.dispose();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (SEBrowserComponent.this.init) {
                    SEBrowserComponent.this.hSelector.removeAdjustmentListener(SEBrowserComponent.this.adjustmentListener);
                    SEBrowserComponent.this.vSelector.removeAdjustmentListener(SEBrowserComponent.this.adjustmentListener);
                    SEBrowserComponent.this.lastX = 0;
                    SEBrowserComponent.this.lastY = 0;
                    SEBrowserComponent.this.lastW = 0;
                    SEBrowserComponent.this.lastH = 0;
                    SEBrowserComponent.this.frm.remove(SEBrowserComponent.this.cnt);
                    SEBrowserComponent.this.init = false;
                    complete[0] = true;
                    SEBrowserComponent.this.frm.repaint();
                } else {
                    complete[0] = true;
                }
                Object object = DEINIT_LOCK;
                synchronized (object) {
                    DEINIT_LOCK.notify();
                }
            }
        });
        Display.getInstance().invokeAndBlock(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!complete[0]) {
                    Object object = DEINIT_LOCK;
                    synchronized (object) {
                        try {
                            DEINIT_LOCK.wait(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        super.deinitialize();
    }

    protected void initComponent() {
        super.initComponent();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        final boolean[] completed = new boolean[1];
        Object object = this.imageLock;
        synchronized (object) {
            this.peerImage = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!SEBrowserComponent.this.init) {
                    SEBrowserComponent.this.init = true;
                    SEBrowserComponent.this.frm.add((Component)SEBrowserComponent.this.cnt, 0);
                    completed[0] = true;
                    Object object = INIT_LOCK;
                    synchronized (object) {
                        INIT_LOCK.notify();
                    }
                    SEBrowserComponent.this.onPositionSizeChange();
                    SEBrowserComponent.this.hSelector.addAdjustmentListener(SEBrowserComponent.this.adjustmentListener);
                    SEBrowserComponent.this.vSelector.addAdjustmentListener(SEBrowserComponent.this.adjustmentListener);
                    SEBrowserComponent.this.frm.repaint();
                    SEBrowserComponent.this.repaint();
                } else {
                    completed[0] = true;
                }
            }
        });
        Display.getInstance().invokeAndBlock(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!completed[0]) {
                    Object object = INIT_LOCK;
                    synchronized (object) {
                        try {
                            INIT_LOCK.wait(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }

    protected void setLightweightMode(boolean l) {
    }

    protected boolean shouldRenderPeerImage() {
        return false;
    }

    protected Dimension calcPreferredSize() {
        return new Dimension((int)(this.web.getWidth() * JavaSEPort.retinaScale / (double)this.instance.zoomLevel), (int)(this.web.getHeight() * JavaSEPort.retinaScale / (double)this.instance.zoomLevel));
    }

    protected void onPositionSizeChange() {
        int screenY;
        int screenX;
        if (this.cnt == null) {
            return;
        }
        Form f = this.getComponentForm();
        if (this.cnt.getParent() == null && f != null && Display.getInstance().getCurrent() == f) {
            return;
        }
        final int x = this.getAbsoluteX();
        final int y = this.getAbsoluteY();
        final int w = this.getWidth();
        final int h = this.getHeight();
        if (this.lastZoom == (double)this.instance.zoomLevel && x == this.lastX && y == this.lastY && w == this.lastW && h == this.lastH) {
            return;
        }
        if (this.instance.getScreenCoordinates() != null) {
            screenX = this.instance.getScreenCoordinates().x;
            screenY = this.instance.getScreenCoordinates().y;
        } else {
            screenX = 0;
            screenY = 0;
        }
        this.lastX = x;
        this.lastY = y;
        this.lastW = w;
        this.lastH = h;
        final double zoom = this.lastZoom = (double)this.instance.zoomLevel;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SEBrowserComponent.this.setZoom(((SEBrowserComponent)SEBrowserComponent.this).instance.zoomLevel);
                    }
                });
                SEBrowserComponent.this.frm.doLayout();
                SEBrowserComponent.this.cnt.setBounds((int)((double)(x + screenX + SEBrowserComponent.this.instance.getCanvasX()) * zoom / JavaSEPort.retinaScale), (int)((double)(y + screenY + SEBrowserComponent.this.instance.getCanvasY()) * zoom / JavaSEPort.retinaScale), (int)((double)w * zoom / JavaSEPort.retinaScale), (int)((double)h * zoom / JavaSEPort.retinaScale));
                SEBrowserComponent.this.cnt.doLayout();
                ((InternalJPanel)SEBrowserComponent.this.cnt).paintOnBuffer();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
            return;
        }
        SwingUtilities.invokeLater(r);
    }

    int getScreenCoordinateX() {
        Rectangle r = this.instance.getScreenCoordinates();
        if (r == null) {
            return 0;
        }
        return r.x;
    }

    int getScreenCoordinateY() {
        Rectangle r = this.instance.getScreenCoordinates();
        if (r == null) {
            return 0;
        }
        return r.y;
    }

    @Override
    public void setProperty(String key, Object value) {
        if (key.equalsIgnoreCase("User-Agent")) {
            // empty if block
        }
    }

    @Override
    public String getTitle() {
        return this.web.getEngine().getTitle();
    }

    @Override
    public String getURL() {
        return this.web.getEngine().getLocation();
    }

    @Override
    public void setURL(String url) {
        this.web.getEngine().load(url);
    }

    @Override
    public void stop() {
    }

    @Override
    public void reload() {
        this.web.getEngine().reload();
    }

    @Override
    public boolean hasBack() {
        return this.web.getEngine().getHistory().getCurrentIndex() > 0;
    }

    @Override
    public boolean hasForward() {
        return this.web.getEngine().getHistory().getCurrentIndex() < this.web.getEngine().getHistory().getMaxSize() - 1;
    }

    @Override
    public void back() {
        this.web.getEngine().getHistory().go(-1);
    }

    @Override
    public void forward() {
        this.web.getEngine().getHistory().go(1);
    }

    @Override
    public void clearHistory() {
    }

    @Override
    public void setPage(String html, String baseUrl) {
        this.web.getEngine().loadContent(html);
        this.repaint();
    }

    @Override
    public void exposeInJavaScript(Object o, String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(com.codename1.ui.Graphics g) {
        if (!this.init) {
            Object object = this.imageLock;
            synchronized (object) {
                if (this.peerImage != null) {
                    Object nativeGraphics = Accessor.getNativeGraphics(g);
                    Graphics2D g2 = (Graphics2D)this.instance.getGraphics(nativeGraphics).create();
                    try {
                        g2.translate(this.getAbsoluteX(), this.getAbsoluteY());
                        if (this.instance.zoomLevel != 1.0f) {
                            g2.scale(1.0f / this.instance.zoomLevel, 1.0f / this.instance.zoomLevel);
                        } else if (this.instance.takingScreenshot && this.instance.screenshotActualZoomLevel != 1.0f) {
                            g2.scale(1.0f / this.instance.screenshotActualZoomLevel, 1.0f / this.instance.screenshotActualZoomLevel);
                        }
                        g2.drawImage((Image)this.peerImage, 0, 0, null);
                    }
                    finally {
                        g2.dispose();
                    }
                    return;
                }
            }
        }
        this.onPositionSizeChange();
        this.instance.drawNativePeer(Accessor.getNativeGraphics(g), this, this.cnt);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((InternalJPanel)SEBrowserComponent.this.cnt).paintOnBuffer();
            }
        });
    }

    @Override
    public void runLater(Runnable r) {
        Platform.runLater((Runnable)r);
    }

    @Override
    public boolean supportsExecuteAndReturnString() {
        return true;
    }

    private static class InternalJPanel
    extends JPanel {
        private final JavaSEPort instance;
        private final SEBrowserComponent cmp;
        BufferedImage buf;

        InternalJPanel(JavaSEPort instance, SEBrowserComponent cmp) {
            this.instance = instance;
            this.cmp = cmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintOnBuffer() {
            if (this.getWidth() == 0 || this.getHeight() == 0) {
                return;
            }
            if (EventQueue.isDispatchThread()) {
                SEBrowserComponent sEBrowserComponent = this.cmp;
                synchronized (sEBrowserComponent) {
                    this.paintOnBufferImpl();
                }
            }
            if (!Display.getInstance().isEdt()) {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            this.paintOnBuffer();
                        }
                    });
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        private void paintOnBufferImpl() {
            BufferedImage buf = this.getBuffer();
            Graphics2D g2d = buf.createGraphics();
            g2d.scale(JavaSEPort.retinaScale / (double)this.instance.zoomLevel, JavaSEPort.retinaScale / (double)this.instance.zoomLevel);
            this.cmp.panel.paint((Graphics)g2d);
            g2d.dispose();
            this.cmp.putClientProperty("__buffer", buf);
        }

        @Override
        public void paint(Graphics g) {
            this.paintOnBuffer();
            Display.getInstance().callSerially(new Runnable(){

                @Override
                public void run() {
                    cmp.repaint();
                }
            });
        }

        @Override
        protected void paintChildren(Graphics g) {
        }

        @Override
        protected void paintBorder(Graphics g) {
        }

        @Override
        protected void paintComponent(Graphics g) {
        }

        private BufferedImage getBuffer() {
            if (this.buf == null || (double)this.buf.getWidth() != (double)this.getWidth() * JavaSEPort.retinaScale / (double)this.instance.zoomLevel || (double)this.buf.getHeight() != (double)this.getHeight() * JavaSEPort.retinaScale / (double)this.instance.zoomLevel) {
                this.buf = new BufferedImage((int)((double)this.getWidth() * JavaSEPort.retinaScale / (double)this.instance.zoomLevel), (int)((double)this.getHeight() * JavaSEPort.retinaScale / (double)this.instance.zoomLevel), 2);
            }
            return this.buf;
        }
    }

    public static class Bridge {
        final WeakReference<BrowserComponent> weakBrowserComp;

        Bridge(BrowserComponent cmp) {
            this.weakBrowserComp = new WeakReference<BrowserComponent>(cmp);
        }

        public boolean shouldNavigate(String url) {
            BrowserComponent browserComp = (BrowserComponent)this.weakBrowserComp.get();
            if (browserComp != null) {
                return browserComp.fireBrowserNavigationCallbacks(url);
            }
            return true;
        }

        public void log(String val) {
            System.out.println("[JS Console] " + val);
        }
    }
}

