/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import javax.swing.JPanel;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.cef.CefClient;
import org.cef.OS;
import org.cef.browser.CN1CefDropTargetListener;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserWindow;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefRequestContext;
import org.cef.browser.ComponentDelegate;
import org.cef.browser.ComponentFactory;
import org.cef.browser.PixelBuffer;
import org.cef.browser.UIPlatform;
import org.cef.callback.CefDragData;
import org.cef.handler.CefClientHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefScreenInfo;

public class CN1CefBrowser
extends CefBrowser_N
implements CefRenderHandler {
    private long window_handle_ = 0L;
    private Rectangle browser_rect_ = new Rectangle(0, 0, 1, 1);
    private Point screenPoint_ = new Point(0, 0);
    private boolean isTransparent_;
    private JPanel component_;
    private WeakReference<PixelBuffer> bufferRef;
    private byte[] buf_;
    private static ComponentFactory componentFactory;
    private static UIPlatform platform;
    private boolean inSetFocus;
    private boolean firstPaint = true;
    private static int cachedJavaVersion;

    CN1CefBrowser(CefClient client, String url, boolean transparent, CefRequestContext context) {
        this(client, url, transparent, context, null, null);
    }

    private CN1CefBrowser(CefClient client, String url, boolean transparent, CefRequestContext context, CN1CefBrowser parent, Point inspectAt) {
        super(client, url, context, (CefBrowser_N)parent, inspectAt);
        this.isTransparent_ = transparent;
        this.createComponent();
    }

    public void setPeerComponentBuffer(PixelBuffer buf) {
        this.bufferRef = new WeakReference<PixelBuffer>(buf);
    }

    public void createImmediately() {
        this.createBrowserIfRequired(false);
    }

    public Component getUIComponent() {
        return this.component_;
    }

    public CefRenderHandler getRenderHandler() {
        return this;
    }

    protected CefBrowser_N createDevToolsBrowser(CefClient client, String url, CefRequestContext context, CefBrowser_N parent, Point inspectAt) {
        return new CN1CefBrowser(client, url, this.isTransparent_, context, this, inspectAt);
    }

    private synchronized long getWindowHandle() {
        if (this.window_handle_ == 0L && OS.isMacintosh()) {
            this.window_handle_ = CN1CefBrowser.getWindowHandle(this.component_);
        }
        return this.window_handle_;
    }

    private static long getWindowHandle(Component component) {
        try {
            if (OS.isMacintosh()) {
                try {
                    Class<?> cls = Class.forName("org.cef.browser.mac.CefBrowserWindowMac");
                    CefBrowserWindow browserWindow = (CefBrowserWindow)cls.newInstance();
                    if (browserWindow != null) {
                        return browserWindow.getWindowHandle(component);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return 0L;
        }
        catch (Throwable t) {
            System.out.println("Exception in thread " + Thread.currentThread().getName());
            t.printStackTrace();
            return 0L;
        }
    }

    private void createComponent() {
        this.component_ = componentFactory.createComponent(new ComponentDelegate(){

            @Override
            public void boundsChanged(int x, int y, int w, int h) {
                if (CN1CefBrowser.this.browser_rect_.getX() == (double)x && CN1CefBrowser.this.browser_rect_.getY() == (double)y && CN1CefBrowser.this.browser_rect_.getWidth() == (double)w && CN1CefBrowser.this.browser_rect_.getHeight() == (double)h) {
                    return;
                }
                CN1CefBrowser.this.browser_rect_.setBounds(x, y, w, h);
                try {
                    CN1CefBrowser.this.screenPoint_ = CN1CefBrowser.this.component_.getLocationOnScreen();
                }
                catch (IllegalComponentStateException ex) {
                    System.err.println("Failed to get location on screen:" + ex.getMessage());
                    CN1CefBrowser.this.screenPoint_ = new Point(0, 0);
                }
                this.wasResized(w, h);
            }

            @Override
            public void wasResized(int width, int height) {
                CN1CefBrowser.this.wasResized(width, height);
            }

            @Override
            public void createBrowserIfRequired(boolean b) {
                CN1CefBrowser.this.createBrowserIfRequired(b);
            }
        });
        this.component_.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                CN1CefBrowser.this.sendMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CN1CefBrowser.this.sendMouseEvent(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CN1CefBrowser.this.sendMouseEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CN1CefBrowser.this.sendMouseEvent(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                CN1CefBrowser.this.sendMouseEvent(e);
            }
        });
        this.component_.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                CN1CefBrowser.this.sendMouseEvent(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                CN1CefBrowser.this.sendMouseEvent(e);
            }
        });
        this.component_.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int units = platform.convertToPixels(e.getUnitsToScroll(), true) * -1;
                if (e.getScrollType() == 0) {
                    MouseWheelEvent e2 = new MouseWheelEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), 1, e.getScrollAmount(), units);
                    CN1CefBrowser.this.sendMouseWheelEvent(e2);
                    return;
                }
                CN1CefBrowser.this.sendMouseWheelEvent(e);
            }
        });
        this.component_.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                CN1CefBrowser.this.sendKeyEvent(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                CN1CefBrowser.this.sendKeyEvent(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                CN1CefBrowser.this.sendKeyEvent(e);
            }
        });
        this.component_.setFocusable(true);
        this.component_.addFocusListener(new FocusListener(){
            private boolean inFocusGained;
            private boolean inFocusLost;

            @Override
            public void focusLost(FocusEvent e) {
                if (this.inFocusLost) {
                    return;
                }
                this.inFocusLost = true;
                try {
                    CN1CefBrowser.this.setFocus(false);
                }
                finally {
                    this.inFocusLost = false;
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (this.inFocusGained) {
                    return;
                }
                this.inFocusGained = true;
                try {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    CN1CefBrowser.this.setFocus(true);
                }
                finally {
                    this.inFocusGained = false;
                }
            }
        });
        new DropTarget(this.component_, new CN1CefDropTargetListener(this));
    }

    public void setFocus(boolean enable) {
        if (this.inSetFocus) {
            return;
        }
        this.inSetFocus = true;
        try {
            super.setFocus(enable);
        }
        finally {
            this.inSetFocus = false;
        }
    }

    public Rectangle getViewRect(CefBrowser browser) {
        return this.browser_rect_;
    }

    public Point getScreenPoint(CefBrowser browser, Point viewPoint) {
        try {
            Point screenPoint = new Point(this.screenPoint_);
            screenPoint.translate(viewPoint.x, viewPoint.y);
            return screenPoint;
        }
        catch (Throwable t) {
            System.out.println("Exception in thread " + Thread.currentThread().getName());
            t.printStackTrace();
            return new Point(this.screenPoint_);
        }
    }

    public void onPopupShow(CefBrowser browser, boolean show) {
        try {
            if (!show) {
                this.invalidate();
            }
        }
        catch (Throwable t) {
            System.out.println("Exception in thread " + Thread.currentThread().getName());
            t.printStackTrace();
        }
    }

    public void onPopupSize(CefBrowser browser, Rectangle size) {
    }

    public void onPaint(CefBrowser browser, boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height) {
        try {
            this._onPaint(browser, popup, dirtyRects, buffer, width, height);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void _onPaint(CefBrowser browser, boolean popup, final Rectangle[] dirtyRects, final ByteBuffer buffer, final int width, final int height) {
        final PixelBuffer buffer_ = (PixelBuffer)this.bufferRef.get();
        if (buffer_ == null) {
            return;
        }
        BufferedImage img = buffer_.getBufferedImage();
        boolean imgUpdated = false;
        if (img == null || img.getWidth() != width || img.getHeight() != height) {
            img = new BufferedImage(width, height, 6);
            imgUpdated = true;
        }
        if (this.buf_ == null || this.buf_.length != width * height * 4) {
            this.buf_ = new byte[width * height * 4];
        }
        final BufferedImage fImg = img;
        final boolean fImgUpdated = imgUpdated;
        if (imgUpdated || this.firstPaint) {
            this.firstPaint = false;
            buffer_.modifyBuffer(new Runnable(){

                @Override
                public void run() {
                    WritableRaster raster = fImg.getRaster();
                    buffer.get(CN1CefBrowser.this.buf_);
                    int len = width * height * 4;
                    for (int i = 0; i < len; i += 4) {
                        byte tmp = CN1CefBrowser.this.buf_[i];
                        ((CN1CefBrowser)CN1CefBrowser.this).buf_[i] = CN1CefBrowser.this.buf_[i + 2];
                        ((CN1CefBrowser)CN1CefBrowser.this).buf_[i + 2] = tmp;
                    }
                    raster.setDataElements(0, 0, width, height, CN1CefBrowser.this.buf_);
                    if (fImgUpdated) {
                        buffer_.setBufferedImage(fImg);
                    }
                }
            });
            platform.runLater(new Runnable(){

                @Override
                public void run() {
                    buffer_.repaint();
                }
            });
        } else {
            buffer_.modifyBuffer(new Runnable(){

                @Override
                public void run() {
                    WritableRaster raster = fImg.getRaster();
                    for (Rectangle rect : dirtyRects) {
                        int dx = rect.x;
                        int dy = rect.y;
                        int rw = rect.width;
                        int rh = rect.height;
                        int dy2 = dy + rh;
                        for (int row = dy; row < dy2; ++row) {
                            buffer.position(row * width * 4 + dx * 4);
                            buffer.get(CN1CefBrowser.this.buf_, rw * (row - dy) * 4, rw * 4);
                        }
                        int len = rw * rh * 4;
                        for (int i = 0; i < len; i += 4) {
                            byte tmp = CN1CefBrowser.this.buf_[i];
                            ((CN1CefBrowser)CN1CefBrowser.this).buf_[i] = CN1CefBrowser.this.buf_[i + 2];
                            ((CN1CefBrowser)CN1CefBrowser.this).buf_[i + 2] = tmp;
                        }
                        raster.setDataElements(dx, dy, rw, rh, CN1CefBrowser.this.buf_);
                    }
                }
            });
            platform.runLater(new Runnable(){

                @Override
                public void run() {
                    for (Rectangle rect : dirtyRects) {
                        buffer_.repaint(rect.x, rect.y, rect.width, rect.height);
                    }
                }
            });
        }
    }

    public void onCursorChange(CefBrowser browser, final int cursorType) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CN1CefBrowser.this.component_.setCursor(new Cursor(cursorType));
            }
        });
    }

    public boolean startDragging(CefBrowser browser, CefDragData dragData, int mask, int x, int y) {
        return false;
    }

    public void updateDragCursor(CefBrowser browser, int operation) {
    }

    private void createBrowserIfRequired(boolean hasParent) {
        long windowHandle = 0L;
        if (hasParent) {
            windowHandle = this.getWindowHandle();
        }
        if (this.getNativeRef("CefBrowser") == 0L) {
            if (this.getParentBrowser() != null) {
                this.createDevTools(this.getParentBrowser(), (CefClientHandler)this.getClient(), windowHandle, true, this.isTransparent_, null, this.getInspectAt());
            } else {
                this.createBrowser((CefClientHandler)this.getClient(), windowHandle, this.getUrl(), true, this.isTransparent_, null, this.getRequestContext());
            }
        } else {
            this.setFocus(true);
        }
    }

    public void loadURL(String url) {
        super.loadURL(url);
    }

    public static void setUIPlatform(UIPlatform p) {
        platform = p;
    }

    public static void setComponentFactory(ComponentFactory factory) {
        componentFactory = factory;
    }

    public boolean getScreenInfo(CefBrowser browser, CefScreenInfo screenInfo) {
        try {
            GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfig = graphicsDevice.getDefaultConfiguration();
            screenInfo.Set(CN1CefBrowser.calcRetinaScale(), graphicsConfig.getColorModel().getPixelSize(), graphicsConfig.getColorModel().getComponentSize(0), false, graphicsConfig.getBounds(), graphicsConfig.getBounds());
        }
        catch (Throwable t) {
            System.out.println("Exception in thread " + Thread.currentThread().getName());
            t.printStackTrace();
        }
        return true;
    }

    private static double calcRetinaScale() {
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        try {
            if (CN1CefBrowser.getJavaVersion() >= 9) {
                GraphicsConfiguration graphicsConfig = graphicsDevice.getDefaultConfiguration();
                AffineTransform tx = graphicsConfig.getDefaultTransform();
                double scaleX = tx.getScaleX();
                double scaleY = tx.getScaleY();
                return Math.max(1.0, Math.min(scaleX, scaleY));
            }
            Field field = graphicsDevice.getClass().getDeclaredField("scale");
            if (field != null) {
                field.setAccessible(true);
                Object scale = field.get(graphicsDevice);
                if (scale instanceof Integer && (Integer)scale >= 2) {
                    return ((Integer)scale).doubleValue();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 1.0;
    }

    private static int getJavaVersion() {
        if (cachedJavaVersion < 0) {
            String version = System.getProperty("java.version");
            if (version.startsWith("1.")) {
                version = version.substring(2);
            }
            int dotPos = version.indexOf(46);
            int dashPos = version.indexOf(45);
            if (dotPos < 0 && dashPos < 0) {
                cachedJavaVersion = Integer.parseInt(version);
                return cachedJavaVersion;
            }
            cachedJavaVersion = Integer.parseInt(version.substring(0, dotPos > -1 ? dotPos : (dashPos > -1 ? dashPos : 1)));
            return cachedJavaVersion;
        }
        return cachedJavaVersion;
    }

    static {
        cachedJavaVersion = -1;
    }
}

