/*
 * Decompiled with CFR 0.152.
 */
package net.informaticalibera.tests.goldeneditor;

import com.codename1.io.Log;
import com.codename1.io.NetworkEvent;
import com.codename1.io.Preferences;
import com.codename1.ui.CN;
import com.codename1.ui.Component;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.TextArea;
import com.codename1.ui.Toolbar;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.util.Resources;
import net.informaticalibera.tests.goldeneditor.DeviceUtilities;

public class GoldenEditor {
    private Form current;
    private Resources theme;
    private long pressedTime = -1L;

    public void init(Object context) {
        CN.updateNetworkThreadCount((int)2);
        DeviceUtilities.loadCSS("theme");
        Toolbar.setGlobalToolbar((boolean)true);
        Log.bindCrashProtection((boolean)true);
        CN.addNetworkErrorListener(err -> {
            NetworkEvent networkEvent;
            err.consume();
            if (err.getError() != null) {
                Log.e((Throwable)err.getError());
            }
            Log.sendLogAsync();
            Dialog.show((String)"Connection Error", (String)("There was a networking error in the connection to " + networkEvent.getConnectionRequest().getUrl()), (String)"OK", null);
        });
    }

    /*
     * WARNING - void declaration
     */
    public void start() {
        void var1_1;
        void var2_2;
        if (this.current != null) {
            this.current.show();
            return;
        }
        Form hi = new Form("Golden Editor", (Layout)new BorderLayout());
        hi.getToolbar().hideToolbar();
        hi.getContentPane().setSafeArea(true);
        hi.setFormBottomPaddingEditingMode(true);
        TextArea textArea = new TextArea();
        if (!Preferences.get((String)"isFirstRun", (boolean)true)) {
            textArea.setText(Preferences.get((String)"TextArea", (String)""));
        } else {
            textArea.setText("Ciao, sono Golden Editor\nQui puoi scrivere le tue note\n\nPer condividerle, premi lo schermo per almeno tre secondi");
            Preferences.set((String)"isFirstRun", (boolean)false);
        }
        textArea.setHint("Golden Editor - Premi 3 sec per condividere");
        textArea.getHintLabel().setUIID("TextAreaHint");
        hi.add((Object)"Center", (Component)textArea);
        TextArea textArea2 = textArea;
        textArea2.addDataChangedListener((type, index) -> {
            TextArea textArea2;
            Preferences.set((String)"TextArea", (String)textArea2.getText());
        });
        textArea.addPointerPressedListener(l -> {
            Log.p((String)"Pointer pressed listener");
            this.pressedTime = System.currentTimeMillis();
        });
        textArea.addPointerReleasedListener(arg_0 -> this.lambda$start$3((TextArea)var2_2, arg_0));
        var1_1.show();
    }

    public void stop() {
        this.current = CN.getCurrentForm();
        if (this.current instanceof Dialog) {
            ((Dialog)this.current).dispose();
            this.current = CN.getCurrentForm();
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$start$3(TextArea textArea, ActionEvent l) {
        Log.p((String)"Pointer released listener");
        if (this.pressedTime > -1L && System.currentTimeMillis() - this.pressedTime > 3000L) {
            void var1_1;
            Log.p((String)"Sharing text");
            textArea.stopEditing();
            Display.getInstance().share(var1_1.getText(), null, "text/plain");
        }
    }
}

