/*
 * Decompiled with CFR 0.152.
 */
package net.informaticalibera.tests.goldeneditor;

import com.codename1.io.Log;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.Resources;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;

public class DeviceUtilities {
    private static int percentage = DeviceUtilities.calculateAdaptionPercentage();

    public static void loadCSS(String css) {
        try {
            UIManager.initFirstTheme((String)("/" + css));
            Resources resource = Resources.openLayered((String)("/" + css));
            Hashtable themeProps = resource.getTheme("Theme");
            UIManager.getInstance().setThemeProps(DeviceUtilities.adaptTheme(themeProps));
            Resources.setGlobalResources((Resources)resource);
            Log.p((String)("Loaded " + css + ".css"), (int)1);
        }
        catch (Exception ex) {
            Log.p((String)"CssUtilities.loadCSS - ERROR", (int)4);
            Log.e((Throwable)ex);
            Log.sendLogAsync();
        }
    }

    private static int calculateAdaptionPercentage() {
        int defaultScreenWidth = Display.getInstance().convertToPixels(62.0f);
        int currentScreenWidth = Display.getInstance().getDisplayWidth();
        int currentInMM = currentScreenWidth / Display.getInstance().convertToPixels(1.0f);
        int percentage = currentScreenWidth * 100 / defaultScreenWidth - 100;
        if (percentage < -30) {
            percentage = -30;
        } else if (percentage > 0) {
            percentage = 0;
        }
        Log.p((String)("Estimated screen width: " + currentInMM + " mm"), (int)2);
        Log.p((String)("Font percentage: " + percentage + "%"), (int)2);
        return percentage;
    }

    private static Hashtable adaptTheme(Hashtable hashtable) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        Set keys = hashtable.keySet();
        for (String key : keys) {
            Object value = hashtable.get(key);
            if (value instanceof Font && ((Font)value).isTTFNativeFont() && percentage < 0) {
                Font font = (Font)value;
                float newSize = (int)(font.getPixelSize() * (float)(100 + percentage) / 100.0f);
                result.put(key, font.derive(newSize, font.getStyle()));
                continue;
            }
            if (key.endsWith("#margin") || key.endsWith(".margin") || key.endsWith("#padding") || key.endsWith(".padding")) {
                if (!(value instanceof String)) continue;
                result.put(key, DeviceUtilities.resizeMarginPadding((String)value));
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    public static int getResized(int size) {
        return size * (100 + percentage) / 100;
    }

    public static float getResized(double size) {
        return (float)(size * (double)(100 + percentage) / 100.0);
    }

    public static int getResized(int size, boolean convertToPx) {
        if (!convertToPx) {
            return DeviceUtilities.getResized(size);
        }
        return DeviceUtilities.getResized(Display.getInstance().convertToPixels((float)size));
    }

    private static String resizeMarginPadding(String input) {
        String result = "";
        StringTokenizer st = new StringTokenizer(input, ",");
        if (st.countTokens() == 4) {
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    Float number = Float.valueOf(token);
                    number = Float.valueOf(DeviceUtilities.getResized(number.floatValue()));
                    number = Float.valueOf((float)((int)(number.floatValue() * 10.0f)) / 10.0f);
                    result = result + number;
                    if (st.countTokens() == 0) continue;
                    result = result + ",";
                }
                catch (NumberFormatException e) {
                    return input;
                }
            }
        } else {
            return input;
        }
        return result;
    }

    public static double getResized(double size, boolean convertToPx) {
        if (!convertToPx) {
            return DeviceUtilities.getResized(size);
        }
        return DeviceUtilities.getResized(Display.getInstance().convertToPixels((float)size));
    }
}

