/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.compat;

import com.codename1.charts.compat.GradientDrawable;
import com.codename1.charts.compat.Paint;
import com.codename1.charts.util.ColorUtil;
import com.codename1.io.Log;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.Stroke;
import com.codename1.ui.Transform;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.geom.Rectangle2D;
import com.codename1.ui.geom.Shape;

public class Canvas {
    public Graphics g;
    public Rectangle bounds = null;
    public int absoluteX = 0;
    public int absoluteY = 0;

    public Canvas() {
        Display d = Display.getInstance();
        this.bounds = new Rectangle(0, 0, d.getDisplayWidth(), d.getDisplayHeight());
        this.absoluteX = this.bounds.getX();
        this.absoluteY = this.bounds.getY();
    }

    public void getClipBounds(Rectangle mRect) {
        int[] bounds = this.g.getClip();
        mRect.setBounds(bounds[0], bounds[1], bounds[2], bounds[3]);
    }

    private void applyPaint(Paint paint) {
        this.applyPaint(paint, false);
    }

    private void applyPaint(Paint paint, boolean forText) {
        this.g.setColor(paint.getColor());
        int alpha = ColorUtil.alpha(paint.getColor());
        this.g.setAlpha(alpha);
        if (forText) {
            Font typeFace = paint.getTypeface();
            if (typeFace != null) {
                if (typeFace.getSize() != (int)paint.getTextSize()) {
                    typeFace = typeFace.derive(paint.getTextSize(), 0);
                }
                this.g.setFont(typeFace);
            } else {
                this.g.setFont(null);
            }
        }
    }

    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        this.applyPaint(paint);
        Paint.Style style = paint.getStyle();
        if (Paint.Style.FILL.equals((Object)style)) {
            this.g.fillRect((int)left, (int)top, (int)right - (int)left, (int)bottom - (int)top);
        } else if (Paint.Style.STROKE.equals((Object)style)) {
            this.g.drawRect((int)left, (int)top, (int)right - (int)left, (int)bottom - (int)top);
        } else if (Paint.Style.FILL_AND_STROKE.equals((Object)style)) {
            this.g.fillRect((int)left, (int)top, (int)right - (int)left, (int)bottom - (int)top);
        }
    }

    public void drawText(String string, float x, float y, Paint paint) {
        this.applyPaint(paint, true);
        int offX = 0;
        int offY = 0;
        if (paint.getTextAlign() == 4) {
            offX = -this.g.getFont().stringWidth(string) / 2;
        } else if (paint.getTextAlign() == 3) {
            offX = -this.g.getFont().stringWidth(string);
        }
        int h = this.g.getFont().getAscent();
        this.g.drawString(string, (int)x + offX, (int)y - h + offY);
    }

    public int getHeight() {
        if (this.bounds != null) {
            return this.bounds.getHeight();
        }
        return this.g.getClipHeight();
    }

    public int getWidth() {
        if (this.bounds != null) {
            return this.bounds.getWidth();
        }
        return this.g.getClipWidth();
    }

    private Stroke getStroke(Paint paint) {
        return new Stroke(paint.getStrokeWidth(), paint.getStrokeCap(), paint.getStrokeJoin(), paint.getStrokeMiter());
    }

    public void drawPath(Shape p, Paint paint) {
        this.applyPaint(paint);
        Paint.Style style = paint.getStyle();
        if (style.equals((Object)Paint.Style.FILL)) {
            this.g.fillShape(p);
        } else if (style.equals((Object)Paint.Style.STROKE)) {
            this.g.drawShape(p, this.getStroke(paint));
        } else if (style.equals((Object)Paint.Style.FILL_AND_STROKE)) {
            this.g.fillShape(p);
            this.g.drawShape(p, this.getStroke(paint));
        }
    }

    public void drawLine(float x1, float y1, float x2, float y2, Paint paint) {
        this.applyPaint(paint);
        this.g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
    }

    public void rotate(float angle, float x, float y) {
        Transform t = this.g.getTransform();
        t.rotate((float)((double)angle * Math.PI / 180.0), x + (float)this.absoluteX - (float)this.bounds.getX(), y + (float)this.absoluteY - (float)this.bounds.getY());
        this.g.setTransform(t);
    }

    public void scale(float x, float y) {
        Transform t = this.g.getTransform();
        t.translate(this.bounds.getX(), this.bounds.getY());
        t.scale(x, y);
        t.translate(-this.bounds.getX(), -this.bounds.getY());
        this.g.setTransform(t);
    }

    public void translate(float x, float y) {
        Transform t = this.g.getTransform();
        t.translate(x, y);
        this.g.setTransform(t);
    }

    public void drawCircle(float cx, float cy, float r, Paint paint) {
        this.drawArc(new Rectangle2D(cx - r, cy - r, 2.0f * r, 2.0f * r), 0.0f, 360.0f, true, paint);
    }

    public void drawArc(Rectangle2D oval, float currentAngle, float sweepAngle, boolean useCenter, Paint paint) {
        this.applyPaint(paint);
        Paint.Style style = paint.getStyle();
        if (Paint.Style.FILL.equals((Object)style)) {
            this.g.fillArc((int)Math.round(oval.getX()), (int)Math.round(oval.getY()), (int)Math.round(oval.getWidth()), (int)Math.round(oval.getHeight()), -((int)Math.floor(currentAngle)), -((int)Math.ceil(sweepAngle)));
        } else if (Paint.Style.STROKE.equals((Object)style)) {
            this.g.drawArc((int)Math.round(oval.getX()), (int)Math.round(oval.getY()), (int)Math.round(oval.getWidth()), (int)Math.round(oval.getHeight()), -((int)Math.floor(currentAngle)), -((int)Math.ceil(sweepAngle)));
        } else if (Paint.Style.FILL_AND_STROKE.equals((Object)style)) {
            this.g.fillArc((int)Math.round(oval.getX()), (int)Math.round(oval.getY()), (int)Math.round(oval.getWidth()), (int)Math.round(oval.getHeight()), -((int)Math.floor(currentAngle)), -((int)Math.ceil(sweepAngle)));
            this.g.drawArc((int)Math.round(oval.getX()), (int)Math.round(oval.getY()), (int)Math.round(oval.getWidth()), (int)Math.round(oval.getHeight()), -((int)Math.floor(currentAngle)), -((int)Math.ceil(sweepAngle)));
        }
    }

    public void drawArcWithGradient(Rectangle2D oval, float currentAngle, float sweepAngle, boolean useCenter, Paint paint, GradientDrawable gradient) {
        this.g.fillRadialGradient(gradient.colors[1], gradient.colors[0], (int)oval.getX(), (int)oval.getY(), (int)oval.getWidth(), (int)oval.getHeight(), -((int)Math.floor(currentAngle)), -((int)Math.ceil(sweepAngle)));
    }

    public void drawPoint(Float get, Float get0, Paint paint) {
        throw new RuntimeException("Not supported yet.");
    }

    public void drawRoundRect(Rectangle2D rect, float rx, float ry, Paint mPaint) {
        this.applyPaint(mPaint);
        Paint.Style style = mPaint.getStyle();
        if (Paint.Style.FILL.equals((Object)style)) {
            this.g.fillRoundRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight(), (int)rx, (int)ry);
        } else if (Paint.Style.STROKE.equals((Object)style)) {
            this.g.drawRoundRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight(), (int)rx, (int)ry);
        } else if (Paint.Style.FILL_AND_STROKE.equals((Object)style)) {
            this.g.fillRoundRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight(), (int)rx, (int)ry);
            this.g.drawRoundRect((int)rect.getX(), (int)rect.getY(), this.getWidth(), (int)rect.getHeight(), (int)rx, (int)ry);
        }
        this.g.drawRoundRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight(), (int)rx, (int)ry);
    }

    public void drawBitmap(Image img, float left, float top, Paint paint) {
        this.g.drawImage(img, (int)left, (int)top);
    }

    void drawGradient(GradientDrawable gradient) {
        GradientDrawable.Orientation o = gradient.orientation;
        Rectangle r = gradient.bounds;
        int[] colors = gradient.colors;
        int clen = colors.length;
        if (GradientDrawable.Orientation.TOP_BOTTOM.equals((Object)o) || GradientDrawable.Orientation.BOTTOM_TOP.equals((Object)o)) {
            if (GradientDrawable.Orientation.BOTTOM_TOP.equals((Object)o)) {
                colors = new int[clen];
                for (int i = 0; i < clen; ++i) {
                    colors[i] = gradient.colors[clen - i - 1];
                }
            }
            this.g.fillLinearGradient(colors[0], colors[clen - 1], r.getX(), r.getY(), r.getWidth(), r.getHeight(), false);
        } else if (GradientDrawable.Orientation.LEFT_RIGHT.equals((Object)o)) {
            this.g.fillLinearGradient(gradient.colors[0], gradient.colors[clen - 1], r.getX(), r.getY(), r.getWidth(), r.getHeight(), true);
        } else {
            Log.p("Gradient with type " + (Object)((Object)o) + " not implemented yet.  Just filling solid rect");
            this.g.setColor(gradient.colors[0]);
            this.g.fillRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }
    }

    public boolean isShapeClipSupported() {
        return this.g.isShapeClipSupported();
    }
}

