/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.models;

import com.codename1.charts.models.CategorySeries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AreaSeries {
    private Map<String, HashMap<Integer, Double>> mTable = new HashMap<String, HashMap<Integer, Double>>();
    private List<String> mCategories = new ArrayList<String>();
    private List<String> mSeries = new ArrayList<String>();

    public synchronized void addSeries(CategorySeries series) {
        int length = series.getItemCount();
        for (int i = 0; i < length; ++i) {
            HashMap<Integer, Double> col;
            String category = series.getCategory(i);
            if (!this.mTable.containsKey(category)) {
                this.mCategories.add(category);
                col = new HashMap();
            } else {
                col = this.mTable.get(category);
            }
            col.put(this.mSeries.size(), series.getValue(i));
            this.mTable.put(category, col);
        }
        this.mSeries.add(series.getTitle());
    }

    public synchronized void clear() {
        this.mTable.clear();
        this.mCategories.clear();
        this.mSeries.clear();
    }

    public synchronized int getCategoriesCount() {
        return this.mCategories.size();
    }

    public synchronized int getSeriesCount() {
        return this.mSeries.size();
    }

    public synchronized String[] getCategories() {
        return this.mCategories.toArray(new String[this.mCategories.size()]);
    }

    public synchronized String[] getSeries() {
        return this.mSeries.toArray(new String[this.mSeries.size()]);
    }

    public synchronized double getValue(int index, String category) {
        if (!this.mTable.containsKey(category)) {
            return 0.0;
        }
        if (!this.mTable.get(category).containsKey(index)) {
            return 0.0;
        }
        return this.mTable.get(category).get(index);
    }
}

