/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.models;

import com.codename1.charts.models.XYSeries;
import java.util.ArrayList;
import java.util.List;

public class CategorySeries {
    private String mTitle;
    private List<String> mCategories = new ArrayList<String>();
    private List<Double> mValues = new ArrayList<Double>();

    public CategorySeries(String title) {
        this.mTitle = title;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public synchronized void add(double value) {
        this.add(this.mCategories.size() + "", value);
    }

    public synchronized void add(String category, double value) {
        this.mCategories.add(category);
        this.mValues.add(value);
    }

    public synchronized void set(int index, String category, double value) {
        this.mCategories.set(index, category);
        this.mValues.set(index, value);
    }

    public synchronized void remove(int index) {
        this.mCategories.remove(index);
        this.mValues.remove(index);
    }

    public synchronized void clear() {
        this.mCategories.clear();
        this.mValues.clear();
    }

    public synchronized double getValue(int index) {
        return this.mValues.get(index);
    }

    public synchronized String getCategory(int index) {
        return this.mCategories.get(index);
    }

    public synchronized int getItemCount() {
        return this.mCategories.size();
    }

    public XYSeries toXYSeries() {
        XYSeries xySeries = new XYSeries(this.mTitle);
        int k = 0;
        for (double value : this.mValues) {
            xySeries.add(++k, value);
        }
        return xySeries;
    }
}

