/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.ads.AdsService;
import com.codename1.io.ConnectionRequest;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Label;
import com.codename1.ui.List;
import com.codename1.ui.TextArea;
import com.codename1.ui.TextField;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.html.AsyncDocumentRequestHandlerImpl;
import com.codename1.ui.html.DocumentInfo;
import com.codename1.ui.html.HTMLCallback;
import com.codename1.ui.html.HTMLComponent;
import com.codename1.ui.html.HTMLElement;
import com.codename1.ui.html.IOCallback;
import com.codename1.ui.layouts.BorderLayout;
import java.util.Vector;

public class Ads
extends Container
implements HTMLCallback {
    private long elapsed;
    private int updateDuration = 60;
    private String ad;
    private AdsService service;
    private boolean refreshAd;
    private String appId;
    private String age;
    private String gender;
    private String category;
    private String location;
    private String[] keywords;

    public Ads() {
        this.setUIID("Ads");
        this.setLayout(new BorderLayout());
        this.setFocusable(!Display.getInstance().isTouchScreenDevice());
        Label filler = new Label(" ");
        filler.setPreferredSize(new Dimension(400, 2));
        filler.getStyle().setBgTransparency(0);
        this.addComponent("Center", (Component)filler);
    }

    public Ads(String appId) {
        this(appId, true);
    }

    public Ads(String appId, boolean refreshAd) {
        this();
        this.appId = appId;
        this.refreshAd = refreshAd;
        this.service = AdsService.createAdsService();
    }

    public void initComponent() {
        if (this.service != null) {
            this.service.initialize(this);
            this.service.addResponseListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String a = (String)evt.getSource();
                    Ads.this.setAd(a);
                }
            });
            if (this.refreshAd) {
                this.getComponentForm().registerAnimated(this);
            } else {
                this.requestAd();
            }
        }
    }

    protected void deinitialize() {
        if (this.refreshAd) {
            this.getComponentForm().deregisterAnimated(this);
        }
    }

    private void requestAd() {
        this.service.requestAd();
    }

    public boolean animate() {
        Form parent = this.getComponentForm();
        if (parent == null || !parent.isVisible()) {
            return false;
        }
        long t = System.currentTimeMillis();
        if (t - this.elapsed > (long)(this.getUpdateDuration() * 1000)) {
            this.elapsed = t;
            this.requestAd();
        }
        return super.animate();
    }

    public void keyReleased(int code) {
        if (Display.getInstance().getGameAction(code) == 8) {
            this.launchAd();
            this.requestAd();
        }
    }

    public void pointerReleased(int x, int y) {
        if (!this.isDragActivated()) {
            this.launchAd();
            this.requestAd();
        }
    }

    private void launchAd() {
        Component c = this.getComponentAt(0);
        if (c instanceof HTMLComponent) {
            HTMLElement e;
            String link;
            HTMLComponent h = (HTMLComponent)c;
            h.setSupressExceptions(true);
            HTMLElement dom = h.getDOM();
            Vector links = dom.getDescendantsByTagName("a");
            if (links.size() > 0 && (link = (e = (HTMLElement)links.elementAt(0)).getAttribute("href")) != null) {
                Display.getInstance().execute(link);
            }
        }
    }

    public String getAd() {
        return this.ad;
    }

    public void setAd(String ad) {
        HTMLComponent html = new HTMLComponent(new AsyncDocumentRequestHandlerImpl(){

            protected ConnectionRequest createConnectionRequest(DocumentInfo docInfo, IOCallback callback, Object[] response) {
                ConnectionRequest req = super.createConnectionRequest(docInfo, callback, response);
                req.setFailSilently(true);
                req.addResponseCodeListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                    }
                });
                return req;
            }
        });
        html.setSupressExceptions(true);
        html.setHTMLCallback(this);
        html.setBodyText("<html><body><div align='center'>" + ad + "</div></body></html>");
        this.replace(this.getComponentAt(0), html, null);
        this.revalidate();
        html.setPageUIID("Container");
        html.getStyle().setBgTransparency(0);
    }

    public int getUpdateDuration() {
        return this.updateDuration;
    }

    public void setUpdateDuration(int updateDuration) {
        this.updateDuration = updateDuration;
    }

    public void titleUpdated(HTMLComponent htmlC, String title) {
    }

    public void pageStatusChanged(HTMLComponent htmlC, int status, String url) {
        if (status == 4) {
            this.unfocus(htmlC);
        } else if (status == 3) {
            this.service.onAdDisplay(htmlC);
        }
    }

    private void unfocus(Container c) {
        c.setFocusable(false);
        c.setFocus(false);
        int s = c.getComponentCount();
        for (int iter = 0; iter < s; ++iter) {
            Component current = c.getComponentAt(iter);
            if (current instanceof Container) {
                this.unfocus((Container)current);
                continue;
            }
            current.setFocusable(false);
            current.setFocus(false);
        }
    }

    public String fieldSubmitted(HTMLComponent htmlC, TextArea ta, String actionURL, String id, String value, int type, String errorMsg) {
        return value;
    }

    public String getAutoComplete(HTMLComponent htmlC, String actionURL, String id) {
        return "";
    }

    public int getLinkProperties(HTMLComponent htmlC, String url) {
        return 0;
    }

    public boolean linkClicked(HTMLComponent htmlC, String url) {
        this.launchAd();
        return false;
    }

    public void actionPerformed(ActionEvent evt, HTMLComponent htmlC, HTMLElement element) {
    }

    public void focusGained(Component cmp, HTMLComponent htmlC, HTMLElement element) {
    }

    public void focusLost(Component cmp, HTMLComponent htmlC, HTMLElement element) {
    }

    public void dataChanged(int type, int index, HTMLComponent htmlC, TextField textField, HTMLElement element) {
    }

    public boolean parsingError(int errorId, String tag, String attribute, String value, String description) {
        return true;
    }

    public void selectionChanged(int oldSelected, int newSelected, HTMLComponent htmlC, List list, HTMLElement element) {
    }

    public void setHeight(int height) {
        float percent = (float)height / (float)Display.getInstance().getDisplayHeight();
        if ((percent *= 100.0f) > 25.0f) {
            this.removeAll();
            Label filler = new Label(" ");
            filler.setPreferredSize(new Dimension(400, 2));
            filler.getStyle().setBgTransparency(0);
            this.addComponent("Center", (Component)filler);
            this.revalidate();
        } else {
            super.setHeight(height);
        }
    }

    public void setAppID(String appId) {
        this.appId = appId;
        if (this.service == null) {
            this.service = AdsService.createAdsService();
            if (this.isInitialized()) {
                this.initComponent();
            }
        }
    }

    public String getAppID() {
        return this.appId;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    public String getAge() {
        return this.age;
    }

    public String getGender() {
        return this.gender;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public void setAge(String age) {
        this.age = age;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public String[] getPropertyNames() {
        return new String[]{"appId", "updateDuration", "age", "gender", "category", "location", "keywords"};
    }

    public Class[] getPropertyTypes() {
        Class<?> c = new String[0].getClass();
        return new Class[]{String.class, Integer.class, String.class, String.class, String.class, String.class, c};
    }

    public String[] getPropertyTypeNames() {
        return new String[]{"String", "int", "String", "String", "String", "String", "String[]"};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("appId")) {
            return this.getAppID();
        }
        if (name.equals("updateDuration")) {
            return new Integer(this.getUpdateDuration());
        }
        if (name.equals("age")) {
            return this.getAge();
        }
        if (name.equals("gender")) {
            return this.getGender();
        }
        if (name.equals("category")) {
            return this.getCategory();
        }
        if (name.equals("location")) {
            return this.getLocation();
        }
        if (name.equals("keywords")) {
            return this.getKeywords();
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("appId")) {
            this.setAppID((String)value);
            return null;
        }
        if (name.equals("updateDuration")) {
            this.setUpdateDuration((Integer)value);
            return null;
        }
        if (name.equals("age")) {
            this.setAge((String)value);
            return null;
        }
        if (name.equals("gender")) {
            this.setGender((String)value);
            return null;
        }
        if (name.equals("category")) {
            this.setCategory((String)value);
            return null;
        }
        if (name.equals("location")) {
            this.setLocation((String)value);
            return null;
        }
        if (name.equals("keywords")) {
            this.setKeywords((String[])value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }
}

