/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.ui.CheckBox;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.animations.Animation;
import com.codename1.ui.animations.Motion;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.ActionSource;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.EventDispatcher;
import java.util.Collection;
import java.util.Vector;

public class OnOffSwitch
extends Container
implements ActionSource {
    private String on = "ON";
    private String off = "OFF";
    private boolean iosMode;
    private boolean noTextMode;
    private boolean value;
    private CheckBox button;
    private boolean dragged;
    private int pressX;
    private int buttonWidth;
    private Image switchOnImage;
    private Image switchOffImage;
    private Image switchMaskImage;
    private int deltaX;
    private EventDispatcher dispatcher = new EventDispatcher();
    private boolean animationLock;

    public OnOffSwitch() {
        this.setUIID("OnOffSwitch");
        this.initialize();
    }

    protected Dimension calcPreferredSize() {
        if (this.iosMode) {
            if (this.switchMaskImage == null) {
                this.switchMaskImage = UIManager.getInstance().getThemeImageConstant("switchMaskImage");
                if (this.switchMaskImage == null) {
                    return super.calcPreferredSize();
                }
            }
            return new Dimension(this.switchMaskImage.getWidth(), this.switchMaskImage.getHeight());
        }
        return super.calcPreferredSize();
    }

    protected void resetFocusable() {
        this.setFocusable(true);
    }

    private void initialize() {
        this.iosMode = UIManager.getInstance().isThemeConstant("onOffIOSModeBool", false);
        this.removeAll();
        this.setFocusable(true);
        if (this.iosMode) {
            this.button = null;
            this.switchMaskImage = UIManager.getInstance().getThemeImageConstant("switchMaskImage");
            this.switchOnImage = UIManager.getInstance().getThemeImageConstant("switchOnImage");
            this.switchOffImage = UIManager.getInstance().getThemeImageConstant("switchOffImage");
            this.noTextMode = UIManager.getInstance().isThemeConstant("noTextModeBool", false);
        } else {
            this.setLayout(new BoxLayout(2));
            this.button = new CheckBox(this.on);
            this.button.setToggle(true);
            this.button.setUIID("Button");
            this.button.setEndsWith3Points(false);
            this.button.getUnselectedStyle().setFont(this.getUnselectedStyle().getFont());
            this.button.getSelectedStyle().setFont(this.getSelectedStyle().getFont());
            this.button.getPressedStyle().setFont(this.getSelectedStyle().getFont());
            Dimension d = this.button.getPreferredSize();
            this.button.setText(this.off);
            int pw = this.button.getPreferredW();
            d.setWidth(Math.max(pw, d.getWidth()));
            this.button.setPreferredSize(d);
            this.buttonWidth = this.button.getPreferredW();
            this.button.setFocusable(false);
            this.updateButton();
            this.addComponent(this.button);
            this.button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    OnOffSwitch.this.flip();
                }
            });
        }
    }

    protected boolean isStickyDrag() {
        return true;
    }

    public void addActionListener(ActionListener l) {
        this.dispatcher.addListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.dispatcher.removeListener(l);
    }

    public Vector getActionListeners() {
        return this.dispatcher.getListenerVector();
    }

    public Collection getListeners() {
        return this.dispatcher.getListenerCollection();
    }

    private void fireActionEvent() {
        this.dispatcher.fireActionEvent(new ActionEvent((Object)this, ActionEvent.Type.PointerPressed));
        Display d = Display.getInstance();
        if (d.isBuiltinSoundsEnabled()) {
            d.playBuiltinSound("press");
        }
    }

    public void paint(Graphics g) {
        if (this.iosMode) {
            int switchButtonPadInt = UIManager.getInstance().getThemeConstant("switchButtonPadInt", 16);
            if (Display.getInstance().getDisplayWidth() > 480) {
                switchButtonPadInt *= 2;
            }
            Style s = this.getStyle();
            int x = this.getX() + s.getPaddingLeftNoRTL();
            int y = this.getY() + s.getPaddingTop();
            if (!this.value) {
                if (this.deltaX > 0) {
                    this.dragged = false;
                } else if (this.deltaX < -this.switchOnImage.getWidth()) {
                    this.deltaX = -this.switchOnImage.getWidth();
                }
            } else if (this.deltaX < 0) {
                this.dragged = false;
            } else if (this.deltaX > this.switchOnImage.getWidth()) {
                this.deltaX = this.switchOnImage.getWidth();
            }
            if (this.dragged) {
                int offX;
                int onX;
                if (this.value) {
                    onX = x - this.deltaX;
                    offX = x - this.deltaX + this.switchOnImage.getWidth() - 2 * switchButtonPadInt;
                } else {
                    onX = x - this.deltaX - this.switchOnImage.getWidth() + 2 * switchButtonPadInt;
                    offX = x - this.deltaX;
                }
                switchButtonPadInt /= 2;
                int oldClipX = g.getClipX();
                int oldClipY = g.getClipY();
                int oldClipW = g.getClipWidth();
                int oldClipH = g.getClipHeight();
                g.clipRect(this.getX(), this.getY(), this.switchMaskImage.getWidth(), this.switchMaskImage.getHeight());
                g.drawImage(this.switchOnImage, onX, y);
                g.drawImage(this.switchOffImage, offX, y);
                int strWidth = s.getFont().stringWidth(this.on);
                int sX = onX + this.switchMaskImage.getWidth() / 2 - strWidth / 2 - switchButtonPadInt;
                int sY = y + this.switchMaskImage.getHeight() / 2 - s.getFont().getHeight() / 2;
                g.setFont(s.getFont());
                g.setColor(0xFFFFFF);
                if (!this.noTextMode) {
                    g.drawString(this.on, sX, sY, 8);
                }
                strWidth = s.getFont().stringWidth(this.off);
                g.setColor(0x333333);
                sX = offX + this.switchMaskImage.getWidth() / 2 - strWidth / 2 + switchButtonPadInt;
                if (!this.noTextMode) {
                    g.drawString(this.off, sX, sY);
                }
                g.setClip(oldClipX, oldClipY, oldClipW, oldClipH);
            } else {
                String str;
                switchButtonPadInt /= 2;
                if (this.value) {
                    g.drawImage(this.switchOnImage, x, y);
                    str = this.on;
                    g.setColor(0xFFFFFF);
                    switchButtonPadInt *= -1;
                } else {
                    g.drawImage(this.switchOffImage, x, y);
                    str = this.off;
                    g.setColor(0x333333);
                }
                int strWidth = s.getFont().stringWidth(str);
                int sX = x + this.switchMaskImage.getWidth() / 2 - strWidth / 2 + switchButtonPadInt;
                int sY = y + this.switchMaskImage.getHeight() / 2 - s.getFont().getHeight() / 2;
                g.setFont(s.getFont());
                if (!this.noTextMode) {
                    g.drawString(str, sX, sY);
                }
            }
            g.drawImage(this.switchMaskImage, x, y);
        } else {
            super.paint(g);
        }
    }

    private void updateButton() {
        if (this.value) {
            this.button.setText(this.on);
            this.getUnselectedStyle().setPadding(1, this.buttonWidth);
            this.getUnselectedStyle().setPadding(3, 0);
            this.getSelectedStyle().setPadding(1, this.buttonWidth);
            this.getSelectedStyle().setPadding(3, 0);
        } else {
            this.button.setText(this.off);
            this.getUnselectedStyle().setPadding(3, this.buttonWidth);
            this.getUnselectedStyle().setPadding(1, 0);
            this.getSelectedStyle().setPadding(3, this.buttonWidth);
            this.getSelectedStyle().setPadding(1, 0);
        }
    }

    private void flip() {
        this.setValue(!this.value);
    }

    protected void initComponent() {
        super.initComponent();
    }

    protected void deinitialize() {
        super.deinitialize();
    }

    public void pointerPressed(int x, int y) {
        if (this.iosMode) {
            super.pointerPressed(x, y);
        }
        this.pressX = x;
    }

    public void pointerDragged(int x, int y) {
        this.dragged = true;
        this.deltaX = this.pressX - x;
        if (!this.iosMode) {
            this.button.setText(this.on);
            int left = Math.max(0, this.buttonWidth - this.deltaX);
            int right = Math.min(this.buttonWidth, this.deltaX);
            if (this.deltaX < 0) {
                left = Math.min(this.buttonWidth, this.deltaX * -1);
                right = Math.max(0, this.buttonWidth + this.deltaX);
            }
            this.getUnselectedStyle().setPadding(3, right);
            this.getUnselectedStyle().setPadding(1, left);
            this.getSelectedStyle().setPadding(3, right);
            this.getSelectedStyle().setPadding(1, left);
            if (right < left) {
                this.button.setText(this.on);
            } else {
                this.button.setText(this.off);
            }
            this.revalidate();
        }
    }

    private void animateTo(final boolean value, int position) {
        int switchButtonPadInt = UIManager.getInstance().getThemeConstant("switchButtonPadInt", 16);
        if (Display.getInstance().getDisplayWidth() > 480) {
            switchButtonPadInt *= 2;
        }
        final Motion current = Motion.createEaseInOutMotion(Math.abs(position), this.switchMaskImage.getWidth() - 2 * switchButtonPadInt, 100);
        current.start();
        this.deltaX = position;
        this.getComponentForm().registerAnimated(new Animation(){

            public boolean animate() {
                OnOffSwitch.this.deltaX = current.getValue();
                if (value) {
                    OnOffSwitch.this.deltaX = OnOffSwitch.this.deltaX * -1;
                }
                OnOffSwitch.this.dragged = true;
                if (current.isFinished()) {
                    OnOffSwitch.this.dragged = false;
                    Form f = OnOffSwitch.this.getComponentForm();
                    if (f != null) {
                        f.deregisterAnimated(this);
                    }
                    OnOffSwitch.this.setValue(value);
                }
                OnOffSwitch.this.repaint();
                return false;
            }

            public void paint(Graphics g) {
            }
        });
        this.dragged = true;
    }

    public void pointerReleased(int x, int y) {
        if (this.animationLock) {
            return;
        }
        this.animationLock = true;
        if (this.iosMode) {
            int switchButtonPadInt = UIManager.getInstance().getThemeConstant("switchButtonPadInt", 16);
            if (this.dragged) {
                if (this.deltaX > 0) {
                    if (this.deltaX > this.switchMaskImage.getWidth() / 2 - switchButtonPadInt) {
                        this.animateTo(false, this.deltaX);
                    } else {
                        this.animateTo(true, this.deltaX);
                    }
                } else if (this.deltaX * -1 > this.switchMaskImage.getWidth() / 2 - switchButtonPadInt) {
                    this.animateTo(true, this.deltaX);
                } else {
                    this.animateTo(false, this.deltaX);
                }
            } else {
                this.animateTo(!this.value, 0);
            }
            this.animationLock = false;
            return;
        }
        if (!this.dragged) {
            this.flip();
        } else {
            int w = this.buttonWidth;
            this.deltaX = this.pressX - x;
            int left = Math.max(0, w - this.deltaX);
            int right = Math.min(w, this.deltaX);
            if (this.deltaX < 0) {
                left = Math.min(this.buttonWidth, this.deltaX * -1);
                right = Math.max(0, this.buttonWidth + this.deltaX);
            }
            if (right < left) {
                this.setValue(true);
            } else {
                this.setValue(false);
            }
            this.updateButton();
            this.animateLayoutAndWait(150);
        }
        this.dragged = false;
        this.animationLock = false;
    }

    public String getOn() {
        return this.on;
    }

    public void setOn(String on) {
        this.on = on;
        this.initialize();
    }

    public String getOff() {
        return this.off;
    }

    public void setOff(String off) {
        this.off = off;
        this.initialize();
    }

    public boolean isValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        boolean fireEvent;
        boolean orig = this.animationLock;
        this.animationLock = true;
        boolean bl = fireEvent = this.value != value;
        if (fireEvent) {
            this.value = value;
            if (this.button != null) {
                this.button.setSelected(value);
            }
            this.fireActionEvent();
            if (this.iosMode) {
                this.repaint();
            } else {
                this.updateButton();
                if (this.isInitialized()) {
                    this.animateLayoutAndWait(150);
                }
            }
        }
        this.animationLock = orig;
    }

    public String[] getPropertyNames() {
        return new String[]{"value", "on", "off"};
    }

    public Object getComponentState() {
        if (this.value) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setComponentState(Object state) {
        this.value = (Boolean)state;
    }

    public Class[] getPropertyTypes() {
        return new Class[]{Boolean.class, String.class, String.class};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("on")) {
            return this.on;
        }
        if (name.equals("off")) {
            return this.off;
        }
        if (name.equals("value")) {
            if (this.value) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("on")) {
            this.setOn((String)value);
            return null;
        }
        if (name.equals("off")) {
            this.setOff((String)value);
            return null;
        }
        if (name.equals("value")) {
            this.setValue((Boolean)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public boolean isNoTextMode() {
        return this.noTextMode;
    }

    public void setNoTextMode(boolean noTextMode) {
        this.noTextMode = noTextMode;
    }

    public Image getSwitchOnImage() {
        if (this.iosMode) {
            return this.switchOnImage;
        }
        return null;
    }

    public void setSwitchOnImage(Image switchOnImage) {
        this.switchOnImage = switchOnImage;
        this.iosMode = true;
    }

    public Image getSwitchOffImage() {
        if (this.iosMode) {
            return this.switchOffImage;
        }
        return null;
    }

    public void setSwitchOffImage(Image switchOffImage) {
        this.switchOffImage = switchOffImage;
        this.iosMode = true;
    }

    public Image getSwitchMaskImage() {
        if (this.iosMode) {
            return this.switchMaskImage;
        }
        return null;
    }

    public void setSwitchMaskImage(Image switchMaskImage) {
        this.switchMaskImage = switchMaskImage;
        this.iosMode = true;
    }
}

