/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.contacts;

import com.codename1.contacts.Contact;
import com.codename1.contacts.ContactsManager;
import com.codename1.ui.Display;
import com.codename1.ui.Image;
import com.codename1.ui.list.DefaultListModel;
import java.util.Hashtable;

public class ContactsModel
extends DefaultListModel {
    private Hashtable contactsCache = new Hashtable();
    private Image placeHolder;

    public ContactsModel(String ... ids) {
        super((Object[])ids);
    }

    public void setPlaceHolderImage(Image placeHolder) {
        this.placeHolder = placeHolder;
    }

    public Object getItemAt(final int index) {
        final String id = (String)super.getItemAt(index);
        Hashtable contact = (Hashtable)this.contactsCache.get(id);
        if (contact == null) {
            Hashtable cnt = this.getContactAsHashtable(null);
            this.contactsCache.put(id, cnt);
            Display.getInstance().scheduleBackgroundTask(new Runnable(){

                public void run() {
                    Contact c = ContactsManager.getContactById(id);
                    Hashtable contact = ContactsModel.this.getContactAsHashtable(c);
                    ContactsModel.this.contactsCache.put(id, contact);
                    Display.getInstance().callSerially(new Runnable(){

                        public void run() {
                            ContactsModel.this.setItem(index, id);
                        }
                    });
                }
            });
            return cnt;
        }
        return contact;
    }

    public void addItem(Object item) {
        if (item instanceof String) {
            super.addItem(item);
        } else if (item instanceof Contact) {
            super.addItem(((Contact)item).getId());
            this.contactsCache.put(((Contact)item).getId(), this.getContactAsHashtable((Contact)item));
        } else if (item instanceof Hashtable) {
            super.addItem(((Hashtable)item).get("id"));
            this.contactsCache.put(((Hashtable)item).get("id"), item);
        }
    }

    public void removeItem(int index) {
        String id = (String)super.getItemAt(index);
        super.removeItem(index);
        this.contactsCache.remove(id);
    }

    private Hashtable getContactAsHashtable(Contact c) {
        String email;
        String phone;
        Image image;
        String displayName;
        String lname;
        String fname;
        Hashtable<String, Contact> table = new Hashtable<String, Contact>();
        String id = null;
        if (c == null) {
            fname = "Loading...";
            lname = "Loading...";
            displayName = "Loading...";
            image = this.placeHolder;
            phone = "Loading...";
            email = "Loading...";
        } else {
            id = c.getId();
            fname = c.getFirstName();
            lname = c.getFamilyName();
            displayName = c.getDisplayName();
            image = c.getPhoto();
            if (image == null) {
                image = this.placeHolder;
            }
            phone = this.getContactPhoneNumber(c);
            email = this.getContactEmail(c);
        }
        this.addAttribute(table, "id", id);
        this.addAttribute(table, "fname", fname);
        this.addAttribute(table, "lname", lname);
        this.addAttribute(table, "displayName", displayName);
        this.addAttribute(table, "icon", image);
        this.addAttribute(table, "phone", phone);
        this.addAttribute(table, "email", email);
        if (c != null) {
            table.put("contact", c);
        }
        return table;
    }

    private void addAttribute(Hashtable table, String key, Object value) {
        if (value == null || key == null) {
            return;
        }
        table.put(key, value);
    }

    private String getContactPhoneNumber(Contact contact) {
        if (contact.getPrimaryPhoneNumber() != null) {
            return contact.getPrimaryPhoneNumber();
        }
        Hashtable phones = contact.getPhoneNumbers();
        if (phones != null && phones.size() > 0) {
            String first = (String)phones.keys().nextElement();
            return (String)phones.get(first);
        }
        return null;
    }

    private String getContactEmail(Contact contact) {
        if (contact.getPrimaryEmail() != null) {
            return contact.getPrimaryEmail();
        }
        Hashtable emails = contact.getEmails();
        if (emails != null && emails.size() > 0) {
            String first = (String)emails.keys().nextElement();
            return (String)emails.get(first);
        }
        return null;
    }
}

