/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.location;

import com.codename1.io.Log;
import com.codename1.location.Geofence;
import com.codename1.location.Location;
import com.codename1.location.LocationListener;
import com.codename1.location.LocationRequest;
import com.codename1.ui.Display;
import java.io.IOException;

public abstract class LocationManager {
    private static LocationListener listener;
    private static LocationRequest request;
    private static Class backgroundlistener;
    public static final int AVAILABLE = 0;
    public static final int OUT_OF_SERVICE = 1;
    public static final int TEMPORARILY_UNAVAILABLE = 2;
    private int status = 2;

    public static LocationManager getLocationManager() {
        return Display.getInstance().getLocationManager();
    }

    public int getStatus() {
        return this.status;
    }

    protected void setStatus(int status) {
        this.status = status;
    }

    public abstract Location getCurrentLocation() throws IOException;

    public Location getCurrentLocationSync() {
        return this.getCurrentLocationSync(-1L);
    }

    public Location getCurrentLocationSync(long timeout) {
        try {
            if (this.getStatus() != 0) {
                LL l = new LL();
                l.timeout = timeout;
                l.bind();
                return l.result;
            }
            return this.getCurrentLocation();
        }
        catch (IOException err) {
            Log.e(err);
            return null;
        }
    }

    public abstract Location getLastKnownLocation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocationListener(LocationListener l) {
        LocationManager locationManager = this;
        synchronized (locationManager) {
            if (listener != null) {
                this.clearListener();
                request = null;
                this.status = 2;
            }
            listener = l;
            if (l == null) {
                return;
            }
            this.bindListener();
        }
    }

    public void setLocationListener(LocationListener l, LocationRequest req) {
        this.setLocationListener(l);
        request = req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackgroundLocationListener(Class locationListener) {
        LocationManager locationManager = this;
        synchronized (locationManager) {
            if (backgroundlistener != null) {
                this.clearBackgroundListener();
            }
            backgroundlistener = locationListener;
            if (locationListener == null) {
                return;
            }
            this.bindBackgroundListener();
        }
    }

    public void addGeoFencing(Class GeofenceListenerClass, Geofence gf) {
    }

    public void removeGeoFencing(String id) {
    }

    protected LocationListener getLocationListener() {
        return listener;
    }

    protected LocationRequest getRequest() {
        return request;
    }

    protected Class getBackgroundLocationListener() {
        return backgroundlistener;
    }

    protected abstract void bindListener();

    protected abstract void clearListener();

    protected void bindBackgroundListener() {
    }

    protected void clearBackgroundListener() {
    }

    public boolean isGPSDetectionSupported() {
        return false;
    }

    public boolean isBackgroundLocationSupported() {
        return false;
    }

    public boolean isGeofenceSupported() {
        return false;
    }

    public boolean isGPSEnabled() {
        throw new RuntimeException("GPS Detection is not supported");
    }

    class LL
    implements Runnable,
    LocationListener {
        Location result;
        boolean finished;
        long timeout;

        LL() {
        }

        public void bind() {
            LocationManager.this.setLocationListener(this);
            Display.getInstance().invokeAndBlock(this);
        }

        public void locationUpdated(Location location) {
            this.result = location;
            this.finished = true;
            LocationManager.this.setLocationListener(null);
        }

        public void providerStateChanged(int newState) {
            if (newState == 0) {
                try {
                    this.result = LocationManager.this.getCurrentLocation();
                }
                catch (IOException err) {
                    Log.e(err);
                    this.result = null;
                }
            } else {
                this.result = null;
            }
            this.finished = true;
            LocationManager.this.setLocationListener(null);
        }

        public void run() {
            long start = System.currentTimeMillis();
            while (!this.finished) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.timeout <= -1L || System.currentTimeMillis() - start <= this.timeout) continue;
                break;
            }
        }
    }
}

