/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.media;

import com.codename1.io.Log;
import com.codename1.media.Media;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.util.AsyncResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface AsyncMedia
extends Media {
    public State getState();

    public void addMediaStateChangeListener(ActionListener<MediaStateChangeEvent> var1);

    public void removeMediaStateChangeListener(ActionListener<MediaStateChangeEvent> var1);

    public void addMediaErrorListener(ActionListener<MediaErrorEvent> var1);

    public void removeMediaErrorListener(ActionListener<MediaErrorEvent> var1);

    public void addMediaCompletionHandler(Runnable var1);

    public PlayRequest playAsync();

    public PauseRequest pauseAsync();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PauseRequest
    extends AsyncResource<AsyncMedia> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PlayRequest
    extends AsyncResource<AsyncMedia> {
    }

    public static class MediaErrorEvent
    extends ActionEvent {
        private MediaException mediaException;

        public MediaErrorEvent(Media source, MediaException error) {
            super(source);
            this.mediaException = error;
        }

        public MediaException getMediaException() {
            return this.mediaException;
        }
    }

    public static class MediaException
    extends RuntimeException {
        private MediaErrorType mediaErrorType;

        public MediaException(MediaErrorType type) {
            super(type.description);
            this.mediaErrorType = type;
        }

        public MediaException(MediaErrorType type, String message) {
            super(message);
            this.mediaErrorType = type;
        }

        public MediaException(MediaErrorType type, Throwable cause) {
            super(cause.getMessage());
            Log.e(cause);
            this.mediaErrorType = type;
        }

        public MediaErrorType getMediaErrorType() {
            return this.mediaErrorType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MediaErrorType {
        Aborted("The fetching of the associated resource was aborted by the user's request"),
        Network("Some kind of network error occurred which prevented the media from being successfully fetched, despite having previously been available."),
        Decode("Despite having previously been determined to be usable, an error occurred while trying to decode the media resource, resulting in an error."),
        Encode("Failed to encode media to given type"),
        SrcNotSupported("The associated resource has been found to be unsuitable."),
        Unknown("Unknown error"),
        LineUnavailable("The associated input line is unavailable");

        private String description;

        private MediaErrorType(String description) {
            this.description = description;
        }
    }

    public static class MediaStateChangeEvent
    extends ActionEvent {
        private State oldState;
        private State newState;

        public State getOldState() {
            return this.oldState;
        }

        public State getNewState() {
            return this.newState;
        }

        public MediaStateChangeEvent(AsyncMedia source, State oldState, State newState) {
            super(source);
            this.oldState = oldState;
            this.newState = newState;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        Playing,
        Paused;

    }
}

