/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.testing;

import com.codename1.io.Log;
import com.codename1.testing.UnitTest;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class TestReporting {
    private static TestReporting instance;
    private Hashtable testsExecuted = new Hashtable();

    public static TestReporting getInstance() {
        if (instance == null) {
            instance = new TestReporting();
        }
        return instance;
    }

    public static void setInstance(TestReporting i) {
        instance = i;
    }

    public void startingTestCase(UnitTest test) {
        Log.p("Starting test case " + test.getClass().getName());
    }

    public void logMessage(String message) {
        Log.p(message);
    }

    public void logException(Throwable err) {
        Log.e(err);
    }

    public void finishedTestCase(UnitTest test, boolean passed) {
        if (passed) {
            Log.p(test.getClass().getName() + " passed");
            this.testsExecuted.put(test.getClass().getName(), Boolean.TRUE);
        } else {
            Log.p(test.getClass().getName() + " failed");
            this.testsExecuted.put(test.getClass().getName(), Boolean.FALSE);
        }
    }

    public void writeReport(OutputStream os) throws IOException {
        Enumeration e = this.testsExecuted.elements();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Boolean v = (Boolean)this.testsExecuted.get(key);
            if (v.booleanValue()) {
                os.write((key + " passed\n").getBytes());
                continue;
            }
            os.write((key + " failed\n").getBytes());
        }
    }

    public void testExecutionFinished() {
    }
}

