/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.Button;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.FontImage;
import com.codename1.ui.Form;
import com.codename1.ui.Image;
import com.codename1.ui.List;
import com.codename1.ui.animations.CommonTransitions;
import com.codename1.ui.animations.Transition;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.FlowLayout;
import com.codename1.ui.layouts.GridLayout;
import com.codename1.ui.list.ListCellRenderer;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.LookAndFeel;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import java.util.Vector;

public class MenuBar
extends Container
implements ActionListener {
    private boolean minimizeOnBack = true;
    private Command selectCommand;
    private Command defaultCommand;
    private Command backCommand;
    private Command clearCommand;
    static int leftSK;
    static int rightSK;
    static int rightSK2;
    static int backSK;
    static int clearSK;
    static int backspaceSK;
    private Command menuCommand;
    private Vector commands = new Vector();
    private Button[] soft;
    private Command[] softCommand;
    private Button left;
    private Button right;
    private Button main;
    private ListCellRenderer menuCellRenderer;
    private Transition transitionIn;
    private Transition transitionOut;
    private Component commandList;
    private Style menuStyle;
    private Command selectMenuItem;
    private Command cancelMenuItem;
    private Form parent;
    private boolean thirdSoftButton;
    private boolean hideEmptyCommands;
    private boolean menuDisplaying;

    private int componentCountOffset(Container c) {
        Container t;
        if (this.getUIManager().isThemeConstant("paintsTitleBarBool", false) && (t = this.getTitleAreaContainer()) == c && ((BorderLayout)t.getLayout()).getNorth() != null) {
            return 1;
        }
        return 0;
    }

    protected void initMenuBar(Form parent) {
        this.parent = parent;
        this.selectMenuItem = this.createMenuSelectCommand();
        this.cancelMenuItem = this.createMenuCancelCommand();
        UIManager manager = parent.getUIManager();
        LookAndFeel lf = manager.getLookAndFeel();
        this.minimizeOnBack = manager.isThemeConstant("minimizeOnBackBool", true) && !(parent instanceof Dialog);
        this.hideEmptyCommands = manager.isThemeConstant("hideEmptyCommandsBool", false);
        this.menuStyle = manager.getComponentStyle("Menu");
        this.setUIID("SoftButton");
        this.menuCommand = new Command(manager.localize("menu", "Menu"), lf.getMenuIcons()[2]);
        if (lf.getDefaultMenuTransitionIn() != null || lf.getDefaultMenuTransitionOut() != null) {
            this.transitionIn = lf.getDefaultMenuTransitionIn();
            this.transitionOut = lf.getDefaultMenuTransitionOut();
        } else {
            this.transitionIn = CommonTransitions.createSlide(1, true, 300, true);
            this.transitionOut = CommonTransitions.createSlide(1, false, 300, true);
        }
        this.menuCellRenderer = lf.getMenuRenderer();
        int softkeyCount = Display.getInstance().getImplementation().getSoftkeyCount();
        this.thirdSoftButton = Display.getInstance().isThirdSoftButton();
        int commandBehavior = this.getCommandBehavior();
        if (softkeyCount > 1 && commandBehavior < 4) {
            Button b;
            if (this.thirdSoftButton) {
                this.setLayout(new GridLayout(1, 3));
                this.soft = new Button[]{this.createSoftButton("SoftButtonCenter"), this.createSoftButton("SoftButtonLeft"), this.createSoftButton("SoftButtonRight")};
                this.main = this.soft[0];
                this.left = this.soft[1];
                this.right = this.soft[2];
                if (parent.isRTL()) {
                    this.right.setUIID("SoftButtonLeft");
                    this.left.setUIID("SoftButtonRight");
                    this.addComponent(this.right);
                    this.addComponent(this.main);
                    this.addComponent(this.left);
                } else {
                    this.addComponent(this.left);
                    this.addComponent(this.main);
                    this.addComponent(this.right);
                }
                if (this.isReverseSoftButtons()) {
                    b = this.soft[1];
                    this.soft[1] = this.soft[2];
                    this.soft[2] = b;
                }
            } else {
                this.setLayout(new GridLayout(1, 2));
                this.soft = new Button[]{this.createSoftButton("SoftButtonLeft"), this.createSoftButton("SoftButtonRight")};
                this.main = this.soft[0];
                this.left = this.soft[0];
                this.right = this.soft[1];
                if (parent.isRTL()) {
                    this.right.setUIID("SoftButtonLeft");
                    this.left.setUIID("SoftButtonRight");
                    this.addComponent(this.right);
                    this.addComponent(this.left);
                } else {
                    this.addComponent(this.left);
                    this.addComponent(this.right);
                }
                if (this.isReverseSoftButtons()) {
                    b = this.soft[0];
                    this.soft[0] = this.soft[1];
                    this.soft[1] = b;
                }
            }
            for (int iter = 0; iter < this.soft.length; ++iter) {
                this.soft[iter].setEndsWith3Points(false);
            }
        } else if (this.thirdSoftButton) {
            this.setLayout(new GridLayout(1, 3));
            this.soft = new Button[]{this.createSoftButton("SoftButtonCenter"), this.createSoftButton("SoftButtonLeft"), this.createSoftButton("SoftButtonRight")};
            this.main = this.soft[0];
            this.left = this.soft[1];
            this.right = this.soft[2];
            this.addComponent(this.left);
            this.addComponent(this.main);
            this.addComponent(this.right);
            if (this.isReverseSoftButtons()) {
                Button b = this.soft[1];
                this.soft[1] = this.soft[2];
                this.soft[2] = b;
            }
        } else {
            this.soft = new Button[]{this.createSoftButton("SoftButtonCenter")};
        }
        this.softCommand = new Command[this.soft.length];
    }

    public void removeEmptySoftbuttons() {
        if (this.left != null && this.left.getParent() != null && "".equals(this.left.getText())) {
            this.left.getParent().removeComponent(this.left);
            this.revalidate();
        }
        if (this.right != null && this.right.getParent() != null && "".equals(this.right.getText())) {
            this.right.getParent().removeComponent(this.right);
            this.revalidate();
        }
    }

    public int getCommandBehavior() {
        int i = Display.getInstance().getCommandBehavior();
        if (Display.getInstance().getImplementation().getSoftkeyCount() == 0) {
            if (i != 4 && i != 5 && i != 6 && i != 7) {
                return 5;
            }
            return i;
        }
        if (i == 1) {
            if (Display.getInstance().isTouchScreenDevice()) {
                return 3;
            }
            return 2;
        }
        return i;
    }

    public void setDefaultCommand(Command defaultCommand) {
        this.defaultCommand = defaultCommand;
    }

    public Command getDefaultCommand() {
        if (this.selectCommand != null) {
            return this.selectCommand;
        }
        return this.defaultCommand;
    }

    public void setClearCommand(Command clearCommand) {
        this.clearCommand = clearCommand;
    }

    public Command getClearCommand() {
        return this.clearCommand;
    }

    public Button findCommandComponent(Command c) {
        Button b = this.findCommandComponent(c, this);
        if (b == null) {
            return this.findCommandComponent(c, this.getTitleAreaContainer());
        }
        return b;
    }

    private Button findCommandComponent(Command c, Container cnt) {
        int count = cnt.getComponentCount();
        for (int iter = 0; iter < count; ++iter) {
            Button b;
            Component current = cnt.getComponentAt(iter);
            if (!(current instanceof Button ? (b = (Button)current).getCommand() == c : current instanceof Container && (b = this.findCommandComponent(c, (Container)current)) != null)) continue;
            return b;
        }
        return null;
    }

    void adaptTitleLayoutBackCommandStructure() {
        Container t = this.getTitleAreaContainer();
        if (t.getComponentCount() - this.componentCountOffset(t) == 3) {
            return;
        }
        BorderLayout titleLayout = (BorderLayout)t.getLayout();
        if (7 == this.getCommandBehavior()) {
            titleLayout.setCenterBehavior(0);
            this.getTitleComponent().getUnselectedStyle().setAlignment(1, true);
        } else {
            titleLayout.setCenterBehavior(2);
        }
        t.removeAll();
        t.addComponent("Center", this.getTitleComponent());
        Container leftContainer = new Container(new BoxLayout(1));
        Container rightContainer = new Container(new BoxLayout(1));
        t.addComponent("East", (Component)rightContainer);
        t.addComponent("West", (Component)leftContainer);
        this.initTitleBarStatus();
    }

    private Container findLeftTitleContainer() {
        Component cmp = ((BorderLayout)this.getTitleAreaContainer().getLayout()).getWest();
        if (cmp instanceof Container) {
            return (Container)cmp;
        }
        return null;
    }

    private Container findRightTitleContainer() {
        return (Container)((BorderLayout)this.getTitleAreaContainer().getLayout()).getEast();
    }

    private void updateTitleCommandPlacement() {
        int commandBehavior = this.getCommandBehavior();
        Container t = this.getTitleAreaContainer();
        BorderLayout titleLayout = (BorderLayout)t.getLayout();
        if (this.getParent() == null) {
            this.installMenuBar();
        } else if (this.getParent() == this.getTitleAreaContainer() && commandBehavior != 6 && commandBehavior != 7) {
            this.getParent().removeComponent(this);
            this.installMenuBar();
        }
        if (!(this.parent instanceof Dialog)) {
            if ((commandBehavior == 7 || commandBehavior == 8 || commandBehavior == 5) && this.parent.getTitle() != null && this.parent.getTitle().length() > 0) {
                this.synchronizeCommandsWithButtonsInBackbutton();
                return;
            }
            if (commandBehavior == 6 || commandBehavior == 5) {
                if (this.getParent() != null) {
                    if (this.getParent() == this.getTitleAreaContainer()) {
                        return;
                    }
                    this.getParent().removeComponent(this);
                }
                return;
            }
        }
        if (t.getComponentCount() - this.componentCountOffset(t) > 1) {
            if (7 == this.getCommandBehavior()) {
                titleLayout.setCenterBehavior(0);
            } else {
                titleLayout.setCenterBehavior(2);
            }
            Component l = this.getTitleComponent();
            if (l.getParent() != null) {
                l.getParent().removeComponent(l);
            }
            t.removeAll();
            t.addComponent("Center", l);
            this.initTitleBarStatus();
        }
    }

    public void setBackCommand(Command backCommand) {
        int i;
        int b;
        this.backCommand = backCommand;
        if (this.parent.getToolbar() != null) {
            return;
        }
        if (backCommand != null && UIManager.getInstance().isThemeConstant("hideBackCommandBool", false)) {
            this.removeCommand(backCommand);
        }
        if (((b = this.getCommandBehavior()) == 5 || b == 7 || Display.getInstance().isNativeTitle()) && (i = this.commands.indexOf(backCommand)) > -1) {
            this.commands.removeElementAt(i);
        }
        this.updateTitleCommandPlacement();
    }

    public Command getBackCommand() {
        return this.backCommand;
    }

    public Command getSelectCommand() {
        return this.selectCommand;
    }

    public void setSelectCommand(Command selectCommand) {
        this.selectCommand = selectCommand;
    }

    private void updateCommands() {
        int commandBehavior = this.getCommandBehavior();
        if (commandBehavior == 10) {
            Display.getInstance().getImplementation().setNativeCommands(this.commands);
            return;
        }
        if (commandBehavior >= 4) {
            return;
        }
        if (this.soft.length > 1) {
            this.soft[0].setText("");
            this.soft[1].setText("");
            this.soft[0].setIcon(null);
            this.soft[1].setIcon(null);
            int commandSize = this.getCommandCount();
            if (this.soft.length > 2) {
                this.soft[2].setText("");
                if (commandSize > 2) {
                    this.softCommand[2] = commandSize > 3 ? this.menuCommand : this.getCommand(this.getCommandCount() - 3);
                    this.soft[2].setText(this.softCommand[2].getCommandName());
                    this.soft[2].setIcon(this.softCommand[2].getIcon());
                } else {
                    this.softCommand[2] = null;
                }
            }
            if (commandSize > 0) {
                this.softCommand[0] = this.getCommand(this.getCommandCount() - 1);
                this.soft[0].setText(this.softCommand[0].getCommandName());
                this.soft[0].setIcon(this.softCommand[0].getIcon());
                if (commandSize > 1) {
                    this.softCommand[1] = this.soft.length == 2 && commandSize > 2 ? this.menuCommand : this.getCommand(this.getCommandCount() - 2);
                    this.soft[1].setText(this.softCommand[1].getCommandName());
                    this.soft[1].setIcon(this.softCommand[1].getIcon());
                } else {
                    this.softCommand[1] = null;
                }
            } else {
                this.softCommand[0] = null;
                this.softCommand[1] = null;
            }
            if (commandSize == 1 && this.parent.isVisible()) {
                this.parent.revalidate();
            }
            this.repaint();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.isConsumed()) {
            return;
        }
        Object src = evt.getSource();
        if (this.commandList == null) {
            Button source = (Button)src;
            for (int iter = 0; iter < this.soft.length; ++iter) {
                if (source != this.soft[iter]) continue;
                if (this.softCommand[iter] == this.menuCommand) {
                    this.showMenu();
                    return;
                }
                if (this.softCommand[iter] != null) {
                    ActionEvent e = new ActionEvent((Object)this.softCommand[iter], ActionEvent.Type.Command);
                    this.softCommand[iter].actionPerformed(e);
                    if (!e.isConsumed()) {
                        this.parent.actionCommandImpl(this.softCommand[iter]);
                    }
                }
                return;
            }
        } else {
            Command c;
            if (src instanceof Button) {
                for (int iter = 0; iter < this.soft.length; ++iter) {
                    if (src != this.soft[iter]) continue;
                    for (Container parent = this.commandList.getParent(); parent != null; parent = parent.getParent()) {
                        if (!(parent instanceof Dialog)) continue;
                        ((Dialog)parent).actionCommand(this.softCommand[iter]);
                        return;
                    }
                }
            }
            if (!(c = this.getComponentSelectedCommand(this.commandList)).isEnabled()) {
                return;
            }
            for (Container p = this.commandList.getParent(); p != null; p = p.getParent()) {
                if (!(p instanceof Dialog)) continue;
                ((Dialog)p).actionCommand(c);
                return;
            }
        }
    }

    protected Button createSoftButton(String uiid) {
        Button b = new Button();
        b.setUIID(uiid);
        b.addActionListener((ActionListener)this);
        b.setFocusable(false);
        b.setTactileTouch(true);
        this.updateSoftButtonStyle(b);
        return b;
    }

    private void updateSoftButtonStyle(Button b) {
        int softkeyCount = Display.getInstance().getImplementation().getSoftkeyCount();
        if (softkeyCount < 2) {
            b.getStyle().setMargin(0, 0, 0, 0);
            b.getStyle().setPadding(0, 0, 0, 0);
        }
    }

    public void setUnselectedStyle(Style style) {
        style.setMargin(0, 0, true);
        style.setMargin(2, 0, true);
        super.setUnselectedStyle(style);
        if (this.soft != null) {
            for (int iter = 0; iter < this.soft.length; ++iter) {
                this.updateSoftButtonStyle(this.soft[iter]);
            }
        }
    }

    protected Dimension calcPreferredSize() {
        if (this.soft.length > 1) {
            Dimension d = super.calcPreferredSize();
            if (!(this.soft[0].getText() != null && !this.soft[0].getText().equals("") || this.soft[1].getText() != null && !this.soft[1].getText().equals("") || this.soft[0].getIcon() != null || this.soft[1].getIcon() != null || this.soft.length >= 3 && (this.soft[2].getText() != null && !this.soft[2].getText().equals("") || this.soft[2].getIcon() != null))) {
                d.setHeight(0);
            }
            return d;
        }
        return super.calcPreferredSize();
    }

    public void setTransitions(Transition transitionIn, Transition transitionOut) {
        this.transitionIn = transitionIn;
        this.transitionOut = transitionOut;
    }

    public boolean isMenuShowing() {
        return this.menuDisplaying;
    }

    public void showMenu() {
        Form upcoming;
        final Dialog d = new Dialog("Menu", "");
        d.setDisposeWhenPointerOutOfBounds(true);
        d.setMenu(true);
        d.addOrientationListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                d.dispose();
            }
        });
        d.setTransitionInAnimator(this.transitionIn);
        d.setTransitionOutAnimator(this.transitionOut);
        d.setLayout(new BorderLayout());
        d.setScrollable(false);
        d.getMenuBar().commandList = this.createCommandComponent(this.commands);
        if (this.menuCellRenderer != null && d.getMenuBar().commandList instanceof List) {
            ((List)d.getMenuBar().commandList).setListCellRenderer(this.menuCellRenderer);
        }
        d.getContentPane().getStyle().setMargin(0, 0, 0, 0);
        d.addComponent("Center", d.getMenuBar().commandList);
        if (this.thirdSoftButton) {
            d.addCommand(this.selectMenuItem);
            d.addCommand(this.cancelMenuItem);
        } else {
            d.addCommand(this.cancelMenuItem);
            if (this.soft.length > 1) {
                d.addCommand(this.selectMenuItem);
            }
        }
        d.setClearCommand(this.cancelMenuItem);
        d.setBackCommand(this.cancelMenuItem);
        if (d.getMenuBar().commandList instanceof List) {
            ((List)d.getMenuBar().commandList).addActionListener((ActionListener)d.getMenuBar());
        }
        this.menuDisplaying = true;
        Command result = this.showMenuDialog(d);
        this.menuDisplaying = false;
        if (result != this.cancelMenuItem) {
            Command c = null;
            if (result == this.selectMenuItem) {
                c = this.getComponentSelectedCommand(d.getMenuBar().commandList);
                if (c != null) {
                    ActionEvent e = new ActionEvent((Object)c, ActionEvent.Type.Command);
                    c.actionPerformed(e);
                }
            } else {
                c = result;
                if (!this.isTouchMenus() && (c = result) != null) {
                    ActionEvent e = new ActionEvent((Object)c, ActionEvent.Type.Command);
                    c.actionPerformed(e);
                }
            }
            if (c != null) {
                this.parent.actionCommandImpl(c);
            }
        }
        if (d.getMenuBar().commandList instanceof List) {
            ((List)d.getMenuBar().commandList).removeActionListener((ActionListener)d.getMenuBar());
        }
        if ((upcoming = Display.getInstance().getCurrentUpcoming()) == this.parent) {
            d.disposeImpl();
        } else {
            this.parent.tint = upcoming instanceof Dialog;
        }
    }

    Button[] getSoftButtons() {
        return this.soft;
    }

    private void updateBackBorderToRTL(Style s) {
        Border b = s.getBorder();
        if (b != null) {
            b = b.mirrorBorder();
            s.setBorder(b);
        }
    }

    void verifyBackCommandRTL(Button bg) {
        if (this.getCommandBehavior() == 5 && this.isRTL() && bg.getClientProperty("$cn1BackRTL") == null) {
            bg.putClientProperty("$cn1BackRTL", Boolean.TRUE);
            this.updateBackBorderToRTL(bg.getUnselectedStyle());
            this.updateBackBorderToRTL(bg.getSelectedStyle());
            this.updateBackBorderToRTL(bg.getPressedStyle());
        }
    }

    private void addTwoTitleButtons(Container leftContainer, Container rightContainer) {
        this.ensureCommandsInContainer(this.getCommand(0), null, rightContainer, "TitleCommand", null);
        if (this.parent.getBackCommand() != null) {
            this.ensureCommandsInContainer(this.parent.getBackCommand(), null, leftContainer, "BackCommand", null);
            this.updateGridCommands(1);
        } else {
            if (this.getCommandBehavior() == 7) {
                this.ensureCommandsInContainer(this.getCommand(1), null, rightContainer, "TitleCommand", null);
            } else {
                this.ensureCommandsInContainer(this.getCommand(1), null, leftContainer, "TitleCommand", null);
            }
            this.updateGridCommands(2);
        }
    }

    private void updateGridCommands(int startOffset) {
        int cmdCount = this.getCommandCount() - startOffset;
        if (cmdCount <= 0 || this.getCommandBehavior() == 7) {
            return;
        }
        this.setLayout(new GridLayout(1, cmdCount));
        while (cmdCount < this.getComponentCount()) {
            this.removeComponent(this.getComponentAt(this.getComponentCount() - 1));
        }
        int off = startOffset;
        while (this.getComponentCount() < cmdCount) {
            Button btn = new Button(this.getCommand(off));
            btn.setUIID("TouchCommand");
            ++off;
            this.addComponent(btn);
        }
        for (int iter = 0; iter < cmdCount; ++iter) {
            Button btn = (Button)this.getComponentAt(iter);
            if (btn.getCommand() == this.getCommand(iter + startOffset)) continue;
            btn.setCommand(this.getCommand(iter + startOffset));
        }
    }

    protected Button createBackCommandButton() {
        Button back = new Button(this.parent.getBackCommand());
        if (this.getCommandBehavior() == 7) {
            back.setText("<");
            back.setIcon(null);
        }
        return back;
    }

    void synchronizeCommandsWithButtonsInBackbutton() {
        this.adaptTitleLayoutBackCommandStructure();
        Container leftContainer = this.findLeftTitleContainer();
        if (leftContainer == null && this.getCommandBehavior() == 8) {
            return;
        }
        Container rightContainer = this.findRightTitleContainer();
        int componentCount = this.getCommandCount();
        if (this.parent.getBackCommand() != null && (!UIManager.getInstance().isThemeConstant("hideBackCommandBool", false) || UIManager.getInstance().isThemeConstant("showBackCommandOnTitleBool", false))) {
            if (leftContainer.getComponentCount() - this.componentCountOffset(leftContainer) <= 0) {
                Button back = this.createBackCommandButton();
                leftContainer.addComponent(back);
                if (!back.getUIID().startsWith("BackCommand")) {
                    back.setUIID("BackCommand");
                }
                this.hideEmptyCommand(back);
                this.verifyBackCommandRTL(back);
            } else {
                Button b = (Button)leftContainer.getComponentAt(0);
                if (b.getCommand() != this.parent.getBackCommand()) {
                    b.setCommand(this.parent.getBackCommand());
                    if (!b.getUIID().startsWith("BackCommand")) {
                        b.setUIID("BackCommand");
                    }
                    this.verifyBackCommandRTL(b);
                    this.hideEmptyCommand(b);
                }
            }
            ++componentCount;
        }
        switch (componentCount) {
            case 0: {
                leftContainer.removeAll();
                rightContainer.removeAll();
                this.removeAll();
                this.initTitleBarStatus();
                break;
            }
            case 1: {
                if (this.parent.getBackCommand() != null) {
                    rightContainer.removeAll();
                    this.ensureCommandsInContainer(this.parent.getBackCommand(), null, leftContainer, "BackCommand", null);
                } else {
                    leftContainer.removeAll();
                    this.ensureCommandsInContainer(this.getCommand(0), null, rightContainer, "TitleCommand", null);
                }
                if (this.getCommandBehavior() == 7) break;
                this.removeAll();
                this.initTitleBarStatus();
                break;
            }
            case 2: {
                this.addTwoTitleButtons(leftContainer, rightContainer);
                break;
            }
            case 3: {
                if (Display.getInstance().isTablet()) {
                    if (this.parent.getBackCommand() != null) {
                        this.ensureCommandsInContainer(this.parent.getBackCommand(), null, leftContainer, "BackCommand", null);
                    }
                    if (this.getCommandBehavior() != 7) {
                        this.removeAll();
                        this.initTitleBarStatus();
                    }
                } else {
                    this.addTwoTitleButtons(leftContainer, rightContainer);
                    break;
                }
            }
            default: {
                if (this.getCommandBehavior() == 7) {
                    rightContainer.removeAll();
                    Image i = UIManager.getInstance().getThemeImageConstant("menuImage");
                    if (i == null) {
                        i = FontImage.createMaterial('\ue5d4', this.getUIManager().getComponentStyle("TouchCommand"));
                    }
                    Button menu = this.createTouchCommandButton(new Command("", i){

                        public void actionPerformed(ActionEvent ev) {
                            MenuBar.this.showMenu();
                        }
                    });
                    rightContainer.addComponent(menu);
                    rightContainer.revalidate();
                    break;
                }
                if (Display.getInstance().isTablet()) {
                    this.ensureCommandsInContainer(this.getCommand(0), this.getCommand(2), rightContainer, "TitleCommand", "TitleCommand");
                    if (this.parent.getBackCommand() != null) {
                        this.ensureCommandsInContainer(this.parent.getBackCommand(), this.getCommand(1), leftContainer, "BackCommand", "TitleCommand");
                        this.updateGridCommands(3);
                        break;
                    }
                    this.ensureCommandsInContainer(this.getCommand(1), this.getCommand(3), leftContainer, "TitleCommand", "TitleCommand");
                    this.updateGridCommands(4);
                    break;
                }
                this.addTwoTitleButtons(leftContainer, rightContainer);
            }
        }
    }

    void hideEmptyCommand(Button b) {
        if (this.hideEmptyCommands && (b.getText() == null || b.getText().length() == 0)) {
            b.setUIID("Container");
        }
    }

    private void ensureCommandsInContainer(Command a, Command b, Container c, String styleA, String styleB) {
        if (c.getComponentCount() - this.componentCountOffset(c) == 0) {
            Button btn = new Button(a);
            if (!btn.getUIID().startsWith(styleA)) {
                btn.setUIID(styleA);
            }
            c.addComponent(btn);
            if (b != null) {
                btn = new Button(b);
                if (!btn.getUIID().equals(styleB)) {
                    btn.setUIID(styleB);
                }
                c.addComponent(btn);
            }
            this.hideEmptyCommand(btn);
            return;
        }
        if (c.getComponentCount() - this.componentCountOffset(c) == 1) {
            Button btn = (Button)c.getComponentAt(0);
            if (!btn.getUIID().equals(styleA)) {
                btn.setUIID(styleA);
            }
            if (btn.getCommand() != a) {
                btn.setCommand(a);
            }
            if (b != null) {
                btn = new Button(b);
                if (!btn.getUIID().equals(styleB)) {
                    btn.setUIID(styleB);
                }
                c.addComponent(btn);
            }
            this.hideEmptyCommand(btn);
            return;
        }
        if (c.getComponentCount() - this.componentCountOffset(c) == 2) {
            Button btn = (Button)c.getComponentAt(0);
            if (!btn.getUIID().equals(styleA)) {
                btn.setUIID(styleA);
            }
            if (btn.getCommand() != a) {
                btn.setCommand(a);
            }
            this.hideEmptyCommand(btn);
            if (b != null) {
                btn = (Button)c.getComponentAt(1);
                if (!btn.getUIID().equals(styleB)) {
                    btn.setUIID(styleB);
                }
                if (btn.getCommand() != b) {
                    btn.setCommand(b);
                }
                this.hideEmptyCommand(btn);
            } else {
                c.removeComponent(c.getComponentAt(1));
            }
            return;
        }
    }

    public void addCommand(Command cmd) {
        int behavior;
        if (this.commands.contains(cmd)) {
            return;
        }
        if (this.getBackCommand() == cmd && UIManager.getInstance().isThemeConstant("hideBackCommandBool", false)) {
            return;
        }
        if (this.soft.length > 2 && cmd == this.parent.getDefaultCommand()) {
            this.commands.addElement(cmd);
        } else {
            this.commands.insertElementAt(cmd, 0);
        }
        if (!(this.parent instanceof Dialog || (behavior = this.getCommandBehavior()) != 4 && behavior != 5 && behavior != 6 && behavior != 7)) {
            if (behavior == 5 && (cmd == this.parent.getBackCommand() || this.findCommandComponent(cmd) != null)) {
                return;
            }
            if (this.parent.getBackCommand() != cmd) {
                if ((behavior == 5 || behavior == 7 || behavior == 8) && this.parent.getTitle() != null && this.parent.getTitle().length() > 0) {
                    this.synchronizeCommandsWithButtonsInBackbutton();
                    return;
                }
                this.setLayout(new GridLayout(1, this.getCommandCount()));
                this.addComponent(this.createTouchCommandButton(cmd));
            } else {
                this.commands.removeElement(cmd);
            }
            return;
        }
        this.updateCommands();
    }

    public Command getCommand(int index) {
        if (index < 0 || index >= this.commands.size()) {
            return null;
        }
        return (Command)this.commands.elementAt(index);
    }

    public int getCommandCount() {
        return this.commands.size();
    }

    protected void addCommand(Command cmd, int index) {
        int behavior;
        if (this.getCommandCount() == 0 && this.parent != null) {
            this.installMenuBar();
        }
        if (this.commands.contains(cmd)) {
            return;
        }
        this.commands.insertElementAt(cmd, index);
        if (!(this.parent instanceof Dialog || (behavior = this.getCommandBehavior()) != 4 && behavior != 5 && behavior != 6 && behavior != 7 && behavior != 8)) {
            if (behavior == 5 && cmd == this.parent.getBackCommand()) {
                return;
            }
            if (behavior == 8) {
                return;
            }
            if ((behavior == 5 || behavior == 7) && this.parent.getTitle() != null && this.parent.getTitle().length() > 0) {
                this.synchronizeCommandsWithButtonsInBackbutton();
                return;
            }
            if (this.parent.getBackCommand() != cmd) {
                if (behavior != 7) {
                    this.setLayout(new GridLayout(1, this.getComponentCount() + 1));
                    this.addComponent(Math.min(this.getComponentCount(), index), (Component)this.createTouchCommandButton(cmd));
                    this.revalidate();
                }
            } else {
                this.commands.removeElement(cmd);
            }
            return;
        }
        this.updateCommands();
    }

    protected void installMenuBar() {
        if (this.getParent() == null) {
            int type = this.getCommandBehavior();
            if (type == 6 || type == 7 || type == 8) {
                return;
            }
            int softkeyCount = Display.getInstance().getImplementation().getSoftkeyCount();
            if ((softkeyCount > 1 || type == 4 || type == 5) && Display.getInstance().getProperty("adPaddingBottom", null) == null) {
                this.parent.addComponentToForm("South", this);
            }
        }
    }

    protected void unInstallMenuBar() {
        this.parent.removeComponentFromForm(this);
        Container t = this.getTitleAreaContainer();
        BorderLayout titleLayout = (BorderLayout)t.getLayout();
        titleLayout.setCenterBehavior(0);
        Component l = this.getTitleComponent();
        t.removeAll();
        if (l.getParent() != null) {
            l.getParent().removeComponent(l);
        }
        t.addComponent("Center", l);
        this.initTitleBarStatus();
    }

    protected void removeAllCommands() {
        this.commands.removeAllElements();
        int behavior = this.getCommandBehavior();
        if (behavior == 4 || behavior == 5 || behavior == 6 || behavior == 7) {
            if (this.getTitleComponent() != null) {
                this.getTitleComponent().getParent().removeAll();
            }
            this.getTitleAreaContainer().removeAll();
            this.getTitleAreaContainer().addComponent("Center", this.getTitleComponent());
            this.removeAll();
            this.initTitleBarStatus();
            return;
        }
        this.updateCommands();
    }

    protected void removeCommand(Command cmd) {
        int behavior = this.getCommandBehavior();
        if (behavior == 4 || behavior == 5 || behavior == 6 || behavior == 7) {
            int i = this.commands.indexOf(cmd);
            if (i > -1) {
                this.commands.removeElementAt(i);
                Button b = this.findCommandComponent(cmd);
                if (b != null && b.getParent() != null) {
                    b.getParent().removeComponent(b);
                }
                if (this.getCommandCount() > 0) {
                    this.setLayout(new GridLayout(1, this.getCommandCount()));
                }
            }
            return;
        }
        this.commands.removeElement(cmd);
        this.updateCommands();
    }

    void addSelectCommand(String selectText) {
        if (this.thirdSoftButton) {
            if (this.selectCommand == null) {
                this.selectCommand = this.createSelectCommand();
            }
            this.selectCommand.setCommandName(selectText);
            this.addCommand(this.selectCommand);
        }
    }

    void removeSelectCommand() {
        if (this.thirdSoftButton) {
            this.removeCommand(this.selectCommand);
        }
    }

    protected Command createSelectCommand() {
        return new Command(this.parent.getUIManager().localize("select", "Select"));
    }

    protected Command createMenuSelectCommand() {
        UIManager manager = this.parent.getUIManager();
        LookAndFeel lf = manager.getLookAndFeel();
        return new Command(manager.localize("select", "Select"), lf.getMenuIcons()[0]);
    }

    protected Command createMenuCancelCommand() {
        UIManager manager = this.parent.getUIManager();
        LookAndFeel lf = manager.getLookAndFeel();
        return new Command(manager.localize("cancel", "Cancel"), lf.getMenuIcons()[1]);
    }

    public void setMenuCellRenderer(ListCellRenderer menuCellRenderer) {
        this.menuCellRenderer = menuCellRenderer;
    }

    public Style getMenuStyle() {
        return this.menuStyle;
    }

    static boolean isLSK(int keyCode) {
        return keyCode != 0 && keyCode == leftSK;
    }

    static boolean isRSK(int keyCode) {
        return keyCode != 0 && (keyCode == rightSK || keyCode == rightSK2);
    }

    public boolean handlesKeycode(int keyCode) {
        if (keyCode == 0) {
            return false;
        }
        int game = Display.getInstance().getGameAction(keyCode);
        return MenuBar.isLSK(keyCode) || MenuBar.isRSK(keyCode) || keyCode == backSK || keyCode == clearSK && this.clearCommand != null || keyCode == backspaceSK && this.clearCommand != null || this.thirdSoftButton && game == 8;
    }

    public void keyPressed(int keyCode) {
        int commandBehavior = this.getCommandBehavior();
        if (commandBehavior >= 4) {
            return;
        }
        if (this.getCommandCount() > 0) {
            if (MenuBar.isLSK(keyCode)) {
                if (this.left != null) {
                    this.left.pressed();
                }
            } else if (MenuBar.isRSK(keyCode)) {
                if (this.right != null) {
                    this.right.pressed();
                }
            } else if (Display.getInstance().getGameAction(keyCode) == 8) {
                this.main.pressed();
            }
        }
    }

    public void keyReleased(int keyCode) {
        int commandBehavior = this.getCommandBehavior();
        if (commandBehavior >= 4 && keyCode != backSK && keyCode != clearSK && keyCode != backspaceSK) {
            return;
        }
        if (this.getCommandCount() > 0) {
            int softkeyCount = Display.getInstance().getImplementation().getSoftkeyCount();
            if (softkeyCount < 2 && MenuBar.isLSK(keyCode)) {
                if (this.commandList != null) {
                    for (Container parent = this.commandList.getParent(); parent != null; parent = parent.getParent()) {
                        if (!(parent instanceof Dialog) || !((Dialog)parent).isMenu()) continue;
                        return;
                    }
                }
                this.showMenu();
                return;
            }
            if (MenuBar.isLSK(keyCode)) {
                if (this.left != null) {
                    this.left.released();
                }
                return;
            }
            if (MenuBar.isRSK(keyCode)) {
                if (this.right != null) {
                    this.right.released();
                }
                return;
            }
            if (Display.getInstance().getGameAction(keyCode) == 8) {
                this.main.released();
                return;
            }
        }
        Command c = null;
        if (keyCode == backSK) {
            c = this.parent.getBackCommand();
            if (c == null && this.minimizeOnBack) {
                Display.getInstance().minimizeApplication();
                return;
            }
        } else if (keyCode == clearSK || keyCode == backspaceSK) {
            c = this.getClearCommand();
        }
        if (c != null) {
            ActionEvent ev = new ActionEvent((Object)c, keyCode);
            c.actionPerformed(ev);
            if (!ev.isConsumed()) {
                this.parent.actionCommandImpl(c);
            }
        }
    }

    public void refreshTheme(boolean merge) {
        super.refreshTheme(merge);
        UIManager manager = this.parent.getUIManager();
        if (this.menuStyle.isModified() && merge) {
            this.menuStyle.merge(manager.getComponentStyle("Menu"));
        } else {
            this.menuStyle = manager.getComponentStyle("Menu");
        }
        if (this.menuCellRenderer != null) {
            List tmp = new List();
            tmp.setListCellRenderer(this.menuCellRenderer);
            tmp.refreshTheme(merge);
        }
        for (int iter = 0; iter < this.soft.length; ++iter) {
            this.updateSoftButtonStyle(this.soft[iter]);
        }
        this.revalidate();
    }

    protected Command showMenuDialog(Dialog menu) {
        int height;
        int marginLeft;
        UIManager manager = this.parent.getUIManager();
        boolean pref = manager.isThemeConstant("menuPrefSizeBool", false);
        int marginRight = 0;
        if (pref) {
            Container dialogContentPane = menu.getDialogComponent();
            marginLeft = this.parent.getWidth() - (dialogContentPane.getPreferredW() + menu.getStyle().getHorizontalPadding());
            marginLeft = Math.max(0, marginLeft);
            height = this.parent.getSoftButtonCount() > 1 ? this.parent.getHeight() - this.parent.getSoftButton(0).getParent().getPreferredH() - dialogContentPane.getPreferredH() : this.parent.getHeight() - dialogContentPane.getPreferredH();
            height = Math.max(0, height);
        } else {
            float menuWidthPercent = 1.0f - Float.parseFloat(manager.getThemeConstant("menuWidthPercent", "75")) / 100.0f;
            float menuHeightPercent = 1.0f - Float.parseFloat(manager.getThemeConstant("menuHeightPercent", "50")) / 100.0f;
            height = (int)((float)this.parent.getHeight() * menuHeightPercent);
            marginLeft = (int)((float)this.parent.getWidth() * menuWidthPercent);
        }
        if (this.isReverseSoftButtons()) {
            marginRight = marginLeft;
            marginLeft = 0;
        }
        if (this.getCommandBehavior() == 7) {
            menu.setTransitionOutAnimator(this.transitionIn);
            menu.setTransitionInAnimator(this.transitionOut);
            int th = this.getTitleAreaContainer().getHeight();
            return menu.show(th, height - th, marginLeft, marginRight, true);
        }
        if (manager.getLookAndFeel().isTouchMenus() && manager.isThemeConstant("PackTouchMenuBool", true)) {
            return menu.showPacked("South", true);
        }
        return menu.show(height, 0, marginLeft, marginRight, true);
    }

    protected boolean isReverseSoftButtons() {
        LookAndFeel lf = this.parent.getUIManager().getLookAndFeel();
        if (this.isRTL()) {
            return !lf.isReverseSoftButtons();
        }
        return lf.isReverseSoftButtons();
    }

    protected int calculateTouchCommandGridColumns(Container grid) {
        int count = grid.getComponentCount();
        int maxWidth = 10;
        for (int iter = 0; iter < count; ++iter) {
            Component c = grid.getComponentAt(iter);
            Style s = c.getUnselectedStyle();
            maxWidth = Math.max(maxWidth, c.getPreferredW() + s.getHorizontalMargins());
        }
        return Math.max(2, Display.getInstance().getDisplayWidth() / maxWidth);
    }

    public void setCommandUIID(Command cmd, String uiid) {
        Button b = this.findCommandComponent(cmd);
        if (b != null) {
            b.setUIID(uiid);
            this.revalidate();
        }
        cmd.putClientProperty("cn1$CommandUIID", uiid);
    }

    protected Button createTouchCommandButton(Command c) {
        Button b = new Button(c);
        if (b.getIcon() == null) {
            b.setIcon(this.parent.getUIManager().getThemeImageConstant("defaultCommandImage"));
        } else if (UIManager.getInstance().isThemeConstant("commandAsIconBool", false)) {
            b.setText("");
        }
        b.setTactileTouch(true);
        b.setTextPosition(2);
        b.setEndsWith3Points(false);
        String uiid = (String)c.getClientProperty("cn1$CommandUIID");
        if (uiid != null) {
            b.setUIID(uiid);
        } else {
            b.setUIID("TouchCommand");
        }
        Integer gap = (Integer)c.getClientProperty("iconGap");
        if (gap != null) {
            b.setGap(gap);
        }
        return b;
    }

    protected Component createCommandComponent(Vector commands) {
        UIManager manager = this.parent.getUIManager();
        if (manager.getLookAndFeel().isTouchMenus()) {
            Container menu = new Container();
            menu.setScrollableY(true);
            for (int iter = 0; iter < commands.size(); ++iter) {
                Command c = (Command)commands.elementAt(iter);
                menu.addComponent(this.createTouchCommandButton(c));
            }
            if (!manager.isThemeConstant("touchCommandFlowBool", false)) {
                int rows;
                int cols = this.calculateTouchCommandGridColumns(menu);
                if (cols > this.getCommandCount()) {
                    cols = this.getCommandCount();
                }
                if ((rows = Math.max(1, this.getCommandCount() / cols + (this.getCommandCount() % cols != 0 ? 1 : 0))) > 1) {
                    int remainingColumns = rows * cols % this.getCommandCount();
                    int newCols = cols;
                    int newRows = rows;
                    while (remainingColumns != 0 && remainingColumns > 1 && newCols >= 2 && (newRows = Math.max(1, this.getCommandCount() / --newCols + (this.getCommandCount() % newCols != 0 ? 1 : 0))) == rows) {
                        remainingColumns = newRows * newCols % this.getCommandCount();
                    }
                    if (newRows == rows) {
                        cols = newCols;
                        rows = newRows;
                    }
                }
                GridLayout g = new GridLayout(rows, cols);
                g.setFillLastRow(manager.isThemeConstant("touchCommandFillBool", true));
                menu.setLayout(g);
            } else {
                ((FlowLayout)menu.getLayout()).setFillRows(true);
            }
            menu.setPreferredW(Display.getInstance().getDisplayWidth());
            return menu;
        }
        return this.createCommandList(commands);
    }

    protected Vector getCommands() {
        return this.commands;
    }

    protected List createCommandList(Vector commands) {
        List l = new List(commands);
        l.setUIID("CommandList");
        Component c = (Component)((Object)l.getRenderer());
        c.setUIID("Command");
        c = l.getRenderer().getListFocusComponent(l);
        c.setUIID("CommandFocus");
        l.setFixedSelection(1);
        if (this.parent.getUIManager().isThemeConstant("menuPrefSizeBool", false)) {
            l.setListSizeCalculationSampleCount(50);
        }
        return l;
    }

    Command getComponentSelectedCommand(Component cmp) {
        if (cmp instanceof List) {
            List l = (List)cmp;
            return (Command)l.getSelectedItem();
        }
        if ((cmp = cmp.getComponentForm().getFocused()) instanceof Button) {
            return ((Button)cmp).getCommand();
        }
        return null;
    }

    protected Command getSelectMenuItem() {
        return this.selectMenuItem;
    }

    protected Command getCancelMenuItem() {
        return this.cancelMenuItem;
    }

    public boolean isMinimizeOnBack() {
        return this.minimizeOnBack;
    }

    public void setMinimizeOnBack(boolean minimizeOnBack) {
        this.minimizeOnBack = minimizeOnBack;
    }

    protected int getDragRegionStatus(int x, int y) {
        return 1;
    }

    protected Container getTitleAreaContainer() {
        return this.parent.getTitleArea();
    }

    protected Component getTitleComponent() {
        return this.parent.getTitleComponent();
    }

    Form getParentForm() {
        return this.parent;
    }

    void initTitleBarStatus() {
        this.parent.initTitleBarStatus();
    }

    private boolean isTouchMenus() {
        int t = this.getCommandBehavior();
        return t == 3 || t == 1 && Display.getInstance().isTouchScreenDevice();
    }

    static {
        if (Display.getInstance() == null || Display.getInstance().getImplementation() == null) {
            leftSK = -6;
            rightSK = -7;
            rightSK2 = -7;
            backSK = -11;
            clearSK = -8;
            backspaceSK = -8;
        }
    }
}

