/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.animations;

import com.codename1.ui.Container;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class ComponentAnimation {
    private Object notifyLock;
    private Runnable onCompletion;
    private int step = -1;
    private ArrayList<Runnable> post;
    private boolean completed = false;

    public void addOnCompleteCall(Runnable r) {
        if (this.post == null) {
            this.post = new ArrayList();
        }
        this.post.add(r);
    }

    public boolean isStepModeSupported() {
        return false;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public int getStep() {
        return this.step;
    }

    public int getMaxSteps() {
        return 100;
    }

    public abstract boolean isInProgress();

    protected abstract void updateState();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateAnimationState() {
        this.updateState();
        if (!this.isInProgress()) {
            if (!this.completed) {
                this.completed = true;
                if (this.notifyLock != null) {
                    Iterator<Runnable> iterator = this.notifyLock;
                    synchronized (iterator) {
                        this.notifyLock.notify();
                    }
                }
                if (this.onCompletion != null) {
                    this.onCompletion.run();
                }
                if (this.post != null) {
                    for (Runnable p : this.post) {
                        p.run();
                    }
                }
            }
        } else {
            this.completed = false;
        }
    }

    public void flush() {
    }

    public final void setNotifyLock(Object l) {
        if (this.notifyLock != null) {
            throw new RuntimeException("setNotifyLock shouldn't be invoked more than once");
        }
        this.notifyLock = l;
    }

    public final void setOnCompletion(Runnable r) {
        if (this.onCompletion != null) {
            throw new RuntimeException("setOnCompletion shouldn't be invoked more than once");
        }
        this.onCompletion = r;
    }

    public static ComponentAnimation compoundAnimation(ComponentAnimation ... anims) {
        return new CompoundAnimation(anims);
    }

    public static ComponentAnimation sequentialAnimation(ComponentAnimation ... anims) {
        return new CompoundAnimation(anims, true);
    }

    public static class UIMutation
    extends CompoundAnimation {
        private Set<Container> containers = new HashSet<Container>();
        private boolean isStarted;

        public UIMutation(Container cnt, ComponentAnimation anim) {
            super(new ComponentAnimation[]{anim});
        }

        public boolean add(Container cnt, ComponentAnimation anim) {
            if (this.isStarted) {
                return false;
            }
            for (Container existing : this.containers) {
                if (cnt != existing && !existing.contains(cnt) && !cnt.contains(existing)) continue;
                return false;
            }
            ComponentAnimation[] newAnims = new ComponentAnimation[this.anims.length + 1];
            System.arraycopy(this.anims, 0, newAnims, 0, this.anims.length);
            newAnims[this.anims.length] = anim;
            this.anims = newAnims;
            this.containers.add(cnt);
            return true;
        }

        public boolean isLocked() {
            return this.isStarted;
        }

        protected void updateState() {
            this.isStarted = true;
            super.updateState();
        }
    }

    static class CompoundAnimation
    extends ComponentAnimation {
        ComponentAnimation[] anims;
        int sequence;

        public CompoundAnimation(ComponentAnimation[] anims) {
            this.anims = anims;
            this.sequence = -1;
        }

        public CompoundAnimation(ComponentAnimation[] anims, boolean s) {
            this.anims = anims;
            this.sequence = 0;
        }

        public boolean isInProgress() {
            if (this.sequence > -1 && this.sequence < this.anims.length) {
                if (this.anims[this.sequence].isInProgress()) {
                    return true;
                }
                while (this.anims.length > this.sequence) {
                    if (this.anims[this.sequence].isInProgress()) {
                        return true;
                    }
                    ++this.sequence;
                }
                return false;
            }
            for (ComponentAnimation a : this.anims) {
                if (!a.isInProgress()) continue;
                return true;
            }
            return false;
        }

        protected void updateState() {
            if (this.sequence > -1) {
                this.anims[Math.min(this.sequence, this.anims.length - 1)].updateState();
                return;
            }
            for (ComponentAnimation a : this.anims) {
                a.updateAnimationState();
            }
        }

        public void flush() {
            for (ComponentAnimation a : this.anims) {
                a.flush();
            }
        }

        public int getMaxSteps() {
            if (this.sequence > -1) {
                int out = 0;
                for (ComponentAnimation a : this.anims) {
                    out += a.getMaxSteps();
                }
                return out;
            }
            int out = 0;
            for (ComponentAnimation a : this.anims) {
                out = Math.max(a.getMaxSteps(), out);
            }
            return out;
        }

        public void setStep(int step) {
            super.setStep(step);
            if (this.sequence > -1) {
                int animIdx;
                ComponentAnimation anim;
                int len = this.anims.length;
                for (animIdx = 0; animIdx < this.anims.length && this.anims[animIdx].getMaxSteps() <= step; step -= anim.getMaxSteps(), ++animIdx) {
                    anim = this.anims[animIdx];
                    anim.setStep(anim.getMaxSteps());
                }
                while (animIdx < len) {
                    this.anims[animIdx].setStep(0);
                    ++animIdx;
                }
            } else {
                for (ComponentAnimation anim : this.anims) {
                    anim.setStep(Math.min(anim.getMaxSteps(), step));
                }
            }
        }
    }
}

