/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.layouts;

import com.codename1.ui.layouts.Insets;

public class GridBagConstraints {
    public static final int RELATIVE = -1;
    public static final int REMAINDER = 0;
    public static final int NONE = 0;
    public static final int BOTH = 1;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int CENTER = 10;
    public static final int NORTH = 11;
    public static final int NORTHEAST = 12;
    public static final int EAST = 13;
    public static final int SOUTHEAST = 14;
    public static final int SOUTH = 15;
    public static final int SOUTHWEST = 16;
    public static final int WEST = 17;
    public static final int NORTHWEST = 18;
    public static final int PAGE_START = 19;
    public static final int PAGE_END = 20;
    public static final int LINE_START = 21;
    public static final int LINE_END = 22;
    public static final int FIRST_LINE_START = 23;
    public static final int FIRST_LINE_END = 24;
    public static final int LAST_LINE_START = 25;
    public static final int LAST_LINE_END = 26;
    public int gridx;
    public int gridy;
    public int gridwidth;
    public int gridheight;
    public double weightx;
    public double weighty;
    public int anchor;
    public int fill;
    public Insets insets;
    public int ipadx;
    public int ipady;

    public GridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets, int ipadx, int ipady) {
        this.gridx = gridx;
        this.gridy = gridy;
        this.gridwidth = gridwidth;
        this.gridheight = gridheight;
        this.weightx = weightx;
        this.weighty = weighty;
        this.anchor = anchor;
        this.fill = fill;
        this.insets = insets == null ? null : (Insets)insets.clone();
        this.ipadx = ipadx;
        this.ipady = ipady;
    }

    public GridBagConstraints() {
        this.gridx = -1;
        this.gridy = -1;
        this.gridwidth = 1;
        this.gridheight = 1;
        this.weightx = 0.0;
        this.weighty = 0.0;
        this.anchor = 10;
        this.fill = 0;
        this.insets = new Insets(0, 0, 0, 0);
        this.ipadx = 0;
        this.ipady = 0;
    }

    public Object clone() {
        return new GridBagConstraints(this.gridx, this.gridy, this.gridwidth, this.gridheight, this.weightx, this.weighty, this.anchor, this.fill, this.insets, this.ipadx, this.ipady);
    }

    void verify() throws IllegalArgumentException {
        int maxN = 511;
        if (this.gridx != -1 && this.gridx < 0 || this.gridx >= maxN) {
            throw new IllegalArgumentException("wrong value of GridBagConstraints: " + this.gridx);
        }
        if (this.gridy != -1 && this.gridy < 0 || this.gridy >= maxN) {
            throw new IllegalArgumentException("wrong value of GridBagConstraints: " + this.gridy);
        }
        if (this.gridwidth != -1 && this.gridwidth != 0 && this.gridwidth < 0 || this.gridwidth > maxN) {
            throw new IllegalArgumentException("wrong value of GridBagConstraints: " + this.gridwidth);
        }
        if (this.gridheight != -1 && this.gridheight != 0 && this.gridheight < 0 || this.gridheight > maxN) {
            throw new IllegalArgumentException("wrong value of GridBagConstraints: " + this.gridheight);
        }
        if (!(this.gridx < 0 && this.gridy < 0 || this.gridwidth > 0 && this.gridheight > 0)) {
            throw new IllegalArgumentException("relative grid size parameter goes after absolute grid coordinate");
        }
        if (this.gridx != -1 && this.gridwidth + this.gridx > maxN) {
            throw new IllegalArgumentException("wrong values sum of GridBagConstraints' gridwidth and gridx");
        }
        if (this.gridy != -1 && this.gridheight + this.gridy > maxN) {
            throw new IllegalArgumentException("wrong values sum of GridBagConstraints' gridheight and gridy");
        }
        if (this.gridwidth == -1 && this.gridheight == -1) {
            throw new IllegalArgumentException("component has RELATIVE width and height");
        }
        if (this.weightx < 0.0) {
            throw new IllegalArgumentException("wrong value of GridBagConstraints: " + this.weightx);
        }
        if (this.weighty < 0.0) {
            throw new IllegalArgumentException("wrong value of GridBagConstraints: " + this.weighty);
        }
        if (this.anchor != 10 && this.anchor != 11 && this.anchor != 12 && this.anchor != 13 && this.anchor != 14 && this.anchor != 15 && this.anchor != 16 && this.anchor != 17 && this.anchor != 18 && this.anchor != 19 && this.anchor != 20 && this.anchor != 21 && this.anchor != 22 && this.anchor != 23 && this.anchor != 24 && this.anchor != 25 && this.anchor != 26) {
            throw new IllegalArgumentException("wrong value of GridBagConstraints: " + this.anchor);
        }
        if (this.fill != 0 && this.fill != 2 && this.fill != 3 && this.fill != 1) {
            throw new IllegalArgumentException("wrong value of GridBagConstraints: " + this.fill);
        }
        if (this.ipadx < 0) {
            throw new IllegalArgumentException("wrong value of GridBagConstraints: " + this.ipadx);
        }
        if (this.ipady < 0) {
            throw new IllegalArgumentException("wrong value of GridBagConstraints: " + this.ipady);
        }
        if (this.insets == null || this.insets.left < 0 || this.insets.left < 0 || this.insets.left < 0 || this.insets.left < 0) {
            throw new IllegalArgumentException("wrong value of GridBagConstraints: " + this.insets);
        }
    }
}

