/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.table;

import com.codename1.io.Log;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.plaf.Style;
import java.util.Vector;

public class TableLayout
extends Layout {
    private int currentRow;
    private int currentColumn;
    private static int minimumSizePerColumn = 10;
    private Constraint[] tablePositions;
    private int[] columnPositions;
    private int[] rowPositions;
    private static final Constraint H_SPAN_CONSTRAINT = new Constraint();
    private static final Constraint V_SPAN_CONSTRAINT = new Constraint();
    private static final Constraint VH_SPAN_CONSTRAINT = new Constraint();
    private static int defaultColumnWidth = -1;
    private static int defaultRowHeight = -1;
    private boolean horizontalSpanningExists;
    private boolean verticalSpanningExists;
    private int rows;
    private int columns;
    private boolean growHorizontally;
    private boolean truncateHorizontally;
    private boolean truncateVertically;

    public TableLayout(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.tablePositions = new Constraint[rows * columns];
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public Component getComponentAt(int row, int column) {
        int pos = row * this.columns + column;
        if (pos > -1 && pos < this.tablePositions.length) {
            Constraint c = this.tablePositions[pos];
            return c != null ? c.parent : null;
        }
        return null;
    }

    public void layoutContainer(Container parent) {
        try {
            int iter;
            int iter2;
            this.verticalSpanningExists = false;
            this.horizontalSpanningExists = false;
            Style s = parent.getStyle();
            int top = s.getPaddingTop();
            int left = s.getPaddingLeft(parent.isRTL());
            int bottom = s.getPaddingBottom();
            int right = s.getPaddingRight(parent.isRTL());
            boolean rtl = parent.isRTL();
            int[] columnSizes = new int[this.columns];
            boolean[] modifableColumnSize = new boolean[this.columns];
            boolean[] growingColumnSize = new boolean[this.columns];
            this.columnPositions = new int[this.columns];
            int pWidth = parent.getLayoutWidth() - parent.getSideGap() - left - right;
            int cslen = columnSizes.length;
            int availableReminder = pWidth;
            int growingWidth = 0;
            boolean hasGrowingCols = false;
            int totalWidth = 0;
            int totalModifyablePixels = 0;
            for (iter2 = 0; iter2 < cslen; ++iter2) {
                int[] psize = this.getColumnWidthPixels(iter2, pWidth);
                columnSizes[iter2] = psize[0];
                availableReminder -= columnSizes[iter2];
                totalWidth += columnSizes[iter2];
                if (psize[1] < 0) {
                    modifableColumnSize[iter2] = true;
                    totalModifyablePixels += columnSizes[iter2];
                }
                if (psize[1] >= -1) continue;
                growingColumnSize[iter2] = true;
                hasGrowingCols = true;
                growingWidth += columnSizes[iter2];
            }
            if (hasGrowingCols && availableReminder > 0) {
                for (iter2 = 0; iter2 < cslen; ++iter2) {
                    if (!growingColumnSize[iter2]) continue;
                    int sp = (int)((float)columnSizes[iter2] / (float)growingWidth * (float)availableReminder);
                    int n = iter2;
                    columnSizes[n] = columnSizes[n] + sp;
                }
            }
            if (!parent.isScrollableX() && pWidth < totalWidth) {
                if (this.truncateHorizontally) {
                    availableReminder = pWidth;
                    for (iter2 = 0; iter2 < cslen; ++iter2) {
                        columnSizes[iter2] = Math.min(columnSizes[iter2], Math.max(0, availableReminder));
                        availableReminder -= columnSizes[iter2];
                    }
                } else {
                    int totalPixelsToRemove = totalWidth - pWidth;
                    int totalPixelsNecessary = totalModifyablePixels - totalPixelsToRemove;
                    for (int iter3 = 0; iter3 < cslen; ++iter3) {
                        if (!modifableColumnSize[iter3]) continue;
                        columnSizes[iter3] = (int)((float)columnSizes[iter3] / (float)totalModifyablePixels * (float)totalPixelsNecessary);
                    }
                }
            }
            int currentX = left;
            for (int iter4 = 0; iter4 < cslen; ++iter4) {
                if (rtl) {
                    this.columnPositions[iter4] = pWidth - (currentX += columnSizes[iter4]);
                    continue;
                }
                this.columnPositions[iter4] = currentX;
                currentX += columnSizes[iter4];
            }
            int[] rowSizes = new int[this.rows];
            boolean[] modifableRowSize = new boolean[this.rows];
            boolean[] growingRowSize = new boolean[this.rows];
            this.rowPositions = new int[this.rows];
            int pHeight = parent.getLayoutHeight() - parent.getBottomGap() - top - bottom;
            int rlen = rowSizes.length;
            availableReminder = pHeight;
            int growingHeight = 0;
            boolean hasGrowingRows = false;
            int totalHeight = 0;
            totalModifyablePixels = 0;
            for (iter = 0; iter < rlen; ++iter) {
                int[] psize = this.getRowHeightPixels(iter, pHeight);
                rowSizes[iter] = psize[0];
                availableReminder -= rowSizes[iter];
                totalHeight += rowSizes[iter];
                if (psize[0] < 0) {
                    modifableRowSize[iter] = true;
                    totalModifyablePixels += rowSizes[iter];
                }
                if (psize[0] >= -1) continue;
                growingRowSize[iter] = true;
                hasGrowingRows = true;
                growingHeight += rowSizes[iter];
            }
            if (hasGrowingRows && availableReminder > 0) {
                for (iter = 0; iter < rlen; ++iter) {
                    if (!growingRowSize[iter]) continue;
                    int sp = (int)((float)rowSizes[iter] / (float)growingHeight * (float)availableReminder);
                    int n = iter;
                    rowSizes[n] = rowSizes[n] + sp;
                }
            }
            if (!parent.isScrollableY() && pHeight < totalHeight) {
                if (this.truncateVertically) {
                    availableReminder = pHeight;
                    for (iter = 0; iter < rlen; ++iter) {
                        rowSizes[iter] = Math.min(rowSizes[iter], Math.max(0, availableReminder));
                        availableReminder -= rowSizes[iter];
                    }
                } else {
                    int totalPixelsToRemove = totalHeight - pHeight;
                    int totalPixelsNecessary = totalModifyablePixels - totalPixelsToRemove;
                    for (int iter5 = 0; iter5 < rlen; ++iter5) {
                        if (!modifableRowSize[iter5]) continue;
                        rowSizes[iter5] = (int)((float)rowSizes[iter5] / (float)totalModifyablePixels * (float)totalPixelsNecessary);
                    }
                }
            }
            int currentY = top;
            for (int iter6 = 0; iter6 < rlen; ++iter6) {
                this.rowPositions[iter6] = currentY;
                currentY += rowSizes[iter6];
            }
            int clen = columnSizes.length;
            for (int r = 0; r < rlen; ++r) {
                for (int c = 0; c < clen; ++c) {
                    int conH;
                    int conW;
                    Constraint con = this.tablePositions[r * this.columns + c];
                    if (con == null || con == H_SPAN_CONSTRAINT || con == V_SPAN_CONSTRAINT || con == VH_SPAN_CONSTRAINT) continue;
                    Style componentStyle = con.parent.getStyle();
                    int leftMargin = componentStyle.getMarginLeft(parent.isRTL());
                    int topMargin = componentStyle.getMarginTop();
                    int conX = leftMargin + this.columnPositions[c];
                    int conY = topMargin + this.rowPositions[r];
                    if (con.spanHorizontal > 1) {
                        this.horizontalSpanningExists = true;
                        int w = columnSizes[c];
                        for (int sh = 1; sh < con.spanHorizontal; ++sh) {
                            w += columnSizes[Math.min(c + sh, columnSizes.length - 1)];
                        }
                        if (rtl) {
                            int spanEndPos = c + con.spanHorizontal - 1;
                            if (spanEndPos < 0) {
                                spanEndPos = 0;
                            } else if (spanEndPos > clen - 1) {
                                spanEndPos = clen - 1;
                            }
                            conX = left + leftMargin + this.columnPositions[spanEndPos];
                        }
                        conW = w - leftMargin - componentStyle.getMarginRight(parent.isRTL());
                    } else {
                        conW = columnSizes[c] - leftMargin - componentStyle.getMarginRight(parent.isRTL());
                    }
                    if (con.spanVertical > 1) {
                        this.verticalSpanningExists = true;
                        int h = rowSizes[r];
                        for (int sv = 1; sv < con.spanVertical; ++sv) {
                            h += rowSizes[Math.min(r + sv, rowSizes.length - 1)];
                        }
                        conH = h - topMargin - componentStyle.getMarginBottom();
                    } else {
                        conH = rowSizes[r] - topMargin - componentStyle.getMarginBottom();
                    }
                    this.placeComponent(rtl, con, conX, conY, conW, conH);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException err) {
            Log.e(err);
        }
    }

    public int getRowPosition(int row) {
        if (this.rowPositions != null && this.rowPositions.length > row) {
            return this.rowPositions[row];
        }
        return -1;
    }

    public int getColumnPosition(int col) {
        if (this.columnPositions != null && this.columnPositions.length > col) {
            return this.columnPositions[col];
        }
        return -1;
    }

    private void placeComponent(boolean rtl, Constraint con, int x, int y, int width, int height) {
        int d;
        con.parent.setX(x);
        con.parent.setY(y);
        con.parent.setWidth(width);
        con.parent.setHeight(height);
        Dimension pref = con.parent.getPreferredSize();
        int pWidth = pref.getWidth();
        int pHeight = pref.getHeight();
        if (pWidth < width) {
            d = width - pWidth;
            int a = con.align;
            if (rtl) {
                switch (a) {
                    case 1: {
                        a = 3;
                        break;
                    }
                    case 3: {
                        a = 1;
                    }
                }
            }
            switch (a) {
                case 1: {
                    con.parent.setX(x);
                    con.parent.setWidth(width - d);
                    break;
                }
                case 3: {
                    con.parent.setX(x + d);
                    con.parent.setWidth(width - d);
                    break;
                }
                case 4: {
                    con.parent.setX(x + d / 2);
                    con.parent.setWidth(width - d);
                }
            }
        }
        if (pHeight < height) {
            d = height - pHeight;
            switch (con.valign) {
                case 0: {
                    con.parent.setY(y);
                    con.parent.setHeight(height - d);
                    break;
                }
                case 2: {
                    con.parent.setY(y + d);
                    con.parent.setHeight(height - d);
                    break;
                }
                case 4: {
                    con.parent.setY(y + d / 2);
                    con.parent.setHeight(height - d);
                }
            }
        }
    }

    private int[] getColumnWidthPixels(int column, int percentageOf) {
        int current = 0;
        boolean foundExplicitWidth = false;
        boolean growable = false;
        for (int iter = 0; iter < this.rows; ++iter) {
            Constraint c = this.tablePositions[iter * this.columns + column];
            if (c == null || c == H_SPAN_CONSTRAINT || c == V_SPAN_CONSTRAINT || c == VH_SPAN_CONSTRAINT || c.spanHorizontal > 1) continue;
            if (c.width > 0 && percentageOf > -1) {
                current = Math.max(current, c.width * percentageOf / 100);
                foundExplicitWidth = true;
                continue;
            }
            if (foundExplicitWidth) continue;
            if (c.width == -2 || this.growHorizontally && column == this.columns - 1) {
                growable = true;
            }
            Style s = c.parent.getStyle();
            current = Math.max(current, c.parent.getPreferredW() + s.getMarginLeftNoRTL() + s.getMarginRightNoRTL());
        }
        return new int[]{current, foundExplicitWidth ? 0 : (growable ? -2 : -1)};
    }

    private int[] getRowHeightPixels(int row, int percentageOf) {
        int current = 0;
        boolean foundExplicitHeight = false;
        boolean growable = false;
        for (int iter = 0; iter < this.columns; ++iter) {
            Constraint c = this.tablePositions[row * this.columns + iter];
            if (c == null || c == H_SPAN_CONSTRAINT || c == V_SPAN_CONSTRAINT || c == VH_SPAN_CONSTRAINT || c.spanVertical > 1) continue;
            if (c.height > 0 && percentageOf > -1) {
                current = Math.max(current, c.height * percentageOf / 100);
                foundExplicitHeight = true;
                continue;
            }
            if (foundExplicitHeight) continue;
            if (c.height == -2) {
                growable = true;
            }
            Style s = c.parent.getStyle();
            current = Math.max(current, c.parent.getPreferredH() + s.getMarginTop() + s.getMarginBottom());
        }
        return new int[]{current, foundExplicitHeight ? 0 : (growable ? -2 : -1)};
    }

    public Dimension getPreferredSize(Container parent) {
        int iter;
        Style s = parent.getStyle();
        int w = s.getPaddingLeftNoRTL() + s.getPaddingRightNoRTL();
        int h = s.getPaddingTop() + s.getPaddingBottom();
        for (iter = 0; iter < this.columns; ++iter) {
            w += this.getColumnWidthPixels(iter, -1)[0];
        }
        for (iter = 0; iter < this.rows; ++iter) {
            h += this.getRowHeightPixels(iter, -1)[0];
        }
        return new Dimension(w, h);
    }

    public int getNextRow() {
        return this.currentRow;
    }

    public int getNextColumn() {
        return this.currentColumn;
    }

    private void shiftCell(int row, int column) {
        Constraint currentConstraint = this.tablePositions[row * this.columns + column];
        for (int iter = column + 1; iter < this.columns; ++iter) {
            if (this.tablePositions[row * this.columns + iter] == null) {
                this.tablePositions[row * this.columns + iter] = currentConstraint;
                return;
            }
            Constraint tmp = this.tablePositions[row * this.columns + iter];
            this.tablePositions[row * this.columns + iter] = currentConstraint;
            currentConstraint = tmp;
        }
        for (int rowIter = row + 1; rowIter < this.getRows(); ++rowIter) {
            for (int colIter = 0; colIter < this.getColumns(); ++colIter) {
                if (this.tablePositions[rowIter * this.columns + colIter] == null) {
                    this.tablePositions[rowIter * this.columns + colIter] = currentConstraint;
                    return;
                }
                Constraint tmp = this.tablePositions[rowIter * this.columns + colIter];
                this.tablePositions[rowIter * this.columns + colIter] = currentConstraint;
                currentConstraint = tmp;
            }
        }
        this.addRow();
    }

    private void addRow() {
        ++this.rows;
        Constraint[] newArr = new Constraint[this.rows * this.columns];
        System.arraycopy(this.tablePositions, 0, newArr, 0, this.tablePositions.length);
        this.tablePositions = newArr;
    }

    public void addLayoutComponent(Object value, Component comp, Container c) {
        Constraint con = null;
        if (!(value instanceof Constraint)) {
            con = this.createConstraint();
        } else {
            con = (Constraint)value;
            if (con.parent != null) {
                Constraint con2 = this.createConstraint();
                con2.align = con.align;
                con2.column = con.column;
                con2.height = con.height;
                con2.parent = c;
                con2.row = con.row;
                con2.spanHorizontal = con.spanHorizontal;
                con2.spanVertical = con.spanVertical;
                con2.valign = con.valign;
                con2.width = con.width;
                con = con2;
            }
        }
        con.actualRow = con.row;
        con.actualColumn = con.column;
        if (con.actualRow < 0) {
            con.actualRow = this.currentRow;
        }
        if (con.actualColumn < 0) {
            con.actualColumn = this.currentColumn;
        }
        con.parent = comp;
        if (con.actualRow >= this.rows) {
            this.addRow();
        }
        if (this.tablePositions[con.actualRow * this.columns + con.actualColumn] != null) {
            if (this.tablePositions[con.actualRow * this.columns + con.actualColumn].row != -1 || this.tablePositions[con.actualRow * this.columns + con.actualColumn].column != -1) {
                throw new IllegalArgumentException("Row: " + con.row + " and column: " + con.column + " already occupied");
            }
            this.shiftCell(con.actualRow, con.actualColumn);
            this.tablePositions[con.actualRow * this.columns + con.actualColumn] = con;
        }
        this.tablePositions[con.actualRow * this.columns + con.actualColumn] = con;
        if (con.spanHorizontal > 1 || con.spanVertical > 1) {
            for (int sh = 0; sh < con.spanHorizontal; ++sh) {
                for (int sv = 0; sv < con.spanVertical; ++sv) {
                    if (sh <= 0 && sv <= 0 || this.rows <= con.actualRow + sv || this.columns <= con.actualColumn + sh || this.tablePositions[(con.actualRow + sv) * this.columns + con.actualColumn + sh] != null) continue;
                    if (con.spanHorizontal > 1) {
                        if (con.spanVertical > 1) {
                            this.tablePositions[(con.actualRow + sv) * this.columns + con.actualColumn + sh] = VH_SPAN_CONSTRAINT;
                            continue;
                        }
                        this.tablePositions[(con.actualRow + sv) * this.columns + con.actualColumn + sh] = V_SPAN_CONSTRAINT;
                        continue;
                    }
                    this.tablePositions[(con.actualRow + sv) * this.columns + con.actualColumn + sh] = H_SPAN_CONSTRAINT;
                }
            }
        }
        this.updateRowColumn();
    }

    private void updateRowColumn() {
        if (this.currentRow >= this.rows) {
            return;
        }
        while (this.tablePositions[this.currentRow * this.columns + this.currentColumn] != null) {
            ++this.currentColumn;
            if (this.currentColumn < this.columns) continue;
            this.currentColumn = 0;
            ++this.currentRow;
            if (this.currentRow < this.rows) continue;
            return;
        }
    }

    public int getCellHorizontalSpan(int row, int column) {
        return this.tablePositions[row * this.columns + column].spanHorizontal;
    }

    public int getCellVerticalSpan(int row, int column) {
        return this.tablePositions[row * this.columns + column].spanVertical;
    }

    public boolean isCellSpannedThroughVertically(int row, int column) {
        return this.tablePositions[row * this.columns + column] == V_SPAN_CONSTRAINT || this.tablePositions[row * this.columns + column] == VH_SPAN_CONSTRAINT;
    }

    public boolean isCellSpannedThroughHorizontally(int row, int column) {
        return this.tablePositions[row * this.columns + column] == H_SPAN_CONSTRAINT || this.tablePositions[row * this.columns + column] == VH_SPAN_CONSTRAINT;
    }

    public boolean hasVerticalSpanning() {
        return this.verticalSpanningExists;
    }

    public boolean hasHorizontalSpanning() {
        return this.horizontalSpanningExists;
    }

    public void removeLayoutComponent(Component comp) {
        Vector<Constraint> comps = new Vector<Constraint>();
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                if (this.tablePositions[r * this.columns + c] != null) {
                    if (this.tablePositions[r * this.columns + c].parent != comp) {
                        comps.addElement(this.tablePositions[r * this.columns + c]);
                    } else {
                        this.tablePositions[r * this.columns + c].parent = null;
                    }
                }
                this.tablePositions[r * this.columns + c] = null;
            }
        }
        this.currentRow = 0;
        this.currentColumn = 0;
        int count = comps.size();
        for (int iter = 0; iter < count; ++iter) {
            Constraint con = (Constraint)comps.elementAt(iter);
            if (con == H_SPAN_CONSTRAINT || con == V_SPAN_CONSTRAINT || con == VH_SPAN_CONSTRAINT) continue;
            Component c = con.parent;
            con.parent = null;
            this.addLayoutComponent(con, c, c.getParent());
        }
    }

    public Object getComponentConstraint(Component comp) {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                if (this.tablePositions[r * this.columns + c] == null || this.tablePositions[r * this.columns + c].parent != comp) continue;
                return this.tablePositions[r * this.columns + c];
            }
        }
        return null;
    }

    public Constraint createConstraint() {
        return new Constraint();
    }

    public Constraint cc() {
        return new Constraint();
    }

    public Constraint cc(int row, int column) {
        return this.createConstraint(row, column);
    }

    public Constraint createConstraint(int row, int column) {
        Constraint c = this.createConstraint();
        c.row = row;
        c.column = column;
        return c;
    }

    public static void setMinimumSizePerColumn(int minimumSize) {
        minimumSizePerColumn = minimumSize;
    }

    public static int getMinimumSizePerColumn() {
        return minimumSizePerColumn;
    }

    public static void setDefaultColumnWidth(int w) {
        defaultColumnWidth = w;
    }

    public static int getDefaultColumnWidth() {
        return defaultColumnWidth;
    }

    public static void setDefaultRowHeight(int h) {
        defaultRowHeight = h;
    }

    public static int getDefaultRowHeight() {
        return defaultRowHeight;
    }

    public String toString() {
        return "TableLayout";
    }

    public boolean equals(Object o) {
        return super.equals(o) && ((TableLayout)o).getRows() == this.getRows() && ((TableLayout)o).getColumns() == this.getColumns();
    }

    public boolean isConstraintTracking() {
        return true;
    }

    public boolean isGrowHorizontally() {
        return this.growHorizontally;
    }

    public void setGrowHorizontally(boolean growHorizontally) {
        this.growHorizontally = growHorizontally;
    }

    public boolean isTruncateHorizontally() {
        return this.truncateHorizontally;
    }

    public void setTruncateHorizontally(boolean truncateHorizontally) {
        this.truncateHorizontally = truncateHorizontally;
    }

    public boolean isTruncateVertically() {
        return this.truncateVertically;
    }

    public void setTruncateVertically(boolean truncateVertically) {
        this.truncateVertically = truncateVertically;
    }

    public static Container encloseIn(int columns, Component ... cmps) {
        return TableLayout.encloseIn(columns, true, cmps);
    }

    public static Container encloseIn(int columns, boolean growHorizontally, Component ... cmps) {
        int rows = cmps.length;
        rows = rows % columns > 0 ? rows / columns + 1 : (rows /= columns);
        TableLayout tl = new TableLayout(rows, columns);
        tl.setGrowHorizontally(growHorizontally);
        return Container.encloseIn((Layout)tl, cmps);
    }

    public boolean overridesTabIndices(Container parent) {
        return true;
    }

    protected Component[] getChildrenInTraversalOrder(Container parent) {
        int len = this.tablePositions.length;
        Component[] out = new Component[len];
        for (int i = 0; i < len; ++i) {
            Constraint con = this.tablePositions[i];
            if (con == null) continue;
            out[i] = this.tablePositions[i].parent;
        }
        return out;
    }

    static /* synthetic */ int access$000() {
        return defaultColumnWidth;
    }

    static /* synthetic */ int access$100() {
        return defaultRowHeight;
    }

    public static class Constraint {
        private Component parent;
        private int row = -1;
        private int column = -1;
        private int width = TableLayout.access$000();
        private int height = TableLayout.access$100();
        private int spanHorizontal = 1;
        private int spanVertical = 1;
        private int align = -1;
        private int valign = -1;
        int actualRow = -1;
        int actualColumn = -1;

        public String toString() {
            return "row: " + this.row + " column: " + this.column + " width: " + this.width + " height: " + this.height + " hspan: " + this.spanHorizontal + " vspan: " + this.spanVertical + " align " + this.align + " valign " + this.valign;
        }

        public void setVerticalSpan(int span) {
            if (span < 1) {
                throw new IllegalArgumentException("Illegal span");
            }
            this.spanVertical = span;
        }

        public Constraint verticalSpan(int span) {
            this.setVerticalSpan(span);
            return this;
        }

        public Constraint vs(int span) {
            return this.verticalSpan(span);
        }

        public void setHorizontalSpan(int span) {
            if (span < 1) {
                throw new IllegalArgumentException("Illegal span");
            }
            this.spanHorizontal = span;
        }

        public Constraint horizontalSpan(int span) {
            this.setHorizontalSpan(span);
            return this;
        }

        public Constraint hs(int span) {
            return this.horizontalSpan(span);
        }

        public void setWidthPercentage(int width) {
            this.width = width;
        }

        public Constraint widthPercentage(int width) {
            this.width = width;
            return this;
        }

        public Constraint wp(int width) {
            return this.widthPercentage(width);
        }

        public void setHeightPercentage(int height) {
            this.height = height;
        }

        public Constraint heightPercentage(int height) {
            this.height = height;
            return this;
        }

        public Constraint hp(int height) {
            return this.heightPercentage(height);
        }

        public void setHorizontalAlign(int align) {
            this.align = align;
        }

        public Constraint horizontalAlign(int align) {
            this.align = align;
            return this;
        }

        public Constraint ha(int align) {
            return this.horizontalAlign(align);
        }

        public void setVerticalAlign(int valign) {
            this.valign = valign;
        }

        public Constraint verticalAlign(int valign) {
            this.valign = valign;
            return this;
        }

        public Constraint va(int valign) {
            return this.verticalAlign(valign);
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        public int getWidthPercentage() {
            return this.width;
        }

        public int getHeightPercentage() {
            return this.height;
        }

        public int getHorizontalSpan() {
            return this.spanHorizontal;
        }

        public int getVerticalSpan() {
            return this.spanVertical;
        }

        public int getHorizontalAlign() {
            return this.align;
        }

        public int getVerticalAlign() {
            return this.valign;
        }
    }
}

