/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl;

import com.codename1.impl.javase.JavaJMFSEPort;
import com.codename1.impl.javase.cef.JavaCEFSEPort;
import com.codename1.impl.javase.fx.JavaFXSEPort;

public class ImplementationFactory {
    private static ImplementationFactory instance = new ImplementationFactory();

    protected ImplementationFactory() {
    }

    public static ImplementationFactory getInstance() {
        return instance;
    }

    public static void setInstance(ImplementationFactory i) {
        instance = i;
    }

    public Object createImplementation() {
        boolean cefSupported = false;
        boolean fxSupported = false;
        try {
            Class.forName("javafx.embed.swing.JFXPanel");
            fxSupported = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Class.forName("org.cef.CefApp");
            cefSupported = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String implementation = System.getProperty("cn1.javase.implementation", "");
        if (implementation.equalsIgnoreCase("cef") && cefSupported) {
            return new JavaCEFSEPort();
        }
        if (implementation.equalsIgnoreCase("fx") && fxSupported) {
            return new JavaFXSEPort();
        }
        if (implementation.equalsIgnoreCase("jmf")) {
            return new JavaJMFSEPort();
        }
        if ("".equals(implementation)) {
            if (cefSupported) {
                return new JavaCEFSEPort();
            }
            if (fxSupported) {
                return new JavaFXSEPort();
            }
            return new JavaJMFSEPort();
        }
        return new JavaJMFSEPort();
    }
}

