/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.ui.CN;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.Resources;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CSSWatcher
implements Runnable {
    private Thread watchThread;
    private Thread pulseThread;
    private ServerSocket pulseSocket;
    private Process childProcess;
    private boolean closing;
    private static final int MIN_DESIGNER_VERSION = 6;

    public CSSWatcher() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (CSSWatcher.this.childProcess != null && CSSWatcher.this.childProcess.isAlive()) {
                    try {
                        CSSWatcher.this.closing = true;
                        CSSWatcher.this.childProcess.destroyForcibly();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSupported() {
        Throwable throwable;
        FileInputStream input;
        File userHome = new File(System.getProperty("user.home"));
        File cn1Home = new File(userHome, ".codenameone");
        File updateStatusProps = new File(cn1Home, "UpdateStatus.properties");
        File cn1Props = new File("codenameone_settings.properties");
        if (cn1Props.exists()) {
            Properties cn1Properties = new Properties();
            try {
                input = new FileInputStream(cn1Props);
                throwable = null;
                try {
                    cn1Properties.load(input);
                    String cssWatcherEnabled = cn1Properties.getProperty("csswatcher.enabled", null);
                    if (cssWatcherEnabled != null) {
                        boolean bl2 = "true".equals(cssWatcherEnabled.toLowerCase());
                        return bl2;
                    }
                }
                catch (Throwable cssWatcherEnabled) {
                    throwable = cssWatcherEnabled;
                    throw cssWatcherEnabled;
                }
                finally {
                    if (input != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)input).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            ((InputStream)input).close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CSSWatcher.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!updateStatusProps.exists()) return false;
        Properties updateStatusProperties = new Properties();
        try {
            input = new FileInputStream(updateStatusProps);
            throwable = null;
            try {
                updateStatusProperties.load(input);
                String designerVersionStr = updateStatusProperties.getProperty("designer", "0");
                Double designerVersionDbl = Double.parseDouble(designerVersionStr);
                if (!(designerVersionDbl >= 6.0)) return false;
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (input != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((InputStream)input).close();
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CSSWatcher.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public String unescapeXSI(String s) throws IOException {
        StringBuilder sb = new StringBuilder();
        int segmentStart = 0;
        int searchOffset = 0;
        while (true) {
            int pos;
            if ((pos = s.indexOf(92, searchOffset)) == -1) {
                if (segmentStart >= s.length()) break;
                sb.append(s.substring(segmentStart));
                break;
            }
            if (pos > segmentStart) {
                sb.append(s.substring(segmentStart, pos));
            }
            segmentStart = pos + 1;
            searchOffset = pos + 2;
        }
        return sb.toString();
    }

    private void watch() throws IOException {
        if (this.pulseSocket == null || this.pulseSocket.isClosed()) {
            this.pulseSocket = new ServerSocket(0);
            this.pulseThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Socket socket = CSSWatcher.this.pulseSocket.accept();
                            }
                        }
                        catch (IOException ex) {
                            Logger.getLogger(CSSWatcher.class.getName()).log(Level.SEVERE, null, ex);
                            continue;
                        }
                        break;
                    }
                }
            });
            this.pulseThread.setDaemon(true);
        }
        File javaBin = new File(System.getProperty("java.home"), "bin/java");
        final File srcFile = new File("css", "theme.css");
        String overrideInputs = System.getProperty("codename1.css.compiler.args.input", null);
        if (!srcFile.exists() && overrideInputs == null) {
            return;
        }
        if (overrideInputs == null) {
            System.out.println("Found theme.css file.  Watching for changes...");
        } else {
            if (overrideInputs.trim().isEmpty()) {
                System.out.println("CSS file " + overrideInputs + " does not exist.  Not activating CSS watcher");
                return;
            }
            System.out.println("Watching CSS files for changes: [" + overrideInputs + "]");
        }
        File destFile = new File("src", "theme.res");
        String overrideOutputs = System.getProperty("codename1.css.compiler.args.output", null);
        if (overrideOutputs != null) {
            destFile = new File(overrideOutputs);
        }
        File userHome = new File(System.getProperty("user.home"));
        File cn1Home = new File(userHome, ".codenameone");
        File designerJar = new File(cn1Home, "designer_1.jar");
        if (System.getProperty("codename1.designer.jar", null) != null) {
            designerJar = new File(System.getProperty("codename1.designer.jar", null));
        }
        String cefDir = System.getProperty("cef.dir", cn1Home + File.separator + "cef");
        ProcessBuilder pb = new ProcessBuilder(javaBin.getAbsolutePath(), "-jar", "-Dcli=true", "-Dcef.dir=" + cefDir, "-Dparent.port=" + this.pulseSocket.getLocalPort(), designerJar.getAbsolutePath(), "-css");
        List<String> args = pb.command();
        if (overrideInputs != null) {
            args.add("-input");
            args.add(overrideInputs);
            args.add("-output");
            args.add(overrideOutputs);
            args.add("-merge");
            args.add(System.getProperty("codename1.css.compiler.args.merge", null));
            args.add("-watch");
        } else {
            args.add(srcFile.getAbsolutePath());
            args.add(destFile.getAbsolutePath());
            args.add("-watch");
            args.add("-Dprism.order=sw");
        }
        Process p = pb.start();
        if (this.childProcess != null) {
            try {
                this.childProcess.destroyForcibly();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.childProcess = p;
        OutputStream stdin = p.getOutputStream();
        InputStream stderr = p.getErrorStream();
        final BufferedReader errorReader = new BufferedReader(new InputStreamReader(stderr));
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        String l;
                        while ((l = errorReader.readLine()) != null) {
                            System.err.println("CSS> " + l);
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(CSSWatcher.class.getName()).log(Level.SEVERE, null, ex);
                        continue;
                    }
                    break;
                }
            }
        }).start();
        InputStream stdout = p.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stdout));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stdin));
        final File fDestFile = destFile;
        final String fOverrideInputs = overrideInputs;
        block4: while (true) {
            try {
                while (true) {
                    String l;
                    if ((l = reader.readLine()) == null && !p.isAlive()) {
                        this.watchThread = null;
                        this.start();
                        break block4;
                    }
                    System.out.println("CSS> " + l);
                    if (!"::refresh::".equals(l)) continue;
                    Display.getInstance().callSerially(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (fOverrideInputs != null) {
                                    System.out.println("CSS File " + fOverrideInputs + " has been updated.  Reloading styles from " + fDestFile);
                                } else {
                                    System.out.println("CSS File " + srcFile + " has been updated.  Reloading styles from " + fDestFile);
                                }
                                Resources res = Resources.open((InputStream)new FileInputStream(fDestFile));
                                UIManager.getInstance().addThemeProps(res.getTheme(res.getThemeResourceNames()[0]));
                                Form f = CN.getCurrentForm();
                                if (f != null) {
                                    f.refreshTheme();
                                    f.revalidate();
                                }
                            }
                            catch (Exception err) {
                                err.printStackTrace();
                            }
                        }
                    });
                }
            }
            catch (Throwable t) {
                if (this.closing) {
                    return;
                }
                t.printStackTrace();
                if (p.isAlive()) continue;
                this.watchThread = null;
                this.start();
            }
            break;
        }
    }

    @Override
    public void run() {
        try {
            this.watch();
        }
        catch (Throwable t) {
            System.err.println("CSS watching failed");
            t.printStackTrace();
            this.watchThread = null;
        }
    }

    public void start() {
        if (this.watchThread == null) {
            this.watchThread = new Thread(this);
            this.watchThread.setDaemon(true);
            this.watchThread.start();
        }
    }
}

