/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.impl.CodenameOneImplementation;
import com.codename1.impl.javase.CSSWatcher;
import com.codename1.impl.javase.JavaSEPort;
import com.codename1.impl.javase.Simulator;
import com.codename1.impl.javase.SourceChangeWatcher;
import com.codename1.payment.PurchaseCallback;
import com.codename1.push.PushCallback;
import com.codename1.push.PushContent;
import com.codename1.ui.Component;
import com.codename1.ui.Display;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Executor {
    private static Class c;
    private static Object app;
    private static SourceChangeWatcher sourceWatcher;
    private static final boolean IS_MAC;
    private static final boolean isWindows;
    private static final boolean isDebug;
    private static final boolean usingHotswapAgent;

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        int dotPos = version.indexOf(46);
        int dashPos = version.indexOf(45);
        return Integer.parseInt(version.substring(0, dotPos > -1 ? dotPos : (dashPos > -1 ? dashPos : 1)));
    }

    static void setMacApplicationEventHandled(Object event, boolean handled) {
        if (event != null) {
            try {
                Method setHandledMethod = event.getClass().getDeclaredMethod("setHandled", Boolean.TYPE);
                setHandledMethod.invoke(event, handled);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Executor.main(Simulator.class, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(final Class launcherClass, final String[] argv) throws Exception {
        if (IS_MAC) {
            if (Executor.getJavaVersion() >= 9) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Class<?> quitHandlerClass = Class.forName("java.awt.desktop.QuitHandler");
                        Method setQuitHandler = Desktop.class.getDeclaredMethod("setQuitHandler", quitHandlerClass);
                        Object quitProxy = Proxy.newProxyInstance(Executor.class.getClassLoader(), new Class[]{quitHandlerClass}, new InvocationHandler(){

                            @Override
                            public Object invoke(Object o, Method method, Object[] os) throws Throwable {
                                if (method.getName().equals("handleQuitRequestWith")) {
                                    Class<?> quitResponseClass = Class.forName("java.awt.desktop.QuitResponse");
                                    Method cancelQuit = quitResponseClass.getDeclaredMethod("cancelQuit", new Class[0]);
                                    cancelQuit.invoke(os[1], new Object[0]);
                                    Executor.exit();
                                }
                                return null;
                            }
                        });
                        setQuitHandler.invoke((Object)Desktop.getDesktop(), quitProxy);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            } else {
                try {
                    Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
                    Object macApp = applicationClass.getConstructor(null).newInstance(null);
                    Class<?> applicationListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
                    Method addListenerMethod = applicationClass.getDeclaredMethod("addApplicationListener", applicationListenerClass);
                    Object proxy = Proxy.newProxyInstance(Executor.class.getClassLoader(), new Class[]{applicationListenerClass}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object o, Method method, Object[] os) throws Throwable {
                            if (method.getName().equals("handleQuit")) {
                                Executor.setMacApplicationEventHandled(os[0], true);
                                Executor.exit();
                                return null;
                            }
                            return null;
                        }
                    });
                    addListenerMethod.invoke(macApp, proxy);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        Executor.setProxySettings();
        if (CSSWatcher.isSupported()) {
            CSSWatcher cssWatcher = new CSSWatcher();
            cssWatcher.start();
        }
        final Properties p = new Properties();
        String currentDir = System.getProperty("user.dir");
        File props = new File(currentDir, "codenameone_settings.properties");
        if (!props.exists() && new File(currentDir, "common" + File.separator + "codenameone_settings.properties").exists()) {
            System.setProperty("user.dir", currentDir + File.separator + "common");
            currentDir = System.getProperty("user.dir");
            props = new File(currentDir, "codenameone_settings.properties");
        }
        if (props.exists()) {
            FileInputStream f = null;
            try {
                f = new FileInputStream(props);
                p.load(f);
                f.close();
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            System.out.println("Cannot find codenameone_settings.properties at " + props);
        }
        final File fProps = props;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    String packageName = p.getProperty("codename1.packageName");
                    String mainName = p.getProperty("codename1.mainName");
                    if (argv.length > 1) {
                        if (argv[1].equalsIgnoreCase("-force") || packageName == null) {
                            c = Class.forName(argv[0]);
                        } else {
                            c = Class.forName(packageName + "." + mainName);
                        }
                    } else if (packageName == null || System.getenv("FORCE_CLASS") != null) {
                        c = Class.forName(argv[0]);
                    } else {
                        c = Class.forName(packageName + "." + mainName);
                    }
                    try {
                        Method m = c.getDeclaredMethod("main", String[].class);
                        m.invoke(null, new Object[]{null});
                    }
                    catch (NoSuchMethodException noMain) {
                        try {
                            Method m = c.getDeclaredMethod("startApp", new Class[0]);
                            m.invoke(c.newInstance(), new Object[0]);
                        }
                        catch (NoSuchMethodException noStartApp) {
                            Method m;
                            if (Display.isInitialized()) {
                                Display.deinitialize();
                            }
                            if ((m = c.getMethod("init", Object.class)).getExceptionTypes() != null && m.getExceptionTypes().length > 0) {
                                System.err.println("ERROR: the init method can't declare a throws clause");
                                System.exit(1);
                            }
                            app = c.newInstance();
                            if (app instanceof PushCallback) {
                                CodenameOneImplementation.setPushCallback((PushCallback)((PushCallback)app));
                            }
                            if (app instanceof PurchaseCallback) {
                                CodenameOneImplementation.setPurchaseCallback((PurchaseCallback)((PurchaseCallback)app));
                            }
                            Display.init(null);
                            if (isDebug && usingHotswapAgent) {
                                System.out.println("Hotswap Agent Detected.  Starting source watcher");
                                Executor.startSourceWatcher(fProps, launcherClass);
                                if (sourceWatcher != null) {
                                    sourceWatcher.setApp(app);
                                }
                            } else {
                                System.out.println("Hotswap Agent not detected. To enable enhanced live class reloading feature, run with DCEVM JDK and add -XX:HotswapAgent=core to the VM options");
                            }
                            Display.getInstance().callSerially(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        m.invoke(app, new Object[]{null});
                                        Method start = c.getMethod("start", new Class[0]);
                                        if (start.getExceptionTypes() != null && start.getExceptionTypes().length > 0) {
                                            System.err.println("ERROR: the start method can't declare a throws clause");
                                            System.exit(1);
                                        }
                                        start.invoke(app, new Object[0]);
                                    }
                                    catch (NoSuchMethodException err) {
                                        System.out.println("Couldn't find a main or a startup in " + argv[0]);
                                    }
                                    catch (InvocationTargetException err) {
                                        err.getTargetException().printStackTrace();
                                        System.exit(1);
                                    }
                                    catch (Exception err) {
                                        err.printStackTrace();
                                        System.exit(1);
                                    }
                                }
                            });
                        }
                    }
                }
                catch (Exception err) {
                    err.printStackTrace();
                    System.exit(1);
                }
            }
        });
    }

    public static void stopApp() {
        if (c != null && app != null) {
            try {
                Method stop = c.getMethod("stop", new Class[0]);
                if (stop.getExceptionTypes() != null && stop.getExceptionTypes().length > 0) {
                    System.err.println("ERROR: the stop method can't declare a throws clause");
                    System.exit(1);
                }
                stop.invoke(app, new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void destroyApp() {
        if (c != null && app != null) {
            try {
                Method stop = c.getMethod("destroy", new Class[0]);
                stop.invoke(app, new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void startApp() {
        if (c != null && app != null) {
            Display.getInstance().callSerially(new Runnable(){

                @Override
                public void run() {
                    try {
                        Method start = c.getMethod("start", new Class[0]);
                        if (start.getExceptionTypes() != null && start.getExceptionTypes().length > 0) {
                            System.err.println("ERROR: the start method can't declare a throws clause");
                            System.exit(1);
                        }
                        start.invoke(app, new Object[0]);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
    }

    public static void registerForPush(final String key) {
        if (c != null && app != null) {
            Display.getInstance().callSerially(new Runnable(){

                @Override
                public void run() {
                    try {
                        Method registeredForPush = c.getDeclaredMethod("registeredForPush", String.class);
                        registeredForPush.invoke(app, key);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
    }

    public static void pushRegistrationError(final String message, final int code) {
        if (c != null && app != null) {
            Display.getInstance().callSerially(new Runnable(){

                @Override
                public void run() {
                    try {
                        Method pushRegistrationError = c.getDeclaredMethod("pushRegistrationError", String.class, Integer.class);
                        pushRegistrationError.invoke(app, message, code);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
    }

    public static void push(final String message, final int type) {
        if (c != null && app != null) {
            Display.getInstance().callSerially(new Runnable(){

                @Override
                public void run() {
                    try {
                        String messageBody = message;
                        Element messageBodyEl = null;
                        String messageType = "" + type;
                        byte messageTypeByte = (byte)type;
                        if (type == 99) {
                            try {
                                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                                DocumentBuilder builder = factory.newDocumentBuilder();
                                if (!messageBody.startsWith("<?xml")) {
                                    messageBody = "<?xml version=\"1.0\"?>" + messageBody;
                                }
                                ByteArrayInputStream input = new ByteArrayInputStream(messageBody.getBytes("UTF-8"));
                                Document doc = builder.parse(input);
                                Element root = doc.getDocumentElement();
                                messageType = "1";
                                messageTypeByte = 1;
                                if (root.hasAttribute("type")) {
                                    messageTypeByte = (byte)Integer.parseInt(root.getAttribute("type"));
                                    messageType = "" + messageTypeByte;
                                }
                                messageBody = "";
                                if (root.hasAttribute("body")) {
                                    messageBody = root.getAttribute("body");
                                }
                                messageBodyEl = root;
                            }
                            catch (Exception x) {
                                System.err.println("Failed to parse XML messagse body");
                                x.printStackTrace();
                                return;
                            }
                        }
                        Method push = c.getDeclaredMethod("push", String.class);
                        String[] actionIds = null;
                        String[] actionLabels = null;
                        ImageIcon imageIcon = null;
                        PushContent.reset();
                        if (messageBodyEl != null) {
                            NodeList images = messageBodyEl.getElementsByTagName("img");
                            if (images.getLength() > 0) {
                                Element img = (Element)images.item(0);
                                PushContent.setImageUrl((String)img.getAttribute("src"));
                                if (!img.getAttribute("src").startsWith("https://")) {
                                    System.err.println("Push message includes image attachment at non-secure URL.  Image will not be displayed on iOS.  Make sure all image attachments use https://");
                                }
                                BufferedImage image = ImageIO.read(new URL(img.getAttribute("src")));
                                imageIcon = new ImageIcon(Executor.fitImage(image, 512, 512));
                                JavaSEPort.instance.checkRichPushBuildHints();
                            }
                            if (messageBodyEl.hasAttribute("category")) {
                                PushContent.setCategory((String)messageBodyEl.getAttribute("category"));
                                JavaSEPort.instance.checkRichPushBuildHints();
                                try {
                                    Object[] categories;
                                    Method getPushActionCategories = c.getDeclaredMethod("getPushActionCategories", new Class[0]);
                                    Class<?> pushActionCategoryCls = c.getClassLoader().loadClass("com.codename1.push.PushActionCategory");
                                    Method getCategoryId = pushActionCategoryCls.getDeclaredMethod("getId", new Class[0]);
                                    Object foundCategory = null;
                                    if (getPushActionCategories != null && (categories = (Object[])getPushActionCategories.invoke(app, new Object[0])) != null) {
                                        for (Object category : categories) {
                                            if (!messageBodyEl.getAttribute("category").equals(getCategoryId.invoke(category, new Object[0]))) continue;
                                            foundCategory = category;
                                            break;
                                        }
                                    }
                                    if (foundCategory != null) {
                                        Method getActions = pushActionCategoryCls.getDeclaredMethod("getActions", new Class[0]);
                                        Object[] actions = (Object[])getActions.invoke(foundCategory, new Object[0]);
                                        actionIds = new String[actions.length];
                                        actionLabels = new String[actions.length];
                                        Class<?> pushActionCls = c.getClassLoader().loadClass("com.codename1.push.PushAction");
                                        Method getActionId = pushActionCls.getDeclaredMethod("getId", new Class[0]);
                                        Method getActionTitle = pushActionCls.getDeclaredMethod("getTitle", new Class[0]);
                                        Method getActionIcon = pushActionCls.getDeclaredMethod("getIcon", new Class[0]);
                                        for (int i = 0; i < actions.length; ++i) {
                                            actionIds[i] = (String)getActionId.invoke(actions[i], new Object[0]);
                                            actionLabels[i] = (String)getActionTitle.invoke(actions[i], new Object[0]);
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        }
                        String[] parts = null;
                        int result = 0;
                        Display.getInstance().setProperty("pushType", "" + messageTypeByte);
                        switch (messageTypeByte) {
                            case 0: 
                            case 1: {
                                PushContent.setBody((String)messageBody);
                                PushContent.setType((int)1);
                                if (Display.getInstance().isMinimized()) {
                                    if (actionIds != null) {
                                        result = JOptionPane.showOptionDialog(null, messageBody, messageBody, 0, 1, imageIcon, actionLabels, null);
                                        if (result >= 0) {
                                            PushContent.setActionId((String)actionIds[result]);
                                        }
                                    } else {
                                        result = JOptionPane.showOptionDialog(null, messageBody, messageBody, 0, 1, imageIcon, new String[]{"OK"}, null);
                                    }
                                    if (result >= 0) {
                                        JavaSEPort.resumeApp();
                                    }
                                }
                                if (result >= 0) {
                                    push.invoke(app, messageBody);
                                }
                                break;
                            }
                            case 2: {
                                PushContent.setMetaData((String)messageBody);
                                PushContent.setType((int)2);
                                push.invoke(app, messageBody);
                                break;
                            }
                            case 3: {
                                parts = messageBody.split(";");
                                PushContent.setMetaData((String)parts[1]);
                                PushContent.setBody((String)parts[0]);
                                PushContent.setType((int)3);
                                if (Display.getInstance().isMinimized()) {
                                    if (actionIds != null) {
                                        result = JOptionPane.showOptionDialog(null, parts[0], parts[0], 0, 1, imageIcon, actionLabels, null);
                                        if (result >= 0) {
                                            PushContent.setActionId((String)actionIds[result]);
                                        }
                                    } else {
                                        result = JOptionPane.showOptionDialog(null, parts[0], parts[0], 0, 1, imageIcon, new String[]{"OK"}, null);
                                    }
                                    if (result >= 0) {
                                        JavaSEPort.resumeApp();
                                    }
                                }
                                if (result >= 0) {
                                    Display.getInstance().setProperty("pushType", "1");
                                    push.invoke(app, parts[0]);
                                    Display.getInstance().setProperty("pushType", "2");
                                    push.invoke(app, parts[1]);
                                }
                                break;
                            }
                            case 4: {
                                parts = messageBody.split(";");
                                PushContent.setTitle((String)parts[0]);
                                PushContent.setBody((String)parts[1]);
                                PushContent.setType((int)4);
                                if (Display.getInstance().isMinimized()) {
                                    if (actionIds != null) {
                                        result = JOptionPane.showOptionDialog(null, parts[1], parts[0], 0, 1, imageIcon, actionLabels, null);
                                        if (result >= 0) {
                                            PushContent.setActionId((String)actionIds[result]);
                                        }
                                    } else {
                                        result = JOptionPane.showOptionDialog(null, parts[1], parts[0], 0, 1, imageIcon, new String[]{"OK"}, null);
                                    }
                                    if (result >= 0) {
                                        JavaSEPort.resumeApp();
                                    }
                                }
                                if (result >= 0) {
                                    Display.getInstance().setProperty("pushType", "4");
                                    push.invoke(app, parts[0] + ";" + parts[1]);
                                }
                                break;
                            }
                            case 5: {
                                PushContent.setBody((String)messageBody);
                                PushContent.setType((int)1);
                                if (Display.getInstance().isMinimized()) {
                                    if (actionIds != null) {
                                        result = JOptionPane.showOptionDialog(null, messageBody, messageBody, 0, 1, imageIcon, actionLabels, null);
                                        if (result >= 0) {
                                            PushContent.setActionId((String)actionIds[result]);
                                        }
                                    } else {
                                        result = JOptionPane.showOptionDialog(null, messageBody, messageBody, 0, 1, imageIcon, new String[]{"OK"}, null);
                                    }
                                    if (result >= 0) {
                                        JavaSEPort.resumeApp();
                                    }
                                }
                                if (result >= 0) {
                                    Display.getInstance().setProperty("pushType", "1");
                                    push.invoke(app, messageBody);
                                }
                                break;
                            }
                            case 101: {
                                PushContent.setBody((String)messageBody.substring(messageBody.indexOf(" ") + 1));
                                PushContent.setType((int)1);
                                if (Display.getInstance().isMinimized()) {
                                    if (actionIds != null) {
                                        result = JOptionPane.showOptionDialog(null, messageBody.substring(messageBody.indexOf(" ") + 1), messageBody.substring(messageBody.indexOf(" ") + 1), 0, 1, imageIcon, actionLabels, null);
                                        if (result >= 0) {
                                            PushContent.setActionId((String)actionIds[result]);
                                        }
                                    } else {
                                        result = JOptionPane.showOptionDialog(null, messageBody.substring(messageBody.indexOf(" ") + 1), messageBody.substring(messageBody.indexOf(" ") + 1), 0, 1, imageIcon, new String[]{"OK"}, null);
                                    }
                                    if (result >= 0) {
                                        JavaSEPort.resumeApp();
                                    }
                                }
                                if (result >= 0) {
                                    push.invoke(app, messageBody.substring(messageBody.indexOf(" ") + 1));
                                }
                                break;
                            }
                            case 102: {
                                parts = messageBody.split(";");
                                PushContent.setTitle((String)parts[1]);
                                PushContent.setBody((String)parts[2]);
                                PushContent.setType((int)2);
                                if (Display.getInstance().isMinimized()) {
                                    if (actionIds != null) {
                                        result = JOptionPane.showOptionDialog(null, parts[2], parts[1], 0, 1, imageIcon, actionLabels, null);
                                        if (result >= 0) {
                                            PushContent.setActionId((String)actionIds[result]);
                                        }
                                    } else {
                                        result = JOptionPane.showOptionDialog(null, parts[2], parts[1], 0, 1, imageIcon, new String[]{"OK"}, null);
                                    }
                                    if (result >= 0) {
                                        JavaSEPort.resumeApp();
                                    }
                                }
                                if (result >= 0) {
                                    push.invoke(app, parts[1] + ";" + parts[2]);
                                }
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unsupported push type: " + messageTypeByte);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
    }

    private static void setProxySettings() {
        Preferences proxyPref = Preferences.userNodeForPackage(Component.class);
        int proxySel = proxyPref.getInt("proxySel", 2);
        String proxySelHttp = proxyPref.get("proxySel-http", "");
        String proxySelPort = proxyPref.get("proxySel-port", "");
        switch (proxySel) {
            case 1: {
                System.getProperties().remove("java.net.useSystemProxies");
                System.getProperties().remove("http.proxyHost");
                System.getProperties().remove("http.proxyPort");
                System.getProperties().remove("https.proxyHost");
                System.getProperties().remove("https.proxyPort");
                break;
            }
            case 2: {
                System.setProperty("java.net.useSystemProxies", "true");
                System.getProperties().remove("http.proxyHost");
                System.getProperties().remove("http.proxyPort");
                System.getProperties().remove("https.proxyHost");
                System.getProperties().remove("https.proxyPort");
                break;
            }
            case 3: {
                System.setProperty("http.proxyHost", proxySelHttp);
                System.setProperty("http.proxyPort", proxySelPort);
                System.setProperty("https.proxyHost", proxySelHttp);
                System.setProperty("https.proxyPort", proxySelPort);
            }
        }
    }

    static Object getApp() {
        return app;
    }

    private static Image fitImage(Image img, int w, int h) {
        BufferedImage resizedimage = new BufferedImage(w, h, 1);
        Graphics2D g2 = resizedimage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(img, 0, 0, w, h, null);
        g2.dispose();
        return resizedimage;
    }

    private static void exit() {
        Display.getInstance().callSerially(new Runnable(){

            @Override
            public void run() {
                Executor.stopApp();
                Executor.destroyApp();
                Display.getInstance().exitApplication();
            }
        });
    }

    private static void startSourceWatcher(File codenameOneSettingsFile, Class launcherClass) throws IOException {
        File hotswapPropsFile;
        InputStream hotswapPropsStream;
        File props = codenameOneSettingsFile;
        sourceWatcher = new SourceChangeWatcher();
        File srcMain = new File(props.getParentFile(), "src" + File.separator + "main" + File.separator + "java");
        if (srcMain.exists()) {
            sourceWatcher.addWatchFolder(srcMain);
        }
        if ((hotswapPropsStream = (hotswapPropsFile = new File(props.getParentFile().getParentFile(), "javase" + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + "hotswap-agent.properties")).exists() ? new FileInputStream(hotswapPropsFile) : launcherClass.getResourceAsStream("/hotswap-agent.properties")) != null) {
            System.out.println("Found hotswap-agent.properties file");
            Properties hotswapProps = new Properties();
            hotswapProps.load(hotswapPropsStream);
            System.out.println("Hotswap Properties:" + hotswapProps);
            try {
                hotswapPropsStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String extraClasspath = hotswapProps.getProperty("extraClasspath");
            if (extraClasspath != null) {
                String[] extraPaths;
                System.out.println("extraClasspath=" + extraClasspath);
                for (String extraPath : extraPaths = extraClasspath.split(";")) {
                    File kotlin;
                    File src;
                    if ((extraPath = extraPath.trim()).isEmpty()) continue;
                    File extraPathFile = new File(extraPath);
                    if (!extraPathFile.exists() || sourceWatcher.hasWatchFolder(extraPathFile)) {
                        System.out.println(extraPathFile + " not found");
                        continue;
                    }
                    if (extraPathFile.getName().equals("classes")) {
                        extraPathFile = extraPathFile.getParentFile();
                    }
                    if (extraPathFile.getName().equals("target")) {
                        extraPathFile = extraPathFile.getParentFile();
                    }
                    if (!(src = new File(extraPathFile, "src")).exists()) {
                        System.out.println(src + " not found");
                        continue;
                    }
                    File main = new File(src, "main");
                    if (!main.exists()) {
                        System.out.println(main + " not found");
                        continue;
                    }
                    File java = new File(main, "java");
                    if (java.exists()) {
                        sourceWatcher.addWatchFolder(java);
                    }
                    if (!(kotlin = new File(main, "kotlin")).exists()) continue;
                    sourceWatcher.addWatchFolder(kotlin);
                }
            }
        } else {
            System.out.println("Did not find hotswap-agent.properties file");
        }
        Thread sourceWatcherThread = new Thread(sourceWatcher);
        sourceWatcherThread.setDaemon(true);
        sourceWatcherThread.start();
    }

    static {
        String n = System.getProperty("os.name");
        if (n != null && n.startsWith("Mac")) {
            IS_MAC = true;
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Codename One GUIBuilder");
            System.setProperty("apple.eawt.quitStrategy", "CLOSE_ALL_WINDOWS");
        } else {
            IS_MAC = false;
        }
        isWindows = File.separatorChar == '\\';
        List<String> inputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        isDebug = inputArgs.toString().indexOf("-agentlib:jdwp") > 0;
        usingHotswapAgent = inputArgs.toString().indexOf("-XX:HotswapAgent") > 0;
    }
}

