/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.impl.javase.JavaSEPort;
import com.codename1.io.Log;
import com.codename1.media.AbstractMedia;
import com.codename1.media.AsyncMedia;
import com.codename1.media.Media;
import com.codename1.ui.CN;
import com.codename1.ui.Component;
import com.codename1.ui.Form;
import com.codename1.ui.Label;
import com.codename1.ui.PeerComponent;
import com.codename1.ui.Toolbar;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.Layout;
import com.codename1.util.AsyncResource;
import java.awt.Container;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.AudioDeviceUnavailableEvent;
import javax.media.ConnectionErrorEvent;
import javax.media.ControllerAdapter;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerListener;
import javax.media.DataLostErrorEvent;
import javax.media.EndOfMediaEvent;
import javax.media.InternalErrorEvent;
import javax.media.Manager;
import javax.media.Player;
import javax.media.ResourceUnavailableEvent;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.media.Time;
import javax.swing.JFrame;

public class JavaJMFSEPort
extends JavaSEPort {
    @Override
    public AsyncResource<Media> createMediaAsync(final InputStream stream, final String mimeType, final Runnable onCompletion) {
        final AsyncResource out = new AsyncResource();
        Container cnt = this.canvas.getParent();
        while (!(cnt instanceof JFrame)) {
            if ((cnt = cnt.getParent()) != null) continue;
            out.error((Throwable)new RuntimeException("Could not find canvas.  Cannot create media"));
            return out;
        }
        final Container fCnt = cnt;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    out.complete((Object)new CodenameOneMediaPlayer(stream, mimeType, (JFrame)fCnt, onCompletion, (AsyncResource<Media>)out));
                }
                catch (IOException ex) {
                    out.error((Throwable)ex);
                }
            }
        });
        return out;
    }

    @Override
    public AsyncResource<Media> createMediaAsync(final String uriAddress, final boolean isVideo, final Runnable onCompletion) {
        final AsyncResource out = new AsyncResource();
        Container cnt = this.canvas.getParent();
        while (!(cnt instanceof JFrame)) {
            if ((cnt = cnt.getParent()) != null) continue;
            out.error((Throwable)new RuntimeException("Could not find canvas.  Cannot create media"));
            return out;
        }
        final Container fCnt = cnt;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    out.complete((Object)new CodenameOneMediaPlayer(uriAddress, isVideo, (JFrame)fCnt, onCompletion, (AsyncResource<Media>)out));
                }
                catch (IOException ex) {
                    out.error((Throwable)ex);
                }
            }
        });
        return out;
    }

    public PeerComponent createBrowserComponent(Object browserComponent) {
        return null;
    }

    @Override
    public boolean isNativeBrowserComponentSupported() {
        return false;
    }

    public void addCompletionHandler(Media media, Runnable onCompletion) {
        super.addCompletionHandler(media, onCompletion);
        if (media instanceof CodenameOneMediaPlayer) {
            ((CodenameOneMediaPlayer)media).addCompletionHandler(onCompletion);
        }
    }

    class CodenameOneMediaPlayer
    extends AbstractMedia {
        private Timer endMediaPoller;
        private Runnable onCompletion;
        private List<Runnable> completionHandlers;
        private Player player;
        private boolean realized = false;
        private boolean isVideo;
        private JFrame frm;
        private boolean playing = false;
        private boolean nativePlayerMode;
        private AsyncResource<Media> _callback;
        private Runnable onPaused = new Runnable(){

            @Override
            public void run() {
                if (CodenameOneMediaPlayer.this.endMediaPoller != null) {
                    CodenameOneMediaPlayer.this.endMediaPoller.cancel();
                    CodenameOneMediaPlayer.this.endMediaPoller = null;
                }
                CodenameOneMediaPlayer.this.stopEndMediaPoller();
                CodenameOneMediaPlayer.this.playing = false;
                CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Paused);
            }
        };
        private Runnable onPlaying = new Runnable(){

            @Override
            public void run() {
                CodenameOneMediaPlayer.this.playing = true;
                CodenameOneMediaPlayer.this.startEndMediaPoller();
                CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Playing);
            }
        };
        private String lastErrorMessage;
        private AsyncMedia.MediaErrorType lastErrorType;
        private Runnable onError = new Runnable(){

            @Override
            public void run() {
                if (CodenameOneMediaPlayer.this._callback != null && !CodenameOneMediaPlayer.this._callback.isDone()) {
                    CodenameOneMediaPlayer.this._callback.error((Throwable)CodenameOneMediaPlayer.this.createMediaException(CodenameOneMediaPlayer.this.lastErrorMessage, CodenameOneMediaPlayer.this.lastErrorType));
                    return;
                }
                Log.p((String)CodenameOneMediaPlayer.this.lastErrorMessage);
                CodenameOneMediaPlayer.this.fireMediaError(CodenameOneMediaPlayer.this.createMediaException(CodenameOneMediaPlayer.this.lastErrorMessage, CodenameOneMediaPlayer.this.lastErrorType));
                if (!CodenameOneMediaPlayer.this.playing) {
                    CodenameOneMediaPlayer.this.stopEndMediaPoller();
                    CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Playing);
                    CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Paused);
                }
            }
        };
        private Component videoComponent;

        private boolean isPlayable(String uri) {
            return true;
        }

        public CodenameOneMediaPlayer(InputStream stream, String mimeType, JFrame f, Runnable onCompletion, AsyncResource<Media> callback) throws IOException {
            String suffix = JavaJMFSEPort.this.guessSuffixForMimetype(mimeType);
            File temp = File.createTempFile("mtmp", suffix);
            temp.deleteOnExit();
            FileOutputStream out = new FileOutputStream(temp);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = stream.read(buf, 0, buf.length)) > -1) {
                out.write(buf, 0, len);
            }
            stream.close();
            this.init(temp.toURI().toString(), mimeType.contains("video"), f, onCompletion, callback);
        }

        public CodenameOneMediaPlayer(String uri, boolean isVideo, JFrame f, Runnable onCompletion, AsyncResource<Media> callback) throws IOException {
            this.init(uri, isVideo, f, onCompletion, callback);
        }

        private void init(String uri, boolean isVideo, JFrame f, Runnable onCompletion, final AsyncResource<Media> callback) throws IOException {
            this.frm = f;
            this._callback = callback;
            if (onCompletion != null) {
                this.addCompletionHandler(onCompletion);
            }
            this.onCompletion = new Runnable(){

                @Override
                public void run() {
                    if (callback != null && !callback.isDone()) {
                        callback.complete((Object)CodenameOneMediaPlayer.this);
                    }
                    CodenameOneMediaPlayer.this.stopEndMediaPoller();
                    CodenameOneMediaPlayer.this.playing = false;
                    CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Paused);
                    CodenameOneMediaPlayer.this.fireCompletionHandlers();
                }
            };
            this.isVideo = isVideo;
            this.frm = f;
            try {
                File fff;
                if (uri.startsWith("file:")) {
                    uri = JavaJMFSEPort.this.unfile(uri);
                }
                if ((fff = new File(uri)).exists()) {
                    uri = fff.toURI().toURL().toExternalForm();
                }
                if (isVideo && !this.isPlayable(uri)) {
                    File temp = File.createTempFile("mtmp", ".mp4");
                    temp.deleteOnExit();
                    FileOutputStream out = new FileOutputStream(temp);
                    byte[] buf = new byte[1024];
                    int len = 0;
                    InputStream stream = new URL(uri).openStream();
                    while ((len = stream.read(buf, 0, buf.length)) > -1) {
                        out.write(buf, 0, len);
                    }
                    stream.close();
                    uri = temp.toURI().toURL().toExternalForm();
                }
                this.player = Manager.createRealizedPlayer((URL)new URL(uri));
                this.player.addControllerListener((ControllerListener)new ControllerAdapter(){

                    public void endOfMedia(EndOfMediaEvent e) {
                        System.out.println("Reached end of media");
                        CodenameOneMediaPlayer.this.onCompletion.run();
                    }

                    public void start(StartEvent e) {
                        System.out.println("In start event");
                        CodenameOneMediaPlayer.this.onPlaying.run();
                    }

                    public void stop(StopEvent e) {
                        System.out.println("In stop event");
                        CodenameOneMediaPlayer.this.onPaused.run();
                    }

                    public void connectionError(ConnectionErrorEvent e) {
                        CodenameOneMediaPlayer.this.lastErrorType = AsyncMedia.MediaErrorType.Network;
                        CodenameOneMediaPlayer.this.lastErrorMessage = e.getMessage();
                        CodenameOneMediaPlayer.this.onError.run();
                    }

                    public void dataLostError(DataLostErrorEvent e) {
                        CodenameOneMediaPlayer.this.lastErrorMessage = e.getMessage();
                        CodenameOneMediaPlayer.this.lastErrorType = AsyncMedia.MediaErrorType.Network;
                        CodenameOneMediaPlayer.this.onError.run();
                    }

                    public void internalError(InternalErrorEvent e) {
                        CodenameOneMediaPlayer.this.lastErrorMessage = e.getMessage();
                        CodenameOneMediaPlayer.this.lastErrorType = AsyncMedia.MediaErrorType.Unknown;
                    }

                    public void controllerError(ControllerErrorEvent e) {
                        CodenameOneMediaPlayer.this.lastErrorMessage = e.getMessage();
                        CodenameOneMediaPlayer.this.lastErrorType = AsyncMedia.MediaErrorType.Unknown;
                    }

                    public void resourceUnavailable(ResourceUnavailableEvent e) {
                        CodenameOneMediaPlayer.this.lastErrorMessage = e.getMessage();
                        CodenameOneMediaPlayer.this.lastErrorType = AsyncMedia.MediaErrorType.LineUnavailable;
                    }

                    public void audioDeviceUnavailable(AudioDeviceUnavailableEvent e) {
                        CodenameOneMediaPlayer.this.lastErrorMessage = "Audio device unavailable";
                        CodenameOneMediaPlayer.this.lastErrorType = AsyncMedia.MediaErrorType.LineUnavailable;
                    }
                });
            }
            catch (Exception ex) {
                if (callback != null && !callback.isDone()) {
                    callback.error((Throwable)ex);
                }
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }

        private AsyncMedia.MediaException createMediaException(String message, AsyncMedia.MediaErrorType type) {
            return new AsyncMedia.MediaException(type, message);
        }

        private void startEndMediaPoller() {
            this.stopEndMediaPoller();
            this.endMediaPoller = new Timer();
            this.endMediaPoller.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (!CodenameOneMediaPlayer.this.playing && CodenameOneMediaPlayer.this.player.getState() == 600) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!CodenameOneMediaPlayer.this.playing && CodenameOneMediaPlayer.this.player.getState() == 600) {
                                    CodenameOneMediaPlayer.this.playing = true;
                                    CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Playing);
                                }
                            }
                        });
                    } else if (CodenameOneMediaPlayer.this.playing && CodenameOneMediaPlayer.this.player.getState() != 600) {
                        CodenameOneMediaPlayer.this.stopEndMediaPoller();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (CodenameOneMediaPlayer.this.playing && CodenameOneMediaPlayer.this.player.getState() != 600) {
                                    CodenameOneMediaPlayer.this.playing = false;
                                    CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Paused);
                                }
                            }
                        });
                    }
                    double diff = CodenameOneMediaPlayer.this.player.getDuration().getNanoseconds() / 1000000L - CodenameOneMediaPlayer.this.player.getMediaTime().getNanoseconds() / 1000000L;
                    if (CodenameOneMediaPlayer.this.playing && diff < 0.01) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Runnable completionCallback;
                                double diff = CodenameOneMediaPlayer.this.player.getDuration().getNanoseconds() / 1000000L - CodenameOneMediaPlayer.this.player.getMediaTime().getNanoseconds() / 1000000L;
                                if (CodenameOneMediaPlayer.this.playing && diff < 0.01 && (completionCallback = CodenameOneMediaPlayer.this.onCompletion) != null) {
                                    completionCallback.run();
                                }
                            }
                        });
                    }
                }
            }, 100L, 100L);
        }

        private void stopEndMediaPoller() {
            if (this.endMediaPoller != null) {
                this.endMediaPoller.cancel();
                this.endMediaPoller = null;
            }
        }

        private void fireCompletionHandlers() {
            if (this.completionHandlers != null && !this.completionHandlers.isEmpty()) {
                CN.callSerially((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (CodenameOneMediaPlayer.this.completionHandlers != null && !CodenameOneMediaPlayer.this.completionHandlers.isEmpty()) {
                            ArrayList toRun;
                            CodenameOneMediaPlayer codenameOneMediaPlayer = CodenameOneMediaPlayer.this;
                            synchronized (codenameOneMediaPlayer) {
                                toRun = new ArrayList(CodenameOneMediaPlayer.this.completionHandlers);
                            }
                            for (Runnable r : toRun) {
                                r.run();
                            }
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCompletionHandler(Runnable onCompletion) {
            CodenameOneMediaPlayer codenameOneMediaPlayer = this;
            synchronized (codenameOneMediaPlayer) {
                if (this.completionHandlers == null) {
                    this.completionHandlers = new ArrayList<Runnable>();
                }
                this.completionHandlers.add(onCompletion);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeCompletionHandler(Runnable onCompletion) {
            if (this.completionHandlers != null) {
                CodenameOneMediaPlayer codenameOneMediaPlayer = this;
                synchronized (codenameOneMediaPlayer) {
                    this.completionHandlers.remove(onCompletion);
                }
            }
        }

        public void cleanup() {
            this.pause();
            this.player.deallocate();
        }

        public void prepare() {
            this.player.prefetch();
        }

        protected void playImpl() {
            if (this.isVideo && this.nativePlayerMode) {
                final Form currForm = CN.getCurrentForm();
                Form playerForm = new Form("Video Player", (Layout)new BorderLayout()){

                    protected void onShow() {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CodenameOneMediaPlayer.this.playInternal();
                            }
                        });
                    }
                };
                Toolbar tb = new Toolbar();
                playerForm.setToolbar(tb);
                tb.setBackCommand("Back", (ActionListener)new ActionListener<ActionEvent>(){

                    public void actionPerformed(ActionEvent e) {
                        CodenameOneMediaPlayer.this.pauseInternal();
                        currForm.showBack();
                    }
                });
                Component videoComponent = this.getVideoComponent();
                if (videoComponent.getComponentForm() != null) {
                    videoComponent.remove();
                }
                playerForm.addComponent((Object)"Center", videoComponent);
                playerForm.show();
                return;
            }
            this.playInternal();
        }

        private void playInternal() {
            if (this.player.getState() != 600) {
                this.player.start();
                this.startEndMediaPoller();
            }
        }

        private void pauseInternal() {
            if (this.player.getState() == 600) {
                this.player.stop();
                this.stopEndMediaPoller();
            }
        }

        protected void pauseImpl() {
            if (this.player.getState() == 600) {
                this.pauseInternal();
            }
        }

        public int getTime() {
            return (int)(this.player.getMediaTime().getNanoseconds() / 1000000L);
        }

        public void setTime(int time) {
            this.player.setMediaTime(new Time((long)time * 1000000L));
        }

        public int getDuration() {
            int d = (int)(this.player.getDuration().getNanoseconds() / 1000000L);
            if (d == 0) {
                return -1;
            }
            return d;
        }

        public void setVolume(int vol) {
            this.player.getGainControl().setLevel((float)vol / 100.0f);
        }

        public int getVolume() {
            return (int)this.player.getGainControl().getLevel() * 100;
        }

        public Component getVideoComponent() {
            if (this.videoComponent != null) {
                return this.videoComponent;
            }
            if (!this.isVideo) {
                return new Label();
            }
            final java.awt.Component awtComponent = this.player.getVisualComponent();
            if (awtComponent != null) {
                if (this.videoComponent == null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CodenameOneMediaPlayer.this.videoComponent = (Component)new JavaSEPort.Peer(CodenameOneMediaPlayer.this.frm, awtComponent);
                        }
                    });
                    CN.invokeAndBlock((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            while (CodenameOneMediaPlayer.this.videoComponent == null) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException ex) {
                                    Logger.getLogger(JavaJMFSEPort.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            }
                        }
                    });
                }
                return this.videoComponent;
            }
            System.out.println("Video Playing is not supported on this platform");
            Label l = new Label("Video");
            l.getStyle().setAlignment(4);
            return l;
        }

        public boolean isVideo() {
            return this.isVideo;
        }

        public boolean isFullScreen() {
            return false;
        }

        public void setFullScreen(boolean fullScreen) {
        }

        public boolean isPlaying() {
            return this.playing;
        }

        public void setNativePlayerMode(boolean nativePlayer) {
            this.nativePlayerMode = nativePlayer;
        }

        public boolean isNativePlayerMode() {
            return this.nativePlayerMode;
        }

        public void setVariable(String key, Object value) {
        }

        public Object getVariable(String key) {
            return null;
        }
    }
}

