/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.location.Location;
import com.codename1.ui.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class LocationSimulation
extends JFrame {
    private double iLastLat = 0.1;
    private double iLastLon = 0.1;
    public static final int E_MeasUnit_Default = -1;
    public static final int E_MeasUnit_Metric = 0;
    public static final int E_MeasUnit_Imperial = 1;
    public static final int E_MeasUnit_Nautical = 2;
    private static final String[] E_MeasUnitKmhString = new String[]{"km/h", "mph", "kn"};
    private static final String[] E_MeasUnitKmString = new String[]{"km", "mi", "nm"};
    private static final double[] E_MeasUnitPerKm = new double[]{1.0, 0.621371192237334, 0.5399568034557235};
    private static final String[] E_MeasUnitMString = new String[]{"m", "yd", "yd"};
    private static int zoom;
    public static final char[] E_MeasUnitS_ms_Char;
    private static final double E_Speed2Kmh = 3.6;
    public static final char[] E_MeasUnitS_ms2_Char;
    private static final double[] E_MeasUnitPerM;
    private JTextField accuracy;
    private JTextField altitude;
    private JTextField direction;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel lang;
    private JTextField latitude;
    private JComboBox locationState;
    private JLabel longi;
    private JTextField longitude;
    private JPanel mapPanel;
    private JComboBox unit;
    private JTextField velocity;

    public LocationSimulation() {
        this.initComponents();
        this.pack();
        this.setLocationByPlatform(true);
        Preferences p = Preferences.userNodeForPackage(Component.class);
        int startingZoom = p.getInt("lastZoom", 9);
        String htmlPage = "<!DOCTYPE html>\n<html>\n  <head>\n <script>\n(function() {\n    var lastTime = 0;\n    var vendors = ['ms', 'moz', 'webkit', 'o'];\n    for(var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {\n        window.requestAnimationFrame = window[vendors[x]+'RequestAnimationFrame'];\n        window.cancelAnimationFrame = window[vendors[x]+'CancelAnimationFrame'] \n                                   || window[vendors[x]+'CancelRequestAnimationFrame'];\n    }\n \n    if (!window.requestAnimationFrame)\n        window.requestAnimationFrame = function(callback, element) {\n            var currTime = new Date().getTime();\n            var timeToCall = Math.max(0, 16 - (currTime - lastTime));\n            var id = window.setTimeout(function() { callback(currTime + timeToCall); }, \n              timeToCall);\n            lastTime = currTime + timeToCall;\n            return id;\n        };\n \n    if (!window.cancelAnimationFrame)\n        window.cancelAnimationFrame = function(id) {\n            clearTimeout(id);\n        };\n}());\n</script>    <meta name=\"viewport\" content=\"initial-scale=1.0, user-scalable=no\" />\n    <style type=\"text/css\">\n      html { height: 100% }\n      body { height: 100%; margin: 0; padding: 0 }\n      #map-canvas { height: 100% }\n      .gm-style-mtc > div, .gm-style > div, .gm-style-cc > div, .gm-style {font-family:sans-serif !important;}\n    </style>\n    <script type=\"text/javascript\"\n      src=\"https://maps.googleapis.com/maps/api/js?key=API_KEY\">\n    </script>\n    <script type=\"text/javascript\">\nfunction moveToLocation(lat, lng){\n    var center = new google.maps.LatLng(lat, lng);\n    // using global variable:\n    document.map.panTo(center);\n}\nfunction initialize() {\nvar latlng = new google.maps.LatLng(40.714353, -74.005973 );\nvar myOptions = {\n  zoom: " + startingZoom + ",\n  center: latlng,\n  mapTypeControl: true,\n  navigationControl: true,\n  streetViewControl: true,\n  backgroundColor: \"#FFFFFF\"\n};\n\ndocument.geocoder = new google.maps.Geocoder();\ndocument.map = new google.maps.Map(document.getElementById(\"map_canvas\"),myOptions);\nconsole.log('map', document.map);\n\ndocument.marker = new google.maps.Marker({\n    position: document.map.getCenter(),\n    icon: {\n      path: google.maps.SymbolPath.CIRCLE,\n      scale: 5\n    },\n    map: document.map\n  });google.maps.event.addListener(document.map, 'drag', function() { document.marker.setPosition(document.map.getCenter()); } );}document.updateJavaFX = function updateJavaFX() {\n    document.currentCenter  = document.map.getCenter();\n    document.currentBounds  = document.map.getBounds();\n    document.currentHeading = document.map.getHeading();\n    document.currentZoom    = document.map.getZoom();\n    document.marker.setPosition(document.currentCenter);\n}    </script>\n  </head>\n <body onload=\"initialize()\">\n    <div id=\"map_canvas\" style=\"width:100%; height:100%\"></div>\n </body></html>";
    }

    private double getTextVal(String aText) {
        try {
            String l = aText;
            return Double.valueOf(l);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double getLatitude() {
        return this.getTextVal(this.latitude.getText());
    }

    public double getLongitude() {
        return this.getTextVal(this.longitude.getText());
    }

    @Override
    public int getState() {
        int index = this.locationState.getSelectedIndex();
        return index;
    }

    public void setLocation(Location aLoc) {
        this.locationState.setSelectedIndex(aLoc.getStatus());
        this.latitude.setText(aLoc.getLatitude() + "");
        this.longitude.setText(aLoc.getLongitude() + "");
        this.setVelocity(aLoc.getVelocity());
        this.setAltitude(aLoc.getAltitude());
        this.setAccuracy(aLoc.getAccuracy());
        this.direction.setText(aLoc.getDirection() + "");
        this.locationState.setSelectedIndex(aLoc.getStatus());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.latitude = new JTextField();
        this.longitude = new JTextField();
        this.locationState = new JComboBox();
        this.mapPanel = new JPanel();
        this.lang = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.longi = new JLabel();
        this.jLabel4 = new JLabel();
        this.altitude = new JTextField();
        this.velocity = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.direction = new JTextField();
        this.jLabel8 = new JLabel();
        this.accuracy = new JTextField();
        this.unit = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Latitude:");
        this.jLabel2.setText("Longitude:");
        this.latitude.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LocationSimulation.this.latitudeFocusLost(evt);
            }
        });
        this.latitude.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                LocationSimulation.this.latitudeMouseWheelMoved(evt);
            }
        });
        this.latitude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationSimulation.this.latitudeActionPerformed(evt);
            }
        });
        this.longitude.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LocationSimulation.this.longitudeFocusLost(evt);
            }
        });
        this.longitude.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                LocationSimulation.this.longitudeMouseWheelMoved(evt);
            }
        });
        this.longitude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationSimulation.this.longitudeActionPerformed(evt);
            }
        });
        this.locationState.setModel(new DefaultComboBoxModel<String>(new String[]{"Available", "Not-Available", "Temp-Not-Available"}));
        this.locationState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationSimulation.this.locationStateActionPerformed(evt);
            }
        });
        GroupLayout mapPanelLayout = new GroupLayout(this.mapPanel);
        this.mapPanel.setLayout(mapPanelLayout);
        mapPanelLayout.setHorizontalGroup(mapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        mapPanelLayout.setVerticalGroup(mapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 595, Short.MAX_VALUE));
        this.jLabel4.setText("Velocity:");
        this.altitude.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LocationSimulation.this.altitudeFocusLost(evt);
            }
        });
        this.altitude.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                LocationSimulation.this.altitudeMouseWheelMoved(evt);
            }
        });
        this.altitude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationSimulation.this.altitudeActionPerformed(evt);
            }
        });
        this.velocity.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LocationSimulation.this.velocityFocusLost(evt);
            }
        });
        this.velocity.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                LocationSimulation.this.velocityMouseWheelMoved(evt);
            }
        });
        this.velocity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationSimulation.this.velocityActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Altitude:");
        this.jLabel7.setText("Direction:");
        this.direction.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LocationSimulation.this.directionFocusLost(evt);
            }
        });
        this.direction.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                LocationSimulation.this.directionMouseWheelMoved(evt);
            }
        });
        this.direction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationSimulation.this.directionActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Accuracy:");
        this.accuracy.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LocationSimulation.this.accuracyFocusLost(evt);
            }
        });
        this.accuracy.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                LocationSimulation.this.accuracyMouseWheelMoved(evt);
            }
        });
        this.accuracy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationSimulation.this.accuracyActionPerformed(evt);
            }
        });
        this.unit.setModel(new DefaultComboBoxModel<String>(new String[]{"Metric [m],[km/h]", "Imperial [yd],[mph]", "Nautical [yd],[kn]"}));
        this.unit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationSimulation.this.unitActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lang, -2, 108, -2).addGap(0, 0, 0).addComponent(this.jLabel5).addGap(0, 0, 0).addComponent(this.longi, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mapPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.locationState, 0, 298, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.latitude).addComponent(this.longitude).addComponent(this.direction)))).addGap(18, 18, 18)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7, -2, 67, -2).addGap(173, 173, 173))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.unit, 0, 309, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4, -2, 57, -2).addComponent(this.jLabel6, -2, 57, -2)).addComponent(this.jLabel8)).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.accuracy).addComponent(this.velocity).addComponent(this.altitude)))))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationState, -2, -1, -2).addComponent(this.unit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.velocity, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.latitude, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.altitude).addComponent(this.longitude, -2, -1, -2)).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING, -2, 26, -2)).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE).addComponent(this.direction).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.accuracy).addComponent(this.jLabel8, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.mapPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.lang).addComponent(this.jLabel5, -2, 25, -2).addComponent(this.longi))));
        this.pack();
    }

    private void updateSave(ActionEvent evt) {
        try {
            String lat = this.latitude.getText();
            String lon = this.longitude.getText();
            if (lat.length() == 0 || lon.length() == 0) {
                return;
            }
            Double la = new Double(lat);
            Double d = new Double(lon);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void latitudeActionPerformed(ActionEvent evt) {
        this.updateSave(evt);
    }

    private void velocityActionPerformed(ActionEvent evt) {
        this.updateSave(evt);
    }

    private void altitudeActionPerformed(ActionEvent evt) {
        this.updateSave(evt);
    }

    private void accuracyActionPerformed(ActionEvent evt) {
        this.updateSave(evt);
    }

    private void directionActionPerformed(ActionEvent evt) {
        this.updateSave(evt);
    }

    private void longitudeActionPerformed(ActionEvent evt) {
        this.updateSave(evt);
    }

    private void locationStateActionPerformed(ActionEvent evt) {
        Preferences p = Preferences.userNodeForPackage(Component.class);
        p.putInt("state", this.locationState.getSelectedIndex());
    }

    private void unitActionPerformed(ActionEvent evt) {
        Preferences p = Preferences.userNodeForPackage(Component.class);
        p.putInt("unit", this.unit.getSelectedIndex());
    }

    private void latitudeMouseWheelMoved(MouseWheelEvent evt) {
        this.latitude.setText(this.updateWheelMoved(evt, this.latitude.getText(), 0.001));
        this.updateSave(null);
    }

    private void longitudeFocusLost(FocusEvent evt) {
        this.updateSave(null);
    }

    private String updateWheelMoved(MouseWheelEvent evt, String aVal, double aDelta) {
        int rot = evt.getWheelRotation();
        double n = this.getTextVal(aVal) - (double)rot * aDelta;
        return n + "";
    }

    private void longitudeMouseWheelMoved(MouseWheelEvent evt) {
        this.longitude.setText(this.updateWheelMoved(evt, this.longitude.getText(), 0.001));
        this.updateSave(null);
    }

    private void directionMouseWheelMoved(MouseWheelEvent evt) {
        this.direction.setText(this.updateWheelMoved(evt, this.direction.getText(), 15.0));
        this.updateSave(null);
    }

    private void velocityMouseWheelMoved(MouseWheelEvent evt) {
        this.velocity.setText(this.updateWheelMoved(evt, this.velocity.getText(), 10.0));
        this.updateSave(null);
    }

    private void altitudeMouseWheelMoved(MouseWheelEvent evt) {
        this.altitude.setText(this.updateWheelMoved(evt, this.altitude.getText(), 100.0));
    }

    private void accuracyMouseWheelMoved(MouseWheelEvent evt) {
        this.accuracy.setText(this.updateWheelMoved(evt, this.accuracy.getText(), 10.0));
        this.updateSave(null);
    }

    private void latitudeFocusLost(FocusEvent evt) {
        this.updateSave(null);
    }

    private void velocityFocusLost(FocusEvent evt) {
        this.updateSave(null);
    }

    private void altitudeFocusLost(FocusEvent evt) {
        this.updateSave(null);
    }

    private void accuracyFocusLost(FocusEvent evt) {
        this.updateSave(null);
    }

    private void directionFocusLost(FocusEvent evt) {
        this.updateSave(null);
    }

    float getAccuracy() {
        return (float)(this.getTextVal(this.accuracy.getText()) / E_MeasUnitPerM[this.unit.getSelectedIndex()]);
    }

    double getAltitude() {
        return this.getTextVal(this.altitude.getText()) / E_MeasUnitPerM[this.unit.getSelectedIndex()];
    }

    float getDirection() {
        return (float)this.getTextVal(this.direction.getText());
    }

    float getVelocity() {
        float s = (float)this.getTextVal(this.velocity.getText());
        s = (float)((double)s / 3.6 / E_MeasUnitPerKm[this.unit.getSelectedIndex()]);
        return s;
    }

    void setAccuracy(float aValue) {
        this.accuracy.setText((double)aValue * E_MeasUnitPerM[this.unit.getSelectedIndex()] + "");
    }

    void setAltitude(double aValue) {
        this.altitude.setText(aValue * E_MeasUnitPerM[this.unit.getSelectedIndex()] + "");
    }

    void setVelocity(float aValue) {
        this.velocity.setText((double)aValue * 3.6 * E_MeasUnitPerKm[this.unit.getSelectedIndex()] + "");
    }

    void setMeasUnit(int aInt) {
        this.unit.setSelectedIndex(aInt);
    }

    static {
        E_MeasUnitS_ms_Char = new char[]{'\'', 'h', 'h'};
        E_MeasUnitS_ms2_Char = new char[]{'\ufffd', '\"', 'h'};
        E_MeasUnitPerM = new double[]{1.0, 1.0936132983377078, 1.0936132983377078};
    }
}

