/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.db.Cursor;
import com.codename1.db.Row;
import com.codename1.db.RowExt;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SECursor
implements Cursor,
RowExt {
    private ResultSet resultSet;
    private boolean closed;

    public SECursor(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            System.out.println("**** WARNING! DB Cursor was released by the GC without being closed first! This might cause crashes on iOS *****");
        }
    }

    public boolean first() throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            return this.resultSet.first();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public boolean last() throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            return this.resultSet.last();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public boolean next() throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            return this.resultSet.next();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public boolean prev() throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            return this.resultSet.previous();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public int getColumnIndex(String columnName) throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            ResultSetMetaData meta = this.resultSet.getMetaData();
            int colsCount = meta.getColumnCount();
            for (int i = 0; i < colsCount; ++i) {
                String c = meta.getColumnLabel(i + 1);
                if (!c.equalsIgnoreCase(columnName)) continue;
                return i;
            }
            return -1;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public String getColumnName(int columnIndex) throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            ResultSetMetaData meta = this.resultSet.getMetaData();
            return meta.getColumnName(columnIndex + 1);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public int getPosition() throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            return this.resultSet.getRow();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public Row getRow() throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        return this;
    }

    public boolean position(int row) throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            return this.resultSet.absolute(row);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            this.closed = true;
            this.resultSet.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public byte[] getBlob(int index) throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            return this.resultSet.getBytes(index + 1);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public double getDouble(int index) throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            return this.resultSet.getDouble(index + 1);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public float getFloat(int index) throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            return this.resultSet.getFloat(index + 1);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public int getInteger(int index) throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            return this.resultSet.getInt(index + 1);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public long getLong(int index) throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            return this.resultSet.getLong(index + 1);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public short getShort(int index) throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            return this.resultSet.getShort(index + 1);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public String getString(int index) throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            return this.resultSet.getString(index + 1);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public boolean wasNull() throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            return this.resultSet.wasNull();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    public int getColumnCount() throws IOException {
        if (this.closed) {
            throw new IOException("Cursor is closed");
        }
        try {
            ResultSetMetaData meta = this.resultSet.getMetaData();
            return meta.getColumnCount();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }
}

