/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.impl.javase.ClassPathLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class Simulator {
    private static final String DEFAULT_SKIN = "/iPhoneX.skin";
    private static ClassPathLoader rootClassLoader;
    private static int cachedJavaVersion;
    private static String OS;
    private static boolean isWindows;
    private static boolean isMac;
    private static final String ARCH;
    private static boolean isUnix;
    private static final boolean is64Bit;

    public static void main(final String[] argv) throws Exception {
        ClassPathLoader ldr;
        String implementation;
        File jmf;
        File cef;
        boolean usingHotswapAgent;
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        System.setProperty("NSHighResolutionCapable", "true");
        String skin = System.getProperty("dskin");
        if (skin == null) {
            System.setProperty("dskin", DEFAULT_SKIN);
        }
        for (int i = 0; i < argv.length; ++i) {
            String argv1 = argv[i];
            if (!argv1.equals("resetSkins")) continue;
            System.setProperty("resetSkins", "true");
            System.setProperty("skin", DEFAULT_SKIN);
            System.setProperty("dskin", DEFAULT_SKIN);
        }
        if (System.getenv("CN1_SIMULATOR_SKIN") != null) {
            System.setProperty("skin", System.getenv("CN1_SIMULATOR_SKIN"));
        }
        String classPathStr = System.getProperty("java.class.path");
        if (System.getProperty("cn1.class.path") != null) {
            classPathStr = classPathStr + File.pathSeparator + System.getProperty("cn1.class.path");
        }
        StringTokenizer t = new StringTokenizer(classPathStr, File.pathSeparator);
        if (argv.length > 0) {
            System.setProperty("MainClass", argv[0]);
        }
        ArrayList<File> files = new ArrayList<File>();
        List<String> inputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
        boolean isDebug = inputArgs.toString().indexOf("-agentlib:jdwp") > 0;
        boolean bl = usingHotswapAgent = inputArgs.toString().indexOf("-XX:HotswapAgent") > 0;
        if (isDebug && usingHotswapAgent) {
            HotswapProperties hotswapProperties = new HotswapProperties();
            files.addAll(hotswapProperties.getExtraClasses());
        }
        int len = t.countTokens();
        for (int iter = 0; iter < len; ++iter) {
            files.add(new File(t.nextToken()));
        }
        File javase = new File("native" + File.separator + "javase");
        File libJavase = new File("lib" + File.separator + "impl" + File.separator + "native" + File.separator + "javase");
        for (File dir : new File[]{javase, libJavase}) {
            if (!dir.exists()) continue;
            for (File file : dir.listFiles()) {
                if (!file.getName().endsWith(".jar") || files.contains(file)) continue;
                files.add(file);
                System.setProperty("java.class.path", System.getProperty("java.class.path") + File.pathSeparator + file.getAbsolutePath());
            }
        }
        boolean cefSupported = false;
        boolean fxSupported = false;
        try {
            Class.forName("javafx.embed.swing.JFXPanel");
            fxSupported = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean fxOnSystemPath = fxSupported;
        File file = cef = System.getProperty("cef.dir") != null ? new File(System.getProperty("cef.dir")) : new File(System.getProperty("user.home") + File.separator + ".codenameone" + File.separator + "cef");
        if (cef.exists()) {
            if (isUnix && !is64Bit) {
                System.out.println("Found CEF, but not using because CEF is only supported on 64 bit platforms.  Try running inside a 64 bit JVM");
            } else {
                String bitSuffix;
                cefSupported = true;
                System.out.println("Adding CEF to classpath");
                String cn1LibPath = System.getProperty("cn1.library.path", ".");
                String string = bitSuffix = is64Bit ? "64" : "32";
                String nativeDir = isMac ? "macos64" : (isWindows ? "lib" + File.separator + "win" + bitSuffix : "lib" + File.separator + "linux" + bitSuffix);
                System.setProperty("cn1.library.path", cn1LibPath + File.pathSeparator + cef.getAbsolutePath() + File.separator + nativeDir);
                System.setProperty("java.library.path", cef.getAbsolutePath() + File.separator + nativeDir + File.pathSeparator + System.getProperty("java.library.path", "."));
                for (File jar : cef.listFiles()) {
                    if (!jar.getName().endsWith(".jar") || jar.getName().endsWith("-tests.jar")) continue;
                    files.add(jar);
                }
            }
        }
        if ((jmf = new File(System.getProperty("user.home") + File.separator + ".codenameone" + File.separator + "jmf-2.1.1e.jar")).exists()) {
            System.setProperty("java.class.path", System.getProperty("java.class.path") + File.pathSeparator + jmf.getAbsolutePath());
            files.add(jmf);
        }
        if ((implementation = System.getProperty("cn1.javase.implementation", "")).equalsIgnoreCase("cef") && !cefSupported) {
            System.err.println("cn1.javase.implementation=cef but CEF was not found.  Please update your Codename One libraries and try again.\nAlternatively, you can try using a different implementation.");
            System.exit(1);
        }
        if (implementation.equalsIgnoreCase("fx") && !fxSupported) {
            System.err.println("cn1.javase.implementation=fx but JavaFX was not found.  Please use a JDK that has JavaFX such as ZuluFX.  https://www.azul.com/downloads/zulu-community/");
            System.exit(1);
        }
        if ("".equals(implementation)) {
            if (cefSupported) {
                System.setProperty("cn1.javase.implementation", "cef");
            } else if (fxSupported) {
                System.setProperty("cn1.javase.implementation", "fx");
            } else {
                System.setProperty("cn1.javase.implementation", "jmf");
            }
        }
        ClassPathLoader classPathLoader = ldr = rootClassLoader == null ? new ClassPathLoader(files.toArray(new File[files.size()])) : new ClassPathLoader(rootClassLoader, files.toArray(new File[files.size()]));
        if (rootClassLoader == null) {
            rootClassLoader = ldr;
            ldr = new ClassPathLoader(rootClassLoader, files.toArray(new File[files.size()]));
        }
        ldr.addExclude("org.cef.");
        final ClassPathLoader classPathLoader2 = ldr;
        Class<?> c = Class.forName("com.codename1.impl.javase.Executor", true, ldr);
        Method m = c.getDeclaredMethod("main", String[].class);
        m.invoke(null, new Object[]{argv});
        new Thread(){

            @Override
            public void run() {
                String r;
                this.setContextClassLoader(classPathLoader2);
                do {
                    try {
                        1.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while ((r = System.getProperty("reload.simulator")) == null || !r.equals("true"));
                System.out.println("Detected reload of simulator");
                System.setProperty("reload.simulator", "");
                try {
                    Simulator.main(argv);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
    }

    private static void addToSystemClassLoader(File f) {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, f.toURI().toURL());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void loadFXRuntime() {
        String javahome = System.getProperty("java.home");
        String fx = javahome + "/lib/jfxrt.jar";
        File f = new File(fx);
        if (f.exists()) {
            Simulator.addToSystemClassLoader(f);
        }
    }

    private static String getJavaFXVersionStr() {
        return Simulator.getJavaVersion() == 8 ? "8" : "";
    }

    private static int getJavaVersion() {
        if (cachedJavaVersion < 0) {
            String version = System.getProperty("java.version");
            if (version.startsWith("1.")) {
                version = version.substring(2);
            }
            int dotPos = version.indexOf(46);
            int dashPos = version.indexOf(45);
            if (dotPos < 0 && dashPos < 0) {
                cachedJavaVersion = Integer.parseInt(version);
                return cachedJavaVersion;
            }
            cachedJavaVersion = Integer.parseInt(version.substring(0, dotPos > -1 ? dotPos : (dashPos > -1 ? dashPos : 1)));
            return cachedJavaVersion;
        }
        return cachedJavaVersion;
    }

    private static final boolean is64Bit() {
        String model = System.getProperty("sun.arch.data.model", System.getProperty("com.ibm.vm.bitmode"));
        if (model != null) {
            return "64".equals(model);
        }
        return "x86-64".equals(ARCH) || "ia64".equals(ARCH) || "ppc64".equals(ARCH) || "ppc64le".equals(ARCH) || "sparcv9".equals(ARCH) || "mips64".equals(ARCH) || "mips64el".equals(ARCH) || "amd64".equals(ARCH) || "aarch64".equals(ARCH);
    }

    static {
        cachedJavaVersion = -1;
        OS = System.getProperty("os.name").toLowerCase();
        isWindows = OS.indexOf("win") >= 0;
        isMac = OS.indexOf("mac") >= 0;
        ARCH = System.getProperty("os.arch");
        isUnix = OS.indexOf("nux") >= 0;
        is64Bit = Simulator.is64Bit();
    }

    private static class HotswapProperties {
        Properties props;

        private HotswapProperties() {
        }

        private File findHotswapPropertiesFile() {
            try {
                File currDir = new File(System.getProperty("user.dir")).getCanonicalFile();
                while (!new File(currDir, "javase").exists()) {
                    if ((currDir = currDir.getParentFile()) != null) continue;
                    return null;
                }
                File hotswapProps = new File(currDir, "javase" + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + "hotswap-agent.properties");
                if (hotswapProps.exists()) {
                    return hotswapProps;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties loadHotswapProperties() {
            Properties out = new Properties();
            File hotswapProps = this.findHotswapPropertiesFile();
            if (hotswapProps != null) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(hotswapProps);
                    out.load(fis);
                }
                catch (IOException ex) {
                    System.err.println("Failed to load hotswap properties file from " + hotswapProps);
                    ex.printStackTrace();
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            return out;
        }

        private Properties getProperties() {
            if (this.props == null) {
                this.props = this.loadHotswapProperties();
            }
            return this.props;
        }

        private List<File> getExtraClasses() {
            String extraClasspath = this.getProperties().getProperty("extraClasspath");
            if (extraClasspath == null || extraClasspath.trim().isEmpty()) {
                return new ArrayList<File>();
            }
            String[] parts = extraClasspath.split(";");
            ArrayList<File> files = new ArrayList<File>();
            for (String part : parts) {
                part = part.trim();
                files.add(new File(part));
            }
            return files;
        }
    }
}

