/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.testing.TestReporting;
import com.codename1.testing.UnitTest;
import com.codename1.ui.Display;
import java.awt.Container;
import java.awt.Frame;
import java.util.Timer;
import java.util.TimerTask;

public class TestExecuter {
    private static boolean failed;

    public static boolean runTest(String mainClass, String testClass, boolean quiteMode) {
        try {
            if (quiteMode) {
                Display.init((Object)new Container());
            } else {
                System.setProperty("dskin", "/iphone3gs.skin");
                Display.init(null);
            }
            final Class<?> mainCls = Class.forName(mainClass);
            Display.getInstance().callSeriallyAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object main = mainCls.newInstance();
                        main.getClass().getMethod("init", Object.class).invoke(main, new Object[]{null});
                        main.getClass().getMethod("start", new Class[0]).invoke(main, new Object[0]);
                    }
                    catch (Exception err) {
                        failed = true;
                        TestReporting.getInstance().logException((Throwable)err);
                    }
                }
            });
            try {
                final UnitTest test = (UnitTest)Class.forName(testClass).newInstance();
                final int timeout = test.getTimeoutMillis();
                if (test.shouldExecuteOnEDT()) {
                    Display.getInstance().callSeriallyAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                TestReporting.getInstance().startingTestCase(test);
                                test.prepare();
                                TestReporting.getInstance().logMessage("Test prepared for execution on EDT");
                                failed = !test.runTest();
                                test.cleanup();
                                TestReporting.getInstance().finishedTestCase(test, !failed);
                            }
                            catch (Exception err) {
                                failed = true;
                                TestReporting.getInstance().logException((Throwable)err);
                            }
                        }
                    }, timeout);
                } else {
                    Timer timeoutKiller = new Timer();
                    final Thread currentThread = Thread.currentThread();
                    TimerTask timeoutTask = new TimerTask(){

                        @Override
                        public void run() {
                            TestReporting.getInstance().logMessage("Test timeout occured: " + timeout + " milliseconds");
                            failed = true;
                            currentThread.stop();
                        }
                    };
                    timeoutKiller.schedule(timeoutTask, timeout);
                    TestReporting.getInstance().startingTestCase(test);
                    test.prepare();
                    TestReporting.getInstance().logMessage("Test prepared for execution off the EDT");
                    failed = !test.runTest();
                    test.cleanup();
                    TestReporting.getInstance().finishedTestCase(test, !failed);
                    timeoutTask.cancel();
                }
            }
            catch (Exception err) {
                failed = true;
                TestReporting.getInstance().logException((Throwable)err);
            }
            Display.deinitialize();
            for (Frame f : Frame.getFrames()) {
                if (f == null || !f.isShowing()) continue;
                f.dispose();
            }
            return !failed;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }
}

