/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase;

import com.codename1.impl.javase.JavaSEPort;
import com.codename1.testing.TestUtils;
import com.codename1.ui.Button;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Label;
import com.codename1.ui.List;
import com.codename1.ui.TextArea;
import com.codename1.ui.Toolbar;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.SelectionListener;
import com.codename1.ui.list.ContainerList;
import com.codename1.ui.list.ListModel;
import com.codename1.ui.spinner.GenericSpinner;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;

public class TestRecorder
extends JFrame {
    private Form currentForm;
    private long waitTimer = 0L;
    private int pointerPressedX;
    private int pointerPressedY;
    private boolean dragged;
    private int screenshots = 0;
    private static final String INITIAL_CODE = "package __PACKAGE_NAME__;\n\nimport com.codename1.testing.AbstractTest;\n\nimport com.codename1.ui.Display;\n\npublic class __TEST_NAME__ extends AbstractTest {\n    public boolean runTest() throws Exception {\n";
    private static final String CLOSING_CODE = "        return true;\n    }\n}\n";
    private String generatedCode = "";
    private JButton assertLabels;
    private JButton assertTextAreas;
    private JButton assertTitle;
    private JCheckBox dragToScroll;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private JToggleButton recording;
    private JButton saveRecording;
    private JButton screenshotTest;
    private JTextArea script;
    private JTextField testName;
    private JTextField testsPackage;

    public TestRecorder() {
        this.initComponents();
        File f = new File("codenameone_settings.properties");
        if (!f.exists()) {
            this.saveRecording.setEnabled(false);
        }
        Display.getInstance().callSerially(new Runnable(){

            @Override
            public void run() {
                Form f = Display.getInstance().getCurrent();
                if (f != null) {
                    TestRecorder.this.bindForm(f);
                }
                JavaSEPort.addFormChangeListener(new com.codename1.ui.events.ActionListener(){
                    Form oldForm;
                    int counter = 1;

                    private String getFormTitle(Form f) {
                        String s = null;
                        if (f.getToolbar() != null) {
                            Component cmp = f.getToolbar().getTitleComponent();
                            if (cmp instanceof Label) {
                                s = ((Label)cmp).getText();
                            }
                        } else {
                            s = f.getTitle();
                        }
                        if (s == null) {
                            return "";
                        }
                        return s;
                    }

                    public void actionPerformed(ActionEvent evt) {
                        Form newForm = Display.getInstance().getCurrent();
                        if (TestRecorder.this.isRecording()) {
                            if (newForm.getName() != null && newForm.getName().length() > 0) {
                                TestRecorder.this.generatedCode = TestRecorder.this.generatedCode + "        waitForFormName(\"" + newForm.getName() + "\");\n";
                            } else {
                                String ft = this.getFormTitle(newForm);
                                String oldT = "";
                                if (this.oldForm != null) {
                                    oldT = this.getFormTitle(this.oldForm);
                                }
                                if (ft.equals(oldT) || ft.length() == 0) {
                                    TestRecorder.this.generatedCode = TestRecorder.this.generatedCode + "        waitForUnnamedForm();\n";
                                } else {
                                    TestRecorder.this.generatedCode = TestRecorder.this.generatedCode + "        waitForFormTitle(\"" + ft + "\");\n";
                                }
                                TestRecorder.this.generatedCode = TestRecorder.this.generatedCode + "        Display.getInstance().getCurrent().setName(\"Form_" + this.counter + "\");\n";
                                Display.getInstance().getCurrent().setName("Form_" + this.counter);
                                ++this.counter;
                            }
                            TestRecorder.this.updateTestCode();
                            TestRecorder.this.resetWaitTimer();
                        }
                        TestRecorder.this.bindForm(newForm);
                        this.oldForm = newForm;
                    }
                });
            }
        });
    }

    void addWaitStatement() {
        if (this.isRecording()) {
            long t = System.currentTimeMillis();
            long d = t - this.waitTimer;
            this.generatedCode = this.generatedCode + "        waitFor(" + d + ");\n";
            this.waitTimer = t;
        }
    }

    private boolean isRecording() {
        return this.recording.isSelected();
    }

    void resetWaitTimer() {
        this.waitTimer = System.currentTimeMillis();
    }

    private void updateTestCode() {
        this.script.setText((INITIAL_CODE.replace("__PACKAGE_NAME__", this.testsPackage.getText()) + this.generatedCode + CLOSING_CODE).replace("__TEST_NAME__", this.testName.getText()));
    }

    private String toGameKeyConstant(int k) {
        switch (k) {
            case 6: {
                return "Display.GAME_DOWN";
            }
            case 2: {
                return "Display.GAME_LEFT";
            }
            case 5: {
                return "Display.GAME_RIGHT";
            }
            case 1: {
                return "Display.GAME_UP";
            }
            case 8: {
                return "Display.GAME_FIRE";
            }
        }
        return null;
    }

    void eventKeyPressed(int k) {
        if (this.isRecording()) {
            this.resetWaitTimer();
            int g = Display.getInstance().getGameAction(k);
            this.generatedCode = g <= 0 ? this.generatedCode + "        keyPress(" + k + ");\n" : this.generatedCode + "        gameKeyPress(" + this.toGameKeyConstant(g) + ");\n";
            this.updateTestCode();
        }
    }

    void eventKeyReleased(int k) {
        if (this.isRecording()) {
            this.addWaitStatement();
            int g = Display.getInstance().getGameAction(k);
            this.generatedCode = g <= 0 ? this.generatedCode + "        keyPress(" + k + ");\n" : this.generatedCode + "        gameKeyPress(" + this.toGameKeyConstant(g) + ");\n";
            this.updateTestCode();
        }
    }

    void eventPointerPressed(int x, int y) {
        this.pointerPressedX = x;
        this.pointerPressedY = y;
        this.dragged = false;
        this.resetWaitTimer();
    }

    private Component getCodenameOneComponentAt(int x, int y) {
        return Display.getInstance().getCurrent().getComponentAt(x, y);
    }

    private String getPathToComponent(Component cmp) {
        Container contentPane = cmp.getComponentForm().getContentPane();
        ArrayList<Integer> l = new ArrayList<Integer>();
        while (cmp != contentPane) {
            Container parent = cmp.getParent();
            if (parent == null) {
                return "(String)null";
            }
            l.add(0, parent.getComponentIndex(cmp));
            cmp = parent;
        }
        StringBuilder response = new StringBuilder("new int[]{");
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            response.append(iter.next());
            if (iter.hasNext()) {
                response.append(", ");
                continue;
            }
            response.append("}");
        }
        return response.toString();
    }

    private String generatePointerEventArguments(int x, int y) {
        String componentName;
        Component cmp = this.getCodenameOneComponentAt(x, y);
        if (cmp.getParent() instanceof Form) {
            cmp = cmp.getParent();
        }
        componentName = (componentName = cmp.getName()) == null ? this.getPathToComponent(cmp) : "\"" + componentName + "\"";
        float actualX = ((float)x - (float)cmp.getAbsoluteX()) / (float)cmp.getWidth();
        float actualY = ((float)y - (float)cmp.getAbsoluteY()) / (float)cmp.getHeight();
        return "(" + actualX + "f, " + actualY + "f, " + componentName + ");\n";
    }

    void eventPointerDragged(int x, int y) {
        if (this.isRecording()) {
            if (this.dragToScroll.isSelected()) {
                this.dragged = true;
            } else {
                if (!this.dragged) {
                    this.generatedCode = this.generatedCode + "        pointerPress" + this.generatePointerEventArguments(this.pointerPressedX, this.pointerPressedY);
                }
                this.dragged = true;
                this.addWaitStatement();
                this.generatedCode = this.generatedCode + "        pointerDrag" + this.generatePointerEventArguments(x, y);
                this.updateTestCode();
            }
        }
    }

    private void visitComponents(Container cnt, ComponentVisitor v) {
        v.visit((Component)cnt);
        int count = cnt.getComponentCount();
        for (int iter = 0; iter < count; ++iter) {
            Component current = cnt.getComponentAt(iter);
            if (current instanceof Container) {
                this.visitComponents((Container)current, v);
                continue;
            }
            v.visit(current);
        }
    }

    private Component findLowestVisibleComponent() {
        Form f = Display.getInstance().getCurrent();
        final Component[] cmp = new Component[1];
        this.visitComponents(f.getContentPane(), new ComponentVisitor(){
            int lowest = -1;

            @Override
            public void visit(Component c) {
                int abY = c.getAbsoluteY();
                if (abY > this.lowest && abY + c.getHeight() < Display.getInstance().getDisplayHeight()) {
                    this.lowest = abY;
                    cmp[0] = c;
                }
            }
        });
        return cmp[0];
    }

    private Component findHighestVisibleComponent() {
        Form f = Display.getInstance().getCurrent();
        final Component[] cmp = new Component[1];
        this.visitComponents(f.getContentPane(), new ComponentVisitor(){
            int highest = Display.getInstance().getDisplayHeight();

            @Override
            public void visit(Component c) {
                int abY = c.getAbsoluteY();
                if (abY < this.highest && abY >= 0) {
                    this.highest = abY;
                    cmp[0] = c;
                }
            }
        });
        return cmp[0];
    }

    private void bindListListener(final Component cmp, ListModel m) {
        if (cmp.getClientProperty("CN1$listenerBound") == null) {
            cmp.putClientProperty("CN1$listenerBound", (Object)Boolean.TRUE);
            m.addSelectionListener(new SelectionListener(){

                public void selectionChanged(int oldSelected, int newSelected) {
                    TestRecorder.this.generatedCode = TestRecorder.this.generatedCode + "        selectInList(" + TestRecorder.this.getPathOrName(cmp) + ", " + newSelected + ");\n";
                    TestRecorder.this.updateTestCode();
                }
            });
        }
    }

    private boolean isListComponent(Component cmp) {
        if (cmp instanceof List) {
            if (cmp.getParent() instanceof GenericSpinner) {
                cmp = cmp.getParent();
            } else {
                this.bindListListener(cmp, ((List)cmp).getModel());
                return true;
            }
        }
        if (cmp instanceof ContainerList) {
            this.bindListListener(cmp, ((ContainerList)cmp).getModel());
            return true;
        }
        if (cmp instanceof GenericSpinner) {
            this.bindListListener(cmp, ((GenericSpinner)cmp).getModel());
            return true;
        }
        return false;
    }

    public boolean isToolbarComponent(Component cmp) {
        while (cmp.getParent() != null) {
            if (!((cmp = cmp.getParent()) instanceof Toolbar)) continue;
            return true;
        }
        return false;
    }

    void eventPointerReleased(int x, int y) {
        if (this.isRecording()) {
            Component cmp = Display.getInstance().getCurrent().getComponentAt(x, y);
            if (this.isListComponent(cmp)) {
                return;
            }
            if (this.dragged) {
                if (this.dragToScroll.isSelected()) {
                    Component scrollTo = y > this.pointerPressedY ? this.findLowestVisibleComponent() : this.findHighestVisibleComponent();
                    if (scrollTo != null && scrollTo != Display.getInstance().getCurrent() && scrollTo != Display.getInstance().getCurrent().getContentPane()) {
                        String name = scrollTo.getName();
                        if (name != null) {
                            this.generatedCode = this.generatedCode + "        ensureVisible(\"" + name + "\");\n";
                        } else {
                            String pp = this.getPathToComponent(scrollTo);
                            if (pp == null) {
                                return;
                            }
                            this.generatedCode = this.generatedCode + "        ensureVisible(" + pp + ");\n";
                        }
                        this.updateTestCode();
                    }
                } else {
                    this.addWaitStatement();
                    this.generatedCode = this.generatedCode + "        pointerRelease" + this.generatePointerEventArguments(x, y);
                    this.updateTestCode();
                }
            } else {
                if (this.isToolbarComponent(cmp) && cmp instanceof Button) {
                    Command cmd = ((Button)cmp).getCommand();
                    if (cmd != null) {
                        Command[] commands;
                        int offset = 0;
                        for (Command c : commands = TestUtils.getToolbarCommands()) {
                            if (c == cmd) {
                                this.generatedCode = this.generatedCode + "        assertEqual(getToolbarCommands().length, " + commands.length + ");\n";
                                this.generatedCode = this.generatedCode + "        executeToolbarCommandAtOffset(" + offset + ");\n";
                                this.updateTestCode();
                                return;
                            }
                            ++offset;
                        }
                    } else if (cmp.getUIID().equals("MenuButton")) {
                        this.generatedCode = this.generatedCode + "        showSidemenu();\n";
                        this.updateTestCode();
                        return;
                    }
                }
                if (cmp instanceof Button) {
                    Button btn = (Button)cmp;
                    if (btn.getCommand() != null && btn.getCommand() == Display.getInstance().getCurrent().getBackCommand()) {
                        this.generatedCode = this.generatedCode + "        goBack();\n";
                    } else if (btn.getName() != null && btn.getName().length() > 0) {
                        this.generatedCode = this.generatedCode + "        clickButtonByName(\"" + btn.getName() + "\");\n";
                    } else if (btn.getText() != null && btn.getText().length() > 0) {
                        this.generatedCode = this.generatedCode + "        clickButtonByLabel(\"" + btn.getText() + "\");\n";
                    } else {
                        String pp = this.getPathToComponent(cmp);
                        if (pp == null || pp.equals("(String)null")) {
                            return;
                        }
                        this.generatedCode = this.generatedCode + "        clickButtonByPath(" + pp + ");\n";
                    }
                    this.updateTestCode();
                    return;
                }
                if (cmp instanceof TextArea) {
                    return;
                }
                this.generatedCode = this.generatedCode + "        pointerPress" + this.generatePointerEventArguments(this.pointerPressedX, this.pointerPressedY);
                this.addWaitStatement();
                this.generatedCode = this.generatedCode + "        pointerRelease" + this.generatePointerEventArguments(x, y);
                this.updateTestCode();
            }
        }
    }

    private String getPathOrName(Component cmp) {
        if (cmp.getName() == null || TestUtils.findByName((String)cmp.getName()) != cmp) {
            return this.getPathToComponent(cmp);
        }
        return "\"" + cmp.getName() + "\"";
    }

    void editTextFieldCompleted(Component cmp, String text) {
        this.generatedCode = this.generatedCode + "        setText(" + this.getPathOrName(cmp) + ", \"" + text + "\");\n";
    }

    private void bindForm(Form current) {
        this.currentForm = current;
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.recording = new JToggleButton();
        this.saveRecording = new JButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.script = new JTextArea();
        this.jLabel1 = new JLabel();
        this.testName = new JTextField();
        this.jLabel2 = new JLabel();
        this.testsPackage = new JTextField();
        this.jLabel3 = new JLabel();
        this.assertTitle = new JButton();
        this.assertLabels = new JButton();
        this.assertTextAreas = new JButton();
        this.screenshotTest = new JButton();
        this.jLabel4 = new JLabel();
        this.dragToScroll = new JCheckBox();
        FormListener formListener = new FormListener();
        this.setDefaultCloseOperation(2);
        this.setTitle("Test Recorder");
        this.jToolBar1.setRollover(true);
        this.recording.setIcon(new ImageIcon(this.getClass().getResource("/realvista_videoproduction_record_48.png")));
        this.recording.setToolTipText("Start/pause recording");
        this.recording.setFocusable(false);
        this.recording.setHorizontalTextPosition(0);
        this.recording.setIconTextGap(0);
        this.recording.setSelectedIcon(new ImageIcon(this.getClass().getResource("/realvista_videoproduction_pause_48.png")));
        this.recording.setVerticalTextPosition(3);
        this.recording.addActionListener(formListener);
        this.jToolBar1.add(this.recording);
        this.saveRecording.setIcon(new ImageIcon(this.getClass().getResource("/realvista_computergadgets_floppy_disk_48.png")));
        this.saveRecording.setBorder(null);
        this.saveRecording.setFocusable(false);
        this.saveRecording.setHorizontalTextPosition(0);
        this.saveRecording.setVerticalTextPosition(3);
        this.saveRecording.addActionListener(formListener);
        this.jToolBar1.add(this.saveRecording);
        this.getContentPane().add((java.awt.Component)this.jToolBar1, "First");
        this.script.setColumns(20);
        this.script.setEditable(false);
        this.script.setRows(5);
        this.jScrollPane1.setViewportView(this.script);
        this.jLabel1.setText("Test Name");
        this.testName.setText("UnnamedTest");
        this.jLabel2.setText("Package");
        this.testsPackage.setText("tests");
        this.jLabel3.setText("Asserts");
        this.assertTitle.setText("Title");
        this.assertTitle.setToolTipText("Insert an assert statement to the value of the current form title");
        this.assertTitle.addActionListener(formListener);
        this.assertLabels.setText("Labels");
        this.assertLabels.setToolTipText("Insert assert statements with the value all the labels in the form");
        this.assertLabels.addActionListener(formListener);
        this.assertTextAreas.setText("Text Areas");
        this.assertTextAreas.setToolTipText("Insert assert statements with the values of all the text areas in the form");
        this.assertTextAreas.addActionListener(formListener);
        this.screenshotTest.setText("Screenshot");
        this.screenshotTest.setToolTipText("<html><body>\nGenerate an automated screenshot test for repeated tests<br>\nnotice that this might break since versions are never guaranteed<br>\nto be identical");
        this.screenshotTest.addActionListener(formListener);
        this.jLabel4.setText("Drag To Scroll");
        this.jLabel4.setToolTipText("<html><body>\nWhen checked drag operations are automatically converted to a scroll command<br />\nto issue verborse drag operations (to test features such as drag and drop) just<br />\nuncheck this flag");
        this.dragToScroll.setSelected(true);
        this.dragToScroll.setToolTipText("<html><body>\nWhen checked drag operations are automatically converted to a scroll command<br />\nto issue verborse drag operations (to test features such as drag and drop) just<br />\nuncheck this flag");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.dragToScroll).addGap(360, 360, 360)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.assertTextAreas).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.screenshotTest).addGap(158, 158, 158)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.assertTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.assertLabels).addGap(223, 223, 223)).addComponent(this.testsPackage, -1, 455, Short.MAX_VALUE).addComponent(this.testName, -1, 455, Short.MAX_VALUE)).addContainerGap()).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 594, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.jLabel1, this.jLabel2, this.jLabel3, this.jLabel4);
        jPanel1Layout.linkSize(0, this.assertLabels, this.assertTextAreas, this.assertTitle, this.screenshotTest);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.testName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.testsPackage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.assertTitle).addComponent(this.assertLabels)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.assertTextAreas).addComponent(this.screenshotTest)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.dragToScroll).addComponent(this.jLabel4)).addContainerGap(240, Short.MAX_VALUE)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(168, 168, 168).addComponent(this.jScrollPane1, -1, 231, Short.MAX_VALUE))));
        this.getContentPane().add((java.awt.Component)this.jPanel1, "Center");
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRecordingActionPerformed(java.awt.event.ActionEvent evt) {
        this.updateTestCode();
        File test = new File("test");
        test.mkdirs();
        File tpack = new File(test, this.testsPackage.getText().replace('.', File.separatorChar));
        tpack.mkdirs();
        File testFile = new File(tpack, this.testName.getText() + ".java");
        if (testFile.exists()) {
            JOptionPane.showMessageDialog(this, "A test with the given name already exists", "Save", 0);
        } else {
            FileWriter fw = null;
            try {
                fw = new FileWriter(testFile);
                fw.write(this.script.getText());
                fw.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "An error occured writing to the file: " + ex, "Save", 0);
            }
            finally {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void recordingActionPerformed(java.awt.event.ActionEvent evt) {
        if (this.isRecording()) {
            Form f = Display.getInstance().getCurrent();
            if (f.getName() != null && f.getTitle().length() > 0) {
                this.generatedCode = this.generatedCode + "        waitForFormName(\"" + f.getName() + "\");\n";
            } else if (f.getTitle() != null && f.getTitle().length() > 0) {
                this.generatedCode = this.generatedCode + "        waitForFormTitle(\"" + f.getTitle() + "\");\n";
            }
            this.updateTestCode();
        }
    }

    private void assertTitleActionPerformed(java.awt.event.ActionEvent evt) {
        Form f = Display.getInstance().getCurrent();
        this.generatedCode = this.generatedCode + "        assertTitle(\"" + f.getTitle().replace("\n", "\\n") + "\");\n";
        this.updateTestCode();
    }

    private void assertLabelsActionPerformed(java.awt.event.ActionEvent evt) {
        Form f = Display.getInstance().getCurrent();
        this.visitComponents(f.getContentPane(), new ComponentVisitor(){

            @Override
            public void visit(Component c) {
                if (c instanceof Label) {
                    Label lbl = (Label)c;
                    String labelText = "null";
                    if (lbl.getText() != null) {
                        labelText = "\"" + lbl.getText().replace("\n", "\\n") + "\"";
                    }
                    if (lbl.getName() != null) {
                        TestRecorder.this.generatedCode = TestRecorder.this.generatedCode + "        assertLabel(" + TestRecorder.this.getPathOrName((Component)lbl) + ", " + labelText + ");\n";
                    } else {
                        TestRecorder.this.generatedCode = TestRecorder.this.generatedCode + "        assertLabel(" + labelText + ");\n";
                    }
                }
            }
        });
        this.updateTestCode();
    }

    private void assertTextAreasActionPerformed(java.awt.event.ActionEvent evt) {
        Form f = Display.getInstance().getCurrent();
        this.visitComponents(f.getContentPane(), new ComponentVisitor(){

            @Override
            public void visit(Component c) {
                if (c instanceof TextArea) {
                    TextArea lbl = (TextArea)c;
                    String labelText = "null";
                    if (lbl.getText() != null) {
                        labelText = "\"" + lbl.getText().replace("\n", "\\n") + "\"";
                    }
                    if (lbl.getName() != null) {
                        TestRecorder.this.generatedCode = TestRecorder.this.generatedCode + "        assertTextArea(" + TestRecorder.this.getPathOrName((Component)lbl) + ", " + labelText + ");\n";
                    } else {
                        TestRecorder.this.generatedCode = TestRecorder.this.generatedCode + "        assertTextArea(" + labelText + ");\n";
                    }
                }
            }
        });
        this.updateTestCode();
    }

    private void screenshotTestActionPerformed(java.awt.event.ActionEvent evt) {
        ++this.screenshots;
        this.generatedCode = this.generatedCode + "        screenshotTest(\"__TEST_NAME___" + this.screenshots + "\");\n";
        this.updateTestCode();
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            if (evt.getSource() == TestRecorder.this.saveRecording) {
                TestRecorder.this.saveRecordingActionPerformed(evt);
            } else if (evt.getSource() == TestRecorder.this.recording) {
                TestRecorder.this.recordingActionPerformed(evt);
            } else if (evt.getSource() == TestRecorder.this.assertTitle) {
                TestRecorder.this.assertTitleActionPerformed(evt);
            } else if (evt.getSource() == TestRecorder.this.assertLabels) {
                TestRecorder.this.assertLabelsActionPerformed(evt);
            } else if (evt.getSource() == TestRecorder.this.assertTextAreas) {
                TestRecorder.this.assertTextAreasActionPerformed(evt);
            } else if (evt.getSource() == TestRecorder.this.screenshotTest) {
                TestRecorder.this.screenshotTestActionPerformed(evt);
            }
        }
    }

    static interface ComponentVisitor {
        public void visit(Component var1);
    }
}

