/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase.cef;

import com.codename1.impl.javase.AbstractBrowserWindowSE;
import com.codename1.impl.javase.BrowserWindowFactory;
import com.codename1.impl.javase.JavaSEPort;
import com.codename1.impl.javase.cef.BrowserPanel;
import com.codename1.impl.javase.cef.CEFBrowserComponent;
import com.codename1.impl.javase.cef.CEFBrowserComponentListener;
import com.codename1.impl.javase.cef.StreamWrapper;
import com.codename1.impl.javase.fx.FXBrowserWindowSE;
import com.codename1.io.JSONParser;
import com.codename1.io.Log;
import com.codename1.io.Util;
import com.codename1.media.AbstractMedia;
import com.codename1.media.AsyncMedia;
import com.codename1.media.Media;
import com.codename1.ui.BrowserComponent;
import com.codename1.ui.CN;
import com.codename1.ui.Component;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Label;
import com.codename1.ui.PeerComponent;
import com.codename1.ui.Toolbar;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.Layout;
import com.codename1.util.AsyncResource;
import java.awt.Container;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;

public class JavaCEFSEPort
extends JavaSEPort {
    private static boolean cefExists;

    @Override
    public void init(Object m) {
        super.init(m);
        try {
            Class.forName("org.cef.CefApp");
            cefExists = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean isNativeBrowserComponentSupported() {
        return cefExists && !blockNativeBrowser;
    }

    public PeerComponent createBrowserComponent(Object parent) {
        boolean useWKWebView = "true".equals(Display.getInstance().getProperty("BrowserComponent.useWKWebView", "false"));
        if (useWKWebView && !this.useWKWebViewChecked) {
            this.useWKWebViewChecked = true;
            Map m = Display.getInstance().getProjectBuildHints();
            if (m != null && !m.containsKey("ios.useWKWebView")) {
                Display.getInstance().setProjectBuildHint("ios.useWKWebView", "true");
            }
        }
        return this.createCEFBrowserComponent(parent);
    }

    @Override
    protected BrowserWindowFactory createBrowserWindowFactory() {
        return new BrowserWindowFactory(){

            @Override
            public AbstractBrowserWindowSE createBrowserWindow(String startURL) {
                return new FXBrowserWindowSE(startURL);
            }
        };
    }

    public PeerComponent createCEFBrowserComponent(final Object parent) {
        Log.p((String)"Attempting to create browser component", (int)1);
        final PeerComponent[] out = new PeerComponent[1];
        final Throwable[] error = new Throwable[1];
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            out[0] = JavaCEFSEPort.this.createCEFBrowserComponent(parent);
                        }
                        catch (Throwable t) {
                            error[0] = t;
                        }
                    }
                });
            }
            catch (Throwable ex) {
                Log.e((Throwable)ex);
                throw new RuntimeException("Failed to create CEF browser", ex);
            }
            if (error[0] != null) {
                Log.e((Throwable)error[0]);
                throw new RuntimeException("Failed to create CEF browser", error[0]);
            }
            return out[0];
        }
        return CEFBrowserComponent.create((BrowserComponent)parent);
    }

    @Override
    public AsyncResource<Media> createMediaAsync(InputStream inputStream, String mimeType, Runnable onCompletion) {
        AsyncResource out = new AsyncResource();
        if (!JavaCEFSEPort.checkForPermission("android.permission.READ_PHONE_STATE", "This is required to play media")) {
            out.error((Throwable)new IOException("android.permission.READ_PHONE_STATE is required to play media"));
            return out;
        }
        if (!JavaCEFSEPort.checkForPermission("android.permission.WRITE_EXTERNAL_STORAGE", "This is required to play media")) {
            out.error((Throwable)new IOException("android.permission.WRITE_EXTERNAL_STORAGE is required to play media"));
            return out;
        }
        Container cnt = this.canvas.getParent();
        while (!(cnt instanceof JFrame)) {
            if ((cnt = cnt.getParent()) != null) continue;
            out.error((Throwable)new RuntimeException("Could not find canvas.  Cannot create media"));
            return out;
        }
        StreamWrapper stream = new StreamWrapper(inputStream, mimeType, -1L);
        String id = BrowserPanel.getStreamRegistry().registerStream(stream);
        String uriAddress = "https://cn1app/streams/" + id;
        try {
            new CodenameOneMediaPlayer(uriAddress, mimeType.startsWith("video/"), (JFrame)cnt, onCompletion, (AsyncResource<Media>)out);
        }
        catch (IOException ex) {
            out.error((Throwable)ex);
        }
        return out;
    }

    @Override
    public AsyncResource<Media> createMediaAsync(String uriAddress, boolean isVideo, Runnable onCompletion) {
        AsyncResource out = new AsyncResource();
        if (!JavaCEFSEPort.checkForPermission("android.permission.READ_PHONE_STATE", "This is required to play media")) {
            out.error((Throwable)new IOException("android.permission.READ_PHONE_STATE is required to play media"));
            return out;
        }
        if (!JavaCEFSEPort.checkForPermission("android.permission.WRITE_EXTERNAL_STORAGE", "This is required to play media")) {
            out.error((Throwable)new IOException("android.permission.WRITE_EXTERNAL_STORAGE is required to play media"));
            return out;
        }
        Container cnt = this.canvas.getParent();
        while (!(cnt instanceof JFrame)) {
            if ((cnt = cnt.getParent()) != null) continue;
            out.error((Throwable)new RuntimeException("Could not find canvas.  Cannot create media"));
            return out;
        }
        if (uriAddress.startsWith("file:")) {
            File f = new File(uriAddress = this.unfile(uriAddress));
            if (f.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(f);
                    StreamWrapper stream = new StreamWrapper(fis, this.getMimetype(f), f.length());
                    String id = BrowserPanel.getStreamRegistry().registerStream(stream);
                    uriAddress = "https://cn1app/streams/" + id;
                }
                catch (IOException ex) {
                    out.error((Throwable)ex);
                    return out;
                }
            } else {
                out.error((Throwable)new FileNotFoundException(uriAddress));
                return out;
            }
        }
        String uri = uriAddress;
        try {
            new CodenameOneMediaPlayer(uri, isVideo, (JFrame)cnt, onCompletion, (AsyncResource<Media>)out);
        }
        catch (IOException ex) {
            out.error((Throwable)ex);
        }
        return out;
    }

    public void addCompletionHandler(Media media, Runnable onCompletion) {
        super.addCompletionHandler(media, onCompletion);
        if (media instanceof CodenameOneMediaPlayer) {
            ((CodenameOneMediaPlayer)media).addCompletionHandler(onCompletion);
        }
    }

    public void removeCompletionHandler(Media media, Runnable onCompletion) {
        super.removeCompletionHandler(media, onCompletion);
        if (media instanceof CodenameOneMediaPlayer) {
            ((CodenameOneMediaPlayer)media).removeCompletionHandler(onCompletion);
        }
    }

    class CodenameOneMediaPlayer
    extends AbstractMedia {
        private Runnable onCompletion;
        private List<Runnable> completionHandlers;
        private CEFBrowserComponent bc;
        private boolean realized = false;
        private boolean isVideo;
        private JFrame frm;
        private boolean playing = false;
        private boolean nativePlayerMode;
        private AsyncResource<Media> _callback;
        private int currTime;
        private int duration;
        private int volume;
        private String lastErrorMessage;
        private Runnable onPaused = new Runnable(){

            @Override
            public void run() {
                CodenameOneMediaPlayer.this.playing = false;
                CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Paused);
            }
        };
        private Runnable onPlaying = new Runnable(){

            @Override
            public void run() {
                CodenameOneMediaPlayer.this.playing = true;
                CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Playing);
            }
        };
        private Runnable onError = new Runnable(){

            @Override
            public void run() {
                if (CodenameOneMediaPlayer.this._callback != null && !CodenameOneMediaPlayer.this._callback.isDone()) {
                    CodenameOneMediaPlayer.this._callback.error((Throwable)new IOException(CodenameOneMediaPlayer.this.lastErrorMessage));
                    return;
                }
                Log.p((String)CodenameOneMediaPlayer.this.lastErrorMessage);
                CodenameOneMediaPlayer.this.fireMediaError(CodenameOneMediaPlayer.this.createMediaException(CodenameOneMediaPlayer.this.lastErrorMessage, AsyncMedia.MediaErrorType.Unknown));
                if (!CodenameOneMediaPlayer.this.playing) {
                    CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Playing);
                    CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Paused);
                }
            }
        };

        private boolean isPlayable(String uri) {
            return true;
        }

        public CodenameOneMediaPlayer(String uri, boolean isVideo, JFrame f, Runnable onCompletion, AsyncResource<Media> callback) throws IOException {
            this.init(uri, isVideo, f, onCompletion, callback);
        }

        public void init(String uri, boolean isVideo, JFrame f, Runnable onCompletion, final AsyncResource<Media> callback) throws IOException {
            this._callback = callback;
            final JSONParser parser = new JSONParser();
            String mediaTag = isVideo ? "video" : "audio";
            String style = "<style type='text/css'>document, body {padding:0;margin:0; width:100%; height: 100%} video, audio {margin:0; padding:0; width:100%; height: 100%}</style>";
            String script = "<script>window.cn1Media = document.getElementById('cn1Media');function callback(data){ cefQuery({request:'shouldNavigate:'+JSON.stringify(data), onSuccess: function(response){}, onFailure:function(error_code, error_message) { console.log(error_message)}});}cn1Media.addEventListener('pause', function(){ callback({'state':'paused'})});cn1Media.addEventListener('play', function(){ callback({'state':'playing'})});cn1Media.addEventListener('ended', function(){ callback({'state':'ended'})});cn1Media.addEventListener('durationchange', function(){ callback({'duration': Math.floor(cn1Media.duration * 1000)})});cn1Media.addEventListener('timeupdate', function(){ callback({'time': Math.floor(cn1Media.currentTime * 1000)})});cn1Media.addEventListener('volumechange', function(){ callback({'volume': Math.round(cn1Media.volume * 100)})});cn1Media.addEventListener('error', function(){ var msg = 'Unknown Error'; try {msg = cn1Media.error.message + '. Code='+cn1Media.error.code;}catch(e){} callback({'error': msg})});</script> ";
            String html = "<!doctype html><html><head>" + style + "</head><body><" + mediaTag + " id='cn1Media' width='640' height='480' style='width:100%;height:100%' src='" + uri + "'/>" + script + "</body></html>";
            String url = "data:text/html," + Util.encodeUrl((String)html);
            this.bc = CEFBrowserComponent.create(url, new CEFBrowserComponentListener(){

                @Override
                public void onLoad(ActionEvent e) {
                    if (!callback.isDone()) {
                        callback.complete((Object)CodenameOneMediaPlayer.this);
                    }
                }

                @Override
                public void onError(ActionEvent e) {
                }

                @Override
                public void onStart(ActionEvent e) {
                }

                @Override
                public boolean shouldNavigate(final String url) {
                    if (url.startsWith("{")) {
                        CN.callSerially((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Map m = parser.parseJSON((Reader)new StringReader(url));
                                    if (m.containsKey("time")) {
                                        CodenameOneMediaPlayer.this.currTime = ((Number)m.get("time")).intValue();
                                    }
                                    if (m.containsKey("duration")) {
                                        CodenameOneMediaPlayer.this.duration = ((Number)m.get("duration")).intValue();
                                    }
                                    if (m.containsKey("volume")) {
                                        CodenameOneMediaPlayer.this.volume = ((Number)m.get("volume")).intValue();
                                    }
                                    if (m.containsKey("state")) {
                                        String mState = (String)m.get("state");
                                        if ("playing".equals(mState)) {
                                            if (!CodenameOneMediaPlayer.this.playing) {
                                                CodenameOneMediaPlayer.this.onPlaying.run();
                                            }
                                        } else if ("paused".equals(mState)) {
                                            if (CodenameOneMediaPlayer.this.playing) {
                                                CodenameOneMediaPlayer.this.onPaused.run();
                                            }
                                        } else if ("ended".equals(mState)) {
                                            if (CodenameOneMediaPlayer.this.playing) {
                                                CodenameOneMediaPlayer.this.onPaused.run();
                                            }
                                            CodenameOneMediaPlayer.this.onCompletion.run();
                                        } else if ("canplay".equals(mState)) {
                                            // empty if block
                                        }
                                    }
                                    if (m.containsKey("error")) {
                                        CodenameOneMediaPlayer.this.lastErrorMessage = String.valueOf(m.get("error"));
                                        CodenameOneMediaPlayer.this.onError.run();
                                    }
                                }
                                catch (IOException ex) {
                                    Log.e((Throwable)ex);
                                }
                            }
                        });
                        return false;
                    }
                    return true;
                }
            });
            if (onCompletion != null) {
                this.addCompletionHandler(onCompletion);
            }
            this.onCompletion = new Runnable(){

                @Override
                public void run() {
                    if (callback != null && !callback.isDone()) {
                        callback.complete((Object)CodenameOneMediaPlayer.this);
                    }
                    CodenameOneMediaPlayer.this.playing = false;
                    CodenameOneMediaPlayer.this.fireMediaStateChange(AsyncMedia.State.Paused);
                    CodenameOneMediaPlayer.this.fireCompletionHandlers();
                }
            };
            this.isVideo = isVideo;
            this.frm = f;
        }

        private AsyncMedia.MediaException createMediaException(String message, AsyncMedia.MediaErrorType type) {
            return new AsyncMedia.MediaException(type, message);
        }

        public CodenameOneMediaPlayer(InputStream stream, String mimeType, JFrame f, Runnable onCompletion, AsyncResource<Media> callback) throws IOException {
            String suffix = JavaCEFSEPort.this.guessSuffixForMimetype(mimeType);
            File temp = File.createTempFile("mtmp", suffix);
            temp.deleteOnExit();
            FileOutputStream out = new FileOutputStream(temp);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = stream.read(buf, 0, buf.length)) > -1) {
                out.write(buf, 0, len);
            }
            stream.close();
            this.isVideo = mimeType.contains("video");
            this.frm = f;
            this.init(temp.getAbsolutePath(), this.isVideo, f, onCompletion, callback);
        }

        private void fireCompletionHandlers() {
            if (this.completionHandlers != null && !this.completionHandlers.isEmpty()) {
                Display.getInstance().callSerially(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (CodenameOneMediaPlayer.this.completionHandlers != null && !CodenameOneMediaPlayer.this.completionHandlers.isEmpty()) {
                            ArrayList toRun;
                            CodenameOneMediaPlayer codenameOneMediaPlayer = CodenameOneMediaPlayer.this;
                            synchronized (codenameOneMediaPlayer) {
                                toRun = new ArrayList(CodenameOneMediaPlayer.this.completionHandlers);
                            }
                            for (Runnable r : toRun) {
                                r.run();
                            }
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCompletionHandler(Runnable onCompletion) {
            CodenameOneMediaPlayer codenameOneMediaPlayer = this;
            synchronized (codenameOneMediaPlayer) {
                if (this.completionHandlers == null) {
                    this.completionHandlers = new ArrayList<Runnable>();
                }
                this.completionHandlers.add(onCompletion);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeCompletionHandler(Runnable onCompletion) {
            if (this.completionHandlers != null) {
                CodenameOneMediaPlayer codenameOneMediaPlayer = this;
                synchronized (codenameOneMediaPlayer) {
                    this.completionHandlers.remove(onCompletion);
                }
            }
        }

        public void cleanup() {
            this.pause();
            if (this.bc != null) {
                this.bc.cleanup();
                this.bc = null;
            }
        }

        public void prepare() {
        }

        protected void playImpl() {
            if (this.isVideo && this.nativePlayerMode) {
                final Form currForm = Display.getInstance().getCurrent();
                Form playerForm = new Form("Video Player", (Layout)new BorderLayout()){

                    protected void onShow() {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CodenameOneMediaPlayer.this.playInternal();
                            }
                        });
                    }
                };
                Toolbar tb = new Toolbar();
                playerForm.setToolbar(tb);
                tb.setBackCommand("Back", (ActionListener)new ActionListener<ActionEvent>(){

                    public void actionPerformed(ActionEvent e) {
                        CodenameOneMediaPlayer.this.pauseInternal();
                        currForm.showBack();
                    }
                });
                Component videoComponent = this.getVideoComponent();
                if (videoComponent.getComponentForm() != null) {
                    videoComponent.remove();
                }
                playerForm.addComponent((Object)"Center", videoComponent);
                playerForm.show();
                return;
            }
            this.playInternal();
        }

        private void playInternal() {
            if (this.bc == null) {
                return;
            }
            this.bc.execute("cn1Media.play()");
        }

        private void pauseInternal() {
            if (this.bc == null) {
                return;
            }
            this.bc.execute("cn1Media.pause()");
        }

        protected void pauseImpl() {
            if (this.bc == null) {
                return;
            }
            if (this.playing) {
                this.bc.execute("cn1Media.pause()");
            }
        }

        public int getTime() {
            if (this.bc == null) {
                return -1;
            }
            return this.currTime;
        }

        public void setTime(int time) {
            if (this.bc == null) {
                return;
            }
            this.bc.execute("cn1Media.currentTime = " + (double)time / 1000.0 + ";");
        }

        public int getDuration() {
            int d = this.duration;
            if (d == 0) {
                return -1;
            }
            return d;
        }

        public void setVolume(int vol) {
            if (this.bc == null) {
                return;
            }
            this.bc.execute("cn1Media.volume = " + (double)vol / 100.0);
        }

        public int getVolume() {
            return this.volume;
        }

        public Component getVideoComponent() {
            if (!this.isVideo) {
                return new Label();
            }
            return this.bc;
        }

        public boolean isVideo() {
            return this.isVideo;
        }

        public boolean isFullScreen() {
            return false;
        }

        public void setFullScreen(boolean fullScreen) {
        }

        public boolean isPlaying() {
            return this.playing;
        }

        public void setNativePlayerMode(boolean nativePlayer) {
            this.nativePlayerMode = nativePlayer;
        }

        public boolean isNativePlayerMode() {
            return this.nativePlayerMode;
        }

        public void setVariable(String key, Object value) {
        }

        public Object getVariable(String key) {
            return null;
        }
    }
}

