/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl.javase.cef;

import com.codename1.ui.BrowserComponent;
import java.lang.ref.WeakReference;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;

public class MessageRouterHandlerEx
extends CefMessageRouterHandlerAdapter {
    private WeakReference<BrowserComponent> browserComponentRef;
    private final CefClient client_;
    private final CefMessageRouter.CefMessageRouterConfig config_ = new CefMessageRouter.CefMessageRouterConfig("myQuery", "myQueryAbort");
    private CefMessageRouter router_ = null;

    public MessageRouterHandlerEx(CefClient client, BrowserComponent browserComponent) {
        this.client_ = client;
        this.browserComponentRef = new WeakReference<BrowserComponent>(browserComponent);
    }

    public boolean onQuery(CefBrowser browser, CefFrame frame, long query_id, String request, boolean persistent, CefQueryCallback callback) {
        if (request.startsWith("hasExtension")) {
            if (this.router_ != null) {
                callback.success("");
            } else {
                callback.failure(0, "");
            }
        } else if (request.startsWith("enableExt")) {
            if (this.router_ != null) {
                callback.failure(-1, "Already enabled");
            } else {
                this.router_ = CefMessageRouter.create((CefMessageRouter.CefMessageRouterConfig)this.config_, (CefMessageRouterHandler)new ShouldNavigateMessageRouter());
                this.client_.addMessageRouter(this.router_);
                callback.success("");
            }
        } else if (request.startsWith("disableExt")) {
            if (this.router_ == null) {
                callback.failure(-2, "Already disabled");
            } else {
                this.client_.removeMessageRouter(this.router_);
                this.router_.dispose();
                this.router_ = null;
                callback.success("");
            }
        } else {
            return false;
        }
        return true;
    }

    private class ShouldNavigateMessageRouter
    extends CefMessageRouterHandlerAdapter {
        private ShouldNavigateMessageRouter() {
        }

        public boolean onQuery(CefBrowser browser, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
            if (request.startsWith("shouldNavigate:")) {
                String url = request.substring(request.indexOf(":") + 1);
                BrowserComponent browserComponent_ = (BrowserComponent)MessageRouterHandlerEx.this.browserComponentRef.get();
                if (browserComponent_ != null) {
                    browserComponent_.fireBrowserNavigationCallbacks(url);
                    callback.success("true");
                }
                return true;
            }
            return false;
        }
    }

    private class JavaVersionMessageRouter
    extends CefMessageRouterHandlerAdapter {
        private JavaVersionMessageRouter() {
        }

        public boolean onQuery(CefBrowser browser, CefFrame frame, long query_id, String request, boolean persistent, CefQueryCallback callback) {
            if (request.startsWith("jcefJava")) {
                callback.success(System.getProperty("java.version"));
                return true;
            }
            return false;
        }
    }
}

