/*
 * Decompiled with CFR 0.152.
 */
package net.informaticalibera.tests.goldeneditor;

import com.codename1.io.Log;
import com.codename1.io.Preferences;
import com.codename1.ui.CN;
import com.codename1.ui.Component;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.TextArea;
import com.codename1.ui.Toolbar;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.util.Resources;
import net.informaticalibera.tests.goldeneditor.DeviceUtilities;

public class GoldenEditor {
    private Form current;
    private Resources theme;
    private long pressedTime = -1L;

    public void init(Object context) {
        CN.updateNetworkThreadCount((int)2);
        DeviceUtilities.loadCSS("theme");
        Toolbar.setGlobalToolbar((boolean)true);
        Log.bindCrashProtection((boolean)true);
        CN.addNetworkErrorListener(err -> {
            err.consume();
            if (err.getError() != null) {
                Log.e((Throwable)err.getError());
            }
            Log.sendLogAsync();
            Dialog.show((String)"Connection Error", (String)("There was a networking error in the connection to " + err.getConnectionRequest().getUrl()), (String)"OK", null);
        });
    }

    public void start() {
        if (this.current != null) {
            this.current.show();
            return;
        }
        Form hi = new Form("Golden Editor", (Layout)new BorderLayout());
        hi.getToolbar().hideToolbar();
        hi.getContentPane().setSafeArea(true);
        TextArea textArea = new TextArea();
        if (!Preferences.get((String)"isFirstRun", (boolean)true)) {
            textArea.setText(Preferences.get((String)"TextArea", (String)""));
        } else {
            textArea.setText("Ciao, sono Golden Editor\nQui puoi scrivere le tue note\n\nPer condividerle, premi lo schermo per almeno tre secondi");
            Preferences.set((String)"isFirstRun", (boolean)false);
        }
        textArea.setHint("Golden Editor - Premi 3 sec per condividere");
        textArea.getHintLabel().setUIID("TextAreaHint");
        hi.add((Object)"Center", (Component)textArea);
        textArea.addDataChangedListener((type, index) -> Preferences.set((String)"TextArea", (String)textArea.getText()));
        textArea.addPointerPressedListener(l -> {
            Log.p((String)"Pointer pressed listener");
            this.pressedTime = System.currentTimeMillis();
        });
        textArea.addPointerReleasedListener(l -> {
            Log.p((String)"Pointer released listener");
            if (this.pressedTime > -1L && System.currentTimeMillis() - this.pressedTime > 3000L) {
                Log.p((String)"Sharing text");
                textArea.stopEditing();
                Display.getInstance().share(textArea.getText(), null, "text/plain");
            }
        });
        hi.show();
    }

    public void stop() {
        this.current = CN.getCurrentForm();
        if (this.current instanceof Dialog) {
            ((Dialog)this.current).dispose();
            this.current = CN.getCurrentForm();
        }
    }

    public void destroy() {
    }
}

