/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.capture;

public class VideoCaptureConstraints {
    public static final int QUALITY_LOW = 1;
    public static final int QUALITY_HIGH = 2;
    private static Compiler compiler;
    private int maxLength;
    private int width;
    private int height;
    private int quality;
    private long maxFileSize;
    private int preferredMaxLength;
    private int preferredWidth;
    private int preferredHeight;
    private int preferredQuality;
    private long preferredMaxFileSize;
    boolean compiled;

    public static void init(Compiler cmp) {
        compiler = cmp;
    }

    public VideoCaptureConstraints() {
    }

    public VideoCaptureConstraints(VideoCaptureConstraints toCopy) {
        this.preferredHeight = toCopy.preferredHeight;
        this.preferredWidth = toCopy.preferredWidth;
        this.preferredMaxLength = toCopy.preferredMaxLength;
        this.width = toCopy.width;
        this.height = toCopy.height;
        this.maxLength = toCopy.maxLength;
        this.compiled = toCopy.compiled;
        this.quality = toCopy.quality;
        this.preferredQuality = toCopy.preferredQuality;
        this.maxFileSize = toCopy.maxFileSize;
        this.preferredMaxFileSize = toCopy.preferredMaxFileSize;
    }

    public String toString() {
        return "VideoCaptureConstraints{" + this.getWidth() + "x" + this.getHeight() + " @ " + this.getMaxLength() + "s, " + this.getQualityString() + " " + this.getMaxFileSizeString() + "}";
    }

    private String getQualityString() {
        switch (this.getQuality()) {
            case 1: {
                return "Low quality";
            }
            case 2: {
                return "High quality";
            }
        }
        return "";
    }

    private String getMaxFileSizeString() {
        if (this.getMaxFileSize() > 0L) {
            return "<=" + this.getMaxFileSize() + " bytes";
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == VideoCaptureConstraints.class) {
            VideoCaptureConstraints c = (VideoCaptureConstraints)obj;
            return c.preferredHeight == this.preferredHeight && c.preferredWidth == this.preferredWidth && c.preferredMaxLength == this.preferredMaxLength && c.preferredQuality == this.preferredQuality && c.preferredMaxFileSize == this.preferredMaxFileSize;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.preferredMaxLength;
        hash = 29 * hash + this.preferredWidth;
        hash = 29 * hash + this.preferredHeight;
        hash = 29 * hash + this.preferredQuality;
        hash = 29 * hash + (int)this.preferredMaxFileSize;
        return hash;
    }

    public VideoCaptureConstraints(int quality) {
        this.preferredQuality = quality;
    }

    public VideoCaptureConstraints(int width, int height, int maxLength) {
        this.preferredWidth = width;
        this.preferredHeight = height;
        this.preferredMaxLength = maxLength;
    }

    public long getMaxFileSize() {
        this.build();
        return this.maxFileSize;
    }

    public VideoCaptureConstraints preferredMaxFileSize(long size) {
        if (this.preferredMaxFileSize != size) {
            this.preferredMaxFileSize = size;
            this.compiled = false;
        }
        return this;
    }

    public long getPreferredMaxFileSize() {
        return this.preferredMaxFileSize;
    }

    public int getMaxLength() {
        this.build();
        return this.maxLength;
    }

    public VideoCaptureConstraints preferredMaxLength(int maxLength) {
        if (maxLength != this.preferredMaxLength) {
            this.preferredMaxLength = maxLength;
            this.compiled = false;
        }
        return this;
    }

    public int getPreferredMaxLength() {
        return this.preferredMaxLength;
    }

    public boolean isMaxLengthSupported() {
        this.build();
        return this.maxLength == 0 || this.maxLength == this.preferredMaxLength;
    }

    public int getWidth() {
        this.build();
        return this.width;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public boolean isSizeSupported() {
        this.build();
        if (this.preferredWidth == 0 && this.preferredHeight == 0) {
            return true;
        }
        return this.width == this.preferredWidth && this.height == this.preferredHeight;
    }

    public VideoCaptureConstraints preferredWidth(int width) {
        if (width != this.preferredWidth) {
            this.preferredWidth = width;
            this.compiled = false;
        }
        return this;
    }

    public int getHeight() {
        this.build();
        return this.height;
    }

    public VideoCaptureConstraints preferredHeight(int height) {
        if (height != this.preferredHeight) {
            this.preferredHeight = height;
            this.compiled = false;
        }
        return this;
    }

    public int getPreferredQuality() {
        return this.preferredQuality;
    }

    public int getQuality() {
        this.build();
        return this.quality;
    }

    public VideoCaptureConstraints preferredQuality(int quality) {
        if (quality != this.preferredQuality) {
            this.preferredQuality = quality;
            this.compiled = false;
        }
        return this;
    }

    private VideoCaptureConstraints build() {
        if (this.compiled) {
            return this;
        }
        if (compiler == null) {
            this.height = 0;
            this.width = 0;
            this.maxLength = 0;
            this.quality = 0;
            this.maxFileSize = 0L;
        } else {
            VideoCaptureConstraints result = compiler.compile(this);
            this.width = result.preferredWidth;
            this.height = result.preferredHeight;
            this.maxLength = result.preferredMaxLength;
            this.quality = result.preferredQuality;
            this.maxFileSize = result.preferredMaxFileSize;
        }
        this.compiled = true;
        return this;
    }

    public boolean isSupported() {
        return this.isSizeSupported() && this.isMaxLengthSupported() && this.isQualitySupported() && this.isMaxFileSizeSupported();
    }

    public boolean isQualitySupported() {
        return this.preferredQuality == 0 || this.quality == this.preferredQuality;
    }

    public boolean isMaxFileSizeSupported() {
        return this.preferredMaxFileSize == 0L || this.maxFileSize == this.preferredMaxFileSize;
    }

    public boolean isNullConstraint() {
        return this.getWidth() == 0 && this.getHeight() == 0 && this.getMaxLength() == 0 && this.getQuality() == 0 && this.getMaxFileSize() == 0L;
    }

    public static interface Compiler {
        public VideoCaptureConstraints compile(VideoCaptureConstraints var1);
    }
}

